/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.xml.XMLCharacters;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMUtilities
extends XMLUtilities {
    protected DOMUtilities() {
    }

    public static void writeDocument(Document document, Writer writer) throws IOException {
        Node node = document.getFirstChild();
        while (node != null) {
            DOMUtilities.writeNode(node, writer);
            node = node.getNextSibling();
        }
    }

    public static void writeNode(Node node, Writer writer) throws IOException {
        switch (node.getNodeType()) {
            case 1: {
                Object object;
                writer.write("<");
                writer.write(node.getNodeName());
                if (node.hasAttributes()) {
                    object = node.getAttributes();
                    int n = object.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        Attr attr = (Attr)object.item(n2);
                        writer.write(" ");
                        writer.write(attr.getNodeName());
                        writer.write("=\"");
                        writer.write(DOMUtilities.contentToString(attr.getNodeValue()));
                        writer.write("\"");
                        ++n2;
                    }
                }
                if ((object = node.getFirstChild()) != null) {
                    writer.write(">");
                    while (object != null) {
                        DOMUtilities.writeNode((Node)object, writer);
                        object = object.getNextSibling();
                    }
                    writer.write("</");
                    writer.write(node.getNodeName());
                    writer.write(">");
                    break;
                }
                writer.write("/>");
                break;
            }
            case 3: {
                writer.write(DOMUtilities.contentToString(node.getNodeValue()));
                break;
            }
            case 4: {
                writer.write("<![CDATA[");
                writer.write(node.getNodeValue());
                writer.write("]]>");
                break;
            }
            case 5: {
                writer.write("&");
                writer.write(node.getNodeName());
                writer.write(";");
                break;
            }
            case 7: {
                writer.write("<?");
                writer.write(node.getNodeName());
                writer.write(" ");
                writer.write(node.getNodeValue());
                writer.write("?>");
                break;
            }
            case 8: {
                writer.write("<!--");
                writer.write(node.getNodeValue());
                writer.write("-->");
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new Error("Internal error (" + node.getNodeType() + ")");
            }
        }
    }

    public static String contentToString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            switch (c2) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Document deepCloneDocument(Document document, DOMImplementation dOMImplementation) {
        Element element = document.getDocumentElement();
        Document document2 = dOMImplementation.createDocument(element.getNamespaceURI(), element.getNodeName(), null);
        Element element2 = document2.getDocumentElement();
        boolean bl = true;
        Node node = document.getFirstChild();
        while (node != null) {
            if (node == element) {
                Object object;
                bl = false;
                if (element.hasAttributes()) {
                    object = element.getAttributes();
                    int n = object.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        element2.setAttributeNode((Attr)document2.importNode(object.item(n2), true));
                        ++n2;
                    }
                }
                object = element.getFirstChild();
                while (object != null) {
                    element2.appendChild(document2.importNode((Node)object, true));
                    object = object.getNextSibling();
                }
            } else if (node.getNodeType() != 10) {
                if (bl) {
                    document2.insertBefore(document2.importNode(node, true), element2);
                } else {
                    document2.appendChild(document2.importNode(node, true));
                }
            }
            node = node.getNextSibling();
        }
        return document2;
    }

    public static boolean isValidName(String string) {
        int n;
        char c2 = string.charAt(0);
        int n2 = c2 / 32;
        if ((XMLCharacters.NAME_FIRST_CHARACTER[n2] & 1 << (n = c2 % 32)) == 0) {
            return false;
        }
        int n3 = string.length();
        int n4 = 1;
        while (n4 < n3) {
            c2 = string.charAt(n4);
            n2 = c2 / 32;
            if ((XMLCharacters.NAME_CHARACTER[n2] & 1 << (n = c2 % 32)) == 0) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static boolean isValidPrefix(String string) {
        return string.indexOf(58) == -1;
    }

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        return n == -1 || n == string.length() - 1 ? null : string.substring(0, n);
    }

    public static String getLocalName(String string) {
        int n = string.indexOf(58);
        return n == -1 || n == string.length() - 1 ? string : string.substring(n + 1);
    }

    /*
     * Unable to fully structure code
     */
    public static void parseStyleSheetPIData(String var0, HashTable var1_1) {
        var3_2 = 0;
        while (var3_2 < var0.length()) {
            var2_3 = var0.charAt(var3_2);
            if (!XMLUtilities.isXMLSpace(var2_3)) break;
            ++var3_2;
        }
        block1: while (var3_2 < var0.length()) {
            var2_3 = var0.charAt(var3_2);
            var4_4 = var2_3 / 32;
            if ((XMLCharacters.NAME_FIRST_CHARACTER[var4_4] & 1 << (var5_5 = var2_3 % 32)) == 0) {
                throw new DOMException(5, "Wrong name initial:  " + var2_3);
            }
            var6_6 = new StringBuffer();
            var6_6.append(var2_3);
            while (++var3_2 < var0.length()) {
                var2_3 = var0.charAt(var3_2);
                var4_4 = var2_3 / 32;
                if ((XMLCharacters.NAME_CHARACTER[var4_4] & 1 << (var5_5 = var2_3 % 32)) == 0) break;
                var6_6.append(var2_3);
            }
            if (var3_2 < var0.length()) ** GOTO lbl26
            throw new DOMException(12, "Wrong xml-stylesheet data: " + var0);
            while (XMLUtilities.isXMLSpace(var2_3 = var0.charAt(var3_2))) {
                ++var3_2;
lbl26:
                // 2 sources

                if (var3_2 < var0.length()) continue;
            }
            if (var3_2 >= var0.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + var0);
            }
            if (var0.charAt(var3_2) != '=') {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + var0);
            }
            ++var3_2;
            while (var3_2 < var0.length()) {
                var2_3 = var0.charAt(var3_2);
                if (!XMLUtilities.isXMLSpace(var2_3)) break;
                ++var3_2;
            }
            if (var3_2 >= var0.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + var0);
            }
            var2_3 = var0.charAt(var3_2);
            ++var3_2;
            var7_7 = new StringBuffer();
            if (var2_3 == '\'') {
                while (var3_2 < var0.length()) {
                    var2_3 = var0.charAt(var3_2);
                    if (var2_3 == '\'') break;
                    var7_7.append(var2_3);
                    ++var3_2;
                }
                if (var3_2 >= var0.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + var0);
                }
            } else if (var2_3 == '\"') {
                while (var3_2 < var0.length()) {
                    var2_3 = var0.charAt(var3_2);
                    if (var2_3 == '\"') break;
                    var7_7.append(var2_3);
                    ++var3_2;
                }
                if (var3_2 >= var0.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + var0);
                }
            } else {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + var0);
            }
            var1_1.put(var6_6.toString().intern(), var7_7.toString());
            ++var3_2;
            while (var3_2 < var0.length()) {
                var2_3 = var0.charAt(var3_2);
                if (!XMLUtilities.isXMLSpace(var2_3)) continue block1;
                ++var3_2;
            }
        }
    }
}

