/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;

public class NameRecord {
    private short platformId;
    private short encodingId;
    private short languageId;
    private short nameId;
    private short stringLength;
    private short stringOffset;
    private String record;

    protected NameRecord(RandomAccessFile randomAccessFile) throws IOException {
        this.platformId = randomAccessFile.readShort();
        this.encodingId = randomAccessFile.readShort();
        this.languageId = randomAccessFile.readShort();
        this.nameId = randomAccessFile.readShort();
        this.stringLength = randomAccessFile.readShort();
        this.stringOffset = randomAccessFile.readShort();
    }

    public short getEncodingId() {
        return this.encodingId;
    }

    public short getLanguageId() {
        return this.languageId;
    }

    public short getNameId() {
        return this.nameId;
    }

    public short getPlatformId() {
        return this.platformId;
    }

    public String getRecordString() {
        return this.record;
    }

    protected void loadString(RandomAccessFile randomAccessFile, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        randomAccessFile.seek(n + this.stringOffset);
        if (this.platformId == 0) {
            int n2 = 0;
            while (n2 < this.stringLength / 2) {
                stringBuffer.append(randomAccessFile.readChar());
                ++n2;
            }
        } else if (this.platformId == 1) {
            int n3 = 0;
            while (n3 < this.stringLength) {
                stringBuffer.append((char)randomAccessFile.readByte());
                ++n3;
            }
        } else if (this.platformId == 2) {
            int n4 = 0;
            while (n4 < this.stringLength) {
                stringBuffer.append((char)randomAccessFile.readByte());
                ++n4;
            }
        } else if (this.platformId == 3) {
            int n5 = 0;
            while (n5 < this.stringLength / 2) {
                char c2 = randomAccessFile.readChar();
                stringBuffer.append(c2);
                ++n5;
            }
        }
        this.record = stringBuffer.toString();
    }
}

