/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import java.awt.Color;
import java.util.Vector;
import jregex.Matcher;
import jregex.Pattern;
import uk.ac.cam.ch.oscar.CNMRPeakData;
import uk.ac.cam.ch.oscar.DataInterface;
import uk.ac.cam.ch.oscar.SpectrumInfo;
import uk.ac.cam.ch.oscar.SpectrumInterface;

public class CNMRData
implements DataInterface,
SpectrumInterface {
    private boolean defined = false;
    private String blockdata = "";
    private Vector peaks = new Vector();
    private String propcnmr_Solvent = "";
    private boolean propcnmr_SolventDefined = false;
    private String propcnmr_Standard = "";
    private boolean propcnmr_StandardDefined = false;
    private String propcnmr_Frequency = "";
    private boolean propcnmr_FrequencyDefined = false;
    private String propcnmr_Temperature = "";
    private boolean propcnmr_TemperatureDefined = false;

    public String getBlock() {
        return this.blockdata;
    }

    public Color getColor() {
        return new Color(255, 0, 255);
    }

    public SpectrumInfo getSI() {
        SpectrumInfo specinfo = new SpectrumInfo();
        if (this.peaks.size() == 0) {
            return null;
        }
        specinfo.xmin = 0.0f;
        specinfo.xmax = 200.0f;
        specinfo.ymin = 0.0f;
        specinfo.ymax = 1.0f;
        specinfo.xscale = 50.0f;
        specinfo.yscale = 0.0f;
        specinfo.revX = true;
        specinfo.revY = false;
        specinfo.abs = true;
        specinfo.npeaks = this.peaks.size();
        specinfo.x = new float[this.peaks.size()];
        specinfo.height = new float[this.peaks.size()];
        specinfo.width = new float[this.peaks.size()];
        specinfo.type = new int[this.peaks.size()];
        specinfo.annotation = new String[this.peaks.size()];
        int i = 0;
        while (i < this.peaks.size()) {
            specinfo.x[i] = ((CNMRPeakData)this.peaks.elementAt(i)).getX();
            specinfo.height[i] = ((CNMRPeakData)this.peaks.elementAt(i)).getHeight();
            specinfo.width[i] = ((CNMRPeakData)this.peaks.elementAt(i)).getWidth();
            specinfo.type[i] = ((CNMRPeakData)this.peaks.elementAt(i)).getType();
            specinfo.annotation[i] = ((CNMRPeakData)this.peaks.elementAt(i)).getAnnotation();
            ++i;
        }
        return specinfo;
    }

    public String Parse(String inputtext) {
        Pattern re = new Pattern("\t\t\t\t\\b\t\t\t\t\t\t\t(?:\t\t\t\t(NMR\\W*)? (d|\u0111|\u03b4|\u00e4)C\t\t\t|\t13C\\W*NMR\t\t\t|\t\\b(?-i:C)\\b(?!\\))\t\t\t)\t\t\t\t\t\t(?: \\W* for\\s+\\w+ (?: (![\\(\\);]).)*?)?\t\t\t\t\t\t\t( ((?![\\(\\[\\{])\\W)* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )\t\t?\t\t\t\t(\\W+(d|\u0111|\u03b4|\u00e4|C)+\\b)?\t\t\t\t[\\s:=]+?\t\t\t\t(?: \\W*ppm\\W*?)?\t\t\t\t(?: peaks\\s+at\\s+)?\t\t\t\t\t\t\t\t\t\t(\t(?:about\\s+)?\t\t\t\t\t\t\t[+\u2013\\-\\?]?\t\t\t\\d{1,3}(?:\\.\\d+)?\t\t\t(?: \\s* [\u2013\\-\\?] \\s* \\d{1,3}(?:\\.\\d+)? )?\t\t\t(?: \\s*\\* )? \t\t\t\t\t\t(?: \t\t\t\\s*\t\t\t(?:\t\t\t\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t (?: \\s*\\* )?\t\t\t)\t\t )?\t\t\t)\t\t\t(?!\\w|\\s*=)\t\t\t\t\t(?:\t\t\t\t\t\t\t(?: \\s* (,|and|including|&|;|\\/) \\s* )+\t\t\t\t\t\t\t\t\t(\t(?:about\\s+)?\t\t\t\t\t\t\t[+\u2013\\-\\?]?\t\t\t\\d{1,3}(?:\\.\\d+)?\t\t\t(?: \\s* [\u2013\\-\\?] \\s* \\d{1,3}(?:\\.\\d+)? )?\t\t\t(?: \\s*\\* )? \t\t\t\t\t\t(?: \t\t\t\\s*\t\t\t(?:\t\t\t\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t (?: \\s*\\* )?\t\t\t)\t\t )?\t\t\t)\t\t\t(?!\\w|\\s*=)\t\t\t\t\t)+\t\t\t(?!-)\t\t\t\t\t", 9);
        Matcher m = re.matcher(inputtext);
        this.defined = m.find();
        if (this.defined) {
            this.blockdata = m.group(0);
            int i = inputtext.indexOf(this.blockdata);
            inputtext = inputtext.substring(0, i) + inputtext.substring(i + this.blockdata.length(), inputtext.length());
            this.breakUp(this.blockdata);
        } else {
            this.blockdata = "";
        }
        return inputtext;
    }

    public int getPeakCount() {
        return this.peaks.size();
    }

    public CNMRPeakData getPeakAt(int n) {
        return (CNMRPeakData)this.peaks.elementAt(n);
    }

    public String getSummary() {
        String out = "C-NMR";
        return out;
    }

    public String getDetails() {
        String out = "";
        if (this.defined) {
            out = out + "C-NMR:\n";
            if (this.propcnmr_SolventDefined) {
                out = out + "   Solvent: " + this.propcnmr_Solvent + "\n";
            }
            if (this.propcnmr_StandardDefined) {
                out = out + "   Standard: " + this.propcnmr_Standard + "\n";
            }
            if (this.propcnmr_FrequencyDefined) {
                out = out + "   Frequency: " + this.propcnmr_Frequency + " MHz\n";
            }
            if (this.propcnmr_TemperatureDefined) {
                out = out + "   Temperature: " + this.propcnmr_Temperature + " K\n";
            }
            int i = 0;
            while (i < this.peaks.size()) {
                CNMRPeakData dp = (CNMRPeakData)this.peaks.elementAt(i);
                out = out + dp.getDetails();
                ++i;
            }
            out = out + "\n";
        }
        return out;
    }

    public String getDetailsHTML() {
        if (!this.defined) {
            return "";
        }
        String out = "";
        out = out + "<h3>";
        out = out + "<a name=\"C-NMR\"></a>";
        out = out + "C-NMR</h3>";
        out = out + "<ul>";
        out = out + "<li>";
        out = out + "<a href=\"spec0\">View plot</a>";
        if (this.propcnmr_SolventDefined) {
            out = out + "<li><b>Solvent:</b> " + this.propcnmr_Solvent + "";
        }
        if (this.propcnmr_StandardDefined) {
            out = out + "<li><b>Standard:</b> " + this.propcnmr_Standard + "";
        }
        if (this.propcnmr_FrequencyDefined) {
            out = out + "<li><b>Frequency:</b> " + this.propcnmr_Frequency + " MHz";
        }
        if (this.propcnmr_TemperatureDefined) {
            out = out + "<li><b>Temperature:</b> " + this.propcnmr_Temperature + " K";
        }
        out = out + "</ul>";
        out = out + "<table border=0><tr><td width=\"40\">&nbsp;</td><td>";
        out = out + "<table border=1>";
        out = out + "<td><b>Shift / ppm</b></td><td><b>Signal Type</b></td><td><b>Comment</b></td>";
        int i = 0;
        while (i < this.peaks.size()) {
            CNMRPeakData dp = (CNMRPeakData)this.peaks.elementAt(i);
            out = out + dp.getDetailsHTML();
            ++i;
        }
        out = out + "</table>";
        out = out + "</td></tr></table>";
        return out;
    }

    public String getXML() {
        if (!this.defined) {
            return "";
        }
        String out = "      <data class=\"cnmr\" type=\"spectrum\">\n";
        if (this.propcnmr_SolventDefined) {
            out = out + "         <value id=\"solvent\">" + this.propcnmr_Solvent + "</value>\n";
        }
        if (this.propcnmr_StandardDefined) {
            out = out + "         <value id=\"standard\">" + this.propcnmr_Standard + "</value>\n";
        }
        if (this.propcnmr_FrequencyDefined) {
            out = out + "         <value id=\"frequency\">" + this.propcnmr_Frequency + "</value>\n";
        }
        if (this.propcnmr_TemperatureDefined) {
            out = out + "         <value id=\"temperature\">" + this.propcnmr_Temperature + "</value>\n";
        }
        int i = 0;
        while (i < this.peaks.size()) {
            CNMRPeakData dp = (CNMRPeakData)this.peaks.elementAt(i);
            out = out + dp.getXML();
            ++i;
        }
        out = out + "      </data>\n";
        return out;
    }

    public boolean isSet() {
        return this.defined;
    }

    private void breakUp(String data) {
        data = this.matchcnmr_Solvent(data);
        data = this.matchcnmr_Standard(data);
        data = this.matchcnmr_Frequency(data);
        data = this.matchcnmr_Temperature(data);
        data = this.matchPeaks(data);
    }

    private String matchPeaks(String data) {
        this.peaks.removeAllElements();
        boolean found = false;
        Pattern re = new Pattern("(\t\t\t\t\t\t(\t(?:about\\s+)?\t\t\t\t\t\t\t[+\u2013\\-\\?]?\t\t\t\\d{1,3}(?:\\.\\d+)?\t\t\t(?: \\s* [\u2013\\-\\?] \\s* \\d{1,3}(?:\\.\\d+)? )?\t\t\t(?: \\s*\\* )? \t\t\t\t\t\t(?: \t\t\t\\s*\t\t\t(?:\t\t\t\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t (?: \\s*\\* )?\t\t\t)\t\t )?\t\t\t)\t\t\t(?!\\w|\\s*=)\t\t\t\t\t(?:\t\t\t\t\t\t\t(?: \\s* (,|and|including|&|;|\\/) \\s* )+\t\t\t\t\t\t\t\t\t(\t(?:about\\s+)?\t\t\t\t\t\t\t[+\u2013\\-\\?]?\t\t\t\\d{1,3}(?:\\.\\d+)?\t\t\t(?: \\s* [\u2013\\-\\?] \\s* \\d{1,3}(?:\\.\\d+)? )?\t\t\t(?: \\s*\\* )? \t\t\t\t\t\t(?: \t\t\t\\s*\t\t\t(?:\t\t\t\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t (?: \\s*\\* )?\t\t\t)\t\t )?\t\t\t)\t\t\t(?!\\w|\\s*=)\t\t\t\t\t)+\t\t\t(?!-)\t\t)$", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            String peakblock = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
            boolean foundpeak = false;
            re = new Pattern("(\t\t\t(\t(?:about\\s+)?\t\t\t\t\t\t\t[+\u2013\\-\\?]?\t\t\t\\d{1,3}(?:\\.\\d+)?\t\t\t(?: \\s* [\u2013\\-\\?] \\s* \\d{1,3}(?:\\.\\d+)? )?\t\t\t(?: \\s*\\* )? \t\t\t\t\t\t(?: \t\t\t\\s*\t\t\t(?:\t\t\t\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t (?: \\s*\\* )?\t\t\t)\t\t )?\t\t\t)\t\t\t(?!\\w|\\s*=)\t\t)", 9);
            m = re.matcher(peakblock);
            foundpeak = m.find();
            while (foundpeak) {
                CNMRPeakData dp = new CNMRPeakData();
                dp.Parse(m.group(1));
                this.peaks.addElement(dp);
                int j = peakblock.indexOf(m.group(0));
                peakblock = peakblock.substring(0, j) + peakblock.substring(j + m.group(0).length(), peakblock.length());
                m = re.matcher(peakblock);
                foundpeak = m.find();
            }
            i = this.peaks.size() - 1;
            while (i-- > 0) {
                ((CNMRPeakData)this.peaks.elementAt(i)).setNextPeak((CNMRPeakData)this.peaks.elementAt(i + 1));
            }
        }
        return data;
    }

    private String matchcnmr_Solvent(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\W((?:\\[2H6\\]DMSO|Si(CH3)3|Me2CO-d6|\\(CH3CH2\\)2O|\\(OCH2CH2\\)2|Acetone-d6|C2HCl3|C4D8O|C4D8O2|C4H8O|C5D5N|C6D5CD3|C6D5NO2|C6D6|C6H5CD3|CCl4|CD2Cl2|CD3CD2OD|CD3CD2OH|CD3CN|CD3COCD3|CD3COOD|CD3NO2|CD3OD|CD3OH|CD3SOCD3|CDCl3|CF3CO2D|CF3COOD|CH3CH3OD|CH3OCH3|CH3OD|CHCl2CHCl2|Cl2CHCHCl2|Cl2DCCDCl2|CS2|D2O|d5-pyridine|d6-acetone|d6-DMSO|d6-THF|d8-toluene|DCM-d2|DCOOD|DMF-d7|DMSO-d6|Et2O|EtOD|Me2NCHO|MeOD|Pyridine-d5|THF-d6|Toluene-d8))\\b", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propcnmr_Solvent = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propcnmr_Solvent = "";
        }
        this.propcnmr_SolventDefined = found;
        if (this.propcnmr_Solvent == "") {
            this.propcnmr_SolventDefined = false;
        }
        if (this.propcnmr_Solvent == null) {
            this.propcnmr_SolventDefined = false;
            this.propcnmr_Solvent = "";
        }
        return data;
    }

    public boolean iscnmr_SolventDefined() {
        return this.propcnmr_SolventDefined;
    }

    public String getcnmr_Solvent() {
        return this.propcnmr_Solvent;
    }

    private String matchcnmr_Standard(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\W((?:Me4Si|CFCl3))\\b", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propcnmr_Standard = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propcnmr_Standard = "";
        }
        this.propcnmr_StandardDefined = found;
        if (this.propcnmr_Standard == "") {
            this.propcnmr_StandardDefined = false;
        }
        if (this.propcnmr_Standard == null) {
            this.propcnmr_StandardDefined = false;
            this.propcnmr_Standard = "";
        }
        return data;
    }

    public boolean iscnmr_StandardDefined() {
        return this.propcnmr_StandardDefined;
    }

    public String getcnmr_Standard() {
        return this.propcnmr_Standard;
    }

    private String matchcnmr_Frequency(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\b(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\\s*MHz\\b", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propcnmr_Frequency = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propcnmr_Frequency = "";
        }
        this.propcnmr_FrequencyDefined = found;
        if (this.propcnmr_Frequency == "") {
            this.propcnmr_FrequencyDefined = false;
        }
        if (this.propcnmr_Frequency == null) {
            this.propcnmr_FrequencyDefined = false;
            this.propcnmr_Frequency = "";
        }
        return data;
    }

    public boolean iscnmr_FrequencyDefined() {
        return this.propcnmr_FrequencyDefined;
    }

    public String getcnmr_Frequency() {
        return this.propcnmr_Frequency;
    }

    private String matchcnmr_Temperature(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\b(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\\s*K\\b", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propcnmr_Temperature = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propcnmr_Temperature = "";
        }
        this.propcnmr_TemperatureDefined = found;
        if (this.propcnmr_Temperature == "") {
            this.propcnmr_TemperatureDefined = false;
        }
        if (this.propcnmr_Temperature == null) {
            this.propcnmr_TemperatureDefined = false;
            this.propcnmr_Temperature = "";
        }
        return data;
    }

    public boolean iscnmr_TemperatureDefined() {
        return this.propcnmr_TemperatureDefined;
    }

    public String getcnmr_Temperature() {
        return this.propcnmr_Temperature;
    }
}

