/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import jregex.Matcher;
import jregex.Pattern;
import uk.ac.cam.ch.oscar.DataPointInterface;
import uk.ac.cam.ch.oscar.Tools;

public class CNMRPeakData
implements DataPointInterface {
    private boolean defined = false;
    private String blockdata = "";
    private CNMRPeakData nextPeak = null;
    private String propPOINTER = "";
    private boolean propPOINTERDefined = false;
    private String propcnmr_ShiftPoint = "";
    private boolean propcnmr_ShiftPointDefined = false;
    private String propcnmr_ShiftLower = "";
    private boolean propcnmr_ShiftLowerDefined = false;
    private String propcnmr_ShiftUpper = "";
    private boolean propcnmr_ShiftUpperDefined = false;
    private String propcnmr_PeakType = "";
    private boolean propcnmr_PeakTypeDefined = false;
    private String propcnmr_Comment = "";
    private boolean propcnmr_CommentDefined = false;

    public void Parse(String inputtext) {
        this.breakUp(inputtext);
        this.defined = true;
    }

    public String getDetails() {
        String out = "";
        if (this.defined) {
            out = out + "   ";
            if (this.propcnmr_ShiftPointDefined) {
                out = out + "" + this.propcnmr_ShiftPoint + "";
            }
            out = out + "";
            if (this.propcnmr_ShiftLowerDefined) {
                out = out + "" + this.propcnmr_ShiftLower + " - " + this.propcnmr_ShiftUpper + "";
            }
            out = out + " ppm";
            if (this.propcnmr_PeakTypeDefined) {
                out = out + ", " + this.propcnmr_PeakType + "";
            }
            out = out + "";
            if (this.propcnmr_CommentDefined) {
                out = out + " : " + this.propcnmr_Comment + "";
            }
            out = out + "\n";
        }
        return out;
    }

    public String getDetailsHTML() {
        String out = "";
        if (this.defined) {
            out = out + "<tr><td>";
            if (this.propcnmr_ShiftPointDefined) {
                out = out + "" + this.propcnmr_ShiftPoint + "";
            }
            out = out + "";
            if (this.propcnmr_ShiftLowerDefined) {
                out = out + "" + this.propcnmr_ShiftLower + " - " + this.propcnmr_ShiftUpper + "";
            }
            out = out + "</td><td>";
            if (this.propcnmr_PeakTypeDefined) {
                out = out + "" + this.propcnmr_PeakType + "";
            }
            out = out + "</td><td>";
            if (this.propcnmr_CommentDefined) {
                out = out + "" + this.propcnmr_Comment + "";
            }
            out = out + "</td></tr>";
        }
        return out;
    }

    public String getXML() {
        if (!this.defined) {
            return "";
        }
        String out = "         <peak>\n";
        if (this.propcnmr_ShiftPointDefined) {
            out = out + "            <value id=\"shiftpoint\">" + this.propcnmr_ShiftPoint + "</value>\n";
        }
        if (this.propcnmr_ShiftLowerDefined) {
            out = out + "            <value id=\"shiftlower\">" + this.propcnmr_ShiftLower + "</value>\n";
        }
        if (this.propcnmr_ShiftUpperDefined) {
            out = out + "            <value id=\"shiftupper\">" + this.propcnmr_ShiftUpper + "</value>\n";
        }
        if (this.propcnmr_PeakTypeDefined) {
            out = out + "            <value id=\"sigtype\">" + this.propcnmr_PeakType + "</value>\n";
        }
        if (this.propcnmr_CommentDefined) {
            out = out + "            <value id=\"comment\">" + this.propcnmr_Comment + "</value>\n";
        }
        out = out + "         </peak>\n";
        return out;
    }

    public boolean isSet() {
        return this.defined;
    }

    private void breakUp(String data) {
        data = this.matchPOINTER(data);
        data = this.matchcnmr_ShiftPoint(data);
        data = this.matchcnmr_ShiftLower(data);
        data = this.matchcnmr_ShiftUpper(data);
        data = this.matchcnmr_PeakType(data);
        data = this.matchcnmr_Comment(data);
    }

    public void setNextPeak(CNMRPeakData thePeak) {
        this.nextPeak = thePeak;
    }

    public CNMRPeakData getNextPeak() {
        return this.nextPeak;
    }

    private String matchPOINTER(String data) {
        boolean found = false;
        Pattern re = new Pattern("((NMR\\W*?)?\\bdC|(13C\\W+?NMR(\\W*?)))", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propPOINTER = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propPOINTER = "";
        }
        this.propPOINTERDefined = found;
        if (this.propPOINTER == "") {
            this.propPOINTERDefined = false;
        }
        if (this.propPOINTER == null) {
            this.propPOINTERDefined = false;
            this.propPOINTER = "";
        }
        return data;
    }

    public boolean isPOINTERDefined() {
        return this.propPOINTERDefined;
    }

    public String getPOINTER() {
        return this.propPOINTER;
    }

    private String matchcnmr_ShiftPoint(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t^\\s*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\\s*(?![\u2013\\-\\?]|\\.\\d)\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propcnmr_ShiftPoint = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propcnmr_ShiftPoint = "";
        }
        this.propcnmr_ShiftPointDefined = found;
        if (this.propcnmr_ShiftPoint == "") {
            this.propcnmr_ShiftPointDefined = false;
        }
        if (this.propcnmr_ShiftPoint == null) {
            this.propcnmr_ShiftPointDefined = false;
            this.propcnmr_ShiftPoint = "";
        }
        return data;
    }

    public boolean iscnmr_ShiftPointDefined() {
        return this.propcnmr_ShiftPointDefined;
    }

    public String getcnmr_ShiftPoint() {
        return this.propcnmr_ShiftPoint;
    }

    private String matchcnmr_ShiftLower(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t^\\s*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\\s*(?=[\u2013\\-\\?])\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propcnmr_ShiftLower = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propcnmr_ShiftLower = "";
        }
        this.propcnmr_ShiftLowerDefined = found;
        if (this.propcnmr_ShiftLower == "") {
            this.propcnmr_ShiftLowerDefined = false;
        }
        if (this.propcnmr_ShiftLower == null) {
            this.propcnmr_ShiftLowerDefined = false;
            this.propcnmr_ShiftLower = "";
        }
        return data;
    }

    public boolean iscnmr_ShiftLowerDefined() {
        return this.propcnmr_ShiftLowerDefined;
    }

    public String getcnmr_ShiftLower() {
        return this.propcnmr_ShiftLower;
    }

    private String matchcnmr_ShiftUpper(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t^\\s*[\u2013\\-\\?]\\s*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propcnmr_ShiftUpper = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propcnmr_ShiftUpper = "";
        }
        this.propcnmr_ShiftUpperDefined = found;
        if (this.propcnmr_ShiftUpper == "") {
            this.propcnmr_ShiftUpperDefined = false;
        }
        if (this.propcnmr_ShiftUpper == null) {
            this.propcnmr_ShiftUpperDefined = false;
            this.propcnmr_ShiftUpper = "";
        }
        return data;
    }

    public boolean iscnmr_ShiftUpperDefined() {
        return this.propcnmr_ShiftUpperDefined;
    }

    public String getcnmr_ShiftUpper() {
        return this.propcnmr_ShiftUpper;
    }

    private String matchcnmr_PeakType(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t\\b(\t\t\t\t(br\\W+|b\\W*|app\\w*\\W+)?\t\t\t\t(?:s|m|[tdq]+|qn|quint\\w*|sextet|sept|septet|oct|octet|AB\\w*)(\\s+br)?\t\t\t)\\b\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propcnmr_PeakType = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propcnmr_PeakType = "";
        }
        this.propcnmr_PeakTypeDefined = found;
        if (this.propcnmr_PeakType == "") {
            this.propcnmr_PeakTypeDefined = false;
        }
        if (this.propcnmr_PeakType == null) {
            this.propcnmr_PeakTypeDefined = false;
            this.propcnmr_PeakType = "";
        }
        return data;
    }

    public boolean iscnmr_PeakTypeDefined() {
        return this.propcnmr_PeakTypeDefined;
    }

    public String getcnmr_PeakType() {
        return this.propcnmr_PeakType;
    }

    private String matchcnmr_Comment(String data) {
        boolean found = false;
        Pattern re = new Pattern("^[^\\(\\[\\{]* [\\(\\[\\{] [\\s,]* (.*?) [\\s,]* [\\}\\]\\)] [^\\}\\]\\)]*$", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propcnmr_Comment = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propcnmr_Comment = "";
        }
        this.propcnmr_CommentDefined = found;
        if (this.propcnmr_Comment == "") {
            this.propcnmr_CommentDefined = false;
        }
        if (this.propcnmr_Comment == null) {
            this.propcnmr_CommentDefined = false;
            this.propcnmr_Comment = "";
        }
        return data;
    }

    public boolean iscnmr_CommentDefined() {
        return this.propcnmr_CommentDefined;
    }

    public String getcnmr_Comment() {
        return this.propcnmr_Comment;
    }

    public float getX() {
        if (this.iscnmr_ShiftPointDefined()) {
            return Float.valueOf(this.getcnmr_ShiftPoint()).floatValue();
        }
        if (this.iscnmr_ShiftUpperDefined() & this.iscnmr_ShiftLowerDefined()) {
            return (Float.valueOf(this.getcnmr_ShiftLower()).floatValue() + Float.valueOf(this.getcnmr_ShiftUpper()).floatValue()) / 2.0f;
        }
        return 0.0f;
    }

    public float getHeight() {
        if (this.iscnmr_ShiftPointDefined() | this.iscnmr_ShiftUpperDefined() & this.iscnmr_ShiftLowerDefined()) {
            if (Tools.SearchExp("\\b((C(=?O[^CMH]|N|ph|F|Br|Ar|ar|\\([^0-9]|C|M))|(Ar-?C\\b)|((-|O|C)C(C|\\(\\D|M|N|F|Br)))", this.getcnmr_Comment())) {
                return 0.2f;
            }
            return 0.7f;
        }
        return 0.0f;
    }

    public float getWidth() {
        if (this.iscnmr_ShiftUpperDefined() & this.iscnmr_ShiftLowerDefined()) {
            return Float.valueOf(this.getcnmr_ShiftUpper()).floatValue() - Float.valueOf(this.getcnmr_ShiftLower()).floatValue();
        }
        return 0.0f;
    }

    public int getType() {
        if (this.iscnmr_ShiftUpperDefined() & this.iscnmr_ShiftLowerDefined()) {
            return 2;
        }
        return 0;
    }

    public String getAnnotation() {
        return this.getcnmr_Comment();
    }
}

