/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import java.util.Vector;
import uk.ac.cam.ch.oscar.Analysis;
import uk.ac.cam.ch.oscar.BPData;
import uk.ac.cam.ch.oscar.CNMRData;
import uk.ac.cam.ch.oscar.ElemAnalData;
import uk.ac.cam.ch.oscar.HNMRData;
import uk.ac.cam.ch.oscar.HRMSData;
import uk.ac.cam.ch.oscar.HighlightInfo;
import uk.ac.cam.ch.oscar.IRData;
import uk.ac.cam.ch.oscar.MPData;
import uk.ac.cam.ch.oscar.MassSpecData;
import uk.ac.cam.ch.oscar.NameData;
import uk.ac.cam.ch.oscar.NatureData;
import uk.ac.cam.ch.oscar.OptRotData;
import uk.ac.cam.ch.oscar.RFData;
import uk.ac.cam.ch.oscar.RefIndexData;
import uk.ac.cam.ch.oscar.SpectrumInfo;
import uk.ac.cam.ch.oscar.UVData;
import uk.ac.cam.ch.oscar.YieldData;

public class ExpData {
    private String inputtext = "";
    private String leftover;
    private HighlightInfo hi = new HighlightInfo();
    protected ElemAnalData m_ElemAnalData = new ElemAnalData();
    protected HNMRData m_HNMRData = new HNMRData();
    protected CNMRData m_CNMRData = new CNMRData();
    protected IRData m_IRData = new IRData();
    protected UVData m_UVData = new UVData();
    protected HRMSData m_HRMSData = new HRMSData();
    protected MassSpecData m_MassSpecData = new MassSpecData();
    protected NatureData m_NatureData = new NatureData();
    protected YieldData m_YieldData = new YieldData();
    protected MPData m_MPData = new MPData();
    protected BPData m_BPData = new BPData();
    protected OptRotData m_OptRotData = new OptRotData();
    protected RFData m_RFData = new RFData();
    protected RefIndexData m_RefIndexData = new RefIndexData();
    protected NameData m_NameData = new NameData();
    public static String[] DataNames = new String[]{"BP", "CNMR", "ElemAnal", "HNMR", "HRMS", "IR", "MassSpec", "MP", "Name", "Nature", "OptRot", "RefIndex", "RF", "UV", "Yield"};
    public static String[] SpectrumNames = new String[]{"C-NMR", "H-NMR", "IR", "Mass Spec", "UV"};

    public String getName() {
        if (this.m_NameData.isSet()) {
            return this.m_NameData.getBlock();
        }
        return "Unidentified compound";
    }

    public boolean[] getDataDefined() {
        boolean[] b2 = new boolean[]{this.m_BPData.isSet(), this.m_CNMRData.isSet(), this.m_ElemAnalData.isSet(), this.m_HNMRData.isSet(), this.m_HRMSData.isSet(), this.m_IRData.isSet(), this.m_MassSpecData.isSet(), this.m_MPData.isSet(), this.m_NameData.isSet(), this.m_NatureData.isSet(), this.m_OptRotData.isSet(), this.m_RefIndexData.isSet(), this.m_RFData.isSet(), this.m_UVData.isSet(), this.m_YieldData.isSet()};
        return b2;
    }

    public SpectrumInfo getSpectrumInfo(int i) {
        switch (i) {
            case 0: {
                if (this.m_CNMRData.isSet()) {
                    return this.m_CNMRData.getSI();
                }
                return null;
            }
            case 1: {
                if (this.m_HNMRData.isSet()) {
                    return this.m_HNMRData.getSI();
                }
                return null;
            }
            case 2: {
                if (this.m_IRData.isSet()) {
                    return this.m_IRData.getSI();
                }
                return null;
            }
            case 3: {
                if (this.m_MassSpecData.isSet()) {
                    return this.m_MassSpecData.getSI();
                }
                return null;
            }
            case 4: {
                if (this.m_UVData.isSet()) {
                    return this.m_UVData.getSI();
                }
                return null;
            }
        }
        return null;
    }

    public HighlightInfo getHighlightInfo() {
        return this.hi;
    }

    public void setInput(String journaltext) {
        if (this.inputtext != journaltext) {
            this.inputtext = journaltext;
            this.Parse();
        }
    }

    public String getXML() {
        String XMLout = "   <compound>\n";
        XMLout = XMLout + this.m_BPData.getXML();
        XMLout = XMLout + this.m_CNMRData.getXML();
        XMLout = XMLout + this.m_ElemAnalData.getXML();
        XMLout = XMLout + this.m_HNMRData.getXML();
        XMLout = XMLout + this.m_HRMSData.getXML();
        XMLout = XMLout + this.m_IRData.getXML();
        XMLout = XMLout + this.m_MassSpecData.getXML();
        XMLout = XMLout + this.m_MPData.getXML();
        XMLout = XMLout + this.m_NameData.getXML();
        XMLout = XMLout + this.m_NatureData.getXML();
        XMLout = XMLout + this.m_OptRotData.getXML();
        XMLout = XMLout + this.m_RefIndexData.getXML();
        XMLout = XMLout + this.m_RFData.getXML();
        XMLout = XMLout + this.m_UVData.getXML();
        XMLout = XMLout + this.m_YieldData.getXML();
        XMLout = XMLout + "   </compound>\n";
        return XMLout;
    }

    public String getSummary() {
        String summaryout = "Summary: ";
        summaryout = summaryout + this.getName();
        summaryout = summaryout + "\n\n";
        summaryout = summaryout + "Found:\n";
        if (this.m_BPData.isSet()) {
            summaryout = summaryout + "   " + this.m_BPData.getSummary() + "\n";
        }
        if (this.m_CNMRData.isSet()) {
            summaryout = summaryout + "   " + this.m_CNMRData.getSummary() + "\n";
        }
        if (this.m_ElemAnalData.isSet()) {
            summaryout = summaryout + "   " + this.m_ElemAnalData.getSummary() + "\n";
        }
        if (this.m_HNMRData.isSet()) {
            summaryout = summaryout + "   " + this.m_HNMRData.getSummary() + "\n";
        }
        if (this.m_HRMSData.isSet()) {
            summaryout = summaryout + "   " + this.m_HRMSData.getSummary() + "\n";
        }
        if (this.m_IRData.isSet()) {
            summaryout = summaryout + "   " + this.m_IRData.getSummary() + "\n";
        }
        if (this.m_MassSpecData.isSet()) {
            summaryout = summaryout + "   " + this.m_MassSpecData.getSummary() + "\n";
        }
        if (this.m_MPData.isSet()) {
            summaryout = summaryout + "   " + this.m_MPData.getSummary() + "\n";
        }
        if (this.m_NameData.isSet()) {
            summaryout = summaryout + "   " + this.m_NameData.getSummary() + "\n";
        }
        if (this.m_NatureData.isSet()) {
            summaryout = summaryout + "   " + this.m_NatureData.getSummary() + "\n";
        }
        if (this.m_OptRotData.isSet()) {
            summaryout = summaryout + "   " + this.m_OptRotData.getSummary() + "\n";
        }
        if (this.m_RefIndexData.isSet()) {
            summaryout = summaryout + "   " + this.m_RefIndexData.getSummary() + "\n";
        }
        if (this.m_RFData.isSet()) {
            summaryout = summaryout + "   " + this.m_RFData.getSummary() + "\n";
        }
        if (this.m_UVData.isSet()) {
            summaryout = summaryout + "   " + this.m_UVData.getSummary() + "\n";
        }
        if (this.m_YieldData.isSet()) {
            summaryout = summaryout + "   " + this.m_YieldData.getSummary() + "\n";
        }
        summaryout = summaryout + "\nAbsent:\n";
        if (!this.m_BPData.isSet()) {
            summaryout = summaryout + "   " + this.m_BPData.getSummary() + "\n";
        }
        if (!this.m_CNMRData.isSet()) {
            summaryout = summaryout + "   " + this.m_CNMRData.getSummary() + "\n";
        }
        if (!this.m_ElemAnalData.isSet()) {
            summaryout = summaryout + "   " + this.m_ElemAnalData.getSummary() + "\n";
        }
        if (!this.m_HNMRData.isSet()) {
            summaryout = summaryout + "   " + this.m_HNMRData.getSummary() + "\n";
        }
        if (!this.m_HRMSData.isSet()) {
            summaryout = summaryout + "   " + this.m_HRMSData.getSummary() + "\n";
        }
        if (!this.m_IRData.isSet()) {
            summaryout = summaryout + "   " + this.m_IRData.getSummary() + "\n";
        }
        if (!this.m_MassSpecData.isSet()) {
            summaryout = summaryout + "   " + this.m_MassSpecData.getSummary() + "\n";
        }
        if (!this.m_MPData.isSet()) {
            summaryout = summaryout + "   " + this.m_MPData.getSummary() + "\n";
        }
        if (!this.m_NameData.isSet()) {
            summaryout = summaryout + "   " + this.m_NameData.getSummary() + "\n";
        }
        if (!this.m_NatureData.isSet()) {
            summaryout = summaryout + "   " + this.m_NatureData.getSummary() + "\n";
        }
        if (!this.m_OptRotData.isSet()) {
            summaryout = summaryout + "   " + this.m_OptRotData.getSummary() + "\n";
        }
        if (!this.m_RefIndexData.isSet()) {
            summaryout = summaryout + "   " + this.m_RefIndexData.getSummary() + "\n";
        }
        if (!this.m_RFData.isSet()) {
            summaryout = summaryout + "   " + this.m_RFData.getSummary() + "\n";
        }
        if (!this.m_UVData.isSet()) {
            summaryout = summaryout + "   " + this.m_UVData.getSummary() + "\n";
        }
        if (!this.m_YieldData.isSet()) {
            summaryout = summaryout + "   " + this.m_YieldData.getSummary() + "\n";
        }
        summaryout = summaryout + "\nUnrecognised data:\n   " + this.leftover + "\n";
        summaryout = summaryout + "\nInput data:\n   " + this.inputtext + "\n";
        return summaryout;
    }

    public String getSummaryHTML() {
        String out = "<h2>Summary: ";
        out = out + this.getName();
        out = out + "</h2>";
        out = out + "<h3>Data found</h3>";
        out = out + "<table cellpadding=3 cellspacing=0 border=0>";
        out = out + "<tr><td width=\"80\"></td><td bgcolor=\"#ddffdd\" width=\"150\"><b>Found</b></td>";
        out = out + "<td bgcolor=\"#ffdddd\" width=\"150\"><b>Absent</b></td></tr>";
        String[] spectra_names = new String[]{this.m_CNMRData.getSummary(), this.m_HNMRData.getSummary(), this.m_IRData.getSummary(), this.m_MassSpecData.getSummary(), this.m_UVData.getSummary()};
        boolean[] spectra_set = new boolean[]{this.m_CNMRData.isSet(), this.m_HNMRData.isSet(), this.m_IRData.isSet(), this.m_MassSpecData.isSet(), this.m_UVData.isSet()};
        int spectra_found = 0;
        String[] spectra_found_column = new String[spectra_names.length];
        String[] spectra_absent_column = new String[spectra_names.length];
        int i = 0;
        while (i < spectra_set.length) {
            if (spectra_set[i]) {
                spectra_found_column[spectra_found] = "<a href=\"spec" + i + "\">" + spectra_names[i] + "</a>";
                ++spectra_found;
            } else {
                spectra_absent_column[i - spectra_found] = spectra_names[i];
            }
            ++i;
        }
        int spectramax = 2 * spectra_found > spectra_names.length ? spectra_found : spectra_names.length - spectra_found;
        int i2 = 0;
        while (i2 < spectramax) {
            out = out + "<tr>";
            out = i2 == 0 ? out + "<td><b>Spectra:</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>" : out + "<td></td>";
            out = out + "<td bgcolor=\"#ddffdd\">";
            if (spectra_found_column[i2] != null) {
                out = out + spectra_found_column[i2];
            }
            out = out + "</td><td bgcolor=\"#ffdddd\">";
            if (spectra_absent_column[i2] != null) {
                out = out + spectra_absent_column[i2];
            }
            out = out + "</td></tr>";
            ++i2;
        }
        String[] properties_names = new String[]{this.m_BPData.getSummary(), this.m_ElemAnalData.getSummary(), this.m_HRMSData.getSummary(), this.m_MPData.getSummary(), this.m_NameData.getSummary(), this.m_NatureData.getSummary(), this.m_OptRotData.getSummary(), this.m_RefIndexData.getSummary(), this.m_RFData.getSummary(), this.m_YieldData.getSummary()};
        boolean[] properties_set = new boolean[]{this.m_BPData.isSet(), this.m_ElemAnalData.isSet(), this.m_HRMSData.isSet(), this.m_MPData.isSet(), this.m_NameData.isSet(), this.m_NatureData.isSet(), this.m_OptRotData.isSet(), this.m_RefIndexData.isSet(), this.m_RFData.isSet(), this.m_YieldData.isSet()};
        int properties_found = 0;
        String[] properties_found_column = new String[properties_names.length];
        String[] properties_absent_column = new String[properties_names.length];
        int i3 = 0;
        while (i3 < properties_set.length) {
            if (properties_set[i3]) {
                properties_found_column[properties_found] = "<a href=\"prop" + properties_names[i3] + "\">" + properties_names[i3] + "</a>";
                ++properties_found;
            } else {
                properties_absent_column[i3 - properties_found] = properties_names[i3];
            }
            ++i3;
        }
        int propertiesmax = 2 * properties_found > properties_names.length ? properties_found : properties_names.length - properties_found;
        int i4 = 0;
        while (i4 < propertiesmax) {
            out = out + "<tr>";
            out = i4 == 0 ? out + "<td><b>Properties:</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>" : out + "<td></td>";
            out = out + "<td bgcolor=\"#ddffdd\">";
            if (properties_found_column[i4] != null) {
                out = out + properties_found_column[i4];
            }
            out = out + "</td><td bgcolor=\"#ffdddd\">";
            if (properties_absent_column[i4] != null) {
                out = out + properties_absent_column[i4];
            }
            out = out + "</td></tr>";
            ++i4;
        }
        out = out + "</table>";
        out = out + "<h3>Input data</h3>";
        out = out + "<p>";
        out = out + this.inputtext;
        out = out + "</p>";
        return out;
    }

    public String getDetails() {
        String detailsout = "";
        detailsout = detailsout + this.m_BPData.getDetails();
        detailsout = detailsout + this.m_CNMRData.getDetails();
        detailsout = detailsout + this.m_ElemAnalData.getDetails();
        detailsout = detailsout + this.m_HNMRData.getDetails();
        detailsout = detailsout + this.m_HRMSData.getDetails();
        detailsout = detailsout + this.m_IRData.getDetails();
        detailsout = detailsout + this.m_MassSpecData.getDetails();
        detailsout = detailsout + this.m_MPData.getDetails();
        detailsout = detailsout + this.m_NameData.getDetails();
        detailsout = detailsout + this.m_NatureData.getDetails();
        detailsout = detailsout + this.m_OptRotData.getDetails();
        detailsout = detailsout + this.m_RefIndexData.getDetails();
        detailsout = detailsout + this.m_RFData.getDetails();
        detailsout = detailsout + this.m_UVData.getDetails();
        detailsout = detailsout + this.m_YieldData.getDetails();
        return detailsout;
    }

    public String getDetailsHTML() {
        String out = "<h2>Details: ";
        out = out + this.getName();
        out = out + "</h2>";
        out = out + "<p>";
        boolean b2 = false;
        if (this.m_BPData.isSet()) {
            if (b2) {
                out = out + " | ";
            } else {
                b2 = true;
            }
            out = out + "<a href=\"propBoiling Point\">Boiling Point</a>";
        }
        if (this.m_CNMRData.isSet()) {
            if (b2) {
                out = out + " | ";
            } else {
                b2 = true;
            }
            out = out + "<a href=\"propC-NMR\">C-NMR</a>";
        }
        if (this.m_ElemAnalData.isSet()) {
            if (b2) {
                out = out + " | ";
            } else {
                b2 = true;
            }
            out = out + "<a href=\"propElemental Analysis\">Elemental Analysis</a>";
        }
        if (this.m_HRMSData.isSet()) {
            if (b2) {
                out = out + " | ";
            } else {
                b2 = true;
            }
            out = out + "<a href=\"propHigh-Res Mass Spec\">High-Res Mass Spec</a>";
        }
        if (this.m_HNMRData.isSet()) {
            if (b2) {
                out = out + " | ";
            } else {
                b2 = true;
            }
            out = out + "<a href=\"propH-NMR\">H-NMR</a>";
        }
        if (this.m_IRData.isSet()) {
            if (b2) {
                out = out + " | ";
            } else {
                b2 = true;
            }
            out = out + "<a href=\"propIR\">IR</a>";
        }
        if (this.m_MassSpecData.isSet()) {
            if (b2) {
                out = out + " | ";
            } else {
                b2 = true;
            }
            out = out + "<a href=\"propMass Spec\">Mass Spec</a>";
        }
        if (this.m_MPData.isSet()) {
            if (b2) {
                out = out + " | ";
            } else {
                b2 = true;
            }
            out = out + "<a href=\"propMelting Point\">Melting Point</a>";
        }
        if (this.m_NameData.isSet()) {
            if (b2) {
                out = out + " | ";
            } else {
                b2 = true;
            }
            out = out + "<a href=\"propName\">Name</a>";
        }
        if (this.m_NatureData.isSet()) {
            if (b2) {
                out = out + " | ";
            } else {
                b2 = true;
            }
            out = out + "<a href=\"propNature\">Nature</a>";
        }
        if (this.m_OptRotData.isSet()) {
            if (b2) {
                out = out + " | ";
            } else {
                b2 = true;
            }
            out = out + "<a href=\"propOptical Rotation\">Optical Rotation</a>";
        }
        if (this.m_RefIndexData.isSet()) {
            if (b2) {
                out = out + " | ";
            } else {
                b2 = true;
            }
            out = out + "<a href=\"propRefractive Index\">Refractive Index</a>";
        }
        if (this.m_RFData.isSet()) {
            if (b2) {
                out = out + " | ";
            } else {
                b2 = true;
            }
            out = out + "<a href=\"propRf\">Rf</a>";
        }
        if (this.m_UVData.isSet()) {
            if (b2) {
                out = out + " | ";
            } else {
                b2 = true;
            }
            out = out + "<a href=\"propUV\">UV</a>";
        }
        if (this.m_YieldData.isSet()) {
            if (b2) {
                out = out + " | ";
            } else {
                b2 = true;
            }
            out = out + "<a href=\"propYield\">Yield</a>";
        }
        out = out + "</p>";
        out = out + this.m_BPData.getDetailsHTML();
        out = out + this.m_CNMRData.getDetailsHTML();
        out = out + this.m_ElemAnalData.getDetailsHTML();
        out = out + this.m_HRMSData.getDetailsHTML();
        out = out + this.m_HNMRData.getDetailsHTML();
        out = out + this.m_IRData.getDetailsHTML();
        out = out + this.m_MassSpecData.getDetailsHTML();
        out = out + this.m_MPData.getDetailsHTML();
        out = out + this.m_NameData.getDetailsHTML();
        out = out + this.m_NatureData.getDetailsHTML();
        out = out + this.m_OptRotData.getDetailsHTML();
        out = out + this.m_RefIndexData.getDetailsHTML();
        out = out + this.m_RFData.getDetailsHTML();
        out = out + this.m_UVData.getDetailsHTML();
        out = out + this.m_YieldData.getDetailsHTML();
        return out;
    }

    public String getAnalysis() {
        Analysis a2 = new Analysis(this.m_BPData, this.m_CNMRData, this.m_ElemAnalData, this.m_HNMRData, this.m_HRMSData, this.m_IRData, this.m_MassSpecData, this.m_MPData, this.m_NameData, this.m_NatureData, this.m_OptRotData, this.m_RefIndexData, this.m_RFData, this.m_UVData, this.m_YieldData);
        return a2.getAnalysis();
    }

    public String getAnalysisHTML() {
        Analysis a2 = new Analysis(this.m_BPData, this.m_CNMRData, this.m_ElemAnalData, this.m_HNMRData, this.m_HRMSData, this.m_IRData, this.m_MassSpecData, this.m_MPData, this.m_NameData, this.m_NatureData, this.m_OptRotData, this.m_RefIndexData, this.m_RFData, this.m_UVData, this.m_YieldData);
        return a2.getAnalysisHTML();
    }

    public Vector[] getAnalysisParagraphs(int priority) {
        Analysis a2 = new Analysis(this.m_BPData, this.m_CNMRData, this.m_ElemAnalData, this.m_HNMRData, this.m_HRMSData, this.m_IRData, this.m_MassSpecData, this.m_MPData, this.m_NameData, this.m_NatureData, this.m_OptRotData, this.m_RefIndexData, this.m_RFData, this.m_UVData, this.m_YieldData);
        return a2.getAnalysisParagraphs(priority);
    }

    private void Parse() {
        int p;
        String strippedtext = this.inputtext;
        this.hi.empty();
        strippedtext = this.m_ElemAnalData.Parse(strippedtext);
        if (this.m_ElemAnalData.isSet()) {
            p = this.inputtext.indexOf(this.m_ElemAnalData.getBlock());
            this.hi.add(p, p + this.m_ElemAnalData.getBlock().length(), this.m_ElemAnalData.getColor());
        }
        strippedtext = this.m_HNMRData.Parse(strippedtext);
        if (this.m_HNMRData.isSet()) {
            p = this.inputtext.indexOf(this.m_HNMRData.getBlock());
            this.hi.add(p, p + this.m_HNMRData.getBlock().length(), this.m_HNMRData.getColor());
        }
        strippedtext = this.m_CNMRData.Parse(strippedtext);
        if (this.m_CNMRData.isSet()) {
            p = this.inputtext.indexOf(this.m_CNMRData.getBlock());
            this.hi.add(p, p + this.m_CNMRData.getBlock().length(), this.m_CNMRData.getColor());
        }
        strippedtext = this.m_IRData.Parse(strippedtext);
        if (this.m_IRData.isSet()) {
            p = this.inputtext.indexOf(this.m_IRData.getBlock());
            this.hi.add(p, p + this.m_IRData.getBlock().length(), this.m_IRData.getColor());
        }
        strippedtext = this.m_UVData.Parse(strippedtext);
        if (this.m_UVData.isSet()) {
            p = this.inputtext.indexOf(this.m_UVData.getBlock());
            this.hi.add(p, p + this.m_UVData.getBlock().length(), this.m_UVData.getColor());
        }
        strippedtext = this.m_HRMSData.Parse(strippedtext);
        if (this.m_HRMSData.isSet()) {
            p = this.inputtext.indexOf(this.m_HRMSData.getBlock());
            this.hi.add(p, p + this.m_HRMSData.getBlock().length(), this.m_HRMSData.getColor());
        }
        strippedtext = this.m_MassSpecData.Parse(strippedtext);
        if (this.m_MassSpecData.isSet()) {
            p = this.inputtext.indexOf(this.m_MassSpecData.getBlock());
            this.hi.add(p, p + this.m_MassSpecData.getBlock().length(), this.m_MassSpecData.getColor());
        }
        strippedtext = this.m_NatureData.Parse(strippedtext);
        if (this.m_NatureData.isSet()) {
            p = this.inputtext.indexOf(this.m_NatureData.getBlock());
            this.hi.add(p, p + this.m_NatureData.getBlock().length(), this.m_NatureData.getColor());
        }
        strippedtext = this.m_YieldData.Parse(strippedtext);
        if (this.m_YieldData.isSet()) {
            p = this.inputtext.indexOf(this.m_YieldData.getBlock());
            this.hi.add(p, p + this.m_YieldData.getBlock().length(), this.m_YieldData.getColor());
        }
        strippedtext = this.m_MPData.Parse(strippedtext);
        if (this.m_MPData.isSet()) {
            p = this.inputtext.indexOf(this.m_MPData.getBlock());
            this.hi.add(p, p + this.m_MPData.getBlock().length(), this.m_MPData.getColor());
        }
        strippedtext = this.m_BPData.Parse(strippedtext);
        if (this.m_BPData.isSet()) {
            p = this.inputtext.indexOf(this.m_BPData.getBlock());
            this.hi.add(p, p + this.m_BPData.getBlock().length(), this.m_BPData.getColor());
        }
        strippedtext = this.m_OptRotData.Parse(strippedtext);
        if (this.m_OptRotData.isSet()) {
            p = this.inputtext.indexOf(this.m_OptRotData.getBlock());
            this.hi.add(p, p + this.m_OptRotData.getBlock().length(), this.m_OptRotData.getColor());
        }
        strippedtext = this.m_RFData.Parse(strippedtext);
        if (this.m_RFData.isSet()) {
            p = this.inputtext.indexOf(this.m_RFData.getBlock());
            this.hi.add(p, p + this.m_RFData.getBlock().length(), this.m_RFData.getColor());
        }
        strippedtext = this.m_RefIndexData.Parse(strippedtext);
        if (this.m_RefIndexData.isSet()) {
            p = this.inputtext.indexOf(this.m_RefIndexData.getBlock());
            this.hi.add(p, p + this.m_RefIndexData.getBlock().length(), this.m_RefIndexData.getColor());
        }
        strippedtext = this.m_NameData.Parse(strippedtext);
        if (this.m_NameData.isSet()) {
            p = this.inputtext.indexOf(this.m_NameData.getBlock());
            this.hi.add(p, p + this.m_NameData.getBlock().length(), this.m_NameData.getColor());
        }
        this.leftover = strippedtext;
    }

    public SpectrumInfo getHNMRInfo() {
        if (this.m_HNMRData.isSet()) {
            return this.m_HNMRData.getSI();
        }
        return null;
    }

    public SpectrumInfo getCNMRInfo() {
        if (this.m_CNMRData.isSet()) {
            return this.m_CNMRData.getSI();
        }
        return null;
    }

    public SpectrumInfo getIRInfo() {
        if (this.m_IRData.isSet()) {
            return this.m_IRData.getSI();
        }
        return null;
    }

    public SpectrumInfo getUVInfo() {
        if (this.m_UVData.isSet()) {
            return this.m_UVData.getSI();
        }
        return null;
    }

    public SpectrumInfo getMassSpecInfo() {
        if (this.m_MassSpecData.isSet()) {
            return this.m_MassSpecData.getSI();
        }
        return null;
    }
}

