/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import jregex.Matcher;
import jregex.Pattern;
import uk.ac.cam.ch.oscar.DataPointInterface;

public class HNMRPeakData
implements DataPointInterface {
    private boolean defined = false;
    private String blockdata = "";
    private HNMRPeakData nextPeak = null;
    private String propPOINTER = "";
    private boolean propPOINTERDefined = false;
    private String prophnmr_ShiftPoint = "";
    private boolean prophnmr_ShiftPointDefined = false;
    private String prophnmr_ShiftLower = "";
    private boolean prophnmr_ShiftLowerDefined = false;
    private String prophnmr_ShiftUpper = "";
    private boolean prophnmr_ShiftUpperDefined = false;
    private String prophnmr_PeakType = "";
    private boolean prophnmr_PeakTypeDefined = false;
    private String prophnmr_Integral = "";
    private boolean prophnmr_IntegralDefined = false;
    private String prophnmr_Coupling = "";
    private boolean prophnmr_CouplingDefined = false;
    private String prophnmr_Comment = "";
    private boolean prophnmr_CommentDefined = false;

    public void Parse(String inputtext) {
        this.breakUp(inputtext);
        this.defined = true;
    }

    public String getDetails() {
        String out = "";
        if (this.defined) {
            out = out + "   ";
            if (this.prophnmr_ShiftPointDefined) {
                out = out + "" + this.prophnmr_ShiftPoint + "";
            }
            out = out + "";
            if (this.prophnmr_ShiftLowerDefined) {
                out = out + "" + this.prophnmr_ShiftLower + " - " + this.prophnmr_ShiftUpper + "";
            }
            out = out + " ppm";
            if (this.prophnmr_IntegralDefined) {
                out = out + ", " + this.prophnmr_Integral + "H";
            }
            out = out + "";
            if (this.prophnmr_PeakTypeDefined) {
                out = out + ", " + this.prophnmr_PeakType + "";
            }
            out = out + "";
            if (this.prophnmr_CouplingDefined) {
                out = out + ", J " + this.prophnmr_Coupling + " Hz";
            }
            out = out + "";
            if (this.prophnmr_CommentDefined) {
                out = out + " : " + this.prophnmr_Comment + "";
            }
            out = out + "\n";
        }
        return out;
    }

    public String getDetailsHTML() {
        String out = "";
        if (this.defined) {
            out = out + "<tr><td>";
            if (this.prophnmr_ShiftPointDefined) {
                out = out + "" + this.prophnmr_ShiftPoint + "";
            }
            out = out + "";
            if (this.prophnmr_ShiftLowerDefined) {
                out = out + "" + this.prophnmr_ShiftLower + " - " + this.prophnmr_ShiftUpper + "";
            }
            out = out + "</td><td>";
            if (this.prophnmr_IntegralDefined) {
                out = out + "" + this.prophnmr_Integral + " H";
            }
            out = out + "</td><td>";
            if (this.prophnmr_PeakTypeDefined) {
                out = out + "" + this.prophnmr_PeakType + "";
            }
            out = out + "</td><td>";
            if (this.prophnmr_CouplingDefined) {
                out = out + "" + this.prophnmr_Coupling + " Hz";
            }
            out = out + "</td><td>";
            if (this.prophnmr_CommentDefined) {
                out = out + "" + this.prophnmr_Comment + "";
            }
            out = out + "</td></tr>";
        }
        return out;
    }

    public String getXML() {
        if (!this.defined) {
            return "";
        }
        String out = "         <peak>\n";
        if (this.prophnmr_ShiftPointDefined) {
            out = out + "            <value id=\"shiftpoint\">" + this.prophnmr_ShiftPoint + "</value>\n";
        }
        if (this.prophnmr_ShiftLowerDefined) {
            out = out + "            <value id=\"shiftlower\">" + this.prophnmr_ShiftLower + "</value>\n";
        }
        if (this.prophnmr_ShiftUpperDefined) {
            out = out + "            <value id=\"shiftupper\">" + this.prophnmr_ShiftUpper + "</value>\n";
        }
        if (this.prophnmr_PeakTypeDefined) {
            out = out + "            <value id=\"sigtype\">" + this.prophnmr_PeakType + "</value>\n";
        }
        if (this.prophnmr_IntegralDefined) {
            out = out + "            <value id=\"integral\">" + this.prophnmr_Integral + "</value>\n";
        }
        if (this.prophnmr_CouplingDefined) {
            out = out + "            <value id=\"coupling\">" + this.prophnmr_Coupling + "</value>\n";
        }
        if (this.prophnmr_CommentDefined) {
            out = out + "            <value id=\"comment\">" + this.prophnmr_Comment + "</value>\n";
        }
        out = out + "         </peak>\n";
        return out;
    }

    public boolean isSet() {
        return this.defined;
    }

    private void breakUp(String data) {
        data = this.matchPOINTER(data);
        data = this.matchhnmr_ShiftPoint(data);
        data = this.matchhnmr_ShiftLower(data);
        data = this.matchhnmr_ShiftUpper(data);
        data = this.matchhnmr_PeakType(data);
        data = this.matchhnmr_Integral(data);
        data = this.matchhnmr_Coupling(data);
        data = this.matchhnmr_Comment(data);
    }

    public void setNextPeak(HNMRPeakData thePeak) {
        this.nextPeak = thePeak;
    }

    public HNMRPeakData getNextPeak() {
        return this.nextPeak;
    }

    private String matchPOINTER(String data) {
        boolean found = false;
        Pattern re = new Pattern("((NMR\\W*?)?\\bdH|(1H\\W+?NMR(\\W*?)))", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propPOINTER = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propPOINTER = "";
        }
        this.propPOINTERDefined = found;
        if (this.propPOINTER == "") {
            this.propPOINTERDefined = false;
        }
        if (this.propPOINTER == null) {
            this.propPOINTERDefined = false;
            this.propPOINTER = "";
        }
        return data;
    }

    public boolean isPOINTERDefined() {
        return this.propPOINTERDefined;
    }

    public String getPOINTER() {
        return this.propPOINTER;
    }

    private String matchhnmr_ShiftPoint(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t^\\s*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\\s*(?![\u2013\\-\\?]|\\.\\d)\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.prophnmr_ShiftPoint = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.prophnmr_ShiftPoint = "";
        }
        this.prophnmr_ShiftPointDefined = found;
        if (this.prophnmr_ShiftPoint == "") {
            this.prophnmr_ShiftPointDefined = false;
        }
        if (this.prophnmr_ShiftPoint == null) {
            this.prophnmr_ShiftPointDefined = false;
            this.prophnmr_ShiftPoint = "";
        }
        return data;
    }

    public boolean ishnmr_ShiftPointDefined() {
        return this.prophnmr_ShiftPointDefined;
    }

    public String gethnmr_ShiftPoint() {
        return this.prophnmr_ShiftPoint;
    }

    private String matchhnmr_ShiftLower(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t^\\s*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\\s*(?=[\u2013\\-\\?])\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.prophnmr_ShiftLower = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.prophnmr_ShiftLower = "";
        }
        this.prophnmr_ShiftLowerDefined = found;
        if (this.prophnmr_ShiftLower == "") {
            this.prophnmr_ShiftLowerDefined = false;
        }
        if (this.prophnmr_ShiftLower == null) {
            this.prophnmr_ShiftLowerDefined = false;
            this.prophnmr_ShiftLower = "";
        }
        return data;
    }

    public boolean ishnmr_ShiftLowerDefined() {
        return this.prophnmr_ShiftLowerDefined;
    }

    public String gethnmr_ShiftLower() {
        return this.prophnmr_ShiftLower;
    }

    private String matchhnmr_ShiftUpper(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t^\\s*[\u2013\\-\\?]\\s*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.prophnmr_ShiftUpper = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.prophnmr_ShiftUpper = "";
        }
        this.prophnmr_ShiftUpperDefined = found;
        if (this.prophnmr_ShiftUpper == "") {
            this.prophnmr_ShiftUpperDefined = false;
        }
        if (this.prophnmr_ShiftUpper == null) {
            this.prophnmr_ShiftUpperDefined = false;
            this.prophnmr_ShiftUpper = "";
        }
        return data;
    }

    public boolean ishnmr_ShiftUpperDefined() {
        return this.prophnmr_ShiftUpperDefined;
    }

    public String gethnmr_ShiftUpper() {
        return this.prophnmr_ShiftUpper;
    }

    private String matchhnmr_PeakType(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t\\b(\t\t\t\t(br\\W+|b\\W*|app\\w*\\W+)?\t\t\t\t(?:s|m|[tdq]+|qn|quint\\w*|sextet|sept|septet|oct|octet|AB\\w*)(\\s+br)?\t\t\t)\\b\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.prophnmr_PeakType = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.prophnmr_PeakType = "";
        }
        this.prophnmr_PeakTypeDefined = found;
        if (this.prophnmr_PeakType == "") {
            this.prophnmr_PeakTypeDefined = false;
        }
        if (this.prophnmr_PeakType == null) {
            this.prophnmr_PeakTypeDefined = false;
            this.prophnmr_PeakType = "";
        }
        return data;
    }

    public boolean ishnmr_PeakTypeDefined() {
        return this.prophnmr_PeakTypeDefined;
    }

    public String gethnmr_PeakType() {
        return this.prophnmr_PeakType;
    }

    private String matchhnmr_Integral(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t\t\t\\< (\t\t\t\t\t\t(?: \\d+ \\s*[x\u00d7]\\s* )?\t\t\t\t\t\t\\d+\t\t\t\t\t) \\s* H \\b\t\t\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.prophnmr_Integral = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.prophnmr_Integral = "";
        }
        this.prophnmr_IntegralDefined = found;
        if (this.prophnmr_Integral == "") {
            this.prophnmr_IntegralDefined = false;
        }
        if (this.prophnmr_Integral == null) {
            this.prophnmr_IntegralDefined = false;
            this.prophnmr_Integral = "";
        }
        return data;
    }

    public boolean ishnmr_IntegralDefined() {
        return this.prophnmr_IntegralDefined;
    }

    public String gethnmr_Integral() {
        return this.prophnmr_Integral;
    }

    private String matchhnmr_Coupling(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t\t\t\\b J \\W*?\t\t\t\t\t(\t\t\t\t\t\t\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t\t\t\t\t\t\t(?: \\s* (?: , | and ) \\s* \t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t )*\t\t\t\t\t)\t\t\t\t\t(\\s*Hz)?\\b(?!\\s*[\u2013\\-\\?x\u00d7])\t\t\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.prophnmr_Coupling = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.prophnmr_Coupling = "";
        }
        this.prophnmr_CouplingDefined = found;
        if (this.prophnmr_Coupling == "") {
            this.prophnmr_CouplingDefined = false;
        }
        if (this.prophnmr_Coupling == null) {
            this.prophnmr_CouplingDefined = false;
            this.prophnmr_Coupling = "";
        }
        return data;
    }

    public boolean ishnmr_CouplingDefined() {
        return this.prophnmr_CouplingDefined;
    }

    public String gethnmr_Coupling() {
        return this.prophnmr_Coupling;
    }

    private String matchhnmr_Comment(String data) {
        boolean found = false;
        Pattern re = new Pattern("^[^\\(\\[\\{]* [\\(\\[\\{] [\\s,]* (?![\\s,]) (.+?) (?<![\\s,]) [\\s,]* [\\}\\]\\)] [^\\}\\]\\)]*$", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.prophnmr_Comment = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.prophnmr_Comment = "";
        }
        this.prophnmr_CommentDefined = found;
        if (this.prophnmr_Comment == "") {
            this.prophnmr_CommentDefined = false;
        }
        if (this.prophnmr_Comment == null) {
            this.prophnmr_CommentDefined = false;
            this.prophnmr_Comment = "";
        }
        return data;
    }

    public boolean ishnmr_CommentDefined() {
        return this.prophnmr_CommentDefined;
    }

    public String gethnmr_Comment() {
        return this.prophnmr_Comment;
    }

    public float getX() {
        if (this.ishnmr_ShiftPointDefined()) {
            return Float.valueOf(this.gethnmr_ShiftPoint()).floatValue();
        }
        if (this.ishnmr_ShiftUpperDefined() & this.ishnmr_ShiftLowerDefined()) {
            return (Float.valueOf(this.gethnmr_ShiftLower()).floatValue() + Float.valueOf(this.gethnmr_ShiftUpper()).floatValue()) / 2.0f;
        }
        return 0.0f;
    }

    public float getHeight() {
        Pattern re;
        Matcher m;
        if (this.ishnmr_IntegralDefined()) {
            Pattern re2 = new Pattern("(\\d+)$", 9);
            Matcher m2 = re2.matcher(this.gethnmr_Integral());
            m2.find();
            return Float.valueOf(m2.group(1)).floatValue() / 10.0f;
        }
        if (this.getNextPeak() != null && this.getNextPeak().ishnmr_IntegralDefined() && (m = (re = new Pattern("[x\u00d7]\\s*(\\d+)$", 9)).matcher(this.getNextPeak().gethnmr_Integral())).find()) {
            return Float.valueOf(m.group(1)).floatValue() / 10.0f;
        }
        return 0.1f;
    }

    public float getWidth() {
        if (this.ishnmr_ShiftUpperDefined() & this.ishnmr_ShiftLowerDefined()) {
            return Float.valueOf(this.gethnmr_ShiftUpper()).floatValue() - Float.valueOf(this.gethnmr_ShiftLower()).floatValue();
        }
        return 0.05f;
    }

    public int getType() {
        return 2;
    }

    public String getAnnotation() {
        Pattern re;
        Matcher m;
        if (this.ishnmr_PeakTypeDefined() && this.ishnmr_CommentDefined()) {
            return this.gethnmr_PeakType() + ", " + this.gethnmr_Comment();
        }
        if (this.ishnmr_CommentDefined()) {
            return this.gethnmr_Comment();
        }
        if (this.ishnmr_PeakTypeDefined()) {
            return this.gethnmr_PeakType();
        }
        if (this.getNextPeak() != null && this.getNextPeak().ishnmr_IntegralDefined() && (m = (re = new Pattern("[x\u00d7]", 9)).matcher(this.getNextPeak().gethnmr_Integral())).find()) {
            if (this.getNextPeak().ishnmr_PeakTypeDefined() && this.getNextPeak().ishnmr_CommentDefined()) {
                return this.getNextPeak().gethnmr_PeakType() + ", " + this.getNextPeak().gethnmr_Comment();
            }
            if (this.getNextPeak().ishnmr_CommentDefined()) {
                return this.getNextPeak().gethnmr_Comment();
            }
            if (this.getNextPeak().ishnmr_PeakTypeDefined()) {
                return this.getNextPeak().gethnmr_PeakType();
            }
        }
        return "";
    }
}

