/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import java.awt.Color;
import java.util.Vector;
import jregex.Matcher;
import jregex.Pattern;
import uk.ac.cam.ch.oscar.DataInterface;
import uk.ac.cam.ch.oscar.IRPeakData;
import uk.ac.cam.ch.oscar.SpectrumInfo;
import uk.ac.cam.ch.oscar.SpectrumInterface;

public class IRData
implements DataInterface,
SpectrumInterface {
    private boolean defined = false;
    private String blockdata = "";
    private Vector peaks = new Vector();
    private String propir_Form = "";
    private boolean propir_FormDefined = false;
    private String propir_Plate = "";
    private boolean propir_PlateDefined = false;

    public String getBlock() {
        return this.blockdata;
    }

    public Color getColor() {
        return new Color(255, 0, 0);
    }

    public SpectrumInfo getSI() {
        SpectrumInfo specinfo = new SpectrumInfo();
        if (this.peaks.size() == 0) {
            return null;
        }
        specinfo.xmin = 500.0f;
        specinfo.xmax = 4000.0f;
        specinfo.ymin = 0.0f;
        specinfo.ymax = 100.0f;
        specinfo.xscale = 500.0f;
        specinfo.yscale = 20.0f;
        specinfo.revX = true;
        specinfo.revY = true;
        specinfo.abs = false;
        specinfo.npeaks = this.peaks.size();
        specinfo.x = new float[this.peaks.size()];
        specinfo.height = new float[this.peaks.size()];
        specinfo.width = new float[this.peaks.size()];
        specinfo.type = new int[this.peaks.size()];
        specinfo.annotation = new String[this.peaks.size()];
        int i = 0;
        while (i < this.peaks.size()) {
            specinfo.x[i] = ((IRPeakData)this.peaks.elementAt(i)).getX();
            specinfo.height[i] = ((IRPeakData)this.peaks.elementAt(i)).getHeight();
            specinfo.width[i] = ((IRPeakData)this.peaks.elementAt(i)).getWidth();
            specinfo.type[i] = ((IRPeakData)this.peaks.elementAt(i)).getType();
            specinfo.annotation[i] = ((IRPeakData)this.peaks.elementAt(i)).getAnnotation();
            ++i;
        }
        return specinfo;
    }

    public String Parse(String inputtext) {
        Pattern re = new Pattern("\t\t\t\t(\t\t\t\t\t(?x-i:\t\t\t\t\t\tIR(?=\\D) \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t? \\W*? (?: [vun\u03bd\u03c5]?max  \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t? \\W*? )?\t\t\t\t\t|\t[vun\u03bd\u03c5]max \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t? \\W*?\t\t\t\t\t)\t\t\t\t\t(?: \t\t\t(?: \\/? cm \\.? [\u2013\\-\\?] 1 | \\( cm \\.? [\u2013\\-\\?] 1 \\) )\t\t [\\s:]* )? (?: \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t [\\s:]* )? (?: n [\\s:]* )? \t\t\t\t\t\t(\t\t\t\t\\d{3,} (?:\\.\\d+)? (?: \\s*[\u2013\\-\\?]\\s* \\d{3,} (?:\\.\\d+)? )? (?:\\s* cm[\u2013\\-\\?])?\t\t\t\t(?: \\s* (?:s|vs|m|w|b|br|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t(?:\t\t\t\t\t\t\t(?: \\s* (,|and|including|&|;|\\/) \\s* )+\t\t\t\t\t\t\t\t\t(\t\t\t\t\\d{3,} (?:\\.\\d+)? (?: \\s*[\u2013\\-\\?]\\s* \\d{3,} (?:\\.\\d+)? )? (?:\\s* cm[\u2013\\-\\?])?\t\t\t\t(?: \\s* (?:s|vs|m|w|b|br|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t)*\t\t (?: \\s* \t\t\t(?: \\/? cm \\.? [\u2013\\-\\?] 1 | \\( cm \\.? [\u2013\\-\\?] 1 \\) )\t\t )?\t\t\t\t|\t\t\t\t\t[a-z]?max \\s* (?: \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t \\W*? )?\t\t\t\t\t(?:\t\t\t\t\t\t(?: \t\t\t(?: \\/? cm \\.? [\u2013\\-\\?] 1 | \\( cm \\.? [\u2013\\-\\?] 1 \\) )\t\t [\\s:]* ) (?: \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t [\\s:]* )? (?: n [\\s:]* )? \t\t\t\t\t\t(\t\t\t\t\\d{3,} (?:\\.\\d+)? (?: \\s*[\u2013\\-\\?]\\s* \\d{3,} (?:\\.\\d+)? )? (?:\\s* cm[\u2013\\-\\?])?\t\t\t\t(?: \\s* (?:s|vs|m|w|b|br|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t(?:\t\t\t\t\t\t\t(?: \\s* (,|and|including|&|;|\\/) \\s* )+\t\t\t\t\t\t\t\t\t(\t\t\t\t\\d{3,} (?:\\.\\d+)? (?: \\s*[\u2013\\-\\?]\\s* \\d{3,} (?:\\.\\d+)? )? (?:\\s* cm[\u2013\\-\\?])?\t\t\t\t(?: \\s* (?:s|vs|m|w|b|br|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t)*\t\t\t\t\t\t\t|\t(?: n [\\s:]* )? \t\t\t\t\t\t(\t\t\t\t\\d{3,} (?:\\.\\d+)? (?: \\s*[\u2013\\-\\?]\\s* \\d{3,} (?:\\.\\d+)? )? (?:\\s* cm[\u2013\\-\\?])?\t\t\t\t(?: \\s* (?:s|vs|m|w|b|br|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t(?:\t\t\t\t\t\t\t(?: \\s* (,|and|including|&|;|\\/) \\s* )+\t\t\t\t\t\t\t\t\t(\t\t\t\t\\d{3,} (?:\\.\\d+)? (?: \\s*[\u2013\\-\\?]\\s* \\d{3,} (?:\\.\\d+)? )? (?:\\s* cm[\u2013\\-\\?])?\t\t\t\t(?: \\s* (?:s|vs|m|w|b|br|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t)*\t\t (?: \\s* \t\t\t(?: \\/? cm \\.? [\u2013\\-\\?] 1 | \\( cm \\.? [\u2013\\-\\?] 1 \\) )\t\t )\t\t\t\t\t)\t\t\t\t)\t\t\t", 9);
        Matcher m = re.matcher(inputtext);
        this.defined = m.find();
        if (this.defined) {
            this.blockdata = m.group(0);
            int i = inputtext.indexOf(this.blockdata);
            inputtext = inputtext.substring(0, i) + inputtext.substring(i + this.blockdata.length(), inputtext.length());
            this.breakUp(this.blockdata);
        } else {
            this.blockdata = "";
        }
        return inputtext;
    }

    public int getPeakCount() {
        return this.peaks.size();
    }

    public IRPeakData getPeakAt(int n) {
        return (IRPeakData)this.peaks.elementAt(n);
    }

    public String getSummary() {
        String out = "IR";
        return out;
    }

    public String getDetails() {
        String out = "";
        if (this.defined) {
            out = out + "IR:\n";
            if (this.propir_FormDefined) {
                out = out + "   Form: " + this.propir_Form + "\n";
            }
            if (this.propir_PlateDefined) {
                out = out + "   Plate: " + this.propir_Plate + "\n";
            }
            int i = 0;
            while (i < this.peaks.size()) {
                IRPeakData dp = (IRPeakData)this.peaks.elementAt(i);
                out = out + dp.getDetails();
                ++i;
            }
            out = out + "\n";
        }
        return out;
    }

    public String getDetailsHTML() {
        if (!this.defined) {
            return "";
        }
        String out = "";
        out = out + "<h3>";
        out = out + "<a name=\"IR\"></a>";
        out = out + "IR</h3>";
        out = out + "<ul>";
        out = out + "<li>";
        out = out + "<a href=\"spec2\">View plot</a>";
        if (this.propir_FormDefined) {
            out = out + "<li><b>Form:</b> " + this.propir_Form + "";
        }
        if (this.propir_PlateDefined) {
            out = out + "<li><b>Plate:</b> " + this.propir_Plate + "";
        }
        out = out + "</ul>";
        out = out + "<table border=0><tr><td width=\"40\">&nbsp;</td><td>";
        out = out + "<table border=1>";
        out = out + "<td><b>vmax</b></td><td><b>Signal Type</b></td><td><b>Comment</b></td>";
        int i = 0;
        while (i < this.peaks.size()) {
            IRPeakData dp = (IRPeakData)this.peaks.elementAt(i);
            out = out + dp.getDetailsHTML();
            ++i;
        }
        out = out + "</table>";
        out = out + "</td></tr></table>";
        return out;
    }

    public String getXML() {
        if (!this.defined) {
            return "";
        }
        String out = "      <data class=\"ir\" type=\"spectrum\">\n";
        if (this.propir_FormDefined) {
            out = out + "         <value id=\"form\">" + this.propir_Form + "</value>\n";
        }
        if (this.propir_PlateDefined) {
            out = out + "         <value id=\"plate\">" + this.propir_Plate + "</value>\n";
        }
        int i = 0;
        while (i < this.peaks.size()) {
            IRPeakData dp = (IRPeakData)this.peaks.elementAt(i);
            out = out + dp.getXML();
            ++i;
        }
        out = out + "      </data>\n";
        return out;
    }

    public boolean isSet() {
        return this.defined;
    }

    private void breakUp(String data) {
        data = this.matchir_Form(data);
        data = this.matchir_Plate(data);
        data = this.matchPeaks(data);
    }

    private String matchPeaks(String data) {
        this.peaks.removeAllElements();
        boolean found = false;
        Pattern re = new Pattern("(?!1\\b)(\t\t\t\t\t\t(\t\t\t\t\\d{3,} (?:\\.\\d+)? (?: \\s*[\u2013\\-\\?]\\s* \\d{3,} (?:\\.\\d+)? )? (?:\\s* cm[\u2013\\-\\?])?\t\t\t\t(?: \\s* (?:s|vs|m|w|b|br|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t(?:\t\t\t\t\t\t\t(?: \\s* (,|and|including|&|;|\\/) \\s* )+\t\t\t\t\t\t\t\t\t(\t\t\t\t\\d{3,} (?:\\.\\d+)? (?: \\s*[\u2013\\-\\?]\\s* \\d{3,} (?:\\.\\d+)? )? (?:\\s* cm[\u2013\\-\\?])?\t\t\t\t(?: \\s* (?:s|vs|m|w|b|br|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t)*\t\t)", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            String peakblock = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
            boolean foundpeak = false;
            re = new Pattern("(\t\t\t(\t\t\t\t\\d{3,} (?:\\.\\d+)? (?: \\s*[\u2013\\-\\?]\\s* \\d{3,} (?:\\.\\d+)? )? (?:\\s* cm[\u2013\\-\\?])?\t\t\t\t(?: \\s* (?:s|vs|m|w|b|br|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t)", 9);
            m = re.matcher(peakblock);
            foundpeak = m.find();
            while (foundpeak) {
                IRPeakData dp = new IRPeakData();
                dp.Parse(m.group(1));
                this.peaks.addElement(dp);
                int j = peakblock.indexOf(m.group(0));
                peakblock = peakblock.substring(0, j) + peakblock.substring(j + m.group(0).length(), peakblock.length());
                m = re.matcher(peakblock);
                foundpeak = m.find();
            }
            i = this.peaks.size() - 1;
            while (i-- > 0) {
                ((IRPeakData)this.peaks.elementAt(i)).setNextPeak((IRPeakData)this.peaks.elementAt(i + 1));
            }
        }
        return data;
    }

    private String matchir_Form(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\b((?:((liquid|thin)?\\s*)film|neat|nujol(\\s*mull)?|solid|CHCl3(\\s*solution)?))\\b", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propir_Form = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propir_Form = "";
        }
        this.propir_FormDefined = found;
        if (this.propir_Form == "") {
            this.propir_FormDefined = false;
        }
        if (this.propir_Form == null) {
            this.propir_FormDefined = false;
            this.propir_Form = "";
        }
        return data;
    }

    public boolean isir_FormDefined() {
        return this.propir_FormDefined;
    }

    public String getir_Form() {
        return this.propir_Form;
    }

    private String matchir_Plate(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\b((?:CaF|KBr|NaCl))\\b", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propir_Plate = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propir_Plate = "";
        }
        this.propir_PlateDefined = found;
        if (this.propir_Plate == "") {
            this.propir_PlateDefined = false;
        }
        if (this.propir_Plate == null) {
            this.propir_PlateDefined = false;
            this.propir_Plate = "";
        }
        return data;
    }

    public boolean isir_PlateDefined() {
        return this.propir_PlateDefined;
    }

    public String getir_Plate() {
        return this.propir_Plate;
    }
}

