/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import java.awt.Color;
import java.util.Vector;
import jregex.Matcher;
import jregex.Pattern;
import uk.ac.cam.ch.oscar.DataInterface;
import uk.ac.cam.ch.oscar.MassSpecPeakData;
import uk.ac.cam.ch.oscar.SpectrumInfo;
import uk.ac.cam.ch.oscar.SpectrumInterface;

public class MassSpecData
implements DataInterface,
SpectrumInterface {
    private boolean defined = false;
    private String blockdata = "";
    private Vector peaks = new Vector();
    private String propmassspec_Method = "";
    private boolean propmassspec_MethodDefined = false;

    public String getBlock() {
        return this.blockdata;
    }

    public Color getColor() {
        return new Color(64, 255, 64);
    }

    public SpectrumInfo getSI() {
        SpectrumInfo specinfo = new SpectrumInfo();
        if (this.peaks.size() == 0) {
            return null;
        }
        specinfo.xmin = 0.0f;
        specinfo.xmax = 500.0f;
        specinfo.ymin = 0.0f;
        specinfo.ymax = 100.0f;
        specinfo.xscale = 50.0f;
        specinfo.yscale = 10.0f;
        specinfo.revX = false;
        specinfo.revY = false;
        specinfo.abs = true;
        specinfo.npeaks = this.peaks.size();
        specinfo.x = new float[this.peaks.size()];
        specinfo.height = new float[this.peaks.size()];
        specinfo.width = new float[this.peaks.size()];
        specinfo.type = new int[this.peaks.size()];
        specinfo.annotation = new String[this.peaks.size()];
        int i = 0;
        while (i < this.peaks.size()) {
            specinfo.x[i] = ((MassSpecPeakData)this.peaks.elementAt(i)).getX();
            specinfo.height[i] = ((MassSpecPeakData)this.peaks.elementAt(i)).getHeight();
            specinfo.width[i] = ((MassSpecPeakData)this.peaks.elementAt(i)).getWidth();
            specinfo.type[i] = ((MassSpecPeakData)this.peaks.elementAt(i)).getType();
            specinfo.annotation[i] = ((MassSpecPeakData)this.peaks.elementAt(i)).getAnnotation();
            ++i;
        }
        return specinfo;
    }

    public String Parse(String inputtext) {
        Pattern re = new Pattern("\t\t\t\t(?:\t\t\t\t\t(?: (?x-i) (?!HR) \\b[A-Z\u2013\\-\\?]* MS\\b (?: (?!\\() \\W )*?\t\t\t\t\t|\tm\\/[ez] (?: (?!\\() \\W )*?\t\t\t\t\t)+\t\t\t\t)\t\t\t\t(?:\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t [\\s:]*)?\t\t\t\t\t\t\t\t\t\t(\t(?:\\/?\\b\\d+(?:\\.\\d+)?\\b)+\t\t\t\t(?:\t\\s*\t\t\t\t(?:\t\t\t\t(?:\t\t\t\t\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t \\d?[\\+\u2013\\-\\?]\t\t\t\t|\t\\b\t\t\t\t\t\\d? M (?:\\/\\d)?\t\t\t\t\t[a-z\\d\\+\u2013\\-\\?]*\t\t\t\t)\t\t\t)\t\t\t\t\t\t|\t\\s*\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t\t\t\t\t)*\t\t\t\t(?:\\s*\\[[^\\]]+\\][\u2013\\-\\+\\d]*)?\t\t\t)\t\t\t\t\t(?:\t\t\t\t\t\t\t(?: \\s* (,|and|including|&|;|\\/) \\s* )+\t\t\t\t\t\t\t\t\t(\t(?:\\/?\\b\\d+(?:\\.\\d+)?\\b)+\t\t\t\t(?:\t\\s*\t\t\t\t(?:\t\t\t\t(?:\t\t\t\t\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t \\d?[\\+\u2013\\-\\?]\t\t\t\t|\t\\b\t\t\t\t\t\\d? M (?:\\/\\d)?\t\t\t\t\t[a-z\\d\\+\u2013\\-\\?]*\t\t\t\t)\t\t\t)\t\t\t\t\t\t|\t\\s*\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t\t\t\t\t)*\t\t\t\t(?:\\s*\\[[^\\]]+\\][\u2013\\-\\+\\d]*)?\t\t\t)\t\t\t\t\t)*\t\t\t\t\t", 9);
        Matcher m = re.matcher(inputtext);
        this.defined = m.find();
        if (this.defined) {
            this.blockdata = m.group(0);
            int i = inputtext.indexOf(this.blockdata);
            inputtext = inputtext.substring(0, i) + inputtext.substring(i + this.blockdata.length(), inputtext.length());
            this.breakUp(this.blockdata);
        } else {
            this.blockdata = "";
        }
        return inputtext;
    }

    public int getPeakCount() {
        return this.peaks.size();
    }

    public MassSpecPeakData getPeakAt(int n) {
        return (MassSpecPeakData)this.peaks.elementAt(n);
    }

    public String getSummary() {
        String out = "Mass Spec";
        return out;
    }

    public String getDetails() {
        String out = "";
        if (this.defined) {
            out = out + "Mass Spec:\n";
            if (this.propmassspec_MethodDefined) {
                out = out + "   Method: " + this.propmassspec_Method + "\n";
            }
            int i = 0;
            while (i < this.peaks.size()) {
                MassSpecPeakData dp = (MassSpecPeakData)this.peaks.elementAt(i);
                out = out + dp.getDetails();
                ++i;
            }
            out = out + "\n";
        }
        return out;
    }

    public String getDetailsHTML() {
        if (!this.defined) {
            return "";
        }
        String out = "";
        out = out + "<h3>";
        out = out + "<a name=\"Mass Spec\"></a>";
        out = out + "Mass Spec</h3>";
        out = out + "<ul>";
        out = out + "<li>";
        out = out + "<a href=\"spec3\">View plot</a>";
        if (this.propmassspec_MethodDefined) {
            out = out + "<li><b>Method:</b> " + this.propmassspec_Method + "";
        }
        out = out + "</ul>";
        out = out + "<table border=0><tr><td width=\"40\">&nbsp;</td><td>";
        out = out + "<table border=1>";
        out = out + "<td><b>m/z</b></td><td><b>Intensity</b></td><td><b>Comment</b></td>";
        int i = 0;
        while (i < this.peaks.size()) {
            MassSpecPeakData dp = (MassSpecPeakData)this.peaks.elementAt(i);
            out = out + dp.getDetailsHTML();
            ++i;
        }
        out = out + "</table>";
        out = out + "</td></tr></table>";
        return out;
    }

    public String getXML() {
        if (!this.defined) {
            return "";
        }
        String out = "      <data class=\"massspec\" type=\"spectrum\">\n";
        if (this.propmassspec_MethodDefined) {
            out = out + "         <value id=\"method\">" + this.propmassspec_Method + "</value>\n";
        }
        int i = 0;
        while (i < this.peaks.size()) {
            MassSpecPeakData dp = (MassSpecPeakData)this.peaks.elementAt(i);
            out = out + dp.getXML();
            ++i;
        }
        out = out + "      </data>\n";
        return out;
    }

    public boolean isSet() {
        return this.defined;
    }

    private void breakUp(String data) {
        data = this.matchmassspec_Method(data);
        data = this.matchPeaks(data);
    }

    private String matchPeaks(String data) {
        this.peaks.removeAllElements();
        boolean found = false;
        Pattern re = new Pattern("\\b(\t\t\t\t\t\t(\t(?:\\/?\\b\\d+(?:\\.\\d+)?\\b)+\t\t\t\t(?:\t\\s*\t\t\t\t(?:\t\t\t\t(?:\t\t\t\t\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t \\d?[\\+\u2013\\-\\?]\t\t\t\t|\t\\b\t\t\t\t\t\\d? M (?:\\/\\d)?\t\t\t\t\t[a-z\\d\\+\u2013\\-\\?]*\t\t\t\t)\t\t\t)\t\t\t\t\t\t|\t\\s*\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t\t\t\t\t)*\t\t\t\t(?:\\s*\\[[^\\]]+\\][\u2013\\-\\+\\d]*)?\t\t\t)\t\t\t\t\t(?:\t\t\t\t\t\t\t(?: \\s* (,|and|including|&|;|\\/) \\s* )+\t\t\t\t\t\t\t\t\t(\t(?:\\/?\\b\\d+(?:\\.\\d+)?\\b)+\t\t\t\t(?:\t\\s*\t\t\t\t(?:\t\t\t\t(?:\t\t\t\t\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t \\d?[\\+\u2013\\-\\?]\t\t\t\t|\t\\b\t\t\t\t\t\\d? M (?:\\/\\d)?\t\t\t\t\t[a-z\\d\\+\u2013\\-\\?]*\t\t\t\t)\t\t\t)\t\t\t\t\t\t|\t\\s*\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t\t\t\t\t)*\t\t\t\t(?:\\s*\\[[^\\]]+\\][\u2013\\-\\+\\d]*)?\t\t\t)\t\t\t\t\t)*\t\t)$", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            String peakblock = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
            boolean foundpeak = false;
            re = new Pattern("(?=\\d)\\b(\t\t\t(\t(?:\\/?\\b\\d+(?:\\.\\d+)?\\b)+\t\t\t\t(?:\t\\s*\t\t\t\t(?:\t\t\t\t(?:\t\t\t\t\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t \\d?[\\+\u2013\\-\\?]\t\t\t\t|\t\\b\t\t\t\t\t\\d? M (?:\\/\\d)?\t\t\t\t\t[a-z\\d\\+\u2013\\-\\?]*\t\t\t\t)\t\t\t)\t\t\t\t\t\t|\t\\s*\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t\t\t\t\t)*\t\t\t\t(?:\\s*\\[[^\\]]+\\][\u2013\\-\\+\\d]*)?\t\t\t)\t\t)", 9);
            m = re.matcher(peakblock);
            foundpeak = m.find();
            while (foundpeak) {
                MassSpecPeakData dp = new MassSpecPeakData();
                dp.Parse(m.group(1));
                this.peaks.addElement(dp);
                int j = peakblock.indexOf(m.group(0));
                peakblock = peakblock.substring(0, j) + peakblock.substring(j + m.group(0).length(), peakblock.length());
                m = re.matcher(peakblock);
                foundpeak = m.find();
            }
            i = this.peaks.size() - 1;
            while (i-- > 0) {
                ((MassSpecPeakData)this.peaks.elementAt(i)).setNextPeak((MassSpecPeakData)this.peaks.elementAt(i + 1));
            }
        }
        return data;
    }

    private String matchmassspec_Method(String data) {
        boolean found = false;
        Pattern re = new Pattern("[\\(\\[]\\b((?:(?:CI|EI|DMT|ESI(-FTMS)?|GCMS|NH3|FAB(\\s*[<>]\\s*\\d+)?|NBA|ES|APCI|GT|TOF|electrospray|probe|HRFABMS)\\b (\\+)? (\\W+\\d+\\s*ev)? [\\s,]*?)+ )[\\)\\]]?", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propmassspec_Method = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propmassspec_Method = "";
        }
        this.propmassspec_MethodDefined = found;
        if (this.propmassspec_Method == "") {
            this.propmassspec_MethodDefined = false;
        }
        if (this.propmassspec_Method == null) {
            this.propmassspec_MethodDefined = false;
            this.propmassspec_Method = "";
        }
        return data;
    }

    public boolean ismassspec_MethodDefined() {
        return this.propmassspec_MethodDefined;
    }

    public String getmassspec_Method() {
        return this.propmassspec_Method;
    }
}

