/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import java.awt.Color;
import jregex.Matcher;
import jregex.Pattern;
import uk.ac.cam.ch.oscar.DataInterface;

public class OptRotData
implements DataInterface {
    private boolean defined = false;
    private String blockdata = "";
    private String propoptrot_Temperature = "";
    private boolean propoptrot_TemperatureDefined = false;
    private String propoptrot_Rotation = "";
    private boolean propoptrot_RotationDefined = false;
    private String propoptrot_Concentration = "";
    private boolean propoptrot_ConcentrationDefined = false;
    private String propoptrot_Solvent = "";
    private boolean propoptrot_SolventDefined = false;

    public String Parse(String inputtext) {
        Pattern re = new Pattern("\\[.?\\]\\s*D?\\W*\\d.*? \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t", 9);
        Matcher m = re.matcher(inputtext);
        this.defined = m.find();
        if (this.defined) {
            this.blockdata = m.group(0);
            int p0 = inputtext.indexOf(this.blockdata);
            inputtext = inputtext.substring(0, p0) + inputtext.substring(p0 + this.blockdata.length(), inputtext.length());
            this.breakUp(this.blockdata);
        } else {
            this.blockdata = "";
        }
        return inputtext;
    }

    public String getBlock() {
        return this.blockdata;
    }

    public Color getColor() {
        return new Color(0, 224, 0);
    }

    public String getSummary() {
        String out = "Optical Rotation";
        return out;
    }

    public String getDetails() {
        String out = "";
        if (this.defined) {
            out = out + "Optical Rotation:\n";
            if (this.propoptrot_TemperatureDefined) {
                out = out + "   Temperature: " + this.propoptrot_Temperature + "\n";
            }
            if (this.propoptrot_RotationDefined) {
                out = out + "   Rotation: " + this.propoptrot_Rotation + "\n";
            }
            if (this.propoptrot_ConcentrationDefined) {
                out = out + "   Concentration: " + this.propoptrot_Concentration + "\n";
            }
            if (this.propoptrot_SolventDefined) {
                out = out + "   Solvent: " + this.propoptrot_Solvent + "\n";
            }
            out = out + "\n";
        }
        return out;
    }

    public String getDetailsHTML() {
        if (!this.defined) {
            return "";
        }
        String out = "<h3>";
        out = out + "<a name=\"Optical Rotation\"></a>";
        out = out + "Optical Rotation</h3>";
        out = out + "<ul>";
        if (this.propoptrot_TemperatureDefined) {
            out = out + "<li><b>Temperature:</b> " + this.propoptrot_Temperature + "";
        }
        if (this.propoptrot_RotationDefined) {
            out = out + "<li><b>Rotation:</b> " + this.propoptrot_Rotation + "";
        }
        if (this.propoptrot_ConcentrationDefined) {
            out = out + "<li><b>Concentration:</b> " + this.propoptrot_Concentration + "";
        }
        if (this.propoptrot_SolventDefined) {
            out = out + "<li><b>Solvent:</b> " + this.propoptrot_Solvent + "";
        }
        out = out + "</ul>";
        return out;
    }

    public String getXML() {
        if (!this.defined) {
            return "";
        }
        String out = "      <data class=\"optrot\" type=\"property\">\n";
        if (this.propoptrot_TemperatureDefined) {
            out = out + "         <value id=\"temperature\">" + this.propoptrot_Temperature + "</value>\n";
        }
        if (this.propoptrot_RotationDefined) {
            out = out + "         <value id=\"rotation\">" + this.propoptrot_Rotation + "</value>\n";
        }
        if (this.propoptrot_ConcentrationDefined) {
            out = out + "         <value id=\"concentration\">" + this.propoptrot_Concentration + "</value>\n";
        }
        if (this.propoptrot_SolventDefined) {
            out = out + "         <value id=\"solvent\">" + this.propoptrot_Solvent + "</value>\n";
        }
        out = out + "      </data>\n";
        return out;
    }

    public boolean isSet() {
        return this.defined;
    }

    private void breakUp(String data) {
        data = this.matchoptrot_Temperature(data);
        data = this.matchoptrot_Rotation(data);
        data = this.matchoptrot_Concentration(data);
        data = this.matchoptrot_Solvent(data);
    }

    private String matchoptrot_Temperature(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\[.?\\]\\s*D?((?<=D)\\d+|\\d+(?=D))D?", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propoptrot_Temperature = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propoptrot_Temperature = "";
        }
        this.propoptrot_TemperatureDefined = found;
        if (this.propoptrot_Temperature == "") {
            this.propoptrot_TemperatureDefined = false;
        }
        if (this.propoptrot_Temperature == null) {
            this.propoptrot_TemperatureDefined = false;
            this.propoptrot_Temperature = "";
        }
        return data;
    }

    public boolean isoptrot_TemperatureDefined() {
        return this.propoptrot_TemperatureDefined;
    }

    public String getoptrot_Temperature() {
        return this.propoptrot_Temperature;
    }

    private String matchoptrot_Rotation(String data) {
        boolean found = false;
        Pattern re = new Pattern("(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\\W*?(?=\\()", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propoptrot_Rotation = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propoptrot_Rotation = "";
        }
        this.propoptrot_RotationDefined = found;
        if (this.propoptrot_Rotation == "") {
            this.propoptrot_RotationDefined = false;
        }
        if (this.propoptrot_Rotation == null) {
            this.propoptrot_RotationDefined = false;
            this.propoptrot_Rotation = "";
        }
        return data;
    }

    public boolean isoptrot_RotationDefined() {
        return this.propoptrot_RotationDefined;
    }

    public String getoptrot_Rotation() {
        return this.propoptrot_Rotation;
    }

    private String matchoptrot_Concentration(String data) {
        boolean found = false;
        Pattern re = new Pattern("(?<=\\()\\s*c\\W*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propoptrot_Concentration = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propoptrot_Concentration = "";
        }
        this.propoptrot_ConcentrationDefined = found;
        if (this.propoptrot_Concentration == "") {
            this.propoptrot_ConcentrationDefined = false;
        }
        if (this.propoptrot_Concentration == null) {
            this.propoptrot_ConcentrationDefined = false;
            this.propoptrot_Concentration = "";
        }
        return data;
    }

    public boolean isoptrot_ConcentrationDefined() {
        return this.propoptrot_ConcentrationDefined;
    }

    public String getoptrot_Concentration() {
        return this.propoptrot_Concentration;
    }

    private String matchoptrot_Solvent(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\(.*?((?:CCl4|CHCl3|chloroform|DMF|Et2O|EtOH|DMSO|CH2Cl2|C6H6|AcOH|H2O|MeOH|methanol|C2H5OH|Pyridine)).*?\\)", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propoptrot_Solvent = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propoptrot_Solvent = "";
        }
        this.propoptrot_SolventDefined = found;
        if (this.propoptrot_Solvent == "") {
            this.propoptrot_SolventDefined = false;
        }
        if (this.propoptrot_Solvent == null) {
            this.propoptrot_SolventDefined = false;
            this.propoptrot_Solvent = "";
        }
        return data;
    }

    public boolean isoptrot_SolventDefined() {
        return this.propoptrot_SolventDefined;
    }

    public String getoptrot_Solvent() {
        return this.propoptrot_Solvent;
    }
}

