/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import java.util.Vector;
import jregex.Matcher;
import jregex.Pattern;
import jregex.RETokenizer;
import jregex.Replacer;
import uk.ac.cam.ch.oscar.ExpData;
import uk.ac.cam.ch.oscar.HighlightInfo;
import uk.ac.cam.ch.oscar.ProgressInterface;

public class PaperSplitter {
    private String inputpaper;
    private Vector paragraphs = new Vector();
    private Vector expDatas = new Vector();
    private HighlightInfo hi = new HighlightInfo();
    private ProgressInterface progressInterface = null;

    public void setProgressInterface(ProgressInterface pi) {
        this.progressInterface = pi;
    }

    public boolean setInput(String s) {
        if (s != this.inputpaper) {
            this.inputpaper = s;
            this.paragraphs.removeAllElements();
            this.expDatas.removeAllElements();
            if (!this.parse()) {
                return false;
            }
        }
        return true;
    }

    public int getCount() {
        return this.expDatas.size();
    }

    public String getParagraphAt(int i) {
        if (i < 0 | i >= this.expDatas.size()) {
            return "";
        }
        return (String)this.paragraphs.elementAt(i);
    }

    public ExpData getDataAt(int i) {
        if (i < 0 | i >= this.expDatas.size()) {
            return null;
        }
        return (ExpData)this.expDatas.elementAt(i);
    }

    public String getStructure() {
        String out = new String("");
        if (this.paragraphs.size() == 0) {
            return "No data identified.";
        }
        int i = 0;
        while (i < this.paragraphs.size() - 1) {
            out = out + (i + 1) + ".\t";
            out = out + (String)this.paragraphs.elementAt(i);
            out = out + "\n\n---\n\n";
            ++i;
        }
        out = out + this.paragraphs.size() + ".\t";
        out = out + (String)this.paragraphs.elementAt(this.paragraphs.size() - 1);
        out = out + "\n";
        return out;
    }

    public HighlightInfo getHighlightInfo() {
        return this.hi;
    }

    public String getXML() {
        String out = "<experimental>\n";
        if (this.expDatas.size() == 0) {
            return "";
        }
        int i = 0;
        while (i < this.expDatas.size()) {
            out = out + ((ExpData)this.expDatas.elementAt(i)).getXML();
            ++i;
        }
        out = out + "</experimental>";
        return out;
    }

    private boolean parse() {
        this.inputpaper = this.replaceFunnyCharacters(this.inputpaper);
        String s = this.findExperimental(this.inputpaper);
        this.hi.empty();
        if (s == "") {
            return false;
        }
        this.hi.setExpStart(this.inputpaper.indexOf(s));
        this.hi.setExpEnd(this.hi.getExpStart() + s.length());
        s = this.doReplaces(s);
        this.tokenise(s);
        if (this.progressInterface != null) {
            this.progressInterface.setMax(this.paragraphs.size());
        }
        if (!this.makeExpDatas()) {
            return false;
        }
        this.progressInterface = null;
        return true;
    }

    private String findExperimental(String s) {
        Pattern re = new Pattern("[\\r\\n][^a-z]*?experimental(?:\\s+section)?\\s*\\r?\\n((?s).*?) \\r?\\n[^a-z]*?(?:references?|acknowledgements?)", 9);
        Matcher m = re.matcher(s);
        if (m.find()) {
            return m.group(1);
        }
        return s;
    }

    private String doReplaces(String s) {
        Pattern re = new Pattern("(\\.\\W+\\w+)(\\s*\\r?\\n)+", 9);
        Replacer r = re.replacer("$1\n\n\n");
        s = r.replace(s);
        re = new Pattern("(\\.\\W*\\w*)(\\s*\\r?\\n)+", 9);
        r = re.replacer("$1\n\n");
        s = r.replace(s);
        return s;
    }

    private void tokenise(String s) {
        Pattern p = new Pattern("(?<=...\\.|..\\.\\)|.[a-z]\\.\\d|[a-z]\\.\\d\\d)\\s*\\r?\\n(\\s*\\r?\\n)+\\s*", 9);
        RETokenizer tok = new RETokenizer(p, s);
        tok.setEmptyEnabled(false);
        while (tok.hasMore()) {
            this.paragraphs.addElement(tok.nextToken());
        }
    }

    private boolean makeExpDatas() {
        String paper = this.inputpaper;
        int offset = paper.length();
        int k = this.paragraphs.size() - 1;
        while (k >= 0) {
            ExpData ed = new ExpData();
            String para = (String)this.paragraphs.elementAt(k);
            ed.setInput(para);
            boolean[] b2 = ed.getDataDefined();
            int j = 0;
            int i = 0;
            while (i < b2.length) {
                if (b2[i]) {
                    ++j;
                }
                ++i;
            }
            if (j > 2) {
                this.expDatas.insertElementAt(ed, 0);
                int lb = para.indexOf("\n");
                offset = lb > 0 ? paper.substring(0, offset).lastIndexOf(para.substring(0, lb)) : paper.substring(0, offset).lastIndexOf(para);
                this.copyHI(ed.getHighlightInfo(), offset);
            } else {
                this.paragraphs.removeElementAt(k);
            }
            if (this.progressInterface != null && !this.progressInterface.progress()) {
                return false;
            }
            --k;
        }
        return true;
    }

    private void copyHI(HighlightInfo h, int o) {
        while (h.hasMoreItems()) {
            this.hi.add(h.getP0() + o, h.getP1() + o, h.getColor());
            h.next();
        }
    }

    private String replaceFunnyCharacters(String in) {
        Pattern re = new Pattern("\u2013", 9);
        Replacer r = re.replacer("-");
        return r.replace(in);
    }
}

