/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.Vector;
import uk.ac.cam.ch.oscar.SpectrumInfo;

public class Plotter {
    private SpectrumInfo si = null;
    private float xspace;
    private float yspace;
    private float xscale;
    private float xmin;
    private float xmax;
    private float ymin;
    private float ymax;
    private float rxmin;
    private float rxmax;
    private int zx1;
    private int zx2;
    private int zy1;
    private int zy2;
    private Vector line_x;
    private Vector line_y;
    private Vector peak_x;
    private float[] peak_heights;
    private int[] peak_polyline;
    private int[] peak_polyline_x;
    private int[] peakheight;
    private boolean scaled = false;
    private Rectangle xAxisRect;
    private Rectangle yAxisRect;
    private boolean show_annotations = false;
    private int mouseover_peak = -1;
    private Dimension size;
    private final int sticky_size = 15;
    private final float[] scales = new float[]{100000.0f, 50000.0f, 20000.0f, 10000.0f, 5000.0f, 2000.0f, 1000.0f, 500.0f, 200.0f, 100.0f, 50.0f, 20.0f, 10.0f, 5.0f, 2.0f, 1.0f, 0.5f, 0.2f, 0.1f, 0.05f, 0.02f, 0.01f, 0.005f, 0.002f, 0.001f, 5.0E-4f, 2.0E-4f, 1.0E-4f};
    private final int[] scales_dp = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
    private int xscale_dp = 0;

    public Plotter() {
        this.size = new Dimension(0, 0);
        this.line_x = new Vector();
        this.line_y = new Vector();
        this.peak_x = new Vector();
    }

    public void toggleAnnotations() {
        this.show_annotations = !this.show_annotations;
    }

    public void setSI(SpectrumInfo specinfo) {
        this.si = specinfo;
        if (this.si == null) {
            return;
        }
        this.getSIRecommendedX();
        this.ymin = this.si.ymin;
        this.ymax = this.si.ymax;
        this.peakheight = new int[this.si.x.length];
        this.scaled = false;
        this.show_annotations = false;
        this.mouseover_peak = -1;
    }

    public void paint(Graphics g) {
        if (this.si == null) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setColor(Color.black);
            g.drawString("Sorry, spectrum not available.", (this.getSize().width - g.getFontMetrics().stringWidth("Sorry, spectrum not available.")) / 2, this.getSize().height / 2);
            return;
        }
        if (this.size.width <= 0 | this.size.height <= 0) {
            return;
        }
        if (!this.scaled) {
            this.doXscale(0, g);
            this.doYscale();
            this.setZoom();
            this.updateStickyZones();
            this.doHeightsToPolyline();
            this.getPeakHeights();
            this.scaled = true;
        }
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.setClip(this.si.revX ? this.getX(this.xmax) : this.getX(this.xmin), this.si.revY ? this.getY(this.ymin) : 0, (!this.si.revX ? this.getX(this.xmax) : this.getX(this.xmin)) - (this.si.revX ? this.getX(this.xmax) : this.getX(this.xmin)), this.si.revY ? this.getSize().height : this.getY(this.ymin));
        this.drawLines(g);
        this.drawGaussians(g);
        g.setClip(0, 0, this.getSize().width, this.getSize().height);
        this.drawAxes(g);
        g.setClip(0, this.si.revY ? this.getY(this.ymin) : 0, this.getSize().width, this.si.revY ? this.getSize().height : this.getY(this.ymin));
        if (this.show_annotations) {
            this.drawAnnotations(g);
        }
        g.setClip(0, 0, this.getSize().width, this.getSize().height);
    }

    public void setSize(Dimension d2) {
        if (this.size != d2) {
            this.size = d2;
            this.scaled = false;
        }
    }

    public Dimension getSize() {
        return this.size;
    }

    private void drawLines(Graphics g) {
        g.setColor(Color.red);
        int i = 0;
        while (i < this.line_x.size()) {
            g.drawLine((Integer)this.line_x.elementAt(i), this.getY(0.0f), (Integer)this.line_x.elementAt(i), this.getY(((Float)this.line_y.elementAt(i)).floatValue()));
            ++i;
        }
    }

    private void drawGaussians(Graphics g) {
        g.setColor(Color.red);
        g.drawPolyline(this.peak_polyline_x, this.peak_polyline, (this.getX(this.xmin) - this.getX(this.xmax)) * (this.si.revX ? 1 : -1));
    }

    private void drawAxes(Graphics g) {
        int fontheight = g.getFontMetrics().getAscent();
        g.setColor(Color.black);
        g.drawLine(this.getX(this.xmin), this.getY(this.ymin < 0.0f ? 0.0f : this.ymin), this.getX(this.xmax), this.getY(this.ymin < 0.0f ? 0.0f : this.ymin));
        if (this.xmin > 0.0f) {
            g.drawLine(this.getX(this.xmin), this.getY(this.ymin), this.getX(this.xmin), this.getY(this.ymax));
        } else if (this.xmin <= 0.0f & this.xmax > 0.0f) {
            g.drawLine(this.getX(0.0f), this.getY(this.ymin), this.getX(0.0f), this.getY(this.ymax));
        } else {
            g.drawLine(this.getX(this.xmax), this.getY(this.ymin), this.getX(this.xmax), this.getY(this.ymax));
        }
        if (this.xscale > 0.0f) {
            float x = this.xmin;
            while (x <= this.xmax) {
                if (this.si.revY) {
                    g.drawString(this.FtS(x, this.xscale_dp), this.getX(x) - g.getFontMetrics().stringWidth(this.FtS(x, this.xscale_dp)) / 2, this.getY(this.ymin < 0.0f ? 0.0f : this.ymin) - 3);
                } else {
                    g.drawString(this.FtS(x, this.xscale_dp), this.getX(x) - g.getFontMetrics().stringWidth(this.FtS(x, this.xscale_dp)) / 2, this.getY(this.ymin < 0.0f ? 0.0f : this.ymin) + fontheight + 3);
                }
                g.drawLine(this.getX(x), this.getY(this.ymin < 0.0f ? 0.0f : this.ymin) + 2, this.getX(x), this.getY(this.ymin < 0.0f ? 0.0f : this.ymin) - 2);
                x += this.xscale;
            }
        }
    }

    private void drawAnnotations(Graphics g) {
        g.setColor(Color.blue);
        int fontheight = g.getFontMetrics().getAscent();
        Rectangle[] textbounds = new Rectangle[this.si.x.length];
        int i = this.si.revX ? this.si.x.length - 1 : 0;
        while (!this.si.revX ? i < this.si.x.length : i >= 0) {
            if (this.si.annotation[i].length() != 0) {
                textbounds[i] = new Rectangle(this.getX(this.si.x[i]) - g.getFontMetrics().stringWidth(this.si.annotation[i]) / 2, this.peakheight[i] + (this.si.revY ? 10 : -1 * (10 + fontheight)), g.getFontMetrics().stringWidth(this.si.annotation[i]), fontheight);
                int j = this.si.revX ? this.si.x.length - 1 : 0;
                while (!this.si.revX ? j < i : j > i) {
                    if (this.si.annotation[j].length() != 0) {
                        textbounds[i].grow(5, 5);
                        if (textbounds[i].intersects(textbounds[j])) {
                            textbounds[i].translate(0, this.si.revY ? fontheight + 10 : -1 * (fontheight + 10));
                            j = this.si.revX ? this.si.x.length - 1 : 0;
                        }
                        textbounds[i].grow(-5, -5);
                    }
                    j += this.si.revX ? -1 : 1;
                }
                g.drawLine(this.getX(this.si.x[i]), this.peakheight[i] + (this.si.revY ? 3 : -3), this.getX(this.si.x[i]), textbounds[i].y + (this.si.revY ? -1 : fontheight + 1));
            }
            i += this.si.revX ? -1 : 1;
        }
        int i2 = 0;
        while (i2 < this.si.x.length) {
            if (this.si.annotation[i2].length() != 0) {
                g.setColor(Color.white);
                g.fillRect(textbounds[i2].x, textbounds[i2].y - (this.si.revY ? 2 : 0), textbounds[i2].width, textbounds[i2].height + (this.si.revY ? 0 : 3));
                g.setColor(Color.blue);
                g.drawLine(textbounds[i2].x, textbounds[i2].y + (this.si.revY ? 0 : textbounds[i2].height), textbounds[i2].x + textbounds[i2].width, textbounds[i2].y + (this.si.revY ? 0 : textbounds[i2].height));
                g.drawLine(this.getX(this.si.x[i2]), textbounds[i2].y + (this.si.revY ? -1 : fontheight + 1), this.getX(this.si.x[i2]), textbounds[i2].y + (this.si.revY ? -3 : fontheight + 3));
                if (this.si.revY) {
                    g.drawLine(textbounds[i2].x - 1, textbounds[i2].y, textbounds[i2].x - 1, textbounds[i2].y + 2);
                    g.drawLine(textbounds[i2].x + textbounds[i2].width + 1, textbounds[i2].y, textbounds[i2].x + textbounds[i2].width + 1, textbounds[i2].y + 2);
                } else {
                    g.drawLine(textbounds[i2].x - 1, textbounds[i2].y + textbounds[i2].height, textbounds[i2].x - 1, textbounds[i2].y + textbounds[i2].height - 2);
                    g.drawLine(textbounds[i2].x + textbounds[i2].width + 1, textbounds[i2].y + textbounds[i2].height, textbounds[i2].x + textbounds[i2].width + 1, textbounds[i2].y + textbounds[i2].height - 2);
                }
                g.drawString(this.si.annotation[i2], textbounds[i2].x, textbounds[i2].y + textbounds[i2].height - 2);
            }
            ++i2;
        }
    }

    private int getX(float x) {
        if (this.si.revX) {
            return this.getSize().width - (int)Math.floor((double)((x - this.xmin + this.xspace) * (float)(this.getSize().width - 2) / (this.xmax + 2.0f * this.xspace - this.xmin)) + 1.0);
        }
        return (int)Math.floor((double)((x - this.xmin + this.xspace) * (float)(this.getSize().width - 2) / (this.xmax + 2.0f * this.xspace - this.xmin)) + 1.0);
    }

    private int getY(float y) {
        if (!this.si.revY) {
            return this.getSize().height - (int)Math.floor((double)((y - this.ymin + this.yspace) * (float)(this.getSize().height - 2) / (this.ymax + 2.0f * this.yspace - this.ymin)) + 1.0);
        }
        return (int)Math.floor((double)((y - this.ymin + this.yspace) * (float)(this.getSize().height - 2) / (this.ymax + 2.0f * this.yspace - this.ymin)) + 1.0);
    }

    private float getXint(int x) {
        return this.xmin - this.xspace + (float)(this.si.revX ? this.getSize().width - 1 - x : x - 1) * (this.xmax - this.xmin + 2.0f * this.xspace) / (float)(this.getSize().width - 2);
    }

    private float getYint(int y) {
        return this.ymin - this.yspace + (float)(!this.si.revY ? this.getSize().height - 1 - y : y - 1) * (this.ymax - this.ymin + 2.0f * this.yspace) / (float)(this.getSize().height - 2);
    }

    private void getSIRecommendedX() {
        this.rxmin = this.si.x[0];
        this.rxmax = this.si.x[0];
        int i = 1;
        while (i < this.si.npeaks) {
            if (this.si.x[i] > this.rxmax) {
                this.rxmax = this.si.x[i];
            }
            if (this.si.x[i] < this.rxmin) {
                this.rxmin = this.si.x[i];
            }
            ++i;
        }
        if (this.rxmin > this.si.xmin) {
            this.rxmin = this.si.xmin;
        }
        if (this.rxmax < this.si.xmax) {
            this.rxmax = this.si.xmax;
        }
    }

    private void doXscale(int s, Graphics g) {
        float delta = this.rxmax - this.rxmin;
        int i = s;
        while (i < this.scales.length - 1) {
            if (this.scales[i] < delta) break;
            ++i;
        }
        this.xscale = this.scales[i];
        this.xscale_dp = this.scales_dp[i];
        this.xmin = this.round(this.rxmin, this.xscale, false);
        this.xmax = this.round(this.rxmax, this.xscale, true);
        if ((double)this.getXaxisLabelLength(g) > 0.42) {
            this.xscale = this.scales[i - 1];
            this.xscale_dp = this.scales_dp[i - 1];
            this.xmin = this.round(this.rxmin, this.xscale, false);
            this.xmax = this.round(this.rxmax, this.xscale, true);
        } else if (++i < this.scales.length) {
            this.doXscale(i, g);
        }
        this.xspace = 0.1f * (this.xmax - this.xmin);
        this.fillPeakHeights();
    }

    private void fillPeakHeights() {
        this.line_x.removeAllElements();
        this.line_y.removeAllElements();
        this.peak_x.removeAllElements();
        this.peak_heights = new float[(this.getX(this.xmin) - this.getX(this.xmax)) * (this.si.revX ? 1 : -1)];
        int i = 0;
        while (i < this.peak_heights.length) {
            this.peak_heights[i] = 0.0f;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.si.x.length) {
            if (!(this.si.x[i2] < this.xmin | this.si.x[i2] > this.xmax)) {
                this.peak_x.addElement(new Integer(this.getX(this.si.x[i2])));
                if (this.si.type[i2] == 0 | this.si.type[i2] == 2 & Math.abs(this.getX(6.0f * this.si.width[i2]) - this.getX(0.0f)) < 5) {
                    this.line_x.addElement(new Integer(this.getX(this.si.x[i2])));
                    if (this.si.abs) {
                        this.line_y.addElement(new Float(this.si.height[i2]));
                    } else {
                        this.line_y.addElement(new Float(1.0 - Math.exp(-1.0 * (double)this.si.height[i2])));
                    }
                }
            }
            ++i2;
        }
        int sx = this.si.revX ? this.getX(this.xmax) : this.getX(this.xmin);
        int range = (this.getX(this.xmin) - this.getX(this.xmax)) * (this.si.revX ? 1 : -1);
        int i3 = 0;
        while (i3 < range) {
            float x = this.getXint(sx + i3);
            int n = 0;
            while (n < this.si.x.length) {
                if (this.si.type[n] == 2 && Math.abs(this.getX(6.0f * this.si.width[n]) - this.getX(0.0f)) > 4) {
                    int n2 = i3;
                    this.peak_heights[n2] = this.peak_heights[n2] + (float)((double)this.si.height[n] * Math.exp(-0.6931 * Math.pow(this.si.x[n] - x, 2.0) / Math.pow(this.si.width[n], 2.0)));
                }
                ++n;
            }
            if (!this.si.abs) {
                this.peak_heights[i3] = 1.0f - (float)Math.exp(-1.0f * this.peak_heights[i3]);
            }
            ++i3;
        }
    }

    private void getPeakHeights() {
        int i = 0;
        while (i < this.peakheight.length) {
            this.peakheight[i] = 0;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.si.x.length) {
            if (!(this.si.x[i2] < this.xmin | this.si.x[i2] > this.xmax)) {
                if (this.si.type[i2] == 0 | this.si.type[i2] == 2 & Math.abs(this.getX(6.0f * this.si.width[i2]) - this.getX(0.0f)) < 5) {
                    this.peakheight[i2] = this.si.abs ? this.getY(this.si.height[i2]) : this.getY((float)(1.0 - Math.exp(-1.0 * (double)this.si.height[i2])));
                } else {
                    int n = this.getX(this.si.x[i2]) - (this.si.revX ? this.getX(this.xmax) : this.getX(this.xmin));
                    if (n >= 0 & n < this.peak_polyline.length) {
                        this.peakheight[i2] = this.peak_polyline[n];
                    }
                    if (n > 0 & n < this.peak_polyline.length) {
                        int delta = this.peak_polyline[n] - this.peak_polyline[n - 1];
                        if (delta > 0 & !this.si.revY) {
                            this.peakheight[i2] = this.peak_polyline[n - 1];
                        }
                        if (delta < 0 & this.si.revY) {
                            this.peakheight[i2] = this.peak_polyline[n - 1];
                        }
                    }
                }
            }
            ++i2;
        }
    }

    private void doYscale() {
        this.ymin = 0.0f;
        float new_ymax = 0.0f;
        int i = 0;
        while (i < this.line_y.size()) {
            if (((Float)this.line_y.elementAt(i)).floatValue() > new_ymax) {
                new_ymax = ((Float)this.line_y.elementAt(i)).floatValue();
            }
            ++i;
        }
        int range = (this.getX(this.xmin) - this.getX(this.xmax)) * (this.si.revX ? 1 : -1);
        int i2 = 0;
        while (i2 < range) {
            if (this.peak_heights[i2] > new_ymax) {
                new_ymax = this.peak_heights[i2];
            }
            ++i2;
        }
        if ((double)((new_ymax - this.ymin) / (this.ymax - this.ymin)) > 0.9) {
            this.ymax = new_ymax = (float)((double)new_ymax * 1.33);
        }
        if ((double)((new_ymax - this.ymin) / (this.ymax - this.ymin)) < 0.4) {
            this.ymax = new_ymax = (float)((double)new_ymax * 1.5);
        }
        if (new_ymax == 0.0f) {
            this.ymax = 0.1f;
        }
    }

    private void doHeightsToPolyline() {
        int range = (this.getX(this.xmin) - this.getX(this.xmax)) * (this.si.revX ? 1 : -1);
        int sx = this.si.revX ? this.getX(this.xmax) : this.getX(this.xmin);
        this.peak_polyline = new int[range];
        this.peak_polyline_x = new int[range];
        int i = 0;
        while (i < range) {
            this.peak_polyline_x[i] = sx + i;
            this.peak_polyline[i] = this.getY(this.peak_heights[i]);
            ++i;
        }
    }

    private float getXaxisLabelLength(Graphics g) {
        StringBuffer labels = new StringBuffer("");
        float x = this.xmin;
        while (x <= this.xmax) {
            labels.append(this.FtS(x, this.xscale_dp));
            x += this.xscale;
        }
        float lx = g.getFontMetrics(new Font("Dialog", 0, 10)).stringWidth(labels.toString());
        float ax = (float)this.getSize().width / 1.2f;
        return lx / ax;
    }

    private void updateStickyZones() {
        this.xAxisRect = new Rectangle(0, this.getY(this.ymin < 0.0f ? 0.0f : this.ymin) - 15, this.getSize().width, 31);
        float x = this.xmin > 0.0f ? this.xmin : (this.xmin <= 0.0f & this.xmax > 0.0f ? 0.0f : this.xmax);
        this.yAxisRect = new Rectangle(this.getX(x) - 15, 0, 31, this.getSize().height);
    }

    private float round(float x, float s, boolean roundUp) {
        float x2 = x;
        if (x < 0.0f) {
            return -1.0f * this.round(-1.0f * x, s, !roundUp);
        }
        float remainder = x % s;
        if (remainder > 0.0f) {
            x -= remainder;
            if (roundUp) {
                x += s;
            }
        }
        return x;
    }

    private void setZoom() {
        this.yspace = 0.1f * (this.ymax - this.ymin);
    }

    private String FtS(float x, int n) {
        BigDecimal d2 = new BigDecimal(x);
        d2 = d2.setScale(n, 4);
        return d2.toString();
    }

    public boolean processEvent(AWTEvent e2, Graphics g) {
        if (this.si == null) {
            return false;
        }
        if (!(e2 instanceof InputEvent)) {
            return false;
        }
        boolean zoomout = false;
        boolean LMB = !((InputEvent)e2).isAltDown() & !((InputEvent)e2).isMetaDown() & !((InputEvent)e2).isControlDown();
        boolean MMB = ((InputEvent)e2).isAltDown();
        boolean RMB = ((InputEvent)e2).isMetaDown() | ((InputEvent)e2).isControlDown();
        switch (e2.getID()) {
            case 503: {
                if (this.show_annotations) break;
                int x = ((MouseEvent)e2).getX();
                int new_mouseoverpeak = -1;
                int d2 = 20;
                int i = 0;
                while (i < this.peak_x.size()) {
                    int d22 = Math.abs(x - (Integer)this.peak_x.elementAt(i));
                    if (d22 < d2) {
                        d2 = d22;
                        int j = 0;
                        while (j < this.si.x.length) {
                            if (this.getX(this.si.x[j]) == ((Integer)this.peak_x.elementAt(i)).intValue()) {
                                new_mouseoverpeak = j;
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                if (new_mouseoverpeak == this.mouseover_peak) break;
                this.repaint(g);
                if (new_mouseoverpeak >= 0) {
                    g.setColor(Color.blue);
                    int fontheight = g.getFontMetrics().getAscent();
                    String annot = new Float(this.si.x[new_mouseoverpeak]).toString();
                    if (this.si.annotation[new_mouseoverpeak].length() > 0) {
                        annot = annot + ", " + this.si.annotation[new_mouseoverpeak];
                    }
                    Rectangle textbounds = new Rectangle(this.getX(this.si.x[new_mouseoverpeak]) - g.getFontMetrics().stringWidth(annot) / 2, this.peakheight[new_mouseoverpeak] + (this.si.revY ? 10 : -1 * (10 + fontheight)), g.getFontMetrics().stringWidth(annot), fontheight);
                    g.drawLine(this.getX(this.si.x[new_mouseoverpeak]), this.peakheight[new_mouseoverpeak] + (this.si.revY ? 3 : -3), this.getX(this.si.x[new_mouseoverpeak]), textbounds.y + (this.si.revY ? -1 : fontheight + 1));
                    g.setColor(Color.white);
                    g.fillRect(textbounds.x, textbounds.y - (this.si.revY ? 2 : 0), textbounds.width, textbounds.height + (this.si.revY ? 0 : 3));
                    g.setColor(Color.blue);
                    g.drawLine(textbounds.x, textbounds.y + (this.si.revY ? 0 : textbounds.height), textbounds.x + textbounds.width, textbounds.y + (this.si.revY ? 0 : textbounds.height));
                    g.drawLine(this.getX(this.si.x[new_mouseoverpeak]), textbounds.y + (this.si.revY ? -1 : fontheight + 1), this.getX(this.si.x[new_mouseoverpeak]), textbounds.y + (this.si.revY ? -3 : fontheight + 3));
                    if (this.si.revY) {
                        g.drawLine(textbounds.x - 1, textbounds.y, textbounds.x - 1, textbounds.y + 2);
                        g.drawLine(textbounds.x + textbounds.width + 1, textbounds.y, textbounds.x + textbounds.width + 1, textbounds.y + 2);
                    } else {
                        g.drawLine(textbounds.x - 1, textbounds.y + textbounds.height, textbounds.x - 1, textbounds.y + textbounds.height - 2);
                        g.drawLine(textbounds.x + textbounds.width + 1, textbounds.y + textbounds.height, textbounds.x + textbounds.width + 1, textbounds.y + textbounds.height - 2);
                    }
                    g.drawString(annot, textbounds.x, textbounds.y + textbounds.height - 2);
                }
                this.mouseover_peak = new_mouseoverpeak;
                break;
            }
            case 501: {
                if (LMB) {
                    this.zx1 = ((MouseEvent)e2).getX();
                    this.zy1 = ((MouseEvent)e2).getY();
                    if (this.xAxisRect.contains(this.zx1, this.zy1)) {
                        this.zy1 = this.xAxisRect.getLocation().y + 15;
                    }
                    if (this.yAxisRect.contains(this.zx1, this.zy1)) {
                        this.zx1 = this.yAxisRect.getLocation().x + 15;
                    }
                    this.zx2 = -1;
                    return false;
                }
                if (!MMB) break;
                this.zx1 = -1;
                this.zy1 = ((MouseEvent)e2).getY();
                return false;
            }
            case 506: {
                if (LMB) {
                    if (this.zx2 > 0) {
                        this.drawXorRect(g);
                    }
                    this.zx2 = ((MouseEvent)e2).getX();
                    this.zy2 = ((MouseEvent)e2).getY();
                    if (this.xAxisRect.contains(this.zx2, this.zy2)) {
                        this.zy2 = this.xAxisRect.getLocation().y + 15;
                    }
                    if (this.yAxisRect.contains(this.zx2, this.zy2)) {
                        this.zx2 = this.yAxisRect.getLocation().x + 15;
                    }
                    this.drawXorRect(g);
                    return false;
                }
                if (!MMB) break;
                this.zy2 = ((MouseEvent)e2).getY();
                int i = 0;
                while (i < this.si.x.length) {
                    this.si.width[i] = this.si.width[i] * (float)Math.pow(1.1, (double)(this.zy1 - this.zy2) / 10.0);
                    ++i;
                }
                this.zy1 = this.zy2;
                this.fillPeakHeights();
                this.doHeightsToPolyline();
                this.getPeakHeights();
                this.repaint(g);
                return false;
            }
            case 502: {
                if (LMB) {
                    if (this.zx2 > 0) {
                        this.drawXorRect(g);
                        float xmin2 = this.getXint(this.zx1);
                        float xmax2 = this.getXint(this.zx2);
                        float ymin2 = this.getYint(this.zy1);
                        float ymax2 = this.getYint(this.zy2);
                        if (this.xAxisRect.contains(this.zx2, this.zy2)) {
                            float f = ymax2 = this.ymin < 0.0f ? 0.0f : this.ymin;
                        }
                        if (this.yAxisRect.contains(this.zx2, this.zy2)) {
                            xmax2 = this.xmin > 0.0f ? this.xmin : (this.xmin <= 0.0f & this.xmax > 0.0f ? 0.0f : this.xmax);
                        }
                        this.rxmin = xmin2 < xmax2 ? xmin2 : xmax2;
                        this.rxmax = xmin2 < xmax2 ? xmax2 : xmin2;
                        this.ymin = ymin2 < ymax2 ? ymin2 : ymax2;
                        this.ymax = ymin2 < ymax2 ? ymax2 : ymin2;
                        this.doXscale(0, g);
                        this.setZoom();
                        this.updateStickyZones();
                        this.doHeightsToPolyline();
                        this.getPeakHeights();
                        return true;
                    }
                    zoomout = true;
                }
                if (MMB) {
                    this.fillPeakHeights();
                    this.doHeightsToPolyline();
                    this.getPeakHeights();
                    this.doYscale();
                    this.setZoom();
                    this.updateStickyZones();
                    this.doHeightsToPolyline();
                    this.getPeakHeights();
                    return true;
                }
                if (!(RMB | zoomout)) break;
                this.getSIRecommendedX();
                this.ymin = this.si.ymin;
                this.ymax = this.si.ymax;
                this.doXscale(0, g);
                this.doYscale();
                this.setZoom();
                this.updateStickyZones();
                this.doHeightsToPolyline();
                this.getPeakHeights();
                return true;
            }
        }
        return false;
    }

    private void drawXorRect(Graphics g) {
        g.setXORMode(Color.white);
        g.setColor(Color.gray);
        g.drawRect(this.zx1 < this.zx2 ? this.zx1 : this.zx2, this.zy1 < this.zy2 ? this.zy1 : this.zy2, Math.abs(this.zx1 - this.zx2), Math.abs(this.zy1 - this.zy2));
    }

    private void repaint(Graphics g) {
        this.paint(g);
    }
}

