/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import java.awt.Color;
import jregex.Matcher;
import jregex.Pattern;
import uk.ac.cam.ch.oscar.DataInterface;

public class RefIndexData
implements DataInterface {
    private boolean defined = false;
    private String blockdata = "";
    private String proprefindex_Temperature = "";
    private boolean proprefindex_TemperatureDefined = false;
    private String proprefindex_Value = "";
    private boolean proprefindex_ValueDefined = false;

    public String Parse(String inputtext) {
        Pattern re = new Pattern("\\bn\\s*(?x-i:\\d* D \\d*\\s*)? \\d\\.\\d+", 9);
        Matcher m = re.matcher(inputtext);
        this.defined = m.find();
        if (this.defined) {
            this.blockdata = m.group(0);
            int p0 = inputtext.indexOf(this.blockdata);
            inputtext = inputtext.substring(0, p0) + inputtext.substring(p0 + this.blockdata.length(), inputtext.length());
            this.breakUp(this.blockdata);
        } else {
            this.blockdata = "";
        }
        return inputtext;
    }

    public String getBlock() {
        return this.blockdata;
    }

    public Color getColor() {
        return new Color(0, 128, 224);
    }

    public String getSummary() {
        String out = "Refractive Index";
        return out;
    }

    public String getDetails() {
        String out = "";
        if (this.defined) {
            out = out + "Refractive Index:\n";
            out = out + "   Value: " + this.proprefindex_Value + "\n";
            if (this.proprefindex_TemperatureDefined) {
                out = out + "   Temperature: " + this.proprefindex_Temperature + "\n";
            }
            out = out + "\n";
        }
        return out;
    }

    public String getDetailsHTML() {
        if (!this.defined) {
            return "";
        }
        String out = "<h3>";
        out = out + "<a name=\"Refractive Index\"></a>";
        out = out + "Refractive Index</h3>";
        out = out + "<ul>";
        out = out + "<li><b>Value:</b> " + this.proprefindex_Value + "";
        if (this.proprefindex_TemperatureDefined) {
            out = out + "<li><b>Temperature:</b> " + this.proprefindex_Temperature + "";
        }
        out = out + "</ul>";
        return out;
    }

    public String getXML() {
        if (!this.defined) {
            return "";
        }
        String out = "      <data class=\"refractiveindex\" type=\"property\">\n";
        if (this.proprefindex_TemperatureDefined) {
            out = out + "         <value id=\"temperature\">" + this.proprefindex_Temperature + "</value>\n";
        }
        if (this.proprefindex_ValueDefined) {
            out = out + "         <value id=\"value\">" + this.proprefindex_Value + "</value>\n";
        }
        out = out + "      </data>\n";
        return out;
    }

    public boolean isSet() {
        return this.defined;
    }

    private void breakUp(String data) {
        data = this.matchrefindex_Temperature(data);
        data = this.matchrefindex_Value(data);
    }

    private String matchrefindex_Temperature(String data) {
        boolean found = false;
        Pattern re = new Pattern("(\\d+D|D\\d+)", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.proprefindex_Temperature = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.proprefindex_Temperature = "";
        }
        this.proprefindex_TemperatureDefined = found;
        if (this.proprefindex_Temperature == "") {
            this.proprefindex_TemperatureDefined = false;
        }
        if (this.proprefindex_Temperature == null) {
            this.proprefindex_TemperatureDefined = false;
            this.proprefindex_Temperature = "";
        }
        return data;
    }

    public boolean isrefindex_TemperatureDefined() {
        return this.proprefindex_TemperatureDefined;
    }

    public String getrefindex_Temperature() {
        return this.proprefindex_Temperature;
    }

    private String matchrefindex_Value(String data) {
        boolean found = false;
        Pattern re = new Pattern("(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)$", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.proprefindex_Value = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.proprefindex_Value = "";
        }
        this.proprefindex_ValueDefined = found;
        if (this.proprefindex_Value == "") {
            this.proprefindex_ValueDefined = false;
        }
        if (this.proprefindex_Value == null) {
            this.proprefindex_ValueDefined = false;
            this.proprefindex_Value = "";
        }
        return data;
    }

    public boolean isrefindex_ValueDefined() {
        return this.proprefindex_ValueDefined;
    }

    public String getrefindex_Value() {
        return this.proprefindex_Value;
    }
}

