/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import java.awt.Color;
import java.util.Vector;
import jregex.Matcher;
import jregex.Pattern;
import uk.ac.cam.ch.oscar.DataInterface;
import uk.ac.cam.ch.oscar.SpectrumInfo;
import uk.ac.cam.ch.oscar.SpectrumInterface;
import uk.ac.cam.ch.oscar.UVPeakData;

public class UVData
implements DataInterface,
SpectrumInterface {
    private boolean defined = false;
    private String blockdata = "";
    private Vector peaks = new Vector();
    private String propuv_Solvent = "";
    private boolean propuv_SolventDefined = false;

    public String getBlock() {
        return this.blockdata;
    }

    public Color getColor() {
        return new Color(128, 128, 255);
    }

    public SpectrumInfo getSI() {
        SpectrumInfo specinfo = new SpectrumInfo();
        if (this.peaks.size() == 0) {
            return null;
        }
        specinfo.xmin = 0.0f;
        specinfo.xmax = 700.0f;
        specinfo.ymin = 0.0f;
        specinfo.ymax = 5.0f;
        specinfo.xscale = 100.0f;
        specinfo.yscale = 1.0f;
        specinfo.revX = false;
        specinfo.revY = false;
        specinfo.abs = true;
        specinfo.npeaks = this.peaks.size();
        specinfo.x = new float[this.peaks.size()];
        specinfo.height = new float[this.peaks.size()];
        specinfo.width = new float[this.peaks.size()];
        specinfo.type = new int[this.peaks.size()];
        specinfo.annotation = new String[this.peaks.size()];
        int i = 0;
        while (i < this.peaks.size()) {
            specinfo.x[i] = ((UVPeakData)this.peaks.elementAt(i)).getX();
            specinfo.height[i] = ((UVPeakData)this.peaks.elementAt(i)).getHeight();
            specinfo.width[i] = ((UVPeakData)this.peaks.elementAt(i)).getWidth();
            specinfo.type[i] = ((UVPeakData)this.peaks.elementAt(i)).getType();
            specinfo.annotation[i] = ((UVPeakData)this.peaks.elementAt(i)).getAnnotation();
            ++i;
        }
        return specinfo;
    }

    public String Parse(String inputtext) {
        Pattern re = new Pattern("\t\t\t\t(electronic\\sspectrum.*?)?\t\t\t\t(\t\t\t\t\t(?:\t\t\t\t\t\t(?: [\u03bbl]max | UV (?: \\s* [\u03bbl]?max)? )\t\t\t\t\t\t\\W*?\t\t\t\t\t)\t\t\t\t\t(?: \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t \\W*? )?\t\t\t\t\t(?: nm [\\s*:] )?\t\t\t\t\t(?: \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t [\\s*:] )?\t\t\t\t\t\t\t\t\t\t\t(\t\t\t\t\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t (?: \\s*[\u2013\\-\\?]\\s* \t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t )? (?: \\s*nm)?\t\t\t\t(?: \\s* (?:inf\\w*|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t(\t\t\t\t\t\t\t(?: \\s* (,|and|including|&|;|\\/) \\s* )+\t\t\t\t\t\t\t\t\t(\t\t\t\t\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t (?: \\s*[\u2013\\-\\?]\\s* \t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t )? (?: \\s*nm)?\t\t\t\t(?: \\s* (?:inf\\w*|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t)*\t\t\t\t\t\t\t(?: \\s* nm )?\t\t\t\t|\t\t\t\t\tmax \\W*? (?: \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t \\W*? )?\t\t\t\t\t(?:\t\t\t\t\t\tnm [\\s:]*\t\t\t\t\t\t(?: \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t [\\s:]* )?\t\t\t\t\t\t\t\t\t\t\t\t(\t\t\t\t\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t (?: \\s*[\u2013\\-\\?]\\s* \t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t )? (?: \\s*nm)?\t\t\t\t(?: \\s* (?:inf\\w*|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t(\t\t\t\t\t\t\t(?: \\s* (,|and|including|&|;|\\/) \\s* )+\t\t\t\t\t\t\t\t\t(\t\t\t\t\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t (?: \\s*[\u2013\\-\\?]\\s* \t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t )? (?: \\s*nm)?\t\t\t\t(?: \\s* (?:inf\\w*|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t)*\t\t\t\t\t\t\t|\t\t\t\t\t\t\t(\t\t\t\t\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t (?: \\s*[\u2013\\-\\?]\\s* \t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t )? (?: \\s*nm)?\t\t\t\t(?: \\s* (?:inf\\w*|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t(\t\t\t\t\t\t\t(?: \\s* (,|and|including|&|;|\\/) \\s* )+\t\t\t\t\t\t\t\t\t(\t\t\t\t\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t (?: \\s*[\u2013\\-\\?]\\s* \t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t )? (?: \\s*nm)?\t\t\t\t(?: \\s* (?:inf\\w*|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t)*\t\t \\s* nm\t\t\t\t\t)\t\t\t\t)\t\t\t", 9);
        Matcher m = re.matcher(inputtext);
        this.defined = m.find();
        if (this.defined) {
            this.blockdata = m.group(0);
            int i = inputtext.indexOf(this.blockdata);
            inputtext = inputtext.substring(0, i) + inputtext.substring(i + this.blockdata.length(), inputtext.length());
            this.breakUp(this.blockdata);
        } else {
            this.blockdata = "";
        }
        return inputtext;
    }

    public int getPeakCount() {
        return this.peaks.size();
    }

    public UVPeakData getPeakAt(int n) {
        return (UVPeakData)this.peaks.elementAt(n);
    }

    public String getSummary() {
        String out = "UV";
        return out;
    }

    public String getDetails() {
        String out = "";
        if (this.defined) {
            out = out + "UV:\n";
            if (this.propuv_SolventDefined) {
                out = out + "   uv_Solvent: " + this.propuv_Solvent + "\n";
            }
            int i = 0;
            while (i < this.peaks.size()) {
                UVPeakData dp = (UVPeakData)this.peaks.elementAt(i);
                out = out + dp.getDetails();
                ++i;
            }
            out = out + "\n";
        }
        return out;
    }

    public String getDetailsHTML() {
        if (!this.defined) {
            return "";
        }
        String out = "";
        out = out + "<h3>";
        out = out + "<a name=\"UV\"></a>";
        out = out + "UV</h3>";
        out = out + "<ul>";
        out = out + "<li>";
        out = out + "<a href=\"spec4\">View plot</a>";
        if (this.propuv_SolventDefined) {
            out = out + "<li><b>uv_Solvent:</b> " + this.propuv_Solvent + "";
        }
        out = out + "</ul>";
        out = out + "<table border=0><tr><td width=\"40\">&nbsp;</td><td>";
        out = out + "<table border=1>";
        out = out + "<td><b>lmax / nm</b></td><td><b>Signal Type</b></td><td><b>e / log e</b></td>";
        int i = 0;
        while (i < this.peaks.size()) {
            UVPeakData dp = (UVPeakData)this.peaks.elementAt(i);
            out = out + dp.getDetailsHTML();
            ++i;
        }
        out = out + "</table>";
        out = out + "</td></tr></table>";
        return out;
    }

    public String getXML() {
        if (!this.defined) {
            return "";
        }
        String out = "      <data class=\"uv\" type=\"spectrum\">\n";
        if (this.propuv_SolventDefined) {
            out = out + "         <value id=\"solvent\">" + this.propuv_Solvent + "</value>\n";
        }
        int i = 0;
        while (i < this.peaks.size()) {
            UVPeakData dp = (UVPeakData)this.peaks.elementAt(i);
            out = out + dp.getXML();
            ++i;
        }
        out = out + "      </data>\n";
        return out;
    }

    public boolean isSet() {
        return this.defined;
    }

    private void breakUp(String data) {
        data = this.matchuv_Solvent(data);
        data = this.matchPeaks(data);
    }

    private String matchPeaks(String data) {
        this.peaks.removeAllElements();
        boolean found = false;
        Pattern re = new Pattern("(\t\t\t\t\t\t(\t\t\t\t\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t (?: \\s*[\u2013\\-\\?]\\s* \t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t )? (?: \\s*nm)?\t\t\t\t(?: \\s* (?:inf\\w*|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t(\t\t\t\t\t\t\t(?: \\s* (,|and|including|&|;|\\/) \\s* )+\t\t\t\t\t\t\t\t\t(\t\t\t\t\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t (?: \\s*[\u2013\\-\\?]\\s* \t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t )? (?: \\s*nm)?\t\t\t\t(?: \\s* (?:inf\\w*|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t\t\t\t)*\t\t)", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            String peakblock = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
            boolean foundpeak = false;
            re = new Pattern("(\t\t\t(\t\t\t\t\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t (?: \\s*[\u2013\\-\\?]\\s* \t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t )? (?: \\s*nm)?\t\t\t\t(?: \\s* (?:inf\\w*|sh)\\b\\.? )*\t\t\t\t(?: \\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )?\t\t\t)\t\t)", 9);
            m = re.matcher(peakblock);
            foundpeak = m.find();
            while (foundpeak) {
                UVPeakData dp = new UVPeakData();
                dp.Parse(m.group(1));
                this.peaks.addElement(dp);
                int j = peakblock.indexOf(m.group(0));
                peakblock = peakblock.substring(0, j) + peakblock.substring(j + m.group(0).length(), peakblock.length());
                m = re.matcher(peakblock);
                foundpeak = m.find();
            }
            i = this.peaks.size() - 1;
            while (i-- > 0) {
                ((UVPeakData)this.peaks.elementAt(i)).setNextPeak((UVPeakData)this.peaks.elementAt(i + 1));
            }
        }
        return data;
    }

    private String matchuv_Solvent(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\b((?:methylbutane|acetonitrile|C4H8O2|C5H10|C5H5N|C6H12|C6H14|C6H5CH3|C6H6|CCl4|CH2Cl2|CH3CN|CH3COCH3|CHCl3|DMF|Et2O|EtOH|H2O|isooctane|isopentane|MeOH|Toluene|ethanol|MeOH|Hexane))\\b", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propuv_Solvent = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propuv_Solvent = "";
        }
        this.propuv_SolventDefined = found;
        if (this.propuv_Solvent == "") {
            this.propuv_SolventDefined = false;
        }
        if (this.propuv_Solvent == null) {
            this.propuv_SolventDefined = false;
            this.propuv_Solvent = "";
        }
        return data;
    }

    public boolean isuv_SolventDefined() {
        return this.propuv_SolventDefined;
    }

    public String getuv_Solvent() {
        return this.propuv_Solvent;
    }
}

