/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar.app;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Insets;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public class HelpDialog
extends JDialog {
    JEditorPane helpText = new JEditorPane();
    Button cmdOK;
    public static final int NOHELP = 0;
    public static final int INPUT = 1;
    public static final int SPLITTEXT = 2;
    public static final int PLOT = 3;
    public static final int XML = 4;
    public static final int TABLE = 5;
    public static final int ANALYSIS = 6;

    public HelpDialog(Frame parent) {
        super(parent, "Help", false);
        this.helpText.setEditable(false);
        this.helpText.setContentType("text/html");
        this.helpText.setText("");
        this.helpText.setMargin(new Insets(0, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.helpText, 22, 30), "Center");
        this.cmdOK = new Button("Close");
        this.getContentPane().add((Component)this.cmdOK, "South");
        this.setBounds(100, 100, 450, 500);
    }

    public boolean handleEvent(Event e2) {
        if (e2.id == 201) {
            this.dispose();
            return true;
        }
        if (e2.target instanceof Button && e2.id == 1001) {
            this.hide();
        }
        return super.handleEvent(e2);
    }

    public void showHelp(int state) {
        switch (state) {
            case 1: {
                this.helpText.setText("<h2>Input Editor</h2><p>Paste a paper into the editor (Edit->Paste or Ctrl+V) then select a command to begin analysis.</p><p><b>Highlight:</b> Colours recognised data, helping spot typos quickly and easily - common mistakes include missing punctuation and mismatched brackets. Non-experimental data is shaded grey.</p><p>Once you are satisfied with the data identified, select a mode from the View menu to continue analysis of the data:</p><p><b>Table view:</b> Presents a table showing a list of all the compounds found, and which types of data have been found for each of them.</p><p><b>Detail view:</b> Presents the details of all the data found in each paragraph, along with simulated plots of any spectra.</p><p><b>Analysis view:</b> Presents a summary of all the points that the expert analysis routines have raised.</p><p><b>XML view:</b> Formats all the data into XML, which provides a good method of storing the data generated by this application.</p>");
                break;
            }
            case 2: {
                this.helpText.setText("<h2>Detail view</h2><p>At this stage, your data has been processed by the parser, and is available for further analysis. Compounds which have been identified are listed on the left - select one to view details of in the right-hand pane.</p><p>There are several parts to the detail view - use them by selecting the appropriate tab below the main panel.<p><b>Summary:</b> Lists types of data which have and have not been found, along with a copy of the highlighted paragraph. If you see data here which should have been picked up, check it carefully for typographical errors.</p><p><b>Details:</b> For each type of data, lists exactly what has been found, such as peak positions and signal types for spectra.</p><p><b>Analysis:</b> Applies a set of rules to your data, and reports any inconsistencies such as spectrum peaks in unusual ranges, or elemental analysis inconsistent with the molecular formula.</p>");
                break;
            }
            case 3: {
                this.helpText.setText("<h2>Spectrum Plotting</h2><p>Given correctly parsed data, the application attempts to create a schematic plot of spectral data - note that plots are not exact replicas of observed spectra.</p><p>Click on one of the tabs below the main panel to select a spectrum type to display. Note that some may be unavailable, depending on data input.</p><p><b>Zooming:</b> Click and drag with the left mouse button to zoom in on a region. Right-click (or hold down the Ctrl key and left-click) to zoom back out.</p><p><b>Peak widths:</b> Click and drag with middle mouse button or wheel button (or left mouse button, while holding down the Alt key) to adjust gaussian widths. Below a threshold, peaks will by plotted as lines.</p><p><b>Toggle labels:</b> Turn annotations on and off (if available).</p><p><b>Save:</b> Spectra may be saved in Structured Vector Graphics (SVG) format. This format can be viewed in most modern web browsers. A free viewer may be downloaded from Adobe (www.adobe.com/svg).</p>");
                break;
            }
            case 4: {
                this.helpText.setText("<h2>XML</h2><p>XML is a file format ideal for storing data extracted by this application. This mode displays the generated XML code, which can easily be saved to disk.</p>");
                break;
            }
            case 5: {
                this.helpText.setText("<h2>Table View</h2><p>This mode displays data on each compound identified from the paper in a row, marking which data types have been identified. Click on a row to be taken to a more detailed view of that compound.</p>");
                break;
            }
            case 6: {
                this.helpText.setText("<h2>Analysis View</h2><P>Applies a set of rules to your data, and reports any inconsistencies such as spectrum peaks in unusual ranges, or elemental analysis inconsistent with the molecular formula.</p><P>Possible problems are listed on the left-hand side, click on one to see details about it, and where it occurs.</P>");
                break;
            }
            default: {
                this.helpText.setText("<h2>Error</h2><p>Unfortunately an error has occured and no help is available on this topic.</p>");
            }
        }
        this.show();
        this.helpText.setCaretPosition(0);
    }

    static {
        NOHELP = 0;
        INPUT = 1;
        SPLITTEXT = 2;
        PLOT = 3;
        XML = 4;
        TABLE = 5;
        ANALYSIS = 6;
    }
}

