import java.io.*;
import java.util.*;
import java.math.*;


public class MultiData {
  public int nShifts;
  public String[] labels;
  public double[] calcShifts;
  public double[] expShifts;
  public String[] calcfiles;
  public String[] expfiles;
  public double[] calcAverages;
  public double[] expAverages;
  public double[] calcStdevps;
  public int[] frequency;
  public int nFiles;

  //Constructor
  public MultiData(String[] labels, double[] calcShifts, double[] expShifts, String[] calcfile, String[] expfile)
    {
    }    


  //Constructor given CalcExpData objects
  public MultiData(CalcExpData[] calcExpData)
    {
    construct(calcExpData);
    }

  //Constructor given files
  public MultiData(String calcFile, String expFile, double tms)
    {
    CalcExpData[] calcExpArray = new CalcExpData[1];
    calcExpArray[0] = new CalcExpData(calcFile,expFile,tms);
    construct(calcExpArray);
    }


  public void construct(CalcExpData[] calcExpData)
    {
    int i; int j; int k=0;
    nFiles = calcExpData.length;
    nShifts=0;
 
    for(i=0;i<nFiles;i++)
      {
      nShifts=nShifts+calcExpData[i].nShifts;
      }

    String[] labelsTemp= new String[nShifts];
    double[] calcShiftsTemp=new double[nShifts];
    double[] expShiftsTemp=new double[nShifts];
    String[] calcfilesTemp=new String[nShifts];
    String[] expfilesTemp = new String[nShifts];
    double[] calcAveragesTemp = new double[nShifts];
    double[] expAveragesTemp = new double[nShifts];
    int[] frequencyTemp = new int[nShifts];
    double[] calcStdevpsTemp = new double[nShifts];

    for(i=0;i<nFiles;i++)
      {
      for(j=0;j<calcExpData[i].nShifts;j++)
        {
        labelsTemp[k]=calcExpData[i].labels[j];
        calcShiftsTemp[k]=calcExpData[i].calcShifts[j];
        expShiftsTemp[k]=calcExpData[i].expShifts[j];
        calcfilesTemp[k]=calcExpData[i].calcfile;
        expfilesTemp[k]=calcExpData[i].expfile;
        k++;
        }
      }

    labels=labelsTemp;
    calcShifts=calcShiftsTemp;
    expShifts=expShiftsTemp;
    calcfiles=calcfilesTemp;
    expfiles=expfilesTemp;
    calcAverages=calcAveragesTemp;
    expAverages=expAveragesTemp;
    frequency=frequencyTemp;
    calcStdevps=calcStdevpsTemp;
    
    fillAverages();
    fillStdevps();
    adjustStdevps();
                
    }









  //Fill averages
  public void fillAverages()
    {
    int i=0; int j=0; int k=0;

    for(i=0;i<nShifts;i++)
      {
      calcAverages[i]=0;
      expAverages[i]=0;
      frequency[i]=0;
      for(j=0;j<nShifts;j++)
        {
        if(labels[i].compareTo(labels[j])==0)
          {
          calcAverages[i]=calcAverages[i]+calcShifts[j];
          expAverages[i]=expAverages[i]+expShifts[j];
          frequency[i]++;
          }
        }
      calcAverages[i]=calcAverages[i]/frequency[i];
      expAverages[i]=expAverages[i]/frequency[i];
      }
    }


  //Fill stdevps
  public void fillStdevps()
    {
    fillAverages();
    for(int i=0;i<nShifts;i++)
      {
      calcStdevps[i]=0;
      for(int j=0;j<nShifts;j++)
        {
        if(labels[i].compareTo(labels[j])==0)
          {
          calcStdevps[i]=calcStdevps[i]+(calcShifts[j]-calcAverages[i])*(calcShifts[j]-calcAverages[i]);
          }
        }
      calcStdevps[i]=Math.sqrt(calcStdevps[i]/frequency[i]);
      }
    }

  //Adjust stdevps (any shifts only present in one structure, replace the stdevp of zero by the average of the stdevps for the non-zero examples)
  public void adjustStdevps()
    {
    double averageWeight = 0;
    double N=0;
    for(int i=0;i<nShifts;i++)
      {
      if(frequency[i]!=1)
        {
        averageWeight=averageWeight+calcStdevps[i]/frequency[i];
        N=N+1.0/frequency[i];
        }
      }
      //System.out.println("Total weight="+averageWeight);
      averageWeight=averageWeight/N;
      //System.out.println("N="+N);
      //System.out.println("Average weight="+averageWeight);
    for(int i=0;i<nShifts;i++)
      {
      if(frequency[i]==1)
        {
        calcStdevps[i]=averageWeight;
        }
      }
    }


  //Filter out any shift not present in all examples
  public void filter()
    {
    int i=0; int j=0;
    fillAverages();
    
    String[] labelsTemp= new String[nShifts];
    double[] calcShiftsTemp=new double[nShifts];
    double[] expShiftsTemp=new double[nShifts];
    String[] calcfilesTemp=new String[nShifts];
    String[] expfilesTemp = new String[nShifts];
    double[] calcAveragesTemp = new double[nShifts];
    double[] expAveragesTemp = new double[nShifts];
    int[] frequencyTemp = new int[nShifts];

    for(i=0;i<nShifts;i++)
      {
      if(frequency[i]==nFiles)
        {
        labelsTemp[j]=labels[i];
        calcShiftsTemp[j]=calcShifts[i];   
        expShiftsTemp[j]=expShifts[i];
        calcfilesTemp[j]=calcfiles[i];
        expfilesTemp[j]=expfiles[i];
        calcAveragesTemp[j]=calcAverages[i];
        expAveragesTemp[j]=expAverages[i];
        frequencyTemp[j]=frequency[i];
        j++;
        }
      }
    
    nShifts=j;
    String[] labelsTemp2= new String[nShifts];
    double[] calcShiftsTemp2=new double[nShifts];
    double[] expShiftsTemp2=new double[nShifts];
    String[] calcfilesTemp2=new String[nShifts];
    String[] expfilesTemp2 = new String[nShifts];
    double[] calcAveragesTemp2 = new double[nShifts];
    double[] expAveragesTemp2 = new double[nShifts];
    int[] frequencyTemp2 = new int[nShifts];
    
    for(i=0;i<nShifts;i++)
      {
      labelsTemp2[i]=labelsTemp[i];
      calcShiftsTemp2[i]=calcShiftsTemp[i];   
      expShiftsTemp2[i]=expShiftsTemp[i];
      calcfilesTemp2[i]=calcfilesTemp[i];
      expfilesTemp2[i]=expfilesTemp[i];
      calcAveragesTemp2[i]=calcAveragesTemp[i];
      expAveragesTemp2[i]=expAveragesTemp[i];
      frequencyTemp2[i]=frequencyTemp[i];
      }

    labels=labelsTemp2;
    calcShifts=calcShiftsTemp2;
    expShifts=expShiftsTemp2;
    calcfiles=calcfilesTemp2;
    expfiles=expfilesTemp2;
    calcAverages=calcAveragesTemp2;
    expAverages=expAveragesTemp2;
    frequency=frequencyTemp2;
    }
            

  //Calculate correl
  public double calculateCorrel()
    {
    double correl=0.0;
    if(nShifts!=0)
      {
      correl = NMR.calculateCorrel(calcShifts,expShifts);
      }
    else
      {
      correl = 1.0/0;
      }
    return(correl);
    }

  //Calculate MAE
  public double calculateMae()
    {
    double mae=0.0;
    if(nShifts!=0) {mae = NMR.calculateMae(calcShifts,expShifts);}
    else { mae = 1.0/0;}
    return(mae);
    }

  //Calculate MAE'
  public double calculateMaePrime()
    {
    double maePrime=0.0;
    if(nShifts!=0) {maePrime = NMR.calculateMaePrime(calcShifts,expShifts); }
    else {maePrime=1.0/0;}
    return(maePrime);
    }

  //Calculate wMae
  public double calculateWMae()
    {
    if(nShifts!=0) {return(NMR.calculateWMae(calcShifts,expShifts,calcStdevps));}
    else {return(1.0/0);}
    }

  //Calculate wMaePrime
  public double calculateWMaePrime()
    {
    if(nShifts!=0) {return(NMR.calculateWMaePrime(calcShifts,expShifts,calcStdevps));}
    else {return(1.0/0);}
    }

  //Calculate CPd
  public double calculateCpd()
    {
    double cpd = 0.0;
    if(nShifts!=0) {cpd = NMR.calculateCpd(calcShifts,expShifts,calcAverages,expAverages);}
    else {cpd=1.0/0;}
    return(cpd);
    }

  //Calculate CPe
  public double calculateCpe()
    {
    double cpe = 0.0;
    if(nShifts!=0) {cpe = NMR.calculateCpe(calcShifts,expShifts,calcAverages,expAverages);}
    else {cpe=1.0/0;}
    return(cpe);
    }

  //Calculate CPh
  public double calculateCph()
    {
    double cph = 0.0;
    if(nShifts!=0) {cph = NMR.calculateCph(calcShifts,expShifts,calcAverages,expAverages);}
    else {cph=1.0/0;}
    return(cph);
    }

  //Calculate slope
  public double calculateSlope()
    {
    return(NMR.calculateSlope(calcShifts,expShifts));
    }

  //Calculate intercept
  public double calculateIntercept()
    {
    return(NMR.calculateIntercept(calcShifts,expShifts));
    }

  //Get |Dd| values
  public double[] getModDd()
    {
    int i;
    double[] modDd = new double[nShifts];
    for(i=0;i<nShifts;i++)
      {
      modDd[i]=Math.abs(calcShifts[i]-expShifts[i]);
      }
    return(modDd);
    }

  //Get |Dd'| values
  public double[] getModDdPrime()
    {
    int i;
    double[] modDdPrime = new double[nShifts];
    double slope = calculateSlope();
    double intercept = calculateIntercept();
    for(i=0;i<nShifts;i++)
      {
      modDdPrime[i]=Math.abs(((calcShifts[i]-intercept)/slope)-expShifts[i]);
      }
    return(modDdPrime);
    }

  //Get scaled shifts
  public double[] getdscaled()
    {
    int i;
    double[] dscaled = new double[nShifts];
    double slope = calculateSlope();
    double intercept = calculateIntercept();
    for(i=0;i<nShifts;i++)
      {
      dscaled[i]=(calcShifts[i]-intercept)/slope;
      }
    return(dscaled);
    }




  // Print
  public void print()
    {
    System.out.println("calcfile,expfile,label,calcShift,expShift,calcAverage,expAverage,frequency");
    for(int i=0;i<nShifts;i++)
      {
      System.out.print(NMR.fileTrim(calcfiles[i])+",");
      System.out.print(NMR.fileTrim(expfiles[i])+",");
      System.out.print(labels[i]+",");
      System.out.print(calcShifts[i]+",");
      System.out.print(expShifts[i]+",");
      System.out.print(calcAverages[i]+",");
      System.out.print(expAverages[i]+",");
      System.out.print(frequency[i]+",");
      System.out.print(calcStdevps[i]+",");
      System.out.print("\n");
      }
    }
}
