import java.io.*;
import java.util.*;
import java.math.*;


public class CalcExpData {
  public int nShifts;
  public String[] labels;
  public double[] calcShifts;
  public double[] expShifts;
  public String calcfile;
  public String expfile;


  //Constructor given  labels and shifts
  public CalcExpData(String[] l, double[] c, double[] e)
    {
    labels=l;
    calcShifts=c;
    expShifts=e;
    }


  //Constructor
  public CalcExpData(NMRData calc, NMRData exp)
    {
    construct(calc,exp);
    }

  public void construct(NMRData calc, NMRData exp)
    {
    calcfile=calc.filename;
    expfile=exp.filename;

    int i=0; int j=0; int k=0;
    int nShiftsTemp=calc.nShifts+exp.nShifts;
    String[] labelsTemp = new String[nShiftsTemp];
    double[] calcShiftsTemp = new double[nShiftsTemp];
    double[] expShiftsTemp = new double[nShiftsTemp];
    for(i=0;i<calc.nShifts;i++)
      {
      for(j=0;j<exp.nShifts;j++)
        {
        if(calc.labels[i].compareTo(exp.labels[j])==0)
          {
          labelsTemp[k]=calc.labels[i];
          calcShiftsTemp[k]=calc.shifts[i];
          expShiftsTemp[k]=exp.shifts[j];
          k++;
          break;
          }
        }
      }
    nShifts=k;

    String[] labelsTemp2=new String[nShifts];
    double[] calcShiftsTemp2=new double[nShifts];
    double[] expShiftsTemp2=new double[nShifts];

    for(i=0;i<nShifts;i++)
      {
      labelsTemp2[i]=labelsTemp[i];
      calcShiftsTemp2[i]=calcShiftsTemp[i];
      expShiftsTemp2[i]=expShiftsTemp[i];
      }
    
    labels=labelsTemp2;
    calcShifts=calcShiftsTemp2;
    expShifts=expShiftsTemp2;
    }          


  //Constructor given files
  public CalcExpData(String calcFile, String expFile, double tms)
    {
    try
      {
      NMRData nmrDataCalc = NMR.convertCalcFileToNMRData(calcFile,tms);
      ExpData expData = new ExpData(expFile);
      NMRData nmrDataExp = NMR.convertExpToNMR(expData,nmrDataCalc);
      construct(nmrDataCalc,nmrDataExp);
      }
    catch(Exception e)
      {
      System.err.println("Error constructing CalcExpData object with "+calcFile+", "+expFile+" and "+tms);
      e.printStackTrace();
      throw new RuntimeException();
      }
    }


  //Calculate correl
  public double calculateCorrel()
    {
    return(NMR.calculateCorrel(expShifts,calcShifts));
    }

  //Calculate MAE
  public double calculateMae()
    {
    return(NMR.calculateMae(calcShifts,expShifts));
    }

  //Calculate maePrime
  public double calculateMaePrime()
    {
    return(NMR.calculateMaePrime(calcShifts,expShifts));
    }


  //Calculate wMae
  public double calculateWMae(Weights weights)
    {
    double[] myWeights = getWeights(weights);
    return(NMR.calculateWMae(calcShifts,expShifts,myWeights));
    }

  //Calculate wMaePrime
  public double calculateWMaePrime(Weights weights)
    {
    double[] myWeights = getWeights(weights);
    return(NMR.calculateWMaePrime(calcShifts,expShifts,myWeights));
    }

  //Calculate rmse
  public double calculateRmse()
    {
    return(NMR.calculateRmse(calcShifts,expShifts));
    }

  //Calculate crmse
  public double calculateCrmse()
    {
    return(NMR.calculateCrmse(calcShifts,expShifts));
    }

  //Calculate w2mae
  public double calculateW2mae(Weights weights)
    {
    double[] myWeights = getWeights(weights);
    for(int i=0;i<myWeights.length;i++)
      {
      myWeights[i]=myWeights[i]*myWeights[i];
      }
    return(NMR.calculateWMae(calcShifts,expShifts,myWeights));
    }

  //Calculate w2cmae
  public double calculateW2cmae(Weights weights)
    {
    double[] myWeights = getWeights(weights);
    for(int i=0;i<myWeights.length;i++)
      {
      myWeights[i]=myWeights[i]*myWeights[i];
      }
    return(NMR.calculateWMaePrime(calcShifts,expShifts,myWeights));
    }

  //Calculate fcmae
  public double calculateFcmae(double slope, double intercept)
    {
    double[] fscaledShifts = new double[nShifts];
    for(int i=0;i<nShifts;i++)
      {
      fscaledShifts[i]=(calcShifts[i]-intercept)/slope;
      }
    return(NMR.calculateMae(fscaledShifts,expShifts));
    }

  //Calculate wfcmae
  public double calculateWfcmae(double slope, double intercept, Weights weights)
    {
    double[] myWeights = getWeights(weights);
    double[] fscaledShifts = new double[nShifts];
    for(int i=0;i<nShifts;i++)
      {
      fscaledShifts[i]=(calcShifts[i]-intercept)/slope;
      }
    return(NMR.calculateWMae(fscaledShifts,expShifts,myWeights));
    }

  //Calculate w2fcmae
  public double calculateW2fcmae(double slope, double intercept, Weights weights)
    {
    double[] myWeights = getWeights(weights);
    for(int i=0;i<myWeights.length;i++)
      {
      myWeights[i]=myWeights[i]*myWeights[i];
      }
    double[] fscaledShifts = new double[nShifts];
    for(int i=0;i<nShifts;i++)
      {
      fscaledShifts[i]=(calcShifts[i]-intercept)/slope;
      }
    return(NMR.calculateWMae(fscaledShifts,expShifts,myWeights));
    }

  //Calculate fcrmse
  public double calculateFcrmse(double slope, double intercept)
    {
    double[] fscaledShifts = new double[nShifts];
    for(int i=0;i<nShifts;i++)
      {
      fscaledShifts[i]=(calcShifts[i]-intercept)/slope;
      }
    return(NMR.calculateRmse(fscaledShifts,expShifts));
    }

  //Calculate Dp1
    public double calculateDp1()
      {
      double[] tempCalcShifts = new double[nShifts];
      double[] tempExpShifts = new double[nShifts];
      String[] tempLabels = new String[nShifts];
      for(int i=0;i<nShifts;i++)
        {
        tempCalcShifts[i] = calcShifts[i];
        tempExpShifts[i] = expShifts[i];
        tempLabels[i] = labels[i];
        }
      for(int i=0;i<nShifts;i++)
        {
        for(int j=0;j<nShifts-1;j++)
          {
          if(tempExpShifts[j]<tempExpShifts[j+1])
            {
            double tempExp = tempExpShifts[j];
            double tempCalc = tempCalcShifts[j];
            String tempLabel = tempLabels[j];
            tempExpShifts[j]=tempExpShifts[j+1];
            tempCalcShifts[j]=tempCalcShifts[j+1];
            tempLabels[j]=tempLabels[j+1];
            tempExpShifts[j+1]=tempExp;
            tempCalcShifts[j+1]=tempCalc;
            tempLabels[j+1]=tempLabel;
            }
          }
       }
     double dp1 = 0.0;
     for(int i=0;i<nShifts-1;i++)
       {
       if(tempCalcShifts[i+1]>tempCalcShifts[i])
         {
         dp1=dp1-((tempCalcShifts[i]-tempCalcShifts[i+1])*(tempExpShifts[i]-tempExpShifts[i+1]));
         }
       }
     return(dp1);
     }
       






  //Calculate DP2
    public double calculateDp2()
      {
      double[] tempCalcShifts = new double[nShifts];
      double[] tempExpShifts = new double[nShifts];
      String[] tempLabels = new String[nShifts];
      for(int i=0;i<nShifts;i++)
        {
        tempCalcShifts[i] = calcShifts[i];
        tempExpShifts[i] = expShifts[i];
        tempLabels[i] = labels[i];
        }
      for(int i=0;i<nShifts;i++)
        {
        for(int j=0;j<nShifts-1;j++)
          {
          if(tempExpShifts[j]<tempExpShifts[j+1])
            {
            double tempExp = tempExpShifts[j];
            double tempCalc = tempCalcShifts[j];
            String tempLabel = tempLabels[j];
            tempExpShifts[j]=tempExpShifts[j+1];
            tempCalcShifts[j]=tempCalcShifts[j+1];
            tempLabels[j]=tempLabels[j+1];
            tempExpShifts[j+1]=tempExp;
            tempCalcShifts[j+1]=tempCalc;
            tempLabels[j+1]=tempLabel;
            }
          }
       }
     double dp2 = 0.0;
     for(int i=0;i<nShifts-1;i++)
       {
       dp2=dp2+Math.abs((tempCalcShifts[i+1]-tempCalcShifts[i])-(tempExpShifts[i+1]-tempExpShifts[i]));
       }
     return(dp2/(nShifts-1));
     }

  //Calculate dp6
    public double calculateDp6()
      {
      double dp6=0.0;
      for(int i=0;i<nShifts;i++)
        {
        for(int j=i+1;j<nShifts;j++)
          {
          dp6=dp6+Math.abs((calcShifts[i]-calcShifts[j])-(expShifts[i]-expShifts[j]));
          }
        }
      return(dp6/(nShifts*(nShifts-1)/2));
      }
      



  //Calculate dp4
  public double calculateDp4(double expect, double stdev)
    {
    double dp4=1.0;
    for(int i=0;i<nShifts;i++)
      {
      double z = Math.abs(((calcShifts[i]-expShifts[i])-expect)/stdev);
      dp4=dp4*2*ProbMath.normalCdf(-z);
      }
    return(dp4);
    }

  //Calculate cdp4
  public double calculateCdp4(double expect, double stdev)
    {
    double cdp4=1.0;
    double[] scaledShifts = getdscaled();
    for(int i=0;i<nShifts;i++)
      {
      double z = Math.abs(((scaledShifts[i]-expShifts[i])-expect)/stdev);
      cdp4=cdp4*2*ProbMath.normalCdf(-z);
      }
    return(cdp4);
    }

  //Calculate ln(cdp4)
  public double calculateLnCdp4(double expect, double stdev)
    {
    double cdp4=0.0;
    double[] scaledShifts = getdscaled();
    for(int i=0;i<nShifts;i++)
      {
      double z = Math.abs(((scaledShifts[i]-expShifts[i])-expect)/stdev);
      cdp4=cdp4+Math.log(2*ProbMath.normalCdf(-z));
      }
    return(cdp4);
    }


  //Calculate dp5
  public double calculateDp5(double[] classes, double[] probabilities)
    {
    double dp5=1.0;
    if((classes.length+1)!=probabilities.length)
      {
      throw new RuntimeException("Number of classes +1 ("+(classes.length+1)+") and probabilities ("+probabilities.length+") do not match");
      }
    for(int i=0;i<nShifts;i++)
      {
      int classAssigned = -1;
      for(int j=0;j<classes.length;j++)
        {
        if((calcShifts[i]-expShifts[i])<classes[j])
          {
          classAssigned = j;
          break;
          }
        }
      if(classAssigned==-1)
        {
        classAssigned=classes.length;
        }
      dp5=dp5*probabilities[classAssigned];
      }
    return(dp5);
    }

  //Calcualte dp5 given an array
  public double calculateDp5(double[][] input)
    {
    return(getDp5Param(input,"dp5"));
    }

  //Calculate dp5 values given an array
  public double getDp5Param(double[][] input, String param)
    {
    int nClasses = input[1].length;
    double[] classes = new double[nClasses-1];
    double[] probs = new double[nClasses];
    for(int i=0;i<nClasses-1;i++)
      {
      classes[i]=input[0][i];
      probs[i]=input[1][i];
      }
    probs[nClasses-1]=input[1][nClasses-1];
    double toReturn = 0.0;
    if(param.compareTo("dp5")==0) toReturn = calculateDp5(classes,probs);
    else if(param.compareTo("cdp5")==0) toReturn = calculateCdp5(classes,probs);
    else throw new RuntimeException("Unknown parameter: "+param);
    return(toReturn);
    } 

  //Calculate cdp5
  public double calculateCdp5(double[] classes, double[] probabilities)
    {
    double cdp5=1.0;
    double[] scaledShifts = getdscaled();
    if((classes.length+1)!=probabilities.length)
      {
      throw new RuntimeException("Number of classes +1 ("+(classes.length+1)+") and probabilities ("+probabilities.length+") do not match");
      }
    for(int i=0;i<nShifts;i++)
      {
      int classAssigned = -1;
      for(int j=0;j<classes.length;j++)
        {
        if((scaledShifts[i]-expShifts[i])<classes[j])
          {
          classAssigned = j;
          break;
          }
        }
      if(classAssigned==-1)
        {
        classAssigned=classes.length;
        }
      cdp5=cdp5*probabilities[classAssigned];
      }
    return(cdp5);
    }
    
  //Calcualte cdp5 given an array
  public double calculateCdp5(double[][] input)
    {
    return(getDp5Param(input,"cdp5"));
    }



  //Calculate ln(wf8)
  public double calculateLnWf8(double expect, double stdev)
    {
    double wf8=0.0;
    double[] scaledShifts = getdscaled();
    for(int i=0;i<nShifts;i++)
      {
      double z = Math.abs((Math.abs(scaledShifts[i]-expShifts[i])-expect)/stdev);
      wf8=wf8+Math.log(2*ProbMath.normalCdf(-z));
      }
    return(wf8);
    }


  //Calculate cdp4Cut  (If any error is more than the cutoff number of standard deviations away from the expectation value, the error is artificially reduced to the cutoff value.
  public double calculateCdp4Cut(double expect, double stdev,double cutoff)
    {
    double cdp4=1.0;
    double[] scaledShifts = getdscaled();
    double cutoffError = stdev*cutoff;
    for(int i=0;i<nShifts;i++)
      {
      double error=scaledShifts[i]-expShifts[i];
      if(error>cutoffError)
        {
        error=cutoffError;
        }
      double z = Math.abs((error-expect)/stdev);
      cdp4=cdp4*2*ProbMath.normalCdf(-z);
      }
    return(cdp4);
    }

  //Calculate tcdp4t
  public double calculateTcdp4(double expect, double stdev, double degfreed)
    {
    double tcdp4=1.0;
    double[] scaledShifts = getdscaled();
    DistLib.t tdist = new DistLib.t();
    for(int i=0;i<nShifts;i++)
      {
      double z = Math.abs(((scaledShifts[i]-expShifts[i])-expect)/stdev);
      tcdp4=tcdp4*2*tdist.cumulative(-z,degfreed);
      }
    return(tcdp4);
    }



  //Calculate maximum error
  public double calculateMaxError()
    {
    return(NMR.calculateMaxError(calcShifts,expShifts));
    }




  //Get weights
  public double[] getWeights(Weights weights)
    {
    int foundIt=0;
    double[] myWeights = new double[nShifts];
    for(int i=0;i<nShifts;i++)
      {
      foundIt=0;
      for(int j=0;j<weights.nShifts;j++)
        {
        if(labels[i].compareTo(weights.labels[j])==0)
          {
          myWeights[i]=weights.weights[j];
  	  foundIt=1;
          break;
          }
        }
        if(foundIt==0)
          {
          throw new RuntimeException("I couldn't find a weight for "+labels[i]);
          }
      }
    return(myWeights);
    }


  //Calculate slope
  public double calculateSlope()
    {
    return(NMR.calculateSlope(calcShifts,expShifts));
    }

  //Calculate intercept
  public double calculateIntercept()
    {
    return(NMR.calculateIntercept(calcShifts,expShifts));
    }

  //Get |Dd| values
  public double[] getModDd()
    {
    int i;
    double[] modDd = new double[nShifts];
    for(i=0;i<nShifts;i++)
      {
      modDd[i]=Math.abs(calcShifts[i]-expShifts[i]);
      }
    return(modDd);
    }

  //Get |Dd'| values
  public double[] getModDdPrime()
    {
    int i;
    double[] modDdPrime = new double[nShifts];
    double slope = calculateSlope();
    double intercept = calculateIntercept();
    for(i=0;i<nShifts;i++)
      {
      modDdPrime[i]=Math.abs(((calcShifts[i]-intercept)/slope)-expShifts[i]);
      }
    return(modDdPrime);
    }

  //Get scaled shifts
  public double[] getdscaled()
    {
    int i;
    double[] dscaled = new double[nShifts];
    double slope = calculateSlope();
    double intercept = calculateIntercept();
    for(i=0;i<nShifts;i++)
      {
      dscaled[i]=(calcShifts[i]-intercept)/slope;
      }
    return(dscaled);
    }

  //Get fscaledShifts
  public double[] getdfscaled(double slope, double intercept)
    {
    double[] dfscaled = new double[nShifts];
    for(int i=0;i<nShifts;i++)
      {
      dfscaled[i]=(calcShifts[i]-intercept)/slope;
      }
    return(dfscaled);
    }


    
  //Get calc shift
  public double getCalcShift(String s)
    {
    String target = s;
    Double targetShift = 0.0;
    for(int i=0;i<nShifts;i++)
      {
      if(labels[i].compareTo(target)==0)
        {
        targetShift = calcShifts[i];
        }
      }
    return(targetShift);
    }

  //Get exp shift
  public double getExpShift(String s)
    {
    String target = s;
    Double targetShift = 0.0;
    for(int i=0;i<nShifts;i++)
      {
      if(labels[i].compareTo(target)==0)
        {
        targetShift = expShifts[i];
        }
      }
    return(targetShift);
    }



  //Print
  public void print()
    {
    int i=0;
    System.out.print(","+calcfile+","+expfile+"\n");
    System.out.print(",calc,exp\n");
    for(i=0;i<nShifts;i++)
      {
      System.out.print(labels[i]+","+calcShifts[i]+","+expShifts[i]+"\n");
      }
    }

}
    
