import java.io.*;
import java.util.*;
import java.math.*;


public class ExpData {
  public String filename;
  public int nShifts;
  public double[] shifts;
  public String[][] labels;
  public int[] assign;
  public int nLabels;


  //Constructor given a file to read
  public ExpData(String s)
    {
    filename = s;
    getNumShifts(filename);
    nLabels=NMR.getMaxTokens(filename);
    readFile(filename);
//    sort();
    }

  //Constructor for making an unassigned ExpData object
  public ExpData(double[] x)
    {
    int i; int j;
    nShifts=x.length;
    nLabels=x.length;
    double[] shiftsTemp = new double[nShifts];
    String[][] labelsTemp = new String[nShifts][nLabels];
    int[] assignTemp = new int[nShifts];
    for(i=0;i<nShifts;i++)
      {
      shiftsTemp[i]=x[i];
      labelsTemp[i][0]="any";
      for(j=1;j<nLabels;j++)
        {
        labelsTemp[i][j]="STR";
        }
      assignTemp[i]=0;
      }
    shifts=shiftsTemp;
    labels=labelsTemp;
    assign=assignTemp;
    }

  //constructor given shifts and labels
  public ExpData(double[] x, String[][] s)
    {
    nShifts=x.length;
    nLabels=x.length;
    shifts = x;
    labels = s;
    assign = new int[nShifts];
    for(int i=0;i<nShifts;i++)
      {
      assign[i]=0;
      }
    }


  //Method for determining number of shifts
  public void getNumShifts(String filename)
    {
    nShifts=Nlines.lines(filename);
    }

  //Method for reading the file
  public void readFile(String filename)
    {
    BufferedReader buffRead;
    String currLine="";
    double[] shiftsTemp = new double[nShifts];
    String[][] labelsTemp = new String[nShifts][nLabels];
    int[] assignTemp = new int[nShifts];
    int i=0; int j=0;

    for(i=0;i<nShifts;i++)
      {
      assignTemp[i]=0;
      }

     try
     {
     buffRead = new BufferedReader(new FileReader(new File(filename)));
     i=0;
     while (currLine!=null&&(currLine.compareTo("end"))!=0)
       {
       currLine = buffRead.readLine();
       StringTokenizer st = new StringTokenizer(currLine," ,\t",false);
       String temp = "";
       shiftsTemp[i] = Double.valueOf(st.nextToken()).doubleValue();
       j=0;
       while(st.hasMoreTokens())
         {
         temp = st.nextToken();
         if((temp.compareTo("assign"))==0)
            {
            temp=st.nextToken();
            assignTemp[i]=Integer.parseInt(temp);
            }
         else
            {
            labelsTemp[i][j]=temp;
            j++;
            }

         }
         while(j<nLabels)
            {
            labelsTemp[i][j]="STR";
            j++;
            }
       i++;
       }
       buffRead.close();
     }        
   catch(Exception e) {;}     
   shifts=shiftsTemp;
   labels=labelsTemp;
   assign=assignTemp;
   }


  //sort shifts and labels into descending order
  public void sort()
    {
    double[] shiftsTemp = new double[nShifts];
    String[][] labelsTemp = new String[nShifts][nLabels];
    int[] assignTemp = new int[nShifts];
    double[] shiftsTemp2 = new double[nShifts];
    String[][] labelsTemp2 = new String[nShifts][nLabels];
    int[] assignTemp2 = new int[nShifts];

    int i=0;int j=0; int k=0; int biggest=0; double biggestValue=0;    

    for(i=0;i<nShifts;i++)
      {
      shiftsTemp[i]=shifts[i];
      for(k=0;k<nLabels;k++)
        {
        labelsTemp[i][k]=labels[i][k];
        }
      assignTemp[i]=assign[i];
      }

    for(j=0;j<nShifts;j++)
      {
      biggestValue = -1000000000;
      for(i=0;i<nShifts;i++)
        {
        if((shiftsTemp[i]>biggestValue)&&(labelsTemp[i][0].compareTo("used")!=0))
          {
          biggest=i;
          biggestValue = shiftsTemp[i];
          }
        }
        shiftsTemp2[j]=shiftsTemp[biggest];
        for(k=0;k<nLabels;k++)
          {
          labelsTemp2[j][k]=labelsTemp[biggest][k];
          }
        assignTemp2[j]=assignTemp[biggest];
        labelsTemp[biggest][0]="used";
        }
 
    shifts=shiftsTemp2;
    labels=labelsTemp2;
    assign=assignTemp2;
    }          


  //Method for changing assignment labels
  public void changeAssignments(String[][] s)
    {
    labels=s;
    }


  //Method for getting the maximum number of labels
//  public void getMaxLabels(filename)

 

  //Print
  public void print()
    {
    int i; int j;
    for(i=0;i<nShifts;i++)
      {
      System.out.print(shifts[i]+" ");
      for(j=0;j<nLabels;j++)
        {
        System.out.print(labels[i][j]+" ");
        }
      System.out.print(assign[i]+"\n");
      }
    }


}
