import java.io.*;
import java.util.*;
import java.math.*;


public class ParameterArray2 {
  public MultiData multiC;
  public MultiData multiH;
  public int nParams=24;
  public double[] values = new double[nParams];

  //Constructor
  public ParameterArray2(MultiData multiC, MultiData multiH)
    {
    values[0] = multiC.calculateCorrel();
    values[1] = multiH.calculateCorrel();
    values[2] = 1-Math.sqrt((1-values[0])*(1-values[1]));
    values[3] = multiC.calculateMae();
    values[4] = multiH.calculateMae();
    values[5] = Math.sqrt(values[3]*values[4]);
    values[6] = multiC.calculateMaePrime();
    values[7] = multiH.calculateMaePrime();
    values[8] = Math.sqrt(values[6]*values[7]);
    values[9] = multiC.calculateWMae();
    values[10] = multiH.calculateWMae();
    values[11] = Math.sqrt(values[9]*values[10]);
    values[12] = multiC.calculateWMaePrime();
    values[13] = multiH.calculateWMaePrime();
    values[14] = Math.sqrt(values[12]*values[13]);
    values[15] = multiC.calculateCpd();
    values[16] = multiH.calculateCpd();
    values[17] = 0.5*(values[15]+values[16]);
    values[18] = multiC.calculateCpe();
    values[19] = multiH.calculateCpe();
    values[20] = 0.5*(values[18]+values[19]);
    values[21] = multiC.calculateCph();
    values[22] = multiH.calculateCph();
    values[23] = 0.5*(values[21]+values[22]);
    }

  //Constructor for an empty array
  public ParameterArray2()
    {
    }


  //Constructor which sets all values to some number
  public ParameterArray2(double d)
    {
    for(int i=0;i<nParams;i++) values[i]=d;
    }

}
    
