import javax.swing.*;    // Swing GUI classes are defined here.
import java.lang.*; 
import java.awt.*; 
import java.awt.event.*; // Event handling class are defined here.
import java.io.*;
import java.util.*;
import java.math.*;
import java.text.*;
import javax.swing.event.*;

/** 
* An applet to compare calculated and experimental NMR data
*
* <P>
* Copyright <A HREF=http://www.ch.cam.ac.uk/staff/jmg.html>J M Goodman</A> and S G Smith, University of Cambridge, 2008
* <P>
* 
*
* @author J M Goodman
* @author S G Smith
*/


public class DP4 extends JApplet 
  {        
  JTextArea calcC, calcH;
  JTextField expC, expH;
  JTextArea assignments;
  JTextArea results;
  JTextArea instructions;
  JPanel northPanel = new JPanel();
  JPanel centerPanel = new JPanel();
  JPanel southPanel = new JPanel();
  JPanel westPanel = new JPanel();
  JButton readButton;
  JButton showAssignmentsButton;
  JButton calculateButton;
  JButton clearButton;
  JButton helpButton;
  JLabel copyright;
  JLabel labelCalcC = new JLabel("13C Calc");
  JLabel labelCalcH = new JLabel("1H Calc");
  JLabel labelExpC = new JLabel("13C Expt");
  JLabel labelExpH = new JLabel("1H Expt");
  JComboBox databaseversion;
  JTextArea distinstructions;
  JList choosedatabase;

  CalcExpData[] calcExpDataC;
  CalcExpData[] calcExpDataH;

  double[] cdp4C;
  double[] cdp4H;
  double[] cdp4M;
  
  double[][] shiftsC;
  double[][] shiftsH;

  int nCalcStructs;

  int error;
  String[] errorMessage = {"",
		"Error reading calculated data",
                 };

  int normalort=1;

  CalcDataMult calcDataCMult;
  CalcDataMult calcDataHMult;
  ExpData expDataC;
  ExpData expDataH;

  String[] databaseFiles; 
  int databaseIndex; 
  double[] stdevCarray; //stdevCarray = new double[databaseFiles.length];
  double[] stdevHarray; //stdevHarray = new double[databaseFiles.length];
  double[] degfreedCarray;
  double[] degfreedHarray;

  double meanC = 0.0;
  double meanH = 0.0;
  double stdevC = 2.4059066666045137;
  double stdevH = 0.18824966196621246;
  double degfreedC = 11.38283;
  double degfreedH = 14.18363;

  double maximumErrorC = 10.0;
  double maximumErrorH = 2.0;

  DecimalFormat mdfp = new DecimalFormat("#0.0");
  DecimalFormat mdfp2 = new DecimalFormat("###0.00");

  String[] distributions;

  int haveC;
  int haveH;

  Color myColor = new Color(250,200,200);
  Color yellow = new Color(250,250,0);
  Color red = new Color(250,0,0);
  Color resultsColor = new Color(250,225,225);
  Color topColor = new Color(250,225,225);

  String introInstructions = "Welcome to the DP4 applet!  \n\nEnter some calculated data for one or more isomers, and one set of experimental data.\nThen click Read Data, Show Assignments or Calculate.\n\nThe required input format for the calculated data is:\n C1,C2,C3,C4\n 202.2,45.7,13.6, 15.5\n 201.8,44.9,16.1,9.2\n\nThe required input format for the experimental data is:\n 200.5(C1), 45.5(C2), 14.8(C3 or C4), 16.4 (C3 or C4)\n\nMore detailed instructions are available by following the links on the left.";

/**
* Set up the applet windows
 *
 * This method is called by the system before the applet
 * appears.  It is used here to create the button and add
 * it to the "content pane" of the JApplet.  An anonymous
 * class is used to create an ActionListener for the button.
 */
  public void init() 
    {


    databaseFiles = new String[] { "DP4-original" , "DP4-database2"  };

    databaseIndex = databaseFiles.length-1;

    stdevCarray = new double[databaseFiles.length];
    stdevHarray = new double[databaseFiles.length];
    degfreedCarray = new double[databaseFiles.length];
    degfreedHarray = new double[databaseFiles.length];


    /*********************************************************/
    // Database values                                       

    stdevCarray[0] = 2.305863716940701;  //From PIfile-6.txt, the database used in the DP4 paper
    stdevHarray[0] = 0.1849547402340214;
    degfreedCarray[0] = 11.38284;
    degfreedHarray[0] = 14.18251;

    stdevCarray[1] = 2.269372270818724;    //From PIfile-7.txt
    stdevHarray[1] = 0.18731058105269952;
    degfreedCarray[1] = 11.63916;           
    degfreedHarray[1] = 13.75399;


    /*********************************************************/

    stdevC = stdevCarray[databaseFiles.length-1];
    stdevH = stdevHarray[databaseFiles.length-1];






    calcC = new JTextArea();
    calcC.setEditable(true);
    calcH = new JTextArea();
    calcH.setEditable(true);
    expC = new JTextField();
    expC.setEditable(true);
    expH = new JTextField();
    expH.setEditable(true);
    assignments = new JTextArea();
    assignments.setEditable(true);
    results = new JTextArea();
    results.setEditable(false);
    instructions = new JTextArea();
    instructions.setEditable(false);
    instructions.setBackground(new Color(250,225,225));
    readButton = new JButton("Read Data");
    showAssignmentsButton = new JButton("Show Assignments");
    calculateButton = new JButton("Calculate");
    clearButton = new JButton("Clear");
    helpButton = new JButton("Help");
    databaseversion = new JComboBox(databaseFiles);
    distinstructions = new JTextArea();
    distinstructions.setEditable(false);
    distinstructions.setBackground(resultsColor);
    choosedatabase = new JList(databaseFiles);
    choosedatabase.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    choosedatabase.setSelectedIndex(databaseIndex);

    
    error = 0;
    haveC = 0;
    haveH = 0;

    String[] testlabels = new String[1];
    double[][] testshifts = new double[1][1];
    testlabels[0]="tst";
    testshifts[0][0]=0.0;

    calcDataCMult = new CalcDataMult(testlabels,testshifts);

    String tdist = "t distribution (recommended)";
    String normaldist = "normal distribution";

    JRadioButton tButton = new JRadioButton(tdist);
    tButton.setActionCommand(tdist);
    tButton.setSelected(true);
    tButton.setBackground(topColor);

    JRadioButton normalButton = new JRadioButton(normaldist);
    normalButton.setActionCommand(normaldist);
    normalButton.setSelected(false);
    normalButton.setBackground(topColor);

    ButtonGroup group = new ButtonGroup();
    group.add(tButton);
    group.add(normalButton);

    JPanel radioPanel = new JPanel(new GridLayout(0, 1));
    radioPanel.add(tButton);
    radioPanel.add(normalButton);
    radioPanel.setBackground(topColor);


    

    //calcC.setText("C01,C02,C03,C04,C05,C06,C07,C08,C09,C10\n74.2554365073922,48.4456981024066,176.8533987759320,11.6726430966840,138.2101285582200,121.8972943080770,122.5037688017990,121.0568182787270,58.8307503367660,15.6273195601159\n76.5460632601859,48.3151410052179,174.5682855133720,18.4222133106306,139.5878723610640,121.5024836259490,122.5607241570980,121.0137997508570,58.3404142282890,15.4212570455936");
    //calcH.setText("H11,H12,H13,H14,H15,H16,H17,H18,H19,H20\n5.272508014964120,2.465115924405980,1.137126312147530,7.434681274189460,7.377040650138500,7.227069006742040,4.158748568823260,1.188113755982280,3.147159999706540,4.161308139516340\n4.7570785596323200,2.7433756754368900,1.3775278273198100,7.3450269178692500,7.3432954630331400,7.1989029013479200,3.9171168547253100,0.9098410063066340,4.0054490941734800,3.8939930353664400");
    //expC.setText("175.5017 (C03), 141.5293(C05), 128.0500 (C06 or C07), 127.3075(C08), 125.9367 (C06 or C07), 73.7292(C01), 60.524(C09),46.5231(C02),13.9214(C04 or C10),10.95 (C10 or C04)");
    



    this.setBackground(myColor);
    this.setLayout(new BorderLayout());

    Panel pn = new Panel();
    this.add("North",pn);
    pn.setLayout(new GridLayout(1,2,5,5));
    pn.setBackground(topColor);
    Panel pn1 = new Panel();
    pn.add(pn1);
    Panel pn2 = new Panel();
    pn.add(pn2);
    pn1.setBackground(topColor);
    pn1.setPreferredSize(new Dimension(280,100));
    pn2.setBackground(topColor);
    pn1.setLayout(new FlowLayout(FlowLayout.LEFT));
    pn1.add(instructions);
    instructions.setText("Please select version of database to use:");
    pn2.setPreferredSize(new Dimension(280,70));
    pn2.setLayout(new FlowLayout(FlowLayout.LEFT));
    pn2.add(distinstructions);
    distinstructions.setText("Select probability distribution:");
    pn2.add(radioPanel);
    JScrollPane listAreaScrollPane = new JScrollPane(choosedatabase);
    listAreaScrollPane.setPreferredSize(new Dimension(280,70));
    pn1.add(listAreaScrollPane);



/*
    pnn.setBackground(resultsColor);
    pnn.add(instructions);
    instructions.setText("Please select version of database to use:");
    pnn.setLayout(new FlowLayout(FlowLayout.RIGHT));
    JScrollPane listAreaScrollPane = new JScrollPane(choosedatabase);
    listAreaScrollPane.setPreferredSize(new Dimension(150,20));
    pnn.add(listAreaScrollPane);
    choosedatabase.setSelectedIndex(databaseIndex);


    Panel pns = new Panel();
    pn.add("South",pns);
    pns.setBackground(resultsColor);
    pns.setLayout(new FlowLayout(FlowLayout.RIGHT));
    pns.add(distinstructions);
    distinstructions.setText("Select probability distribution:");
    pns.add(radioPanel);
*/

    Panel pc = new Panel();
    pc.setBackground(myColor);
    this.add("Center",pc);
    pc.setLayout(new GridBagLayout());

    GridBagConstraints c = new GridBagConstraints();
    //c.fill = GridBagConstraints.BOTH;
    c.insets = new Insets(2,2,2,2);
    c.anchor = GridBagConstraints.LINE_START;

    c.gridx=0; c.gridy=0; c.gridwidth=1; c.gridheight=1; c.weightx=0.0; c.weighty=0.0;
    pc.add(new JLabel("13C Calc:"),c);

    c.gridx=1; c.gridy=0; c.gridwidth=1; c.gridheight=1; c.weightx=0.0; c.weighty=0.0;
    pc.add(new JLabel("1H Calc:"),c);

    c.gridx=0; c.gridy=1; c.gridwidth=1; c.gridheight=1; c.weightx=0.0; c.weighty=0.0;
    JScrollPane areaScrollPane = new JScrollPane(calcC);
    areaScrollPane.setPreferredSize(new Dimension(280, 250));
    pc.add(areaScrollPane,c);

    c.gridx=1; c.gridy=1; c.gridwidth=1; c.gridheight=1; c.weightx=0.0; c.weighty=0.0;
    JScrollPane areaScrollPane2 = new JScrollPane(calcH);
    areaScrollPane2.setPreferredSize(new Dimension(280, 250));
    pc.add(areaScrollPane2,c);

    c.insets = new Insets(10,2,2,2);

    c.gridx=0; c.gridy=2; c.gridwidth=1; c.gridheight=1; c.weightx=0.0; c.weighty=0.0;
    pc.add(new JLabel("13C Expt:"),c);

    c.gridx=1; c.gridy=2; c.gridwidth=1; c.gridheight=1; c.weightx=0.0; c.weighty=0.0;
    pc.add(new JLabel("1H Expt:"),c);
    
    c.insets = new Insets(2,2,2,2);
    c.fill = GridBagConstraints.BOTH;

    c.gridx=0; c.gridy=3; c.gridwidth=1; c.gridheight=1; c.weightx=0.0; c.weighty=0.0;
    pc.add(expC,c);

    c.gridx=1; c.gridy=3; c.gridwidth=1; c.gridheight=1; c.weightx=0.0; c.weighty=0.0;
    pc.add(expH,c);
   
    c.fill = GridBagConstraints.NONE;
    c.insets = new Insets(10,2,2,2);

    c.gridx=0; c.gridy=4; c.gridwidth=2; c.gridheight=1; c.weightx=0.0; c.weighty=0.0;
    Panel buttonsPanel = new Panel();
    buttonsPanel.setLayout(new FlowLayout());
    buttonsPanel.setBackground(myColor);
    buttonsPanel.add(readButton);
    buttonsPanel.add(showAssignmentsButton);
    buttonsPanel.add(calculateButton);
    buttonsPanel.add(clearButton);
    //buttonsPanel.add(helpButton);
    pc.add(buttonsPanel,c);


    c.gridx=0; c.gridy=5; c.gridwidth=2; c.gridheight=1; c.weightx=0.0; c.weighty=0.0;
    results.setBackground(resultsColor);
    JScrollPane areaScrollPane3 = new JScrollPane(results);
    areaScrollPane3.setPreferredSize(new Dimension(562, 250));
    pc.add(areaScrollPane3,c);

    c.insets = new Insets(10,2,2,2);

    results.setText(introInstructions);
    results.setCaretPosition(0);

    tButton.addActionListener( new ActionListener()
      {
      public void actionPerformed(ActionEvent evt)
        {
        normalort=1;
        }
      }  );

    normalButton.addActionListener( new ActionListener()
      {
      public void actionPerformed(ActionEvent evt)
        {
        normalort=0;
        }
      }  );

    choosedatabase.addListSelectionListener( new ListSelectionListener()
      {
      public void valueChanged(ListSelectionEvent e) 
        {
        databaseIndex=choosedatabase.getSelectedIndex();
        getDatabase();
        }
      }  );
     

    calculateButton.addActionListener( new ActionListener() 
      {
      public void actionPerformed(ActionEvent evt) 
	{
        calculate();
        }
      } );

    readButton.addActionListener( new ActionListener() 
      {
      public void actionPerformed(ActionEvent evt) 
	{
        read();
        }
      } );


    showAssignmentsButton.addActionListener( new ActionListener() 
      {
      public void actionPerformed(ActionEvent evt) 
	{
        showAssignments();
        }
      } );


    clearButton.addActionListener( new ActionListener() 
      {
      public void actionPerformed(ActionEvent evt) 
	{
        clear();
        }
      } );



    Panel ps = new Panel();
    ps.setBackground(myColor);
    this.add("South",ps);
    ps.setLayout(new FlowLayout(FlowLayout.RIGHT));
    ps.add(new JLabel("<html><p><FONT COLOR=BLACK>(c) Jonathan M Goodman and Steven G Smith</FONT></p></html>"));

/*
    Panel p1 = new Panel();
    p1.setBackground(new Color(250,175,175));
    this.add("Center",p1);
JScrollPane areaScrollPane = new JScrollPane(calcC);
areaScrollPane.setVerticalScrollBarPolicy(
		JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
areaScrollPane.setPreferredSize(new Dimension(250, 250));
    p1.add(areaScrollPane);

    p1.add(new JButton("Button 2"));

*/


    }

/*
  public void valueChanged(ListSelectionEvent e)
    {
    JList list = (JList)e.getSource();
    databaseIndex=list.getSelectedIndex();
    getDatabase();
    }
*/


  public void getDatabase()
    {
    //String temp = (String)(databaseversion.getSelectedItem());
    //databaseIndex=choosedatabase.getSelectedIndex();
    stdevC = stdevCarray[databaseIndex];
    stdevH = stdevHarray[databaseIndex];
    degfreedC = degfreedCarray[databaseIndex];
    degfreedH = degfreedHarray[databaseIndex];
    
    }

  public void calculate()
    {

    read();

    if(error!=1)   results.setText("");



    if((error!=1)&&(haveC==1))
      {
      checkShifts(calcExpDataC,maximumErrorC,"carbon");
      }

    if((error!=1)&&(haveH==1))
      {
      checkShifts(calcExpDataH,maximumErrorH,"proton");
      }


    if(error==0)
      {
      results.setText("");
      }
    else if(error==2)
      {
      results.append(" DP4 calculation has been attempted anyway, but you may wish to check the input data.\n To check the assignments, click Show Assignments.\n\n");
      }



    //databaseIndex = databaseversion.getSelectedIndex();

    if(error!=1)
      {
      //results.append("databaseIndex="+databaseIndex);
      results.append("This calculation will use the "+databaseFiles[databaseIndex]+" version of the database and the ");
      if(normalort==0) results.append("normal distribution");
      else if(normalort==1) results.append("t distribution");
      results.append(".\n(To change these options select the desired database and distribution from the menus at the \ntop of the applet and then click Calculate).\n\n");
      }

    if((error!=1)&&(haveC==1)&&(haveH==1))
      {
      try
        {
        results.append("Results of DP4 using both carbon and proton data:\n");
        if(normalort==0)
          {
          cdp4M = NMR.calculateCdp4(calcExpDataC,meanC,stdevC,calcExpDataH,meanH,stdevH);
          }
        else if(normalort==1)
          {
          cdp4M = NMR.calculateTcdp4(calcExpDataC,meanC,stdevC,degfreedC,calcExpDataH,meanH,stdevH,degfreedH);
          }
        printResults(cdp4M);
        }
      catch(Exception e)
        {
        if(error==1) results.setText(e.getMessage());
        else 
          {
          error=2; 
          results.append("Error calculating DP4 for the combined data:\n Please check the input and then click Read, Show Assignments or Calculate.\n\n");
          e.printStackTrace();
          }
        }
      }





    if((error!=1)&&(haveC==1))
      {
      try
        {
        results.append("Results of DP4 using the carbon data only:\n");
        if(normalort==0)
          {
          cdp4C = NMR.calculateCdp4(calcExpDataC,meanC,stdevC);
          }
        else if(normalort==1)
          {
          cdp4C = NMR.calculateTcdp4(calcExpDataC,meanC,stdevC,degfreedC);
          }
        printResults(cdp4C);
        }
      catch(Exception e)
        {
        if(error==1) results.setText(e.getMessage());
        else 
          {
          error=2; 
          results.append("Error calculating DP4 for the carbon data:\n Please check the input and then click Read, Show Assignments or Calculate.\n\n");
          e.printStackTrace();
          }
        }
      }



    if((error!=1)&&(haveH==1))
      {
      try
        {
        results.append("Results of DP4 using the proton data only:\n");
        if(normalort==0)
          {
          cdp4H = NMR.calculateCdp4(calcExpDataH,meanH,stdevH);
          }
        else if(normalort==1)
          {
          cdp4H = NMR.calculateTcdp4(calcExpDataH,meanH,stdevH,degfreedH);
          }
        printResults(cdp4H);
        }
      catch(Exception e)
        {
        if(error==1) results.setText(e.getMessage());
        else 
          {
          error=2; 
          results.append("Error calculating DP4 for the proton data:\n Please check the input and then click Calculate.\n\n");
          e.printStackTrace();
          }
        }
      }


    results.setCaretPosition(0);


    }


    



  public void read()
    {
    getDatabase();
    error=0;
    haveC=0;
    haveH=0;
    int haveCCalc=0;
    int haveCExp=0;
    int haveHCalc=0;
    int haveHExp=0;
    results.setText("");
    //results.setText("reading...");

    calcC.setCaretPosition(0);
    calcH.setCaretPosition(0);
    expC.setCaretPosition(0);
    expH.setCaretPosition(0);


    String tempString = calcC.getText();
    if(tempString.length()>0) haveCCalc=1;
    tempString = calcH.getText();
    if(tempString.length()>0) haveHCalc=1;
    tempString = expC.getText();
    if(tempString.length()>0) haveCExp=1;
    tempString = expH.getText();
    if(tempString.length()>0) haveHExp=1;
    
    if((haveCCalc==1)&&(haveCExp==1)) haveC=1;
    if((haveHCalc==1)&&(haveHExp==1)) haveH=1;
    if((haveCCalc==0)&&(haveCExp==1))
      {
      error=1;
      results.append("You have entered some experimental 13C data but no calculated 13C data.\n Please either enter the calculated data or delete the experimental data,\n then click Read, Show Assignments or Calculate.\n\n");
      }
    if((haveHCalc==0)&&(haveHExp==1))
      {
      error=1;
      results.append("You have entered some experimental 1H data but no calculated 1H data.\n Please either enter the calculated data or delete the experimental data,\n then click Read, Show Assignments or Calculate.\n\n");
      }
    if((haveCCalc==1)&&(haveCExp==0))
      {
      error=1;
      results.append("You have entered some calculated 13C data but no experimental 13C data.\n Please either enter the experimental data or delete the calculated data,\n then click Read, Show Assignments or Calculate.\n\n");
      }
    if((haveHCalc==1)&&(haveHExp==0))
      {
      error=1;
      results.append("You have entered some calculated 1H data but no experimental 1H data.\n Please either enter the experimental data or delete the calculated data,\n then click Read, Show Assignments or Calculate.\n\n");
      }


    if((error==0)&&(haveC==0)&&(haveH==0))
      {
      error=1;
      results.append("Please enter some data\n\n");
      }

    if((haveC==1)&&(error==0))
      {
      try
        {
        String calcCstring = calcC.getText();
        calcDataCMult = getCalcShifts(calcCstring,"carbon");
        }
      catch(Exception e)
        {
        if(error==1) results.setText(e.getMessage());
        else 
          {
          results.setText("Error reading the calculated carbon data:\n Please check the input and then click Read Data, Show Assignments or Calculate.");
          e.printStackTrace();
          }
        }
      }

    if((haveH==1)&&(error==0))
      {
      try
        {
        String calcHstring = calcH.getText();
        calcDataHMult = getCalcShifts(calcHstring,"proton");
        }
      catch(Exception e)
        {
        if(error==1) results.setText(e.getMessage());
        else 
          {
          results.setText("Error reading the proton calculated data:\n Please check the input and then click Read Data, Show Assignments or Calculate.");
          e.printStackTrace();
          }
        }
      }



    if((error==0)&&(haveC==1))
      {
      try
       {
       String expCstring = expC.getText();
       expDataC = getExpShifts(expCstring,calcDataCMult,"carbon");
       }
      catch(Exception e)
        {
        if(error==1) 
          {
          results.setText(e.getMessage());
          e.printStackTrace();
          }
        else 
          {
          results.setText("Error reading the carbon experimental data:\n Please check the input and then click Read Data, Show Assignments or Calculate.");
          e.printStackTrace();
          }
        }
      }




    if((error==0)&&(haveH==1))
      {
      try
       {
       String expHstring = expH.getText();
       expDataH = getExpShifts(expHstring,calcDataHMult,"proton");
       }
      catch(Exception e)
        {
        if(error==1) 
          {
          results.setText(e.getMessage());
          e.printStackTrace();
          }
        else 
          {
          results.setText("Error reading the proton experimental data:\n Please check the input and then click Read Data, Show Assignments or Calculate.");
          e.printStackTrace();
          }
        }
      }





    if((error==0)&&(haveC==1))
      {
      try
        {
        calcExpDataC = getCalcExpData(calcDataCMult,expDataC,"carbon");
        }
      catch(Exception e)
        {
        if(error==1) 
          {
          results.setText(e.getMessage());
          e.printStackTrace();
          }
        else 
          {
          results.setText("Error interpretting the carbon experimental data:\n Please check the input and then click Read Data, Show Assignments or Calculate.");
          e.printStackTrace();
          }
        }
      }

    if((error==0)&&(haveH==1))
      {
      try
        {
        calcExpDataH = getCalcExpData(calcDataHMult,expDataH,"proton");
        }
      catch(Exception e)
        {
        if(error==1) 
          {
          results.setText(e.getMessage());
          e.printStackTrace();
          }
        else 
          {
          results.setText("Error interpretting the proton experimental data:\n Please check the input and then click Read Data, Show Assignments or Calculate.");
          e.printStackTrace();
          }
        }
      }


    if((error!=1)&&(haveC==1))
      {
      checkShifts(calcExpDataC,maximumErrorC,"carbon");
      }

    if((error!=1)&&(haveH==1))
      {
      checkShifts(calcExpDataH,maximumErrorH,"proton");
      }


    if(error==0)
      {
      results.setText("Data read successfully.\nNow click Show Assignments or Calculate.");
      }
    else if(error==2)
      {
      results.append(" To check the assignments, click Show Assignments.\n To attempt DP4 calculation anyway, click Calculate.");
      }


    }




  public void showAssignments()
    {

    //results.setFont(new Font("Courier", Font.PLAIN, 14));

    read();

    if(error!=1)   results.setText("");



    if((error!=1)&&(haveC==1))
      {
      checkShifts(calcExpDataC,15.0,"carbon");
      }

    if((error!=1)&&(haveH==1))
      {
      checkShifts(calcExpDataH,2.5,"proton");
      }


    if(error==0)
      {
      results.setText("");
      }
    else if(error==2)
      {
      results.append("\n");
      }
    //results.setText("Assignments will be displayed here");


    if(error!=1)
      {
      int nIsomers=0;
      if(haveC==1) nIsomers = calcExpDataC.length;
      else if(haveH==1) nIsomers = calcExpDataH.length; 
      for(int i=0;i<nIsomers;i++)
        {
        results.append("Isomer "+(i+1)+" (atom, calc, exp):\n");
        if((error!=1)&&(haveC==1))
          {
          printAssignments(calcExpDataC[i],15.0);
          }
        if((error!=1)&&(haveH==1))
          {
          printAssignments(calcExpDataH[i],2.5);
          }
        results.append("\n");
        }
      }
    results.setCaretPosition(0);
    

    }







  public void clear()
    {
    results.setText(introInstructions);
    results.setCaretPosition(0);
    calcH.setText("");
    expC.setText("");
    expH.setText("");
    error=0;
    haveC=0;
    haveH=0;
    }



  public CalcDataMult getCalcShiftsT(String input)
    {
      results.setText("");
      String[] array = NMR.getLines2(input);
      int nShifts=array.length;

      //Check if last string has anything in it
      String temp = array[nShifts-1];
      StringTokenizer st = new StringTokenizer(temp," ,\t",false);
      //results.setText(Integer.toString(nShifts));
      if(st.countTokens()==0) nShifts--;

      //results.append(" "+Integer.toString(nShifts));

      int nIsomers=0;
      StringTokenizer st2 = new StringTokenizer(array[0],", \t",false);
      nIsomers=st2.countTokens()-1;
      for(int i=1;i<nShifts;i++)
        {
        StringTokenizer st3 = new StringTokenizer(array[i],", \t",false);
        if((st3.countTokens()-1)!=nIsomers)
            {
            error=1;
            results.setText("Error reading calculated shifts:  Please check the line for "+st3.nextToken()+".\nCorrect as necessary and then click on Read Data, Show Assignments or Calculate.");
            break;
            }
        }

      double[][] shifts = new double[nIsomers][nShifts];
      String[] labels = new String[nShifts];


      if(error==0)
        {            

        for(int i=0;i<nShifts;i++)
            {
            StringTokenizer st3 = new StringTokenizer(array[i],", \t",false);
            labels[i]=st3.nextToken();
            for(int j=0;j<nIsomers;j++)
              {
              String temp2 = st3.nextToken();
              shifts[j][i]=Double.valueOf(temp2);
              }
            }
        //results.setText("Data read successfully");
        }
      return(new CalcDataMult(labels,shifts));
    }


  public CalcDataMult getCalcShifts(String input, String corh)
    {
    results.setText("");
    String[] array = NMR.getLines2(input);
    int nIsomers=array.length-1;

    //Check if last string has anything in it
    String temp = array[array.length-1];
    StringTokenizer st = new StringTokenizer(temp," ,\t",false);
    //results.setText(Integer.toString(nShifts));
    if(st.countTokens()==0) nIsomers--;

    //Check that all lines have the same number of tokens
    int nShifts=0;
    StringTokenizer st2 = new StringTokenizer(array[0],", \t",false);
    nShifts = st2.countTokens();
    for(int i=1;i<array.length;i++)
      {
      StringTokenizer st3 = new StringTokenizer(array[i],", \t",false);
      int temp2 = st3.countTokens();
      if(temp2!=nShifts)
        {
        error=1;
        throw new RuntimeException("Error reading calculated shifts: \n The number of "+corh+" shifts for isomer "+Integer.toString(i)+" ("+Integer.toString(temp2)+") does not equal the number of labels ("+Integer.toString(nShifts)+").\n Please correct and then click Read Data, Show Assignments or Calculate.");
        }
      }
    
    String[] labels = new String[nShifts];
    double[][] shifts = new double[nIsomers][nShifts];
    
      StringTokenizer st3 = new StringTokenizer(array[0],", \t",false);
      for(int i=0;i<nShifts;i++)
        {
        labels[i]=st3.nextToken();
        }
      for(int i=0;i<nIsomers;i++)
        {
        StringTokenizer st4 = new StringTokenizer(array[i+1],", \t",false);
        for(int j=0;j<nShifts;j++)
          {
          String tempString = st4.nextToken();
          try
            {
            double tempDouble = Double.valueOf(tempString);
            }
          catch(Exception e)
            {
            error=1;
            throw new RuntimeException("Error reading calculated shifts: \n Cannot interpret the shift for atom "+labels[j]+" in isomer "+(i+1)+": "+tempString+".\n Please correct and then click Read Data, Show Assignments or Calculate."); 
            }

          shifts[i][j] = Double.valueOf(tempString);
          }
        }
      //results.setText("Data read successfully");
    return(new CalcDataMult(labels,shifts));
    }








  public ExpData getExpShifts(String expString, CalcDataMult calcDataMult, String corh)
    {
    //Get number of shifts
    int inBracket=0;
    StringBuffer sb = new StringBuffer();
    for(int i=0;i<expString.length();i++)
      {
      char c = expString.charAt(i);
      if(c=='(') inBracket++;
      if(inBracket==0)  sb.append(c);
      if(c==')') inBracket--;
      }
    StringTokenizer st = new StringTokenizer(sb.toString()," \t,");
    int nExpShifts=st.countTokens();
    //results.setText(Integer.toString(nExpShifts));

    //Check that number of exp shifts <= number of calc shifts
    if(nExpShifts>calcDataMult.nShifts)
      {
      error=1;
      throw new RuntimeException("The number of experimental "+corh+" shifts ("+Integer.toString(nExpShifts)+")\n exceeds the number of calculated "+corh+" shifts ("+Integer.toString(calcDataMult.nShifts)+").\n Please amend and then click Read, Assign Resonances or Calculate.");
      }

    double[] expShifts = new double[nExpShifts];
    for(int i=0;i<nExpShifts;i++)
      {
      String temp = st.nextToken();
      try
        {
        expShifts[i]=Double.valueOf(temp);
        }
      catch(Exception e)
        {
        error=1;
        throw new RuntimeException("Error interpretting "+corh+" experimental shift: "+temp+".\n Please check the input data and then click Read, Show Assignments or Calculate.");
        }
      }

    String[][] expLabels = new String[nExpShifts][];

    StringBuffer progress = new StringBuffer();
    int j=0;
    try{
    for(int i=0;i<nExpShifts;i++)
      {
      progress.append(Double.toString(expShifts[i])+" ");
      StringBuffer sb2 = new StringBuffer();
      char c=' ';
      int gotLabel=0;
      while(gotLabel==0)
        {
        c=expString.charAt(j);
        j++;
        if(c==')') inBracket--;
        if(inBracket>0) sb2.append(c);
        if(c=='(') inBracket++;
        if(((c==',')&&(inBracket==0))||(j==(expString.length()-1))) gotLabel=1;
        }
      expLabels[i] = getLabels(sb2.toString(),calcDataMult, corh);
      for(int k=0;k<expLabels[i].length;k++) progress.append(expLabels[i][k]+" ");
      progress.append("\n");
      }
      }
    catch(Exception e)
      {
      error=1;
      throw new RuntimeException("Error reading the "+corh+" experimental data:\n"+progress+"\n Please check the input, then click Read, Show Assignments or Calculate.");
      }
    
    //results.setText(progress.toString());


    //Check if labels match the calculated shifts
    for(int i=0;i<nExpShifts;i++)
      {
      for(int k=0;k<expLabels[i].length;k++)
        {
        boolean foundLabel = false;
        for(int l=0;l<calcDataMult.labels.length;l++)
          {
          if(expLabels[i][k].compareTo(calcDataMult.labels[l])==0)
            {
            foundLabel=true;
            break;
            }
          }
        if(foundLabel==false)
          {
          error=1;
          throw new RuntimeException("Could not interpret the assignment label "+expLabels[i][k]+" in the "+corh+" experimental data:\n it does not appear to correspond to any of the calculated shift labels.");
          }
        }
      }

    //Fill all spare label spaces with STR (needed for creating the ExpData object)
    String[][] newLabels = new String[nExpShifts][nExpShifts];
    for(int i=0;i<nExpShifts;i++)
      {
      j=0;
      for(j=0;j<expLabels[i].length;j++)
        {
        newLabels[i][j]=expLabels[i][j];
        }
      while(j<nExpShifts)
        {
        newLabels[i][j]="STR";
        j++;
        }
      }

    ExpData toReturn = new ExpData(expShifts,newLabels);
    return(toReturn);

    }




    public String[] getLabels(String input, CalcDataMult calcDataMult, String corh)
      {
      String[] toReturn;
      if((input.length()==0)||(input.indexOf("any")!=-1)) toReturn=calcDataMult.labels;
      else
        {
        StringBuffer sb = new StringBuffer(input);
        while(sb.indexOf("or")!=-1)
          {
          sb.insert(sb.indexOf("or"),",");
          sb.delete(sb.indexOf("or"),(sb.indexOf("or")+2));
          }
        StringTokenizer st = new StringTokenizer(sb.toString(),"\t ,",false);
        toReturn = new String[st.countTokens()];
        for(int i=0;i<toReturn.length;i++)
          {
          toReturn[i]=st.nextToken();
          }
        }
      return(toReturn);
      }






  public CalcExpData[] getCalcExpData(CalcDataMult calcDataMult,ExpData expData,String corh)
    {
    int nIsomers = calcDataMult.nIsomers;
    //expData.print();
    CalcExpData[] toReturn = new CalcExpData[nIsomers];
    for(int i=0;i<nIsomers;i++)
      {
      try
        {
        NMRData calcTemp = new NMRData(calcDataMult.labels,calcDataMult.shifts[i]);
        NMRData nmrDataExp = NMR.convertExpToNMR(expData,calcTemp);
        //nmrDataExp.print();
        toReturn[i] = new CalcExpData(calcTemp,nmrDataExp);
        }
      catch(Exception e)
        {
        error=1;
        e.printStackTrace();
        throw new RuntimeException("Error assigning the "+corh+" experimental data.\n Please check that the assignments you have entered are correct and unambiguous.\n (See the Instructions for more information)."); 

//For example, 50.9(C1 or C2), 48.5(C2), 15.5(C3) is not valid because if the 50.9 shift is assigned to C2 (because it fits the calculated shift of C2 better than it does C1) and then no assignment can be found for the 48.5 shift.\n In this case the entry should be ammended to 50.9(C1), 48.5(C2), 15.5(C3).\n Similarly, 50.9, 48.5, 15.5(C3) (where no assignment for the 50.9 and 48.5 shift is taken to mean any assignment is possible) because one of the 50.9 or 48.5 might be assigned to C3 which would then leave no assignment possible for the 15.5 shift.\n In this case the entry should be amended to 50.9(C1 or C2), 48.5(C1 or C2), 15.5(C3)");
        }
      }
    return(toReturn);
    }
        




  public void printResults(double[] probs)
    {
    int nIsomers = probs.length;
    for(int i=0;i<nIsomers;i++)
      {
      results.append("  Isomer "+(i+1)+": "+mdfp.format(probs[i])+"%\n");
      }
    results.append("\n");
    }



  public void checkShifts(CalcExpData[] calcExpData,double errorMax,String corh)
    {
    int nIsomers = calcExpData.length;
    double maxError = 0.0;
    for(int i=0;i<nIsomers;i++)
      {
      double thisMax = calcExpData[i].calculateMaxError();
      if(thisMax>maxError)
        {
        maxError=thisMax;
        }
      }
    if(maxError>errorMax)
      {
      error=2;
      //System.err.println("Error\n\n\n\n\n\n\n\n\n Error = "+error);
      results.append("WARNING: One or more of the "+corh+" shifts have large errors (largest error "+mdfp.format(maxError)+" ppm).\n");
      }
    }


      
  public void printAssignments(CalcExpData calcExpData, double errorMax)
    {
    int nShiftsTemp = calcExpData.nShifts;
    String[] labelsTemp = new String[nShiftsTemp];
    double[] calcShiftsTemp = new double[nShiftsTemp];
    double[] expShiftsTemp = new double[nShiftsTemp];
    for(int i=0;i<nShiftsTemp;i++)
      {
      labelsTemp[i]=calcExpData.labels[i];
      calcShiftsTemp[i]=calcExpData.calcShifts[i];
      expShiftsTemp[i]=calcExpData.expShifts[i];
      }
    for(int i=0;i<nShiftsTemp;i++)
      {
      for(int j=1;j<nShiftsTemp;j++)
        {
        if(labelsTemp[j].compareTo(labelsTemp[j-1])<0)
          {
          String temp1 = labelsTemp[j-1];
          double temp2 = calcShiftsTemp[j-1];
          double temp3 = expShiftsTemp[j-1];
          labelsTemp[j-1]=labelsTemp[j];
          calcShiftsTemp[j-1]=calcShiftsTemp[j];
          expShiftsTemp[j-1]=expShiftsTemp[j];
          labelsTemp[j]=temp1;
          calcShiftsTemp[j]=temp2;
          expShiftsTemp[j]=temp3;
          }
        }
      }
    for(int i=0;i<nShiftsTemp;i++)
      {
      //int maxLabelLength = getMaxLabelLength(calcExpData);
      results.append("   "+labelsTemp[i]+"   ");
      //int spacesToAdd = maxLabelLength-calcExpData.labels[i].length();
      //for(int j=0;j<spacesToAdd;j++)  results.append(" ");
      //if(calcExpData.calcShifts[i]<100.0) results.append(" ");
      //if(calcExpData.calcShifts[i]<10) results.append(" ");
      results.append((Double.toString(calcShiftsTemp[i]))+"   ");
      //if(calcExpData.expShifts[i]<100.0) results.append(" ");
      //if(calcExpData.expShifts[i]<10.0) results.append(" ");
      results.append(Double.toString(expShiftsTemp[i]));
      if(Math.abs(expShiftsTemp[i]-calcShiftsTemp[i])>errorMax) results.append("   Warning: Error = "+mdfp.format(Math.abs(expShiftsTemp[i]-calcShiftsTemp[i]))+" ppm");
      results.append("\n");
      }
    }


  public int getMaxLabelLength(CalcExpData calcExpData)
    {
    int maxLabelLength = 0;
    for(int i=0;i<calcExpData.nShifts;i++)
      {
      if(calcExpData.labels[i].length()>maxLabelLength)  maxLabelLength =  calcExpData.labels[i].length();
      }
    return(maxLabelLength);
    }




  }




