import java.io.*;
import java.util.*;
import java.math.*;


public class NMRData {
  public int nShifts;
  public double[] shifts;
  public String[] labels;
  public String filename;

  //Constructor
  public NMRData(String[] labelsIn, double[] shiftsIn)
    {
    if((labelsIn.length)!=(shiftsIn.length))
      {
      throw new RuntimeException("Number of labels does not equal number of shifts");
      }
    nShifts = shiftsIn.length;

    shifts=shiftsIn;
    labels=labelsIn;
    }
    

  //Constructor with label
  public NMRData(String[] labelsIn, double[] shiftsIn, String filenameIn)
    {
    if((labelsIn.length)!=(shiftsIn.length))
      {
      throw new RuntimeException("Number of labels does not equal number of shifts");
      }
    nShifts = shiftsIn.length;

    shifts=shiftsIn;
    labels=labelsIn;
    filename=filenameIn;
    }





  //sort into descending order
  public void sort()
    {
    nShifts = shifts.length;
    double[] shiftsTemp = new double[shifts.length];
    String[] labelsTemp = new String[shifts.length];
    double[] shiftsTemp2 = new double[shifts.length];
    String[] labelsTemp2 = new String[shifts.length];

    int i=0; int j=0; int biggest=0; double biggestValue=-1000000000;

    for(i=0;i<nShifts;i++)
      {
      shiftsTemp[i]=shifts[i];
      labelsTemp[i]=labels[i];
      }

    for(j=0;j<nShifts;j++)
      {
      biggestValue = -1000000000;
      for(i=0;i<nShifts;i++)
        {
        if((shiftsTemp[i]>biggestValue)&&(labelsTemp[i].compareTo("used")!=0))
          {
          biggest=i;
          biggestValue=shiftsTemp[i];
          }
        }
      labelsTemp2[j]=labelsTemp[biggest];
      shiftsTemp2[j]=shiftsTemp[biggest];
      labelsTemp[biggest]="used";
      }
        
      shifts=shiftsTemp2;
      labels=labelsTemp2;
    }


  //Change labels
  public void changeLabels(String[] s)
    {
    labels=s;
    }




  //Print
  public void print()
    {
    int i;
    for(i=0;i<nShifts;i++)
      {
      System.out.println(labels[i]+" "+shifts[i]);
      }
    }


}
