import java.io.*;
import java.util.*;
import java.math.*;


public class PairwiseData {
  public int nShifts;
  public String[] labels;
  public double[] shiftsa;
  public double[] shiftsb;
  public double[] shiftsA;
  public double[] shiftsB;
  public double[] scaleda;
  public double[] scaledb;
  public double slope;
  public double intercept;
  public String filea;
  public String fileb;
  public String fileA;
  public String fileB;


  //Constructor
  public PairwiseData(String[] labelsIn, double[] shiftsaIn, double[] shiftsbIn, double[] shiftsAIn, double[] shiftsBIn)
    {
    nShifts=labelsIn.length;
    //check all arrays are the same length
    if(((shiftsaIn.length)==nShifts)&&((shiftsbIn.length)==nShifts)&&((shiftsAIn.length)==nShifts)&&((shiftsBIn.length)==nShifts))
      {
      labels=labelsIn;
      shiftsa=shiftsaIn;
      shiftsb=shiftsbIn;
      shiftsA=shiftsAIn;
      shiftsB=shiftsBIn;
      }
    else
      {
      System.err.println("\n\n\n\nLengths of arrays not equal!\n\n\n\n");
      }
    }


  //Constructor with no labels
  public PairwiseData(double[] shiftsaIn, double[] shiftsbIn, double[] shiftsAIn, double[] shiftsBIn)
    {
    nShifts=shiftsaIn.length;
    //check all arrays are the same length
    if(((shiftsaIn.length)==nShifts)&&((shiftsbIn.length)==nShifts)&&((shiftsAIn.length)==nShifts)&&((shiftsBIn.length)==nShifts))
      {
      shiftsa=shiftsaIn;
      shiftsb=shiftsbIn;
      shiftsA=shiftsAIn;
      shiftsB=shiftsBIn;
      }
    else
      {
      System.out.println("\n\n\n\nLengths of arrays not equal!\n\n\n\n");
      }

      String[] l = new String[nShifts];
    for(int i=0;i<nShifts;i++)
      {
      l[i]=("X"+String.valueOf(i+1));
      }
      labels = l;
    }



  //Constructor with filenames
  public PairwiseData(String[] labelsIn, double[] shiftsaIn, double[] shiftsbIn, double[] shiftsAIn, double[] shiftsBIn, String[] filenames)
    {
    nShifts=labelsIn.length;
    //check all arrays are the same length
    if(((shiftsaIn.length)==nShifts)&&((shiftsbIn.length)==nShifts)&&((shiftsAIn.length)==nShifts)&&((shiftsBIn.length)==nShifts))
      {
      labels=labelsIn;
      shiftsa=shiftsaIn;
      shiftsb=shiftsbIn;
      shiftsA=shiftsAIn;
      shiftsB=shiftsBIn;
      filea=filenames[0];
      fileb=filenames[1];
      fileA=filenames[2];
      fileB=filenames[3];
      }
    else
      {
      System.err.println("\n\n\n\nLengths of arrays not equal!\n\n\n\n");
      }
    }







  //Constructor from two NMRData objects (calc) and two ExpData objects
  public PairwiseData(NMRData calca, NMRData calcb, ExpData expA, ExpData expB)
    {
    NMRData expA2 = NMR.convertExpToNMR(expA,calca);
    NMRData expB2 = NMR.convertExpToNMR(expB,calcb);
    PairwiseData pairwise = NMR.convertToPairwise(calca, calcb, expA2, expB2);
    nShifts=pairwise.nShifts;

    labels=pairwise.labels;
    shiftsa=pairwise.shiftsa;
    shiftsb=pairwise.shiftsb;
    shiftsA=pairwise.shiftsA;
    shiftsB=pairwise.shiftsB;
    }
  




  //Print
  public void print()
    {
    int i;
    System.out.println("labels,shiftsa,shiftsb,shiftsA,shiftsB");
    for(i=0;i<nShifts;i++)
      {
      System.out.println(labels[i]+","+shiftsa[i]+","+shiftsb[i]+","+shiftsA[i]+","+shiftsB[i]);
      }
    }



  //Calculate correl
  public double calculateCorrel()
    {
    double[] joinedCalc=NMR.join(shiftsa,shiftsb);
    double[] joinedExp=NMR.join(shiftsA,shiftsB);
    double correl = NMR.calculateCorrel(joinedCalc,joinedExp);
    return(correl);
    }  
    

  //Calculate MAE
  public double calculateMae()
    {
    double[] joinedCalc=NMR.join(shiftsa,shiftsb);
    double[] joinedExp=NMR.join(shiftsA,shiftsB);
    double mae=NMR.calculateMae(joinedCalc,joinedExp);
    return(mae);
    }


  //Calculate MAE'
  public double calculateMaePrime()
    {
    double[] joinedCalc=NMR.join(shiftsa,shiftsb);
    double[] joinedExp=NMR.join(shiftsA,shiftsB);
    double maePrime=NMR.calculateMaePrime(joinedCalc,joinedExp);
    return(maePrime);
    }


  //Calculate wMAE
  public double calculateWMae()
    {
    double[] weights = new double[nShifts];
    for(int i=0;i<nShifts;i++)
      {
      weights[i] = Math.abs(shiftsa[i]-shiftsb[i])/2;
      }
    double[] joinedCalc = NMR.join(shiftsa,shiftsb);
    double[] joinedExp = NMR.join(shiftsA,shiftsB);
    double[] joinedWeights = NMR.join(weights,weights);
    return(NMR.calculateWMae(joinedCalc,joinedExp,joinedWeights));
    }

  //Calculate wMaePrime
  public double calculateWMaePrime()
    {
    double[] weights = new double[nShifts];
    for(int i=0;i<nShifts;i++)
      {
      weights[i] = Math.abs(shiftsa[i]-shiftsb[i])/2;
      }
    double[] joinedCalc = NMR.join(shiftsa,shiftsb);
    double[] joinedExp = NMR.join(shiftsA,shiftsB);
    double[] joinedWeights = NMR.join(weights,weights);
    return(NMR.calculateWMaePrime(joinedCalc,joinedExp,joinedWeights));
    }


    

  //Calculate CPd
  public double calculateCpd()
    {
    int i=0; int j=0;
    double deltaExp=0;
    double deltaCalc=0;
    double num=0;
    double denom=0;

    for(i=0;i<nShifts;i++)
      {
      deltaExp = shiftsB[i]-shiftsA[i];
      deltaCalc = shiftsb[i]-shiftsa[i];
      denom = denom+deltaExp*deltaExp;
      num=num+deltaExp*deltaCalc;
      }

    return num/denom;
    }


  //Calculate CPe
  public double calculateCpe()
    {
    int i=0; int j=0;
    double deltaExp=0;
    double deltaCalc=0;
    double num=0;
    double denom=0;

    for(i=0;i<nShifts;i++)
      {
      deltaExp = shiftsB[i]-shiftsA[i];
      deltaCalc = shiftsb[i]-shiftsa[i];
      denom = denom+deltaExp*deltaExp;
      if((Math.abs(deltaCalc/deltaExp))>1)
        {
        num=num+deltaExp*deltaExp*deltaExp/deltaCalc;
        }
      else
        {
        num=num+deltaExp*deltaCalc;
        }
      }

    return num/denom;
    }


  //Calculate CPh
  public double calculateCph()
    {
    int i=0; int j=0;
    double deltaExp=0;
    double deltaCalc=0;
    double num=0;
    double denom=0;

    for(i=0;i<nShifts;i++)
      {
      deltaExp = shiftsB[i]-shiftsA[i];
      deltaCalc = shiftsb[i]-shiftsa[i];
      denom = denom+deltaExp*deltaExp;
      if((deltaCalc/deltaExp)>1)
        {
        num=num+deltaExp*deltaExp*deltaExp/deltaCalc;
        }
      else
        {
        num=num+deltaExp*deltaCalc;
        }
      }

    return num/denom;
    }






}
