import java.io.*;
import java.util.*;
import java.math.*;


public class Weights {
  public int nShifts;
  public String[] labels;
  public double[] weights;
  public double[][] calcShifts;
  public int[] frequency;
  public int nCalcStructs;

  //Constructor
  public Weights(NMRData[] nmrData)
     {
     construct(nmrData);
     }
  


  public void construct(NMRData[] nmrData)
     {
     int i=0; int j=0; int k=0; int l=0;
     int foundIt=0;
     nCalcStructs = nmrData.length;
     nShifts=0;
     for(i=0;i<nCalcStructs;i++)
       {
       j=j+nmrData[i].nShifts;
       }
     String[] labelsTemp = new String[j];
     double[][] shifts = new double[nCalcStructs][j];
     for(i=0;i<nCalcStructs;i++)  //Loop over the NMRData objects
       {
       for(j=0;j<nmrData[i].nShifts;j++)  //Loop over the shifts of each NMRData object
         {
         foundIt=0;
         for(k=0;k<l;k++) //Loop over the labels already in place
           {
           if(nmrData[i].labels[j].compareTo(labelsTemp[k])==0)
             {
             foundIt=1;
             break;
             }
           } //End loop over labels already in place
         if(foundIt==0)
           {
           labelsTemp[l]=nmrData[i].labels[j];
           l++;
           }
         } //End loop over shifts of each NMRData object
       } //End loop over the NMRData objects
     nShifts=l;

     String[] newLabels = new String[nShifts];
     double[][] newCalcShifts = new double[nShifts][nCalcStructs];
     int[] newFrequency = new int[nShifts];
     double[] newWeights = new double[nShifts];

     for(i=0;i<nShifts;i++)
       {
       newLabels[i]=labelsTemp[i];
       for(j=0;j<nCalcStructs;j++)
         {
         for(k=0;k<nmrData[j].nShifts;k++)
           {
           if(nmrData[j].labels[k].compareTo(newLabels[i])==0)
             {
             newCalcShifts[i][j]=nmrData[j].shifts[k];
             newFrequency[i]++;
             break;
             }
           }
         }
       newWeights[i] = NMR.stdevpNaN(newCalcShifts[i]);
       }

     labels=newLabels;
     calcShifts = newCalcShifts;
     frequency = newFrequency;
     weights = newWeights;
          
     }



  //Print
  public void print()
    {
    for(int i=0;i<nShifts;i++)
      {
      System.out.print(labels[i]+",");
      for(int j=0;j<nCalcStructs;j++)
        {
        System.out.print(calcShifts[i][j]+",");
        }
      System.out.print(frequency[i]+","+weights[i]+"\n");
      }
    }


}
