/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DP4
extends JApplet {
    JTextArea calcC;
    JTextArea calcH;
    JTextField expC;
    JTextField expH;
    JTextArea assignments;
    JTextArea results;
    JTextArea instructions;
    String s_calcC;
    String s_calcH;
    String s_expC;
    String s_expH;
    String s_assignments;
    String s_results;
    JPanel northPanel = new JPanel();
    JPanel centerPanel = new JPanel();
    JPanel southPanel = new JPanel();
    JPanel westPanel = new JPanel();
    JButton readButton;
    JButton showAssignmentsButton;
    JButton calculateButton;
    JButton clearButton;
    JButton helpButton;
    JLabel copyright;
    JLabel labelCalcC = new JLabel("13C Calc");
    JLabel labelCalcH = new JLabel("1H Calc");
    JLabel labelExpC = new JLabel("13C Expt");
    JLabel labelExpH = new JLabel("1H Expt");
    JComboBox databaseversion;
    CalcExpData[] calcExpDataC;
    CalcExpData[] calcExpDataH;
    double[] cdp4C;
    double[] cdp4H;
    double[] cdp4M;
    double[][] shiftsC;
    double[][] shiftsH;
    int nCalcStructs;
    int error;
    String[] errorMessage = new String[]{"", "Error reading calculated data"};
    CalcDataMult calcDataCMult;
    CalcDataMult calcDataHMult;
    ExpData expDataC;
    ExpData expDataH;
    String[] databaseFiles;
    int databaseIndex;
    double[] stdevCarray;
    double[] stdevHarray;
    double meanC = 0.0;
    double meanH = 0.0;
    double stdevC = 2.4059066666045137;
    double stdevH = 0.18824966196621246;
    double maximumErrorC = 10.0;
    double maximumErrorH = 2.0;
    DecimalFormat mdfp = new DecimalFormat("#0.0");
    DecimalFormat mdfp2 = new DecimalFormat("###0.00");
    int haveC;
    int haveH;
    Color myColor = new Color(200, 250, 200);
    Color yellow = new Color(250, 250, 0);
    Color red = new Color(250, 0, 0);
    Color resultsColor = new Color(250, 225, 225);
    String introInstructions = "Welcome to the DP4 applet!  \n\nEnter some calculated data for one or more isomers, and one set of experimental data.\nThen click Read Data, Show Assignments or Calculate.\n\nThe required input format for the calculated data is:\n C1,C2,C3,C4\n 202.2,45.7,13.6, 15.5\n 201.8,44.9,16.1,9.2\n\nThe required input format for the experimental data is:\n 200.5(C1), 45.5(C2), 14.8(C3 or C4), 16.4 (C3 or C4)\n\nH1,H2,H3\n1.1,1.2,4.0\n1.0,1.3,5.0\n\n1.1,1.2,4.0\n\nMore detailed instructions are available by following the links on the left.";

    public static void main(String[] stringArray) {
        System.out.println("Text version of DP4");
        System.out.println("A file with comma-separated text containing calculated and experimental data is needed");
        System.out.println(stringArray[0]);
        System.out.println();
        System.out.println("The required format for data is a text file in four parts:");
        System.out.println("(1) Carbon Calculation; (2) Carbon Experiment; (3) Hydrogen Calculation; (4) Hydrogen Experiment");
        System.out.println("The last two sections can be blank.");
        System.out.println("The sections are separated by a blank line.");
        System.out.println("For example:");
        System.out.println("====");
        System.out.println("C1,C2,C3,C4");
        System.out.println("202.2,45.7,13.6,15.5");
        System.out.println("201.8,44.9,16.2,9.2");
        System.out.println();
        System.out.println("200.5(C1), 45.5(C2), 14.8(C3 or C4), 16.4(C3 or C4)");
        System.out.println("====");
        DP4 dP4 = new DP4();
        dP4.textRun(stringArray[0]);
    }

    void textRun(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            this.s_calcC = "";
            String string2 = bufferedReader.readLine().trim();
            while (string2.length() > 0) {
                this.s_calcC = this.s_calcC + string2 + "\n";
                string2 = bufferedReader.readLine().trim();
            }
            this.s_expC = string2 = bufferedReader.readLine().trim();
            string2 = bufferedReader.readLine().trim();
            string2 = bufferedReader.readLine().trim();
            this.s_calcH = "";
            while (string2.length() > 0) {
                this.s_calcH = this.s_calcH + string2 + "\n";
                string2 = bufferedReader.readLine().trim();
            }
            string2 = bufferedReader.readLine().trim();
            this.s_expH = "";
            this.s_expH = this.s_expH + string2;
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("====");
        System.out.println(this.s_calcC);
        System.out.println(this.s_expC);
        System.out.println(this.s_calcH);
        System.out.println(this.s_expH);
        System.out.println("====");
        this.setUpData();
        this.read();
        System.out.println(this.s_results);
        this.showAssignments();
        System.out.println(this.s_results);
        this.calculate();
        System.out.println(this.s_results);
    }

    @Override
    public void init() {
        this.setUpData();
        this.calcC = new JTextArea();
        this.calcC.setEditable(true);
        this.calcH = new JTextArea();
        this.calcH.setEditable(true);
        this.expC = new JTextField();
        this.expC.setEditable(true);
        this.expH = new JTextField();
        this.expH.setEditable(true);
        this.assignments = new JTextArea();
        this.assignments.setEditable(true);
        this.results = new JTextArea();
        this.results.setEditable(false);
        this.instructions = new JTextArea();
        this.instructions.setEditable(false);
        this.instructions.setBackground(new Color(250, 225, 225));
        this.readButton = new JButton("Read Data");
        this.showAssignmentsButton = new JButton("Show Assignments");
        this.calculateButton = new JButton("Calculate");
        this.clearButton = new JButton("Clear");
        this.helpButton = new JButton("Help");
        this.databaseversion = new JComboBox<String>(this.databaseFiles);
        this.setBackground(this.myColor);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setBackground(new Color(250, 225, 225));
        this.add("North", panel);
        panel.add(this.instructions);
        this.instructions.setText("Please select version of database to use:");
        panel.setLayout(new FlowLayout(2));
        panel.add(this.databaseversion);
        this.databaseversion.setSelectedIndex(this.databaseIndex);
        Panel panel2 = new Panel();
        panel2.setBackground(this.myColor);
        this.add("Center", panel2);
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel2.add((Component)new JLabel("13C Calc:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel2.add((Component)new JLabel("1H Calc:"), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JScrollPane jScrollPane = new JScrollPane(this.calcC);
        jScrollPane.setPreferredSize(new Dimension(280, 250));
        panel2.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JScrollPane jScrollPane2 = new JScrollPane(this.calcH);
        jScrollPane2.setPreferredSize(new Dimension(280, 250));
        panel2.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel2.add((Component)new JLabel("13C Expt:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel2.add((Component)new JLabel("1H Expt:"), gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel2.add((Component)this.expC, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel2.add((Component)this.expH, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout());
        panel3.setBackground(this.myColor);
        panel3.add(this.readButton);
        panel3.add(this.showAssignmentsButton);
        panel3.add(this.calculateButton);
        panel3.add(this.clearButton);
        panel2.add((Component)panel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.results.setBackground(this.resultsColor);
        JScrollPane jScrollPane3 = new JScrollPane(this.results);
        jScrollPane3.setPreferredSize(new Dimension(562, 250));
        panel2.add((Component)jScrollPane3, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 2, 2, 2);
        this.results.setText(this.introInstructions);
        this.results.setCaretPosition(0);
        this.databaseversion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DP4.this.getDatabase();
            }
        });
        this.calculateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DP4.this.readApplet();
                DP4.this.results.setText(DP4.this.s_results);
                DP4.this.calculate();
                DP4.this.results.setText(DP4.this.s_results);
            }
        });
        this.readButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DP4.this.readApplet();
                DP4.this.results.setText(DP4.this.s_results);
            }
        });
        this.showAssignmentsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DP4.this.readApplet();
                DP4.this.results.setText(DP4.this.s_results);
                DP4.this.showAssignments();
                DP4.this.results.setText(DP4.this.s_results);
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DP4.this.clear();
            }
        });
        Panel panel4 = new Panel();
        panel4.setBackground(this.myColor);
        this.add("South", panel4);
        panel4.setLayout(new FlowLayout(2));
        panel4.add(new JLabel("<html><p><FONT COLOR=BLACK>(c) Jonathan M Goodman and Steven G Smith</FONT></p></html>"));
    }

    public void setUpData() {
        this.databaseFiles = new String[2];
        this.databaseFiles[0] = "DP4-original";
        this.databaseFiles[1] = "DP4-database2";
        this.databaseIndex = this.databaseFiles.length - 1;
        this.stdevCarray = new double[this.databaseFiles.length];
        this.stdevHarray = new double[this.databaseFiles.length];
        this.stdevCarray[0] = 2.4258349912535166;
        this.stdevHarray[0] = 0.18580595542083367;
        this.stdevCarray[1] = 2.4059066666045137;
        this.stdevHarray[1] = 0.18824966196621246;
        this.stdevC = this.stdevCarray[this.databaseFiles.length - 1];
        this.stdevH = this.stdevHarray[this.databaseFiles.length - 1];
        this.error = 0;
        this.haveC = 0;
        this.haveH = 0;
        String[] stringArray = new String[1];
        double[][] dArray = new double[1][1];
        stringArray[0] = "tst";
        dArray[0][0] = 0.0;
        this.calcDataCMult = new CalcDataMult(stringArray, dArray);
    }

    public void getDatabase() {
        this.databaseIndex = this.databaseversion.getSelectedIndex();
        this.stdevC = this.stdevCarray[this.databaseIndex];
        this.stdevH = this.stdevHarray[this.databaseIndex];
    }

    public void calculate() {
        if (this.error != 1) {
            this.s_results = "";
        }
        if (this.error != 1 && this.haveC == 1) {
            this.checkShifts(this.calcExpDataC, this.maximumErrorC, "carbon");
        }
        if (this.error != 1 && this.haveH == 1) {
            this.checkShifts(this.calcExpDataH, this.maximumErrorH, "proton");
        }
        if (this.error == 0) {
            this.s_results = "";
        } else if (this.error == 2) {
            this.s_results = this.s_results + " DP4 calculation has been attempted anyway, but you may wish to check the input data.\n To check the assignments, click Show Assignments.\n\n";
        }
        if (this.error != 1) {
            this.databaseIndex = 1;
        }
        this.s_results = this.s_results + "This calculation will use the " + this.databaseFiles[this.databaseIndex] + " version of the database.\n\n";
        if (this.error != 1 && this.haveC == 1 && this.haveH == 1) {
            try {
                this.s_results = this.s_results + "Results of DP4 using both carbon and proton data:\n";
                this.cdp4M = NMR.calculateCdp4(this.calcExpDataC, this.meanC, this.stdevC, this.calcExpDataH, this.meanH, this.stdevH);
                this.printResults(this.cdp4M);
            }
            catch (Exception exception) {
                if (this.error == 1) {
                    this.s_results = exception.getMessage();
                }
                this.error = 2;
                this.s_results = this.s_results + "Error calculating DP4 for the combined data:\n Please check the input and then click Read, Show Assignments or Calculate.\n\n";
                exception.printStackTrace();
            }
        }
        if (this.error != 1 && this.haveC == 1) {
            try {
                this.s_results = this.s_results + "Results of DP4 using the carbon data only:\n";
                this.cdp4C = NMR.calculateCdp4(this.calcExpDataC, this.meanC, this.stdevC);
                this.printResults(this.cdp4C);
            }
            catch (Exception exception) {
                if (this.error == 1) {
                    this.s_results = exception.getMessage();
                }
                this.error = 2;
                this.s_results = this.s_results + "Error calculating DP4 for the carbon data:\n Please check the input and then click Read, Show Assignments or Calculate.\n\n";
                exception.printStackTrace();
            }
        }
        if (this.error != 1 && this.haveH == 1) {
            try {
                this.s_results = this.s_results + "Results of DP4 using the proton data only:\n";
                this.cdp4H = NMR.calculateCdp4(this.calcExpDataH, this.meanH, this.stdevH);
                this.printResults(this.cdp4H);
            }
            catch (Exception exception) {
                if (this.error == 1) {
                    this.s_results = exception.getMessage();
                }
                this.error = 2;
                this.s_results = this.s_results + "Error calculating DP4 for the proton data:\n Please check the input and then click Calculate.\n\n";
                exception.printStackTrace();
            }
        }
    }

    public void readApplet() {
        this.calcC.setCaretPosition(0);
        this.calcH.setCaretPosition(0);
        this.expC.setCaretPosition(0);
        this.expH.setCaretPosition(0);
        this.s_calcC = this.calcC.getText();
        this.s_calcH = this.calcH.getText();
        this.s_expC = this.expC.getText();
        this.s_expH = this.expH.getText();
        this.read();
        this.results.setText(this.s_results);
    }

    public void read() {
        String string;
        this.error = 0;
        this.haveC = 0;
        this.haveH = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.s_results = "";
        try {
            if (this.s_calcC.length() > 0) {
                bl = true;
            }
            if (this.s_expC.length() > 0) {
                bl2 = true;
            }
            if (this.s_calcH.length() > 0) {
                bl3 = true;
            }
            if (this.s_expH.length() > 0) {
                bl4 = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl && bl2) {
            this.haveC = 1;
        }
        if (bl3 && bl4) {
            this.haveH = 1;
        }
        if (!bl && bl2) {
            this.error = 1;
            this.s_results = this.s_results + "You have entered some experimental 13C data but no calculated 13C data.\n Please either enter the calculated data or delete the experimental data,\n then click Read, Show Assignments or Calculate.\n\n";
        }
        if (!bl3 && bl4) {
            this.error = 1;
            this.s_results = this.s_results + "You have entered some experimental 1H data but no calculated 1H data.\n Please either enter the calculated data or delete the experimental data,\n then click Read, Show Assignments or Calculate.\n\n";
        }
        if (bl && !bl2) {
            this.error = 1;
            this.s_results = this.s_results + "You have entered some calculated 13C data but no experimental 13C data.\n Please either enter the calculated data or delete the experimental data,\n then click Read, Show Assignments or Calculate.\n\n";
        }
        if (bl3 && !bl4) {
            this.error = 1;
            this.s_results = this.s_results + "You have entered some calculated 1H data but no experimental 1H data.\n Please either enter the calculated data or delete the experimental data,\n then click Read, Show Assignments or Calculate.\n\n";
        }
        if (this.error == 0 && this.haveC == 0 && this.haveH == 0) {
            this.error = 1;
            this.s_results = this.s_results + "Please enter some calculated data\n\n";
        }
        if (this.haveC == 1 && this.error == 0) {
            try {
                string = this.s_calcC;
                this.calcDataCMult = this.getCalcShifts(string, "carbon");
            }
            catch (Exception exception) {
                if (this.error == 1) {
                    this.s_results = this.s_results + exception.getMessage();
                }
                this.s_results = this.s_results + "Error reading the calculated carbon data:\n Please check the input and then click Read Data, Show Assignments or Calculate.";
                exception.printStackTrace();
            }
        }
        if (this.haveH == 1 && this.error == 0) {
            try {
                string = this.s_calcH;
                this.calcDataHMult = this.getCalcShifts(string, "proton");
            }
            catch (Exception exception) {
                if (this.error == 1) {
                    this.s_results = this.s_results + exception.getMessage();
                }
                this.s_results = this.s_results + "Error reading the proton calculated data:\n Please check the input and then click Read Data, Show Assignments or Calculate.";
                exception.printStackTrace();
            }
        }
        if (this.error == 0 && this.haveC == 1) {
            try {
                string = this.s_expC;
                this.expDataC = this.getExpShifts(string, this.calcDataCMult, "carbon");
            }
            catch (Exception exception) {
                if (this.error == 1) {
                    this.s_results = this.s_results + exception.getMessage();
                    exception.printStackTrace();
                }
                this.s_results = this.s_results + "Error reading the carbon experimental data:\n Please check the input and then click Read Data, Show Assignments or Calculate.";
                exception.printStackTrace();
            }
        }
        if (this.error == 0 && this.haveH == 1) {
            try {
                string = this.s_expH;
                this.expDataH = this.getExpShifts(string, this.calcDataHMult, "proton");
            }
            catch (Exception exception) {
                if (this.error == 1) {
                    this.s_results = this.s_results + exception.getMessage();
                    exception.printStackTrace();
                }
                this.s_results = this.s_results + "Error reading the proton experimental data:\n Please check the input and then click Read Data, Show Assignments or Calculate.";
                exception.printStackTrace();
            }
        }
        if (this.error == 0 && this.haveC == 1) {
            try {
                this.calcExpDataC = this.getCalcExpData(this.calcDataCMult, this.expDataC, "carbon");
            }
            catch (Exception exception) {
                if (this.error == 1) {
                    this.s_results = this.s_results + exception.getMessage();
                    exception.printStackTrace();
                }
                this.s_results = this.s_results + "Error interpreting the carbon experimental data:\n Please check the input and then click Read Data, Show Assignments or Calculate.";
                exception.printStackTrace();
            }
        }
        if (this.error == 0 && this.haveH == 1) {
            try {
                this.calcExpDataH = this.getCalcExpData(this.calcDataHMult, this.expDataH, "proton");
            }
            catch (Exception exception) {
                if (this.error == 1) {
                    this.s_results = this.s_results + exception.getMessage();
                    exception.printStackTrace();
                }
                this.s_results = this.s_results + "Error interpreting the proton experimental data:\n Please check the input and then click Read Data, Show Assignments or Calculate.";
                exception.printStackTrace();
            }
        }
        if (this.error != 1 && this.haveC == 1) {
            this.checkShifts(this.calcExpDataC, this.maximumErrorC, "carbon");
        }
        if (this.error != 1 && this.haveH == 1) {
            this.checkShifts(this.calcExpDataH, this.maximumErrorH, "proton");
        }
        if (this.error == 0) {
            this.s_results = this.s_results + "Data read successfully.\nNow click Show Assignments or Calculate.";
        } else if (this.error == 2) {
            this.s_results = this.s_results + " To check the assignments, click Show Assignments.\n To attempt DP4 calculation anyway, click Calculate.";
        }
    }

    public void showAssignments() {
        if (this.error != 1) {
            this.s_results = "";
        }
        if (this.error != 1 && this.haveC == 1) {
            this.checkShifts(this.calcExpDataC, 15.0, "carbon");
        }
        if (this.error != 1 && this.haveH == 1) {
            this.checkShifts(this.calcExpDataH, 2.5, "proton");
        }
        if (this.error == 0) {
            this.s_results = "";
        } else if (this.error == 2) {
            this.s_results = this.s_results + "\n";
        }
        if (this.error != 1) {
            int n = 0;
            if (this.haveC == 1) {
                n = this.calcExpDataC.length;
            } else if (this.haveH == 1) {
                n = this.calcExpDataH.length;
            }
            for (int i = 0; i < n; ++i) {
                this.s_results = this.s_results + "Isomer " + (i + 1) + " (atom, calc, exp):\n";
                if (this.error != 1 && this.haveC == 1) {
                    this.printAssignments(this.calcExpDataC[i], 15.0);
                }
                if (this.error != 1 && this.haveH == 1) {
                    this.printAssignments(this.calcExpDataH[i], 2.5);
                }
                this.s_results = this.s_results + "\n";
            }
        }
    }

    public void clear() {
        this.results.setText(this.introInstructions);
        this.results.setCaretPosition(0);
        this.calcC.setText("");
        this.calcH.setText("");
        this.expC.setText("");
        this.expH.setText("");
        this.error = 0;
        this.haveC = 0;
        this.haveH = 0;
    }

    public CalcDataMult getCalcShiftsT(String string) {
        Object object;
        int n;
        this.s_results = "";
        String[] stringArray = NMR.getLines2(string);
        String string2 = stringArray[(n = stringArray.length) - 1];
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,\t", false);
        if (stringTokenizer.countTokens() == 0) {
            --n;
        }
        int n2 = 0;
        StringTokenizer stringTokenizer2 = new StringTokenizer(stringArray[0], ", \t", false);
        n2 = stringTokenizer2.countTokens() - 1;
        for (int i = 1; i < n; ++i) {
            object = new StringTokenizer(stringArray[i], ", \t", false);
            if (((StringTokenizer)object).countTokens() - 1 == n2) continue;
            this.error = 1;
            this.s_results = "Error reading calculated shifts:  Please check the line for " + ((StringTokenizer)object).nextToken() + ".\nCorrect as necessary and then click on Read Data, Show Assignments or Calculate.";
            break;
        }
        double[][] dArray = new double[n2][n];
        object = new String[n];
        if (this.error == 0) {
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer3 = new StringTokenizer(stringArray[i], ", \t", false);
                object[i] = stringTokenizer3.nextToken();
                for (int j = 0; j < n2; ++j) {
                    String string3 = stringTokenizer3.nextToken();
                    dArray[j][i] = Double.valueOf(string3);
                }
            }
        }
        return new CalcDataMult((String[])object, dArray);
    }

    public CalcDataMult getCalcShifts(String string, String string2) {
        int n;
        Object object;
        this.s_results = "";
        String[] stringArray = NMR.getLines2(string);
        int n2 = stringArray.length - 1;
        String string3 = stringArray[stringArray.length - 1];
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " ,\t", false);
        if (stringTokenizer.countTokens() == 0) {
            --n2;
        }
        int n3 = 0;
        StringTokenizer stringTokenizer2 = new StringTokenizer(stringArray[0], ", \t", false);
        n3 = stringTokenizer2.countTokens();
        for (int i = 1; i < stringArray.length; ++i) {
            object = new StringTokenizer(stringArray[i], ", \t", false);
            int n4 = ((StringTokenizer)object).countTokens();
            if (n4 == n3) continue;
            this.error = 1;
            throw new RuntimeException("Error reading calculated shifts: \n The number of " + string2 + " shifts for isomer " + Integer.toString(i) + " (" + Integer.toString(n4) + ") does not equal the number of labels (" + Integer.toString(n3) + ").\n Please correct and then click Read Data, Show Assignments or Calculate.");
        }
        String[] stringArray2 = new String[n3];
        object = new double[n2][n3];
        StringTokenizer stringTokenizer3 = new StringTokenizer(stringArray[0], ", \t", false);
        for (n = 0; n < n3; ++n) {
            stringArray2[n] = stringTokenizer3.nextToken();
        }
        for (n = 0; n < n2; ++n) {
            StringTokenizer stringTokenizer4 = new StringTokenizer(stringArray[n + 1], ", \t", false);
            for (int i = 0; i < n3; ++i) {
                String string4 = stringTokenizer4.nextToken();
                try {
                    double d = Double.valueOf(string4);
                }
                catch (Exception exception) {
                    this.error = 1;
                    throw new RuntimeException("Error reading calculated shifts: \n Cannot interpret the shift for atom " + stringArray2[i] + " in isomer " + (n + 1) + ": " + string4 + ".\n Please correct and then click Read Data, Show Assignments or Calculate.");
                }
                object[n][i] = Double.valueOf(string4);
            }
        }
        return new CalcDataMult(stringArray2, (double[][])object);
    }

    public ExpData getExpShifts(String string, CalcDataMult calcDataMult, String string2) {
        int n;
        char c;
        int n2;
        CharSequence charSequence;
        int n3;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            n3 = string.charAt(i);
            if (n3 == 40) {
                ++n4;
            }
            if (n4 == 0) {
                stringBuffer.append((char)n3);
            }
            if (n3 != 41) continue;
            --n4;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), " \t,");
        n3 = stringTokenizer.countTokens();
        if (n3 > calcDataMult.nShifts) {
            this.error = 1;
            throw new RuntimeException("The number of experimental " + string2 + " shifts (" + Integer.toString(n3) + ")\n exceeds the number of calculated " + string2 + " shifts (" + Integer.toString(calcDataMult.nShifts) + ").\n Please amend and then click Read, Assign Resonances or Calculate.");
        }
        double[] dArray = new double[n3];
        for (int i = 0; i < n3; ++i) {
            charSequence = stringTokenizer.nextToken();
            try {
                dArray[i] = Double.valueOf((String)charSequence);
                continue;
            }
            catch (Exception exception) {
                this.error = 1;
                throw new RuntimeException("Error interpreting " + string2 + " experimental shift: " + (String)charSequence + ".\n Please check the input data and then click Read, Show Assignments or Calculate.");
            }
        }
        String[][] stringArrayArray = new String[n3][];
        charSequence = new StringBuffer();
        int n5 = 0;
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                ((StringBuffer)charSequence).append(Double.toString(dArray[n2]) + " ");
                StringBuffer stringBuffer2 = new StringBuffer();
                c = ' ';
                n = 0;
                while (n == 0) {
                    c = string.charAt(n5);
                    ++n5;
                    if (c == ')') {
                        --n4;
                    }
                    if (n4 > 0) {
                        stringBuffer2.append(c);
                    }
                    if (c == '(') {
                        ++n4;
                    }
                    if ((c != ',' || n4 != 0) && n5 != string.length() - 1) continue;
                    n = 1;
                }
                stringArrayArray[n2] = this.getLabels(stringBuffer2.toString(), calcDataMult, string2);
                for (int i = 0; i < stringArrayArray[n2].length; ++i) {
                    ((StringBuffer)charSequence).append(stringArrayArray[n2][i] + " ");
                }
                ((StringBuffer)charSequence).append("\n");
            }
        }
        catch (Exception exception) {
            this.error = 1;
            throw new RuntimeException("Error reading the " + string2 + " experimental data:\n" + charSequence + "\n Please check the input, then click Read, Show Assignments or Calculate.");
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 0; i < stringArrayArray[n2].length; ++i) {
                c = '\u0000';
                for (n = 0; n < calcDataMult.labels.length; ++n) {
                    if (stringArrayArray[n2][i].compareTo(calcDataMult.labels[n]) != 0) continue;
                    c = '\u0001';
                    break;
                }
                if (c != '\u0000') continue;
                this.error = 1;
                throw new RuntimeException("Could not interpret the assignment label " + stringArrayArray[n2][i] + " in the " + string2 + " experimental data:\n it does not appear to correspond to any of the calculated shift labels.");
            }
        }
        String[][] stringArray = new String[n3][n3];
        for (int i = 0; i < n3; ++i) {
            n5 = 0;
            for (n5 = 0; n5 < stringArrayArray[i].length; ++n5) {
                stringArray[i][n5] = stringArrayArray[i][n5];
            }
            while (n5 < n3) {
                stringArray[i][n5] = "STR";
                ++n5;
            }
        }
        ExpData expData = new ExpData(dArray, stringArray);
        return expData;
    }

    public String[] getLabels(String string, CalcDataMult calcDataMult, String string2) {
        String[] stringArray;
        if (string.length() == 0 || string.indexOf("any") != -1) {
            stringArray = calcDataMult.labels;
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (stringBuffer.indexOf("or") != -1) {
                stringBuffer.insert(stringBuffer.indexOf("or"), ",");
                stringBuffer.delete(stringBuffer.indexOf("or"), stringBuffer.indexOf("or") + 2);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\t ,", false);
            stringArray = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
        }
        return stringArray;
    }

    public CalcExpData[] getCalcExpData(CalcDataMult calcDataMult, ExpData expData, String string) {
        int n = calcDataMult.nIsomers;
        CalcExpData[] calcExpDataArray = new CalcExpData[n];
        for (int i = 0; i < n; ++i) {
            try {
                NMRData nMRData = new NMRData(calcDataMult.labels, calcDataMult.shifts[i]);
                NMRData nMRData2 = NMR.convertExpToNMR(expData, nMRData);
                calcExpDataArray[i] = new CalcExpData(nMRData, nMRData2);
                continue;
            }
            catch (Exception exception) {
                this.error = 1;
                exception.printStackTrace();
                throw new RuntimeException("Error assigning the " + string + " experimental data.\n Please check that the assignments you have entered are correct and unambiguous.\n (See the Instructions for more information).");
            }
        }
        return calcExpDataArray;
    }

    public void printResults(double[] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            this.s_results = this.s_results + "  Isomer " + (i + 1) + ": " + this.mdfp.format(dArray[i]) + "%\n";
        }
        this.s_results = this.s_results + "\n";
    }

    public void checkShifts(CalcExpData[] calcExpDataArray, double d, String string) {
        int n = calcExpDataArray.length;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d3 = calcExpDataArray[i].calculateMaxError();
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        if (d2 > d) {
            this.error = 2;
            this.s_results = this.s_results + "WARNING: One or more of the " + string + " shifts have large errors (largest error " + this.mdfp.format(d2) + " ppm).\n";
        }
    }

    public void printAssignments(CalcExpData calcExpData, double d) {
        int n;
        int n2 = calcExpData.nShifts;
        String[] stringArray = new String[n2];
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = calcExpData.labels[n];
            dArray[n] = calcExpData.calcShifts[n];
            dArray2[n] = calcExpData.expShifts[n];
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 1; i < n2; ++i) {
                if (stringArray[i].compareTo(stringArray[i - 1]) >= 0) continue;
                String string = stringArray[i - 1];
                double d2 = dArray[i - 1];
                double d3 = dArray2[i - 1];
                stringArray[i - 1] = stringArray[i];
                dArray[i - 1] = dArray[i];
                dArray2[i - 1] = dArray2[i];
                stringArray[i] = string;
                dArray[i] = d2;
                dArray2[i] = d3;
            }
        }
        for (n = 0; n < n2; ++n) {
            this.s_results = this.s_results + "   " + stringArray[n] + "   ";
            this.s_results = this.s_results + Double.toString(dArray[n]) + "   ";
            this.s_results = this.s_results + Double.toString(dArray2[n]);
            if (Math.abs(dArray2[n] - dArray[n]) > d) {
                this.s_results = this.s_results + "   Warning: Error = " + this.mdfp.format(Math.abs(dArray2[n] - dArray[n])) + " ppm";
            }
            this.s_results = this.s_results + "\n";
        }
    }

    public int getMaxLabelLength(CalcExpData calcExpData) {
        int n = 0;
        for (int i = 0; i < calcExpData.nShifts; ++i) {
            if (calcExpData.labels[i].length() <= n) continue;
            n = calcExpData.labels[i].length();
        }
        return n;
    }
}

