/*
 * Decompiled with CFR 0.152.
 */
public class MultiData {
    public int nShifts;
    public String[] labels;
    public double[] calcShifts;
    public double[] expShifts;
    public String[] calcfiles;
    public String[] expfiles;
    public double[] calcAverages;
    public double[] expAverages;
    public double[] calcStdevps;
    public int[] frequency;
    public int nFiles;

    public MultiData(String[] stringArray, double[] dArray, double[] dArray2, String[] stringArray2, String[] stringArray3) {
    }

    public MultiData(CalcExpData[] calcExpDataArray) {
        this.construct(calcExpDataArray);
    }

    public MultiData(String string, String string2, double d) {
        CalcExpData[] calcExpDataArray = new CalcExpData[]{new CalcExpData(string, string2, d)};
        this.construct(calcExpDataArray);
    }

    public void construct(CalcExpData[] calcExpDataArray) {
        int n;
        int n2 = 0;
        this.nFiles = calcExpDataArray.length;
        this.nShifts = 0;
        for (n = 0; n < this.nFiles; ++n) {
            this.nShifts += calcExpDataArray[n].nShifts;
        }
        String[] stringArray = new String[this.nShifts];
        double[] dArray = new double[this.nShifts];
        double[] dArray2 = new double[this.nShifts];
        String[] stringArray2 = new String[this.nShifts];
        String[] stringArray3 = new String[this.nShifts];
        double[] dArray3 = new double[this.nShifts];
        double[] dArray4 = new double[this.nShifts];
        int[] nArray = new int[this.nShifts];
        double[] dArray5 = new double[this.nShifts];
        for (n = 0; n < this.nFiles; ++n) {
            for (int i = 0; i < calcExpDataArray[n].nShifts; ++i) {
                stringArray[n2] = calcExpDataArray[n].labels[i];
                dArray[n2] = calcExpDataArray[n].calcShifts[i];
                dArray2[n2] = calcExpDataArray[n].expShifts[i];
                stringArray2[n2] = calcExpDataArray[n].calcfile;
                stringArray3[n2] = calcExpDataArray[n].expfile;
                ++n2;
            }
        }
        this.labels = stringArray;
        this.calcShifts = dArray;
        this.expShifts = dArray2;
        this.calcfiles = stringArray2;
        this.expfiles = stringArray3;
        this.calcAverages = dArray3;
        this.expAverages = dArray4;
        this.frequency = nArray;
        this.calcStdevps = dArray5;
        this.fillAverages();
        this.fillStdevps();
        this.adjustStdevps();
    }

    public void fillAverages() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        for (n = 0; n < this.nShifts; ++n) {
            this.calcAverages[n] = 0.0;
            this.expAverages[n] = 0.0;
            this.frequency[n] = 0;
            for (n2 = 0; n2 < this.nShifts; ++n2) {
                if (this.labels[n].compareTo(this.labels[n2]) != 0) continue;
                this.calcAverages[n] = this.calcAverages[n] + this.calcShifts[n2];
                this.expAverages[n] = this.expAverages[n] + this.expShifts[n2];
                int n3 = n;
                this.frequency[n3] = this.frequency[n3] + 1;
            }
            this.calcAverages[n] = this.calcAverages[n] / (double)this.frequency[n];
            this.expAverages[n] = this.expAverages[n] / (double)this.frequency[n];
        }
    }

    public void fillStdevps() {
        this.fillAverages();
        for (int i = 0; i < this.nShifts; ++i) {
            this.calcStdevps[i] = 0.0;
            for (int j = 0; j < this.nShifts; ++j) {
                if (this.labels[i].compareTo(this.labels[j]) != 0) continue;
                this.calcStdevps[i] = this.calcStdevps[i] + (this.calcShifts[j] - this.calcAverages[i]) * (this.calcShifts[j] - this.calcAverages[i]);
            }
            this.calcStdevps[i] = Math.sqrt(this.calcStdevps[i] / (double)this.frequency[i]);
        }
    }

    public void adjustStdevps() {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < this.nShifts; ++n) {
            if (this.frequency[n] == 1) continue;
            d += this.calcStdevps[n] / (double)this.frequency[n];
            d2 += 1.0 / (double)this.frequency[n];
        }
        d /= d2;
        for (n = 0; n < this.nShifts; ++n) {
            if (this.frequency[n] != 1) continue;
            this.calcStdevps[n] = d;
        }
    }

    public void filter() {
        int n = 0;
        int n2 = 0;
        this.fillAverages();
        String[] stringArray = new String[this.nShifts];
        double[] dArray = new double[this.nShifts];
        double[] dArray2 = new double[this.nShifts];
        String[] stringArray2 = new String[this.nShifts];
        String[] stringArray3 = new String[this.nShifts];
        double[] dArray3 = new double[this.nShifts];
        double[] dArray4 = new double[this.nShifts];
        int[] nArray = new int[this.nShifts];
        for (n = 0; n < this.nShifts; ++n) {
            if (this.frequency[n] != this.nFiles) continue;
            stringArray[n2] = this.labels[n];
            dArray[n2] = this.calcShifts[n];
            dArray2[n2] = this.expShifts[n];
            stringArray2[n2] = this.calcfiles[n];
            stringArray3[n2] = this.expfiles[n];
            dArray3[n2] = this.calcAverages[n];
            dArray4[n2] = this.expAverages[n];
            nArray[n2] = this.frequency[n];
            ++n2;
        }
        this.nShifts = n2;
        String[] stringArray4 = new String[this.nShifts];
        double[] dArray5 = new double[this.nShifts];
        double[] dArray6 = new double[this.nShifts];
        String[] stringArray5 = new String[this.nShifts];
        String[] stringArray6 = new String[this.nShifts];
        double[] dArray7 = new double[this.nShifts];
        double[] dArray8 = new double[this.nShifts];
        int[] nArray2 = new int[this.nShifts];
        for (n = 0; n < this.nShifts; ++n) {
            stringArray4[n] = stringArray[n];
            dArray5[n] = dArray[n];
            dArray6[n] = dArray2[n];
            stringArray5[n] = stringArray2[n];
            stringArray6[n] = stringArray3[n];
            dArray7[n] = dArray3[n];
            dArray8[n] = dArray4[n];
            nArray2[n] = nArray[n];
        }
        this.labels = stringArray4;
        this.calcShifts = dArray5;
        this.expShifts = dArray6;
        this.calcfiles = stringArray5;
        this.expfiles = stringArray6;
        this.calcAverages = dArray7;
        this.expAverages = dArray8;
        this.frequency = nArray2;
    }

    public double calculateCorrel() {
        double d = 0.0;
        d = this.nShifts != 0 ? NMR.calculateCorrel(this.calcShifts, this.expShifts) : Double.POSITIVE_INFINITY;
        return d;
    }

    public double calculateMae() {
        double d = 0.0;
        d = this.nShifts != 0 ? NMR.calculateMae(this.calcShifts, this.expShifts) : Double.POSITIVE_INFINITY;
        return d;
    }

    public double calculateMaePrime() {
        double d = 0.0;
        d = this.nShifts != 0 ? NMR.calculateMaePrime(this.calcShifts, this.expShifts) : Double.POSITIVE_INFINITY;
        return d;
    }

    public double calculateWMae() {
        if (this.nShifts != 0) {
            return NMR.calculateWMae(this.calcShifts, this.expShifts, this.calcStdevps);
        }
        return Double.POSITIVE_INFINITY;
    }

    public double calculateWMaePrime() {
        if (this.nShifts != 0) {
            return NMR.calculateWMaePrime(this.calcShifts, this.expShifts, this.calcStdevps);
        }
        return Double.POSITIVE_INFINITY;
    }

    public double calculateCpd() {
        double d = 0.0;
        d = this.nShifts != 0 ? NMR.calculateCpd(this.calcShifts, this.expShifts, this.calcAverages, this.expAverages) : Double.POSITIVE_INFINITY;
        return d;
    }

    public double calculateCpe() {
        double d = 0.0;
        d = this.nShifts != 0 ? NMR.calculateCpe(this.calcShifts, this.expShifts, this.calcAverages, this.expAverages) : Double.POSITIVE_INFINITY;
        return d;
    }

    public double calculateCph() {
        double d = 0.0;
        d = this.nShifts != 0 ? NMR.calculateCph(this.calcShifts, this.expShifts, this.calcAverages, this.expAverages) : Double.POSITIVE_INFINITY;
        return d;
    }

    public double calculateSlope() {
        return NMR.calculateSlope(this.calcShifts, this.expShifts);
    }

    public double calculateIntercept() {
        return NMR.calculateIntercept(this.calcShifts, this.expShifts);
    }

    public double[] getModDd() {
        double[] dArray = new double[this.nShifts];
        for (int i = 0; i < this.nShifts; ++i) {
            dArray[i] = Math.abs(this.calcShifts[i] - this.expShifts[i]);
        }
        return dArray;
    }

    public double[] getModDdPrime() {
        double[] dArray = new double[this.nShifts];
        double d = this.calculateSlope();
        double d2 = this.calculateIntercept();
        for (int i = 0; i < this.nShifts; ++i) {
            dArray[i] = Math.abs((this.calcShifts[i] - d2) / d - this.expShifts[i]);
        }
        return dArray;
    }

    public double[] getdscaled() {
        double[] dArray = new double[this.nShifts];
        double d = this.calculateSlope();
        double d2 = this.calculateIntercept();
        for (int i = 0; i < this.nShifts; ++i) {
            dArray[i] = (this.calcShifts[i] - d2) / d;
        }
        return dArray;
    }

    public void print() {
        System.out.println("calcfile,expfile,label,calcShift,expShift,calcAverage,expAverage,frequency");
        for (int i = 0; i < this.nShifts; ++i) {
            System.out.print(NMR.fileTrim(this.calcfiles[i]) + ",");
            System.out.print(NMR.fileTrim(this.expfiles[i]) + ",");
            System.out.print(this.labels[i] + ",");
            System.out.print(this.calcShifts[i] + ",");
            System.out.print(this.expShifts[i] + ",");
            System.out.print(this.calcAverages[i] + ",");
            System.out.print(this.expAverages[i] + ",");
            System.out.print(this.frequency[i] + ",");
            System.out.print(this.calcStdevps[i] + ",");
            System.out.print("\n");
        }
    }
}

