/*
 * Decompiled with CFR 0.152.
 */
public class PairwiseData {
    public int nShifts;
    public String[] labels;
    public double[] shiftsa;
    public double[] shiftsb;
    public double[] shiftsA;
    public double[] shiftsB;
    public double[] scaleda;
    public double[] scaledb;
    public double slope;
    public double intercept;
    public String filea;
    public String fileb;
    public String fileA;
    public String fileB;

    public PairwiseData(String[] stringArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.nShifts = stringArray.length;
        if (dArray.length == this.nShifts && dArray2.length == this.nShifts && dArray3.length == this.nShifts && dArray4.length == this.nShifts) {
            this.labels = stringArray;
            this.shiftsa = dArray;
            this.shiftsb = dArray2;
            this.shiftsA = dArray3;
            this.shiftsB = dArray4;
        } else {
            System.err.println("\n\n\n\nLengths of arrays not equal!\n\n\n\n");
        }
    }

    public PairwiseData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.nShifts = dArray.length;
        if (dArray.length == this.nShifts && dArray2.length == this.nShifts && dArray3.length == this.nShifts && dArray4.length == this.nShifts) {
            this.shiftsa = dArray;
            this.shiftsb = dArray2;
            this.shiftsA = dArray3;
            this.shiftsB = dArray4;
        } else {
            System.out.println("\n\n\n\nLengths of arrays not equal!\n\n\n\n");
        }
        String[] stringArray = new String[this.nShifts];
        for (int i = 0; i < this.nShifts; ++i) {
            stringArray[i] = "X" + String.valueOf(i + 1);
        }
        this.labels = stringArray;
    }

    public PairwiseData(String[] stringArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, String[] stringArray2) {
        this.nShifts = stringArray.length;
        if (dArray.length == this.nShifts && dArray2.length == this.nShifts && dArray3.length == this.nShifts && dArray4.length == this.nShifts) {
            this.labels = stringArray;
            this.shiftsa = dArray;
            this.shiftsb = dArray2;
            this.shiftsA = dArray3;
            this.shiftsB = dArray4;
            this.filea = stringArray2[0];
            this.fileb = stringArray2[1];
            this.fileA = stringArray2[2];
            this.fileB = stringArray2[3];
        } else {
            System.err.println("\n\n\n\nLengths of arrays not equal!\n\n\n\n");
        }
    }

    public PairwiseData(NMRData nMRData, NMRData nMRData2, ExpData expData, ExpData expData2) {
        NMRData nMRData3 = NMR.convertExpToNMR(expData, nMRData);
        NMRData nMRData4 = NMR.convertExpToNMR(expData2, nMRData2);
        PairwiseData pairwiseData = NMR.convertToPairwise(nMRData, nMRData2, nMRData3, nMRData4);
        this.nShifts = pairwiseData.nShifts;
        this.labels = pairwiseData.labels;
        this.shiftsa = pairwiseData.shiftsa;
        this.shiftsb = pairwiseData.shiftsb;
        this.shiftsA = pairwiseData.shiftsA;
        this.shiftsB = pairwiseData.shiftsB;
    }

    public void print() {
        System.out.println("labels,shiftsa,shiftsb,shiftsA,shiftsB");
        for (int i = 0; i < this.nShifts; ++i) {
            System.out.println(this.labels[i] + "," + this.shiftsa[i] + "," + this.shiftsb[i] + "," + this.shiftsA[i] + "," + this.shiftsB[i]);
        }
    }

    public double calculateCorrel() {
        double[] dArray = NMR.join(this.shiftsa, this.shiftsb);
        double[] dArray2 = NMR.join(this.shiftsA, this.shiftsB);
        double d = NMR.calculateCorrel(dArray, dArray2);
        return d;
    }

    public double calculateMae() {
        double[] dArray = NMR.join(this.shiftsa, this.shiftsb);
        double[] dArray2 = NMR.join(this.shiftsA, this.shiftsB);
        double d = NMR.calculateMae(dArray, dArray2);
        return d;
    }

    public double calculateMaePrime() {
        double[] dArray = NMR.join(this.shiftsa, this.shiftsb);
        double[] dArray2 = NMR.join(this.shiftsA, this.shiftsB);
        double d = NMR.calculateMaePrime(dArray, dArray2);
        return d;
    }

    public double calculateWMae() {
        double[] dArray = new double[this.nShifts];
        for (int i = 0; i < this.nShifts; ++i) {
            dArray[i] = Math.abs(this.shiftsa[i] - this.shiftsb[i]) / 2.0;
        }
        double[] dArray2 = NMR.join(this.shiftsa, this.shiftsb);
        double[] dArray3 = NMR.join(this.shiftsA, this.shiftsB);
        double[] dArray4 = NMR.join(dArray, dArray);
        return NMR.calculateWMae(dArray2, dArray3, dArray4);
    }

    public double calculateWMaePrime() {
        double[] dArray = new double[this.nShifts];
        for (int i = 0; i < this.nShifts; ++i) {
            dArray[i] = Math.abs(this.shiftsa[i] - this.shiftsb[i]) / 2.0;
        }
        double[] dArray2 = NMR.join(this.shiftsa, this.shiftsb);
        double[] dArray3 = NMR.join(this.shiftsA, this.shiftsB);
        double[] dArray4 = NMR.join(dArray, dArray);
        return NMR.calculateWMaePrime(dArray2, dArray3, dArray4);
    }

    public double calculateCpd() {
        int n = 0;
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < this.nShifts; ++n) {
            d = this.shiftsB[n] - this.shiftsA[n];
            d2 = this.shiftsb[n] - this.shiftsa[n];
            d4 += d * d;
            d3 += d * d2;
        }
        return d3 / d4;
    }

    public double calculateCpe() {
        int n = 0;
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < this.nShifts; ++n) {
            d = this.shiftsB[n] - this.shiftsA[n];
            d2 = this.shiftsb[n] - this.shiftsa[n];
            d4 += d * d;
            if (Math.abs(d2 / d) > 1.0) {
                d3 += d * d * d / d2;
                continue;
            }
            d3 += d * d2;
        }
        return d3 / d4;
    }

    public double calculateCph() {
        int n = 0;
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < this.nShifts; ++n) {
            d = this.shiftsB[n] - this.shiftsA[n];
            d2 = this.shiftsb[n] - this.shiftsa[n];
            d4 += d * d;
            if (d2 / d > 1.0) {
                d3 += d * d * d / d2;
                continue;
            }
            d3 += d * d2;
        }
        return d3 / d4;
    }
}

