/*
 * Decompiled with CFR 0.152.
 */
public class ProbMath {
    public static double normalCdf(double d) {
        boolean bl;
        double d2;
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray = new double[]{242.66795523053176, 21.979261618294153, 6.996383488619135, -0.035609843701815386};
        double[] dArray2 = new double[]{215.0588758698612, 91.1649054045149, 15.082797630407788, 1.0};
        double[] dArray3 = new double[]{300.4592610201616, 451.9189537118729, 339.3208167343437, 152.9892850469404, 43.162227222056735, 7.2117582508830935, 0.564195517478974, -1.368648573827167E-7};
        double[] dArray4 = new double[]{300.4592609569833, 790.9509253278981, 931.3540948506096, 638.9802644656312, 277.58544474398764, 77.00015293522948, 12.782727319629423, 1.0};
        double[] dArray5 = new double[]{-0.002996107077035422, -0.04947309106232507, -0.22695659353968692, -0.2786613086096478, -0.02231924597341847};
        double[] dArray6 = new double[]{0.010620923052846792, 0.19130892610782985, 1.051675107067932, 1.9873320181713525, 1.0};
        double d5 = 0.5641895835477563;
        double d6 = 1.4142135623730951;
        if (Math.abs(d) < 1.0E-30) {
            d2 = 0.5;
        } else if (d < -38.0) {
            d2 = 0.0;
        } else if (d < -15.0) {
            d2 = Math.exp(ProbMath.dlanor(d));
        } else if (d > 6.0) {
            d2 = 1.0;
        }
        double d7 = Math.abs(d / d6);
        double d8 = d7 * d7;
        double d9 = 1.0 / d8;
        if (d7 < 0.5) {
            d3 = d7 * ProbMath.devlpl(dArray, 4, d8) / ProbMath.devlpl(dArray2, 4, d8);
            bl = true;
        } else if (d7 < 4.0) {
            d4 = Math.exp(-d8) * ProbMath.devlpl(dArray3, 8, d7) / ProbMath.devlpl(dArray4, 8, d7);
            bl = false;
        } else {
            d4 = Math.exp(-d8) / d7 * (d5 + d9 * ProbMath.devlpl(dArray5, 5, d9) / ProbMath.devlpl(dArray6, 5, d9));
            bl = false;
        }
        if (d >= 0.0) {
            if (!bl) {
                d3 = 1.0 - d4;
            }
            d2 = (1.0 + d3) / 2.0;
        } else {
            if (bl) {
                d4 = 1.0 - d3;
            }
            d2 = d4 / 2.0;
        }
        return d2;
    }

    static double devlpl(double[] dArray, int n, double d) {
        double d2 = dArray[n - 1];
        for (int i = n - 2; i >= 0; --i) {
            d2 = dArray[i] + d2 * d;
        }
        return d2;
    }

    static double dlanor(double d) {
        double d2 = 0.9189385332046728;
        double[] dArray = new double[]{-1.0, 3.0, -15.0, 105.0, -945.0, 10395.0, -135135.0, 2027025.0, -3.4459425E7, 6.54729075E8, -1.3749310575E10, 3.16234143225E11};
        double d3 = Math.abs(d);
        double d4 = -d2 - 0.5 * d3 * d3 - Math.log(d3);
        double d5 = d3 * d3;
        double d6 = ProbMath.devlpl(dArray, 12, 1.0 / d5) / d5;
        d6 = ProbMath.dln1px(d6);
        double d7 = d4 + d6;
        return d7;
    }

    static double dln1px(double d) {
        double d2 = -1.29418923021993;
        double d3 = 0.405303492862024;
        double d4 = -0.0178874546012214;
        double d5 = -1.62752256355323;
        double d6 = 0.747811014037616;
        double d7 = -0.0845104217945565;
        if (Math.abs(d) <= 0.375) {
            double d8 = d / (d + 2.0);
            double d9 = d8 * d8;
            double d10 = (((d4 * d9 + d3) * d9 + d2) * d9 + 1.0) / (((d7 * d9 + d6) * d9 + d5) * d9 + 1.0);
            double d11 = 2.0 * d8 * d10;
            return d11;
        }
        double d12 = 1.0 + d;
        return Math.log(d12);
    }

    public static double inverseNormal(double d) {
        double d2;
        double d3 = 1.0;
        double[] dArray = new double[]{-0.322232431088, -1.0, -0.342242088547, -0.0204231210245, -4.53642210148E-5};
        double[] dArray2 = new double[]{0.099348462606, 0.588581570495, 0.531103462366, 0.10353775285, 0.0038560700634};
        if (d < 1.0E-20) {
            double d4 = -10.0;
            return d4;
        }
        if (d > 1.0) {
            double d5 = 10.0;
            return d5;
        }
        if (d <= 0.5) {
            d3 = -1.0;
            d2 = d;
        } else {
            d2 = 1.0 - d;
        }
        double d6 = Math.sqrt(-2.0 * Math.log(d2));
        double d7 = d6 + ProbMath.devlpl(dArray, 5, d6) / ProbMath.devlpl(dArray2, 5, d6);
        d7 = d3 * d7;
        return d7;
    }

    public static double factorial(int n) {
        int n2 = 1;
        double d = -999.0;
        if (n < 0) {
            throw new IllegalArgumentException("n must be nonnegative");
        }
        if (n < 12) {
            for (int i = 1; i <= n; ++i) {
                n2 *= i;
            }
            d = n2;
        }
        if (n >= 12) {
            d = Math.exp(ProbMath.loggamma((double)n + 1.0));
        }
        return d;
    }

    public static double loggamma(double d) {
        double d2;
        double d3 = 0.0833333333333333;
        double d4 = -0.00277777777760991;
        double d5 = 7.9365066682539E-4;
        double d6 = -5.9520293135187E-4;
        double d7 = 8.37308034031215E-4;
        double d8 = -0.00165322962780713;
        double d9 = 0.418938533204673;
        if (d <= 0.8) {
            d2 = ProbMath.gamln1(d) - Math.log(d);
        } else if (d <= 2.25) {
            double d10 = d - 0.5 - 0.5;
            d2 = ProbMath.gamln1(d10);
        } else if (d < 10.0) {
            int n = (int)(d - 1.25);
            double d11 = d;
            double d12 = 1.0;
            for (int i = 1; i <= n; ++i) {
                d12 = (d11 -= 1.0) * d12;
            }
            d2 = ProbMath.gamln1(d11 - 1.0) + Math.log(d12);
        } else {
            double d13 = 1.0 / d * (1.0 / d);
            double d14 = (((((d8 * d13 + d7) * d13 + d6) * d13 + d5) * d13 + d4) * d13 + d3) / d;
            d2 = d9 + d14 + (d - 0.5) * (Math.log(d) - 1.0);
        }
        return d2;
    }

    static double gamln1(double d) {
        double d2;
        double d3 = 0.577215664901533;
        double d4 = 0.844203922187225;
        double d5 = -0.168860593646662;
        double d6 = -0.780427615533591;
        double d7 = -0.402055799310489;
        double d8 = -0.0673562214325671;
        double d9 = -0.00271935708322958;
        double d10 = 2.88743195473681;
        double d11 = 3.12755088914843;
        double d12 = 1.56875193295039;
        double d13 = 0.361951990101499;
        double d14 = 0.0325038868253937;
        double d15 = 6.67465618796164E-4;
        double d16 = 0.422784335098467;
        double d17 = 0.848044614534529;
        double d18 = 0.565221050691933;
        double d19 = 0.156513060486551;
        double d20 = 0.017050248402265;
        double d21 = 4.97958207639485E-4;
        double d22 = 1.24313399877507;
        double d23 = 0.548042109832463;
        double d24 = 0.10155218743983;
        double d25 = 0.00713309612391;
        double d26 = 1.16165475989616E-4;
        if (d < 0.6) {
            double d27 = ((((((d9 * d + d8) * d + d7) * d + d6) * d + d5) * d + d4) * d + d3) / ((((((d15 * d + d14) * d + d13) * d + d12) * d + d11) * d + d10) * d + 1.0);
            d2 = -d * d27;
        } else {
            double d28 = d - 0.5 - 0.5;
            double d29 = (((((d21 * d28 + d20) * d28 + d19) * d28 + d18) * d28 + d17) * d28 + d16) / (((((d26 * d28 + d25) * d28 + d24) * d28 + d23) * d28 + d22) * d28 + 1.0);
            d2 = d28 * d29;
        }
        return d2;
    }

    public static double combin(int n, int n2) {
        double d = Math.exp(ProbMath.loggamma(n + 1) - ProbMath.loggamma(n2 + 1) - ProbMath.loggamma(n - n2 + 1));
        return d;
    }
}

