/*
 * Decompiled with CFR 0.152.
 */
public class CalcExpData {
    public int nShifts;
    public String[] labels;
    public double[] calcShifts;
    public double[] expShifts;
    public String calcfile;
    public String expfile;

    public CalcExpData(NMRData nMRData, NMRData nMRData2) {
        this.construct(nMRData, nMRData2);
    }

    public void construct(NMRData nMRData, NMRData nMRData2) {
        this.calcfile = nMRData.filename;
        this.expfile = nMRData2.filename;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = nMRData.nShifts + nMRData2.nShifts;
        String[] stringArray = new String[n4];
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        block0: for (n = 0; n < nMRData.nShifts; ++n) {
            for (n2 = 0; n2 < nMRData2.nShifts; ++n2) {
                if (nMRData.labels[n].compareTo(nMRData2.labels[n2]) != 0) continue;
                stringArray[n3] = nMRData.labels[n];
                dArray[n3] = nMRData.shifts[n];
                dArray2[n3] = nMRData2.shifts[n2];
                ++n3;
                continue block0;
            }
        }
        this.nShifts = n3;
        String[] stringArray2 = new String[this.nShifts];
        double[] dArray3 = new double[this.nShifts];
        double[] dArray4 = new double[this.nShifts];
        for (n = 0; n < this.nShifts; ++n) {
            stringArray2[n] = stringArray[n];
            dArray3[n] = dArray[n];
            dArray4[n] = dArray2[n];
        }
        this.labels = stringArray2;
        this.calcShifts = dArray3;
        this.expShifts = dArray4;
    }

    public CalcExpData(String string, String string2, double d) {
        try {
            NMRData nMRData = NMR.convertCalcFileToNMRData(string, d);
            ExpData expData = new ExpData(string2);
            NMRData nMRData2 = NMR.convertExpToNMR(expData, nMRData);
            this.construct(nMRData, nMRData2);
        }
        catch (Exception exception) {
            System.err.println("Error constructing CalcExpData object with " + string + ", " + string2 + " and " + d);
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public double calculateCorrel() {
        return NMR.calculateCorrel(this.expShifts, this.calcShifts);
    }

    public double calculateMae() {
        return NMR.calculateMae(this.calcShifts, this.expShifts);
    }

    public double calculateMaePrime() {
        return NMR.calculateMaePrime(this.calcShifts, this.expShifts);
    }

    public double calculateWMae(Weights weights) {
        double[] dArray = this.getWeights(weights);
        return NMR.calculateWMae(this.calcShifts, this.expShifts, dArray);
    }

    public double calculateWMaePrime(Weights weights) {
        double[] dArray = this.getWeights(weights);
        return NMR.calculateWMaePrime(this.calcShifts, this.expShifts, dArray);
    }

    public double calculateRmse() {
        return NMR.calculateRmse(this.calcShifts, this.expShifts);
    }

    public double calculateCrmse() {
        return NMR.calculateCrmse(this.calcShifts, this.expShifts);
    }

    public double calculateW2mae(Weights weights) {
        double[] dArray = this.getWeights(weights);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] * dArray[i];
        }
        return NMR.calculateWMae(this.calcShifts, this.expShifts, dArray);
    }

    public double calculateW2cmae(Weights weights) {
        double[] dArray = this.getWeights(weights);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] * dArray[i];
        }
        return NMR.calculateWMaePrime(this.calcShifts, this.expShifts, dArray);
    }

    public double calculateFcmae(double d, double d2) {
        double[] dArray = new double[this.nShifts];
        for (int i = 0; i < this.nShifts; ++i) {
            dArray[i] = (this.calcShifts[i] - d2) / d;
        }
        return NMR.calculateMae(dArray, this.expShifts);
    }

    public double calculateWfcmae(double d, double d2, Weights weights) {
        double[] dArray = this.getWeights(weights);
        double[] dArray2 = new double[this.nShifts];
        for (int i = 0; i < this.nShifts; ++i) {
            dArray2[i] = (this.calcShifts[i] - d2) / d;
        }
        return NMR.calculateWMae(dArray2, this.expShifts, dArray);
    }

    public double calculateW2fcmae(double d, double d2, Weights weights) {
        double[] dArray = this.getWeights(weights);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] * dArray[i];
        }
        double[] dArray2 = new double[this.nShifts];
        for (int i = 0; i < this.nShifts; ++i) {
            dArray2[i] = (this.calcShifts[i] - d2) / d;
        }
        return NMR.calculateWMae(dArray2, this.expShifts, dArray);
    }

    public double calculateFcrmse(double d, double d2) {
        double[] dArray = new double[this.nShifts];
        for (int i = 0; i < this.nShifts; ++i) {
            dArray[i] = (this.calcShifts[i] - d2) / d;
        }
        return NMR.calculateRmse(dArray, this.expShifts);
    }

    public double calculateDp1() {
        int n;
        double[] dArray = new double[this.nShifts];
        double[] dArray2 = new double[this.nShifts];
        String[] stringArray = new String[this.nShifts];
        for (n = 0; n < this.nShifts; ++n) {
            dArray[n] = this.calcShifts[n];
            dArray2[n] = this.expShifts[n];
            stringArray[n] = this.labels[n];
        }
        for (n = 0; n < this.nShifts; ++n) {
            for (int i = 0; i < this.nShifts - 1; ++i) {
                if (!(dArray2[i] < dArray2[i + 1])) continue;
                double d = dArray2[i];
                double d2 = dArray[i];
                String string = stringArray[i];
                dArray2[i] = dArray2[i + 1];
                dArray[i] = dArray[i + 1];
                stringArray[i] = stringArray[i + 1];
                dArray2[i + 1] = d;
                dArray[i + 1] = d2;
                stringArray[i + 1] = string;
            }
        }
        double d = 0.0;
        for (int i = 0; i < this.nShifts - 1; ++i) {
            if (!(dArray[i + 1] > dArray[i])) continue;
            d -= (dArray[i] - dArray[i + 1]) * (dArray2[i] - dArray2[i + 1]);
        }
        return d;
    }

    public double calculateDp2() {
        int n;
        double[] dArray = new double[this.nShifts];
        double[] dArray2 = new double[this.nShifts];
        String[] stringArray = new String[this.nShifts];
        for (n = 0; n < this.nShifts; ++n) {
            dArray[n] = this.calcShifts[n];
            dArray2[n] = this.expShifts[n];
            stringArray[n] = this.labels[n];
        }
        for (n = 0; n < this.nShifts; ++n) {
            for (int i = 0; i < this.nShifts - 1; ++i) {
                if (!(dArray2[i] < dArray2[i + 1])) continue;
                double d = dArray2[i];
                double d2 = dArray[i];
                String string = stringArray[i];
                dArray2[i] = dArray2[i + 1];
                dArray[i] = dArray[i + 1];
                stringArray[i] = stringArray[i + 1];
                dArray2[i + 1] = d;
                dArray[i + 1] = d2;
                stringArray[i + 1] = string;
            }
        }
        double d = 0.0;
        for (int i = 0; i < this.nShifts - 1; ++i) {
            d += Math.abs(dArray[i + 1] - dArray[i] - (dArray2[i + 1] - dArray2[i]));
        }
        return d / (double)(this.nShifts - 1);
    }

    public double calculateDp6() {
        double d = 0.0;
        for (int i = 0; i < this.nShifts; ++i) {
            for (int j = i + 1; j < this.nShifts; ++j) {
                d += Math.abs(this.calcShifts[i] - this.calcShifts[j] - (this.expShifts[i] - this.expShifts[j]));
            }
        }
        return d / (double)(this.nShifts * (this.nShifts - 1) / 2);
    }

    public double calculateDp4(double d, double d2) {
        double d3 = 1.0;
        for (int i = 0; i < this.nShifts; ++i) {
            double d4 = Math.abs((this.calcShifts[i] - this.expShifts[i] - d) / d2);
            d3 = d3 * 2.0 * ProbMath.normalCdf(-d4);
        }
        return d3;
    }

    public double calculateCdp4(double d, double d2) {
        double d3 = 1.0;
        double[] dArray = this.getdscaled();
        for (int i = 0; i < this.nShifts; ++i) {
            double d4 = Math.abs((dArray[i] - this.expShifts[i] - d) / d2);
            d3 = d3 * 2.0 * ProbMath.normalCdf(-d4);
        }
        return d3;
    }

    public double calculateDp5(double[] dArray, double[] dArray2) {
        double d = 1.0;
        if (dArray.length + 1 != dArray2.length) {
            throw new RuntimeException("Number of classes +1 (" + (dArray.length + 1) + ") and probabilities (" + dArray2.length + ") do not match");
        }
        for (int i = 0; i < this.nShifts; ++i) {
            int n = -1;
            for (int j = 0; j < dArray.length; ++j) {
                if (!(this.calcShifts[i] - this.expShifts[i] < dArray[j])) continue;
                n = j;
                break;
            }
            if (n == -1) {
                n = dArray.length;
            }
            d *= dArray2[n];
        }
        return d;
    }

    public double calculateDp5(double[][] dArray) {
        return this.getDp5Param(dArray, "dp5");
    }

    public double getDp5Param(double[][] dArray, String string) {
        int n = dArray[1].length;
        double[] dArray2 = new double[n - 1];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n - 1; ++i) {
            dArray2[i] = dArray[0][i];
            dArray3[i] = dArray[1][i];
        }
        dArray3[n - 1] = dArray[1][n - 1];
        double d = 0.0;
        if (string.compareTo("dp5") == 0) {
            d = this.calculateDp5(dArray2, dArray3);
        } else if (string.compareTo("cdp5") == 0) {
            d = this.calculateCdp5(dArray2, dArray3);
        } else {
            throw new RuntimeException("Unknown parameter: " + string);
        }
        return d;
    }

    public double calculateCdp5(double[] dArray, double[] dArray2) {
        double d = 1.0;
        double[] dArray3 = this.getdscaled();
        if (dArray.length + 1 != dArray2.length) {
            throw new RuntimeException("Number of classes +1 (" + (dArray.length + 1) + ") and probabilities (" + dArray2.length + ") do not match");
        }
        for (int i = 0; i < this.nShifts; ++i) {
            int n = -1;
            for (int j = 0; j < dArray.length; ++j) {
                if (!(dArray3[i] - this.expShifts[i] < dArray[j])) continue;
                n = j;
                break;
            }
            if (n == -1) {
                n = dArray.length;
            }
            d *= dArray2[n];
        }
        return d;
    }

    public double calculateCdp5(double[][] dArray) {
        return this.getDp5Param(dArray, "cdp5");
    }

    public double calculateMaxError() {
        return NMR.calculateMaxError(this.calcShifts, this.expShifts);
    }

    public double[] getWeights(Weights weights) {
        boolean bl = false;
        double[] dArray = new double[this.nShifts];
        for (int i = 0; i < this.nShifts; ++i) {
            bl = false;
            for (int j = 0; j < weights.nShifts; ++j) {
                if (this.labels[i].compareTo(weights.labels[j]) != 0) continue;
                dArray[i] = weights.weights[j];
                bl = true;
                break;
            }
            if (bl) continue;
            throw new RuntimeException("I couldn't find a weight for " + this.labels[i]);
        }
        return dArray;
    }

    public double calculateSlope() {
        return NMR.calculateSlope(this.calcShifts, this.expShifts);
    }

    public double calculateIntercept() {
        return NMR.calculateIntercept(this.calcShifts, this.expShifts);
    }

    public double[] getModDd() {
        double[] dArray = new double[this.nShifts];
        for (int i = 0; i < this.nShifts; ++i) {
            dArray[i] = Math.abs(this.calcShifts[i] - this.expShifts[i]);
        }
        return dArray;
    }

    public double[] getModDdPrime() {
        double[] dArray = new double[this.nShifts];
        double d = this.calculateSlope();
        double d2 = this.calculateIntercept();
        for (int i = 0; i < this.nShifts; ++i) {
            dArray[i] = Math.abs((this.calcShifts[i] - d2) / d - this.expShifts[i]);
        }
        return dArray;
    }

    public double[] getdscaled() {
        double[] dArray = new double[this.nShifts];
        double d = this.calculateSlope();
        double d2 = this.calculateIntercept();
        for (int i = 0; i < this.nShifts; ++i) {
            dArray[i] = (this.calcShifts[i] - d2) / d;
        }
        return dArray;
    }

    public double[] getdfscaled(double d, double d2) {
        double[] dArray = new double[this.nShifts];
        for (int i = 0; i < this.nShifts; ++i) {
            dArray[i] = (this.calcShifts[i] - d2) / d;
        }
        return dArray;
    }

    public double getCalcShift(String string) {
        String string2 = string;
        Double d = 0.0;
        for (int i = 0; i < this.nShifts; ++i) {
            if (this.labels[i].compareTo(string2) != 0) continue;
            d = this.calcShifts[i];
        }
        return d;
    }

    public double getExpShift(String string) {
        String string2 = string;
        Double d = 0.0;
        for (int i = 0; i < this.nShifts; ++i) {
            if (this.labels[i].compareTo(string2) != 0) continue;
            d = this.expShifts[i];
        }
        return d;
    }

    public void print() {
        int n = 0;
        System.out.print("," + this.calcfile + "," + this.expfile + "\n");
        System.out.print(",calc,exp\n");
        for (n = 0; n < this.nShifts; ++n) {
            System.out.print(this.labels[n] + "," + this.calcShifts[n] + "," + this.expShifts[n] + "\n");
        }
    }
}

