/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;

class NMR {
    NMR() {
    }

    public static NMRData convertCalcToNMR(CalcData calcData, double d) {
        int n = 0;
        int n2 = calcData.nShifts;
        String[] stringArray = calcData.labels;
        double[] dArray = new double[n2];
        String string = calcData.filename;
        for (n = 0; n < n2; ++n) {
            dArray[n] = (d - calcData.sigmas[n]) / (1.0 - d / 1000000.0);
        }
        NMRData nMRData = new NMRData(stringArray, dArray, string);
        return nMRData;
    }

    public static NMRData convertExpToNMR(ExpData expData, NMRData nMRData) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = expData.nShifts;
        int n5 = nMRData.nShifts;
        int n6 = expData.nLabels;
        String string = expData.filename;
        expData.sort();
        nMRData.sort();
        String[] stringArray = new String[n5];
        for (n = 0; n < n5; ++n) {
            stringArray[n] = nMRData.labels[n];
        }
        int[] nArray = new int[n4];
        for (n = 0; n < n4; ++n) {
            nArray[n] = expData.assign[n];
            if (nArray[n] != 0) continue;
            nArray[n] = 1;
        }
        double[] dArray = new double[n4];
        String[] stringArray2 = new String[n4];
        block2: for (n = 0; n < n4; ++n) {
            dArray[n] = expData.shifts[n];
            for (n2 = 0; n2 < n5; ++n2) {
                for (n3 = 0; n3 < n6; ++n3) {
                    if (expData.labels[n][n3].compareTo(stringArray[n2]) == 0 || expData.labels[n][n3].compareTo("any") == 0 && stringArray[n2].compareTo("used") != 0) {
                        if (nArray[n] == 1) {
                            stringArray2[n] = stringArray[n2];
                            stringArray[n2] = "used";
                            continue block2;
                        }
                        int n7 = n;
                        nArray[n7] = nArray[n7] - 1;
                        continue;
                    }
                    if (expData.labels[n][n3].compareTo(nMRData.labels[n2]) != 0 || nArray[n] == 1) continue;
                    int n8 = n;
                    nArray[n8] = nArray[n8] - 1;
                }
            }
        }
        NMRData nMRData2 = new NMRData(stringArray2, dArray, string);
        return nMRData2;
    }

    public static PairwiseData convertToPairwise(NMRData nMRData, NMRData nMRData2, NMRData nMRData3, NMRData nMRData4) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        String[] stringArray = new String[]{nMRData.filename, nMRData2.filename, nMRData3.filename, nMRData4.filename};
        String[] stringArray2 = new String[nMRData.nShifts * nMRData2.nShifts * nMRData3.nShifts * nMRData4.nShifts + 1];
        for (n = 0; n < nMRData.nShifts; ++n) {
            stringArray2[n] = nMRData.labels[n];
        }
        boolean bl2 = false;
        for (n = 0; n < nMRData2.nShifts; ++n) {
            bl2 = false;
            n2 = 0;
            while (!bl2) {
                if (nMRData2.labels[n].compareTo(stringArray2[n2]) == 0) {
                    bl2 = true;
                }
                if (stringArray2[n2] == null) {
                    stringArray2[n2] = nMRData2.labels[n];
                    bl2 = true;
                }
                ++n2;
            }
        }
        for (n = 0; n < nMRData3.nShifts; ++n) {
            bl2 = false;
            n2 = 0;
            while (!bl2) {
                if (nMRData3.labels[n].compareTo(stringArray2[n2]) == 0) {
                    bl2 = true;
                }
                if (stringArray2[n2] == null) {
                    stringArray2[n2] = nMRData3.labels[n];
                    bl2 = true;
                }
                ++n2;
            }
        }
        for (n = 0; n < nMRData4.nShifts; ++n) {
            bl2 = false;
            n2 = 0;
            while (!bl2) {
                if (nMRData4.labels[n].compareTo(stringArray2[n2]) == 0) {
                    bl2 = true;
                }
                if (stringArray2[n2] == null) {
                    stringArray2[n2] = nMRData4.labels[n];
                    bl2 = true;
                }
                ++n2;
            }
        }
        n = 0;
        while (stringArray2[n] != null) {
            ++n3;
            ++n;
        }
        String[] stringArray3 = new String[n3];
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        int[] nArray = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray[n] = 1;
        }
        for (n = 0; n < n3; ++n) {
            stringArray3[n] = stringArray2[n];
        }
        block10: for (n = 0; n < n3; ++n) {
            for (n2 = 0; n2 < nMRData.nShifts; ++n2) {
                if (stringArray3[n].compareTo(nMRData.labels[n2]) != 0) continue;
                dArray[n] = nMRData.shifts[n2];
                nArray[n] = nArray[n] * 2;
                continue block10;
            }
        }
        block12: for (n = 0; n < n3; ++n) {
            for (n2 = 0; n2 < nMRData2.nShifts; ++n2) {
                if (stringArray3[n].compareTo(nMRData2.labels[n2]) != 0) continue;
                dArray2[n] = nMRData2.shifts[n2];
                nArray[n] = nArray[n] * 2;
                continue block12;
            }
        }
        block14: for (n = 0; n < n3; ++n) {
            for (n2 = 0; n2 < nMRData3.nShifts; ++n2) {
                if (stringArray3[n].compareTo(nMRData3.labels[n2]) != 0) continue;
                dArray3[n] = nMRData3.shifts[n2];
                nArray[n] = nArray[n] * 2;
                continue block14;
            }
        }
        block16: for (n = 0; n < n3; ++n) {
            for (n2 = 0; n2 < nMRData4.nShifts; ++n2) {
                if (stringArray3[n].compareTo(nMRData4.labels[n2]) != 0) continue;
                dArray4[n] = nMRData4.shifts[n2];
                nArray[n] = nArray[n] * 2;
                continue block16;
            }
        }
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            if (nArray[n] != 16) continue;
            ++n4;
        }
        String[] stringArray4 = new String[n4];
        double[] dArray5 = new double[n4];
        double[] dArray6 = new double[n4];
        double[] dArray7 = new double[n4];
        double[] dArray8 = new double[n4];
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            if (nArray[n] != 16) continue;
            stringArray4[n2] = stringArray3[n];
            dArray5[n2] = dArray[n];
            dArray6[n2] = dArray2[n];
            dArray7[n2] = dArray3[n];
            dArray8[n2] = dArray4[n];
            ++n2;
        }
        PairwiseData pairwiseData = new PairwiseData(stringArray4, dArray5, dArray6, dArray7, dArray8, stringArray);
        return pairwiseData;
    }

    public static NMRData convertCalcFileToNMRData(String string, double d) {
        CalcData calcData = new CalcData(string);
        NMRData nMRData = NMR.convertCalcToNMR(calcData, d);
        return nMRData;
    }

    public static PairwiseData convertToPairwise2(NMRData nMRData, NMRData nMRData2, ExpData expData, ExpData expData2) {
        NMRData nMRData3 = NMR.convertExpToNMR(expData, nMRData);
        NMRData nMRData4 = NMR.convertExpToNMR(expData2, nMRData2);
        PairwiseData pairwiseData = NMR.convertToPairwise(nMRData, nMRData2, nMRData3, nMRData4);
        return pairwiseData;
    }

    public static MultiData convertFilesToMultiData(String[] stringArray, char c) {
        double d = 0.0;
        double d2 = 0.0;
        String string = stringArray[4];
        String string2 = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            string2 = bufferedReader.readLine();
            d = Double.valueOf(string2);
            string2 = bufferedReader.readLine();
            d2 = Double.valueOf(string2);
        }
        catch (Exception exception) {
            System.err.println("Error reading TMSfile");
        }
        Double d3 = 0.0;
        if (c == 'C') {
            d3 = d;
        } else if (c == 'H') {
            d3 = d2;
        }
        NMRData[] nMRDataArray = new NMRData[2];
        for (int i = 0; i < 2; ++i) {
            nMRDataArray[i] = NMR.convertCalcFileToNMRData(stringArray[i] + "." + c, d3);
            nMRDataArray[i].sort();
        }
        ExpData[] expDataArray = new ExpData[2];
        for (int i = 0; i < 2; ++i) {
            expDataArray[i] = new ExpData(stringArray[i + 2] + "." + c);
            expDataArray[i].sort();
        }
        CalcExpData[] calcExpDataArray = new CalcExpData[2];
        for (int i = 0; i < 2; ++i) {
            NMRData nMRData = NMR.convertExpToNMR(expDataArray[i], nMRDataArray[i]);
            calcExpDataArray[i] = new CalcExpData(nMRDataArray[i], nMRData);
        }
        MultiData multiData = new MultiData(calcExpDataArray);
        return multiData;
    }

    public static MultiData convertFilesToMultiData(String string, String string2, String string3, String string4, String string5, char c) {
        String[] stringArray = new String[]{string, string2, string3, string4, string5};
        MultiData multiData = NMR.convertFilesToMultiData(stringArray, c);
        return multiData;
    }

    public static double getTms(String string, char c) {
        double d;
        if (c == 'C') {
            d = NMR.getTmsC(string);
        } else if (c == 'H') {
            d = NMR.getTmsH(string);
        } else {
            throw new RuntimeException("Unknown nucleus: " + c);
        }
        return d;
    }

    public static double getTmsC(String string) {
        String string2 = string;
        double d = 0.0;
        String string3 = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string2)));
            string3 = bufferedReader.readLine();
            d = Double.valueOf(string3);
        }
        catch (Exception exception) {
            System.err.println("Error reading TMSfile");
        }
        return d;
    }

    public static double getTmsH(String string) {
        String string2 = string;
        double d = 0.0;
        String string3 = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string2)));
            string3 = bufferedReader.readLine();
            string3 = bufferedReader.readLine();
            d = Double.valueOf(string3);
        }
        catch (Exception exception) {
            System.err.println("Error reading TMSfile");
        }
        return d;
    }

    public static double[] Expect(String string, String string2) {
        double[] dArray = new double[6];
        String string3 = "";
        string3 = "";
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string2)));
            while (string3.compareTo("end") != 0 && string3.compareTo(string) != 0) {
                string3 = bufferedReader.readLine();
            }
            string3 = bufferedReader.readLine();
            for (n = 1; n < 6; ++n) {
                string3 = bufferedReader.readLine();
                dArray[n] = Double.valueOf(string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dArray;
    }

    public static double[] Standard(String string, String string2) {
        double[] dArray = new double[6];
        String string3 = "";
        string3 = "";
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string2)));
            while (string3.compareTo("end") != 0 && string3.compareTo(string) != 0) {
                string3 = bufferedReader.readLine();
            }
            for (n = 0; n < 7; ++n) {
                string3 = bufferedReader.readLine();
            }
            for (n = 1; n < 6; ++n) {
                string3 = bufferedReader.readLine();
                dArray[n] = Double.valueOf(string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dArray;
    }

    public static double[] ExpectPI(String string, String string2) {
        double[] dArray = new double[3];
        String string3 = "";
        string3 = "";
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string2)));
            while (string3.compareTo("end") != 0 && string3.compareTo(string) != 0) {
                string3 = bufferedReader.readLine();
            }
            for (n = 1; n < 3; ++n) {
                string3 = bufferedReader.readLine();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, " ,\t", false);
                dArray[n] = Double.valueOf(stringTokenizer.nextToken());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dArray;
    }

    public static double[] StandardPI(String string, String string2) {
        double[] dArray = new double[3];
        String string3 = "";
        string3 = "";
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string2)));
            while (string3.compareTo("end") != 0 && string3.compareTo(string) != 0) {
                string3 = bufferedReader.readLine();
            }
            for (n = 1; n < 3; ++n) {
                string3 = bufferedReader.readLine();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, " ,\t", false);
                dArray[n] = Double.valueOf(stringTokenizer.nextToken());
                dArray[n] = Double.valueOf(stringTokenizer.nextToken());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dArray;
    }

    public static double PIExpectRight(String string, String string2) {
        double[] dArray = NMR.ExpectPI(string, string2);
        return dArray[1];
    }

    public static double PIExpectWrong(String string, String string2) {
        double[] dArray = NMR.ExpectPI(string, string2);
        return dArray[2];
    }

    public static double PIStdevRight(String string, String string2) {
        double[] dArray = NMR.StandardPI(string, string2);
        return dArray[1];
    }

    public static double PIStdevWrong(String string, String string2) {
        double[] dArray = NMR.StandardPI(string, string2);
        return dArray[2];
    }

    public static double getPiParam(String string, String string2) {
        double d = 0.0;
        String string3 = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string2)));
            while (string3.compareTo(string) != 0) {
                string3 = bufferedReader.readLine();
            }
            string3 = bufferedReader.readLine();
            d = Double.valueOf(string3);
        }
        catch (Exception exception) {
            System.err.println("Error reading PIfile " + string2 + " to get parameter " + string);
            exception.printStackTrace();
        }
        return d;
    }

    public static double[][] getXdp5Classes(String string, String string2) {
        double[][] dArray = new double[2][8];
        String string3 = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string2)));
            while (string3.compareTo(string) != 0) {
                string3 = bufferedReader.readLine();
            }
            for (int i = 0; i < 7; ++i) {
                string3 = bufferedReader.readLine();
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                dArray[0][i] = Double.valueOf(stringTokenizer.nextToken());
                dArray[1][i] = Double.valueOf(stringTokenizer.nextToken());
            }
            string3 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            dArray[1][7] = Double.valueOf(stringTokenizer.nextToken());
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println("Error reading PIfile " + string2 + " to get parameter " + string + ".");
            exception.printStackTrace();
        }
        return dArray;
    }

    public static ParameterArray2 averageParameterArray2s(ParameterArray2[] parameterArray2Array) {
        int n = parameterArray2Array.length;
        int n2 = parameterArray2Array[0].values.length;
        ParameterArray2 parameterArray2 = new ParameterArray2();
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += parameterArray2Array[j].values[i];
            }
            parameterArray2.values[i] = d / (double)n;
        }
        return parameterArray2;
    }

    public static ParameterArray2 stdevParameterArray2s(ParameterArray2[] parameterArray2Array) {
        int n = parameterArray2Array.length;
        int n2 = parameterArray2Array[0].values.length;
        ParameterArray2 parameterArray2 = new ParameterArray2();
        for (int i = 0; i < n2; ++i) {
            double[] dArray = new double[n];
            for (int j = 0; j < n; ++j) {
                dArray[j] = parameterArray2Array[j].values[i];
            }
            parameterArray2.values[i] = NMR.stdevNaN(dArray);
        }
        return parameterArray2;
    }

    public static int[][] generateAsn(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = NMR.nPr(n, n2);
        int[][] nArray = new int[n2][n6];
        int[] nArray2 = new int[n2];
        boolean bl = false;
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = 0;
            nArray2[n5] = NMR.nPr(n - n5 - 1, n2 - 1 - n5);
            while (n4 < n6) {
                for (int i = 0; i < n && n4 < n6; ++i) {
                    bl = false;
                    for (int j = 0; j < n5; ++j) {
                        if (nArray[j][n4] != i) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    for (n3 = 0; n3 < nArray2[n5]; ++n3) {
                        nArray[n5][n4] = i;
                        ++n4;
                    }
                }
            }
        }
        int[][] nArray3 = new int[n2][n6];
        int n7 = 0;
        boolean bl2 = false;
        for (n4 = n6 - 1; n4 > -1; --n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                bl2 = false;
                for (n5 = 0; n5 < n2; ++n5) {
                    if (nArray[n5][n3] > nArray[n5][n7]) {
                        bl2 = true;
                        break;
                    }
                    if (nArray[n5][n3] >= nArray[n5][n7]) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                n7 = n3;
            }
            for (n5 = 0; n5 < n2; ++n5) {
                nArray3[n5][n4] = nArray[n5][n7];
                nArray[n5][n7] = 0;
            }
        }
        return nArray3;
    }

    public static double[] sortArray(double[] dArray) {
        int n;
        int n2 = 0;
        double d = dArray[0];
        int n3 = dArray.length;
        double[] dArray2 = new double[n3];
        int[] nArray = new int[n3];
        for (n = 0; n < n3; ++n) {
            if (!(dArray[n] < d)) continue;
            d = dArray[n];
            n2 = n;
        }
        for (n = 0; n < n3; ++n) {
            double d2 = d;
            int n4 = n2;
            for (int i = 0; i < n3; ++i) {
                if (!(dArray[i] > d2) || nArray[i] != 0) continue;
                d2 = dArray[i];
                n4 = i;
            }
            dArray2[n] = dArray[n4];
            nArray[n4] = 1;
        }
        return dArray2;
    }

    public static double[] sortDescending(double[] dArray) {
        return NMR.sortArray(dArray);
    }

    public static double[] sortAscending(double[] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n - 1; ++j) {
                if (!(dArray[j] > dArray[j + 1])) continue;
                double d = dArray[j];
                dArray[j] = dArray[j + 1];
                dArray[j + 1] = d;
            }
        }
        return dArray;
    }

    public static int[] sortAscending(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n - 1; ++j) {
                if (nArray[j] <= nArray[j + 1]) continue;
                int n2 = nArray[j];
                nArray[j] = nArray[j + 1];
                nArray[j + 1] = n2;
            }
        }
        return nArray;
    }

    public static String[] sortStrings(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n - 1; ++j) {
                if (stringArray[j].compareTo(stringArray[j + 1]) <= 0) continue;
                String string = stringArray[j];
                stringArray[j] = stringArray[j + 1];
                stringArray[j + 1] = string;
            }
        }
        return stringArray;
    }

    public static String[] sortStringsFilter(String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        stringArray = NMR.sortStrings(stringArray);
        for (int i = 0; i < n - 1; ++i) {
            if (stringArray[i].compareTo(stringArray[i + 1]) != 0) continue;
            ++n2;
        }
        String[] stringArray2 = new String[n - n2];
        int n3 = 0;
        for (int i = 0; i < n - 1; ++i) {
            if (stringArray[i].compareTo(stringArray[i + 1]) == 0) continue;
            stringArray2[n3] = stringArray[i];
            ++n3;
        }
        stringArray2[n - n2 - 1] = stringArray[n - 1];
        return stringArray2;
    }

    public static void checkForDuplicates(int[] nArray) {
        nArray = NMR.sortAscending(nArray);
        for (int i = 0; i < nArray.length - 1; ++i) {
            if (nArray[i] != nArray[i + 1]) continue;
            throw new RuntimeException("Warning: duplicate conformers requested: " + nArray[i]);
        }
    }

    public static int getType(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = 3;
        if (nArray[n] == n3) {
            --n5;
        }
        if (nArray[n] == n4) {
            ++n5;
        }
        if (nArray[n2] == n3) {
            ++n5;
        }
        if (nArray[n2] == n4) {
            --n5;
        }
        return n5;
    }

    public static String fileTrim(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " .", false);
        return stringTokenizer.nextToken();
    }

    public static int lines(String string) {
        String string2 = "";
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            while (string2 != null && string2.compareTo("end") != 0) {
                string2 = bufferedReader.readLine();
                ++n;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return --n;
    }

    public static int getMaxTokens(String string) {
        int n = NMR.lines(string);
        String string2 = "";
        int n2 = 0;
        int n3 = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            for (n2 = 0; n2 < n; ++n2) {
                string2 = bufferedReader.readLine();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,\t", false);
                int n4 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    ++n4;
                }
                if (n4 <= n3) continue;
                n3 = n4;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n3;
    }

    public static String[] getLines(String string) {
        int n = NMR.lines(string);
        String[] stringArray = new String[n];
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            for (int i = 0; i < n; ++i) {
                stringArray[i] = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray;
    }

    public static String[] getLines2(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static double calculateCorrel(double[] dArray, double[] dArray2) {
        double d = NMR.calculateSxy(dArray, dArray);
        double d2 = NMR.calculateSxy(dArray2, dArray2);
        double d3 = NMR.calculateSxy(dArray, dArray2);
        return d3 / Math.sqrt(d * d2);
    }

    public static double calculateSlope(double[] dArray, double[] dArray2) {
        double d = NMR.calculateSxy(dArray2, dArray2);
        double d2 = NMR.calculateSxy(dArray2, dArray);
        return d2 / d;
    }

    public static double calculateIntercept(double[] dArray, double[] dArray2) {
        double d = NMR.calculateSlope(dArray, dArray2);
        double d2 = NMR.average(dArray2);
        double d3 = NMR.average(dArray);
        return d3 - d * d2;
    }

    public static double calculateSxy(double[] dArray, double[] dArray2) {
        int n = 0;
        int n2 = dArray.length;
        double d = NMR.average(dArray);
        double d2 = NMR.average(dArray2);
        double d3 = 0.0;
        for (n = 0; n < n2; ++n) {
            d3 += (dArray[n] - d) * (dArray2[n] - d2);
        }
        return d3;
    }

    public static double calculateSumSquares(double[] dArray) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray[i];
        }
        return d;
    }

    public static double average(double[] dArray) {
        int n = 0;
        int n2 = dArray.length;
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            d += dArray[n];
        }
        return d / (double)n2;
    }

    public static double averageNaN(double[] dArray) {
        double[] dArray2 = NMR.removeNaN(dArray);
        return NMR.average(dArray2);
    }

    public static double stdevNaN(double[] dArray) {
        double[] dArray2 = NMR.removeNaN(dArray);
        return NMR.stdev(dArray2);
    }

    public static double stdevpNaN(double[] dArray) {
        double[] dArray2 = NMR.removeNaN(dArray);
        return NMR.stdevp(dArray2);
    }

    public static double stdev(double[] dArray) {
        double d = NMR.calculateSxy(dArray, dArray);
        int n = dArray.length;
        return Math.sqrt(d / (double)(n - 1));
    }

    public static double stdevp(double[] dArray) {
        double d = NMR.calculateSxy(dArray, dArray);
        int n = dArray.length;
        return Math.sqrt(d / (double)n);
    }

    public static double[] removeNaN(double[] dArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = n = dArray.length;
        for (n2 = 0; n2 < n; ++n2) {
            if (!Double.isNaN(dArray[n2])) continue;
            --n4;
        }
        double[] dArray2 = new double[n4];
        for (n2 = 0; n2 < n; ++n2) {
            if (Double.isNaN(dArray[n2])) continue;
            dArray2[n3] = dArray[n2];
            ++n3;
        }
        return dArray2;
    }

    public static double[] join(double[] dArray, double[] dArray2) {
        int n = 0;
        int n2 = 0;
        double[] dArray3 = new double[dArray.length + dArray2.length];
        for (n = 0; n < dArray.length; ++n) {
            dArray3[n2] = dArray[n];
            ++n2;
        }
        for (n = 0; n < dArray2.length; ++n) {
            dArray3[n2] = dArray2[n];
            ++n2;
        }
        return dArray3;
    }

    public static double[] joinArray(double[][] dArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = dArray.length;
        int[] nArray = new int[n4];
        int n5 = 0;
        for (n = 0; n < n4; ++n) {
            n5 += dArray[n].length;
            nArray[n] = dArray[n].length;
        }
        double[] dArray2 = new double[n5];
        for (n = 0; n < n4; ++n) {
            for (n2 = 0; n2 < nArray[n]; ++n2) {
                dArray2[n3] = dArray[n][n2];
                ++n3;
            }
        }
        return dArray2;
    }

    public static double[] normalise(double[] dArray) {
        int n = 0;
        int n2 = dArray.length;
        double d = 0.0;
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            d += dArray[n];
        }
        for (n = 0; n < n2; ++n) {
            dArray2[n] = dArray[n] / d * 100.0;
        }
        return dArray2;
    }

    public static double calculateMae(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.abs(dArray[i] - dArray2[i]);
        }
        return d / (double)dArray.length;
    }

    public static double calculateMaePrime(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = NMR.calculateSlope(dArray, dArray2);
        double d2 = NMR.calculateIntercept(dArray, dArray2);
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 += Math.abs((dArray[i] - d2) / d - dArray2[i]);
        }
        return d3 / (double)n;
    }

    public static double calculateWMae(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.abs(dArray[i] - dArray2[i]) * dArray3[i];
            d2 += dArray3[i];
        }
        return d / d2;
    }

    public static double calculateWMaePrime(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray.length;
        double d = NMR.calculateSlope(dArray, dArray2);
        double d2 = NMR.calculateIntercept(dArray, dArray2);
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 += Math.abs((dArray[i] - d2) / d - dArray2[i]) * dArray3[i];
            d4 += dArray3[i];
        }
        return d3 / d4;
    }

    public static double calculateRmse(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (dArray[i] - dArray2[i]) * (dArray[i] - dArray2[i]);
        }
        return Math.sqrt(d / (double)n);
    }

    public static double calculateCrmse(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = NMR.calculateSlope(dArray, dArray2);
        double d2 = NMR.calculateIntercept(dArray, dArray2);
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 += ((dArray[i] - d2) / d - dArray2[i]) * ((dArray[i] - d2) / d - dArray2[i]);
        }
        return Math.sqrt(d3 / (double)n);
    }

    public static double calculateMaxError(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(dArray[i] - dArray2[i]) > d)) continue;
            d = Math.abs(dArray[i] - dArray2[i]);
        }
        return d;
    }

    public static double calculateCpd(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = dArray.length;
        for (n = 0; n < n2; ++n) {
            d = dArray2[n] - dArray4[n];
            d2 = dArray[n] - dArray3[n];
            d4 += d * d;
            d3 += d * d2;
        }
        return d3 / d4;
    }

    public static double calculateCpe(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = dArray.length;
        for (n = 0; n < n2; ++n) {
            d = dArray2[n] - dArray4[n];
            d2 = dArray[n] - dArray3[n];
            d4 += d * d;
            if (Math.abs(d2 / d) > 1.0) {
                d3 += d * d * d / d2;
                continue;
            }
            d3 += d * d2;
        }
        return d3 / d4;
    }

    public static double calculateCph(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = dArray.length;
        for (n = 0; n < n2; ++n) {
            d = dArray2[n] - dArray4[n];
            d2 = dArray[n] - dArray3[n];
            d4 += d * d;
            if (d2 / d > 1.0) {
                d3 += d * d * d / d2;
                continue;
            }
            d3 += d * d2;
        }
        return d3 / d4;
    }

    public static double[] calculateCdp4(CalcExpData[] calcExpDataArray, double d, double d2) {
        int n;
        int n2 = calcExpDataArray.length;
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = calcExpDataArray[i].calculateCdp4(d, d2);
        }
        double d3 = 0.0;
        for (n = 0; n < n2; ++n) {
            d3 += dArray[n];
        }
        for (n = 0; n < n2; ++n) {
            dArray[n] = dArray[n] / d3 * 100.0;
        }
        return dArray;
    }

    public static double[] calculateCdp4(CalcExpData[] calcExpDataArray, double d, double d2, CalcExpData[] calcExpDataArray2, double d3, double d4) {
        int n;
        if (calcExpDataArray.length != calcExpDataArray2.length) {
            throw new RuntimeException("Error: Numbers of isomers for carbon (" + calcExpDataArray.length + ") and proton (" + calcExpDataArray2.length + ") data are not the same!");
        }
        int n2 = calcExpDataArray.length;
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = calcExpDataArray[i].calculateCdp4(d, d2) * calcExpDataArray2[i].calculateCdp4(d3, d4);
        }
        double d5 = 0.0;
        for (n = 0; n < n2; ++n) {
            d5 += dArray[n];
        }
        for (n = 0; n < n2; ++n) {
            dArray[n] = dArray[n] / d5 * 100.0;
        }
        return dArray;
    }

    public static int whatsGood(String string) {
        int n = 0;
        if (string.compareTo("correlC") == 0) {
            n = 1;
        } else if (string.compareTo("MAEC") == 0) {
            n = -1;
        } else if (string.compareTo("MAE'C") == 0) {
            n = -1;
        } else if (string.compareTo("wMAEC") == 0) {
            n = -1;
        } else if (string.compareTo("wMAE'C") == 0) {
            n = -1;
        } else if (string.compareTo("CP4C") == 0) {
            n = 1;
        } else if (string.compareTo("CP5C") == 0) {
            n = 1;
        } else if (string.compareTo("CP8C") == 0) {
            n = 1;
        } else if (string.compareTo("correlH") == 0) {
            n = 1;
        } else if (string.compareTo("MAEH") == 0) {
            n = -1;
        } else if (string.compareTo("MAE'H") == 0) {
            n = -1;
        } else if (string.compareTo("wMAEH") == 0) {
            n = -1;
        } else if (string.compareTo("wMAE'H") == 0) {
            n = -1;
        } else if (string.compareTo("CP4H") == 0) {
            n = 1;
        } else if (string.compareTo("CP5H") == 0) {
            n = 1;
        } else if (string.compareTo("CP8H") == 0) {
            n = 1;
        } else if (string.compareTo("correlCH2gav") == 0) {
            n = 1;
        } else if (string.compareTo("MAECHav") == 0) {
            n = -1;
        } else if (string.compareTo("MAEprimeCHav") == 0) {
            n = -1;
        } else if (string.compareTo("wMAEM") == 0) {
            n = -1;
        } else if (string.compareTo("wMAE'M") == 0) {
            n = -1;
        } else if (string.compareTo("CP4CHav") == 0) {
            n = 1;
        } else if (string.compareTo("CP5CHav") == 0) {
            n = 1;
        } else if (string.compareTo("CP8CHav") == 0) {
            n = 1;
        } else if (string.compareTo("correlCprob") == 0) {
            n = 1;
        } else if (string.compareTo("MAECprob") == 0) {
            n = 1;
        } else if (string.compareTo("MAE'Cprob") == 0) {
            n = 1;
        } else if (string.compareTo("wMAECProb") == 0) {
            n = 1;
        } else if (string.compareTo("wMAE'CProb") == 0) {
            n = 1;
        } else if (string.compareTo("CP4Cprob") == 0) {
            n = 1;
        } else if (string.compareTo("CP5Cprob") == 0) {
            n = 1;
        } else if (string.compareTo("CP8Cprob") == 0) {
            n = 1;
        } else if (string.compareTo("correlHprob") == 0) {
            n = 1;
        } else if (string.compareTo("MAEHprob") == 0) {
            n = 1;
        } else if (string.compareTo("MAE'Hprob") == 0) {
            n = 1;
        } else if (string.compareTo("wMAEHProb") == 0) {
            n = 1;
        } else if (string.compareTo("wMAE'HProb") == 0) {
            n = 1;
        } else if (string.compareTo("CP4Hprob") == 0) {
            n = 1;
        } else if (string.compareTo("CP5Hprob") == 0) {
            n = 1;
        } else if (string.compareTo("CP8Hprob") == 0) {
            n = 1;
        } else if (string.compareTo("correlMprob") == 0) {
            n = 1;
        } else if (string.compareTo("MAECHprob") == 0) {
            n = 1;
        } else if (string.compareTo("MAE'CHprob") == 0) {
            n = 1;
        } else if (string.compareTo("wMAEMProb") == 0) {
            n = 1;
        } else if (string.compareTo("wMAE'Mprob") == 0) {
            n = 1;
        } else if (string.compareTo("CP4CHprob") == 0) {
            n = 1;
        } else if (string.compareTo("CP5CHprob") == 0) {
            n = 1;
        } else if (string.compareTo("CP8CHprob") == 0) {
            n = 1;
        } else if (string.compareTo("correlNprob") == 0) {
            n = 1;
        } else if (string.compareTo("MAENprob") == 0) {
            n = 1;
        } else if (string.compareTo("MAE'Nprob") == 0) {
            n = 1;
        } else if (string.compareTo("wMAENProb") == 0) {
            n = 1;
        } else if (string.compareTo("wMAE'Nprob") == 0) {
            n = 1;
        } else if (string.compareTo("CP4Nprob") == 0) {
            n = 1;
        } else if (string.compareTo("CP5Nprob") == 0) {
            n = 1;
        } else if (string.compareTo("CP8Nprob") == 0) {
            n = 1;
        } else {
            throw new RuntimeException("whatsGood invalid parameter: " + string);
        }
        return n;
    }

    public static double getValueM(double d, double d2, String string) {
        double d3;
        if (string.compareTo("correl") == 0) {
            d3 = 1.0 - Math.sqrt((1.0 - d) * (1.0 - d2));
        } else if (string.compareTo("mae") == 0) {
            d3 = Math.sqrt(d * d2);
        } else if (string.compareTo("cmae") == 0) {
            d3 = Math.sqrt(d * d2);
        } else if (string.compareTo("wmae") == 0) {
            d3 = Math.sqrt(d * d2);
        } else if (string.compareTo("wcmae") == 0) {
            d3 = Math.sqrt(d * d2);
        } else if (string.compareTo("w2mae") == 0) {
            d3 = Math.sqrt(d * d2);
        } else if (string.compareTo("w2cmae") == 0) {
            d3 = Math.sqrt(d * d2);
        } else if (string.compareTo("rmse") == 0) {
            d3 = Math.sqrt(d * d2);
        } else if (string.compareTo("crmse") == 0) {
            d3 = Math.sqrt(d * d2);
        } else if (string.compareTo("fcmae") == 0) {
            d3 = Math.sqrt(d * d2);
        } else if (string.compareTo("wfcmae") == 0) {
            d3 = Math.sqrt(d * d2);
        } else if (string.compareTo("w2fcmae") == 0) {
            d3 = Math.sqrt(d * d2);
        } else if (string.compareTo("fcrmse") == 0) {
            d3 = Math.sqrt(d * d2);
        } else if (string.compareTo("dp2") == 0) {
            d3 = Math.sqrt(d * d2);
        } else if (string.compareTo("cpd") == 0) {
            d3 = 0.5 * (d + d2);
        } else if (string.compareTo("cpe") == 0) {
            d3 = 0.5 * (d + d2);
        } else if (string.compareTo("cph") == 0) {
            d3 = 0.5 * (d + d2);
        } else {
            throw new RuntimeException("Unknown parameter: " + string);
        }
        return d3;
    }

    public static String convertFileToLatexSr(String string, int n) {
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\\Sr{");
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(string.charAt(n2));
        }
        stringBuffer.append("}{");
        if (Character.isLetter(string.charAt(n2))) {
            if (Character.isUpperCase(string.charAt(n2))) {
                stringBuffer.append(Character.toLowerCase(string.charAt(n2)));
            } else {
                stringBuffer.append(string.charAt(n2));
            }
        } else {
            throw new RuntimeException("I don't understand this structure file: " + string + " (initialLetters=" + n);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static int factorial(int n) {
        if (n <= 1) {
            return 1;
        }
        return n * NMR.factorial(n - 1);
    }

    public static int nPr(int n, int n2) {
        int n3 = 1;
        int n4 = n - n2;
        while (n > n4) {
            n3 *= n;
            --n;
        }
        return n3;
    }

    public static int nCr(int n, int n2) {
        int n3 = NMR.nPr(n, n2) / NMR.factorial(n2);
        return n3;
    }

    public static int kDelta(int n, int n2) {
        if (n == n2) {
            return 1;
        }
        return 0;
    }
}

