/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import jregex.Bitset;
import jregex.UnicodeConstants;

class Block
implements UnicodeConstants {
    private boolean isFull;
    boolean[] bits;
    private boolean shared = false;
    private static final boolean[] EMPTY_BITS = new boolean[256];
    private static final boolean[] FULL_BITS = new boolean[256];

    Block() {
    }

    Block(boolean[] bits) {
        this.bits = bits;
        this.shared = true;
    }

    final boolean set(int c2) {
        if (this.isFull) {
            return false;
        }
        boolean[] bits = this.bits;
        if (bits == null) {
            this.bits = bits = new boolean[256];
            this.shared = false;
            bits[c2] = true;
            return true;
        }
        if (bits[c2]) {
            return false;
        }
        if (this.shared) {
            bits = Block.copyBits(this);
        }
        bits[c2] = true;
        return true;
    }

    final boolean get(int c2) {
        if (this.isFull) {
            return true;
        }
        boolean[] bits = this.bits;
        if (bits == null) {
            return false;
        }
        return bits[c2];
    }

    static final int add(Block[] targets, Block[] addends, int from, int to, boolean inv) {
        int s = 0;
        int i = from;
        while (i <= to) {
            block3: {
                Block target;
                Block addend;
                block5: {
                    block4: {
                        addend = addends[i];
                        if (addend != null ? addend.isFull && inv : !inv) break block3;
                        target = targets[i];
                        if (target != null) break block4;
                        targets[i] = target = new Block();
                        break block5;
                    }
                    if (target.isFull) break block3;
                }
                s += Block.add(target, addend, inv);
            }
            ++i;
        }
        return s;
    }

    private static final int add(Block target, Block addend, boolean inv) {
        if (addend == null) {
            if (!inv) {
                return 0;
            }
            int s = 256;
            boolean[] targetbits = target.bits;
            if (target.bits != null) {
                s -= Block.count(targetbits, 0, 255);
            }
            target.isFull = true;
            target.bits = null;
            target.shared = false;
            return s;
        }
        if (addend.isFull) {
            if (inv) {
                return 0;
            }
            int s = 256;
            boolean[] targetbits = target.bits;
            if (target.bits != null) {
                s -= Block.count(targetbits, 0, 255);
            }
            target.isFull = true;
            target.bits = null;
            target.shared = false;
            return s;
        }
        boolean[] addbits = addend.bits;
        if (addend.bits == null) {
            if (!inv) {
                return 0;
            }
            int s = 256;
            boolean[] targetbits = target.bits;
            if (target.bits != null) {
                s -= Block.count(targetbits, 0, 255);
            }
            target.isFull = true;
            target.bits = null;
            target.shared = false;
            return s;
        }
        boolean[] targetbits = target.bits;
        if (target.bits == null) {
            if (!inv) {
                target.bits = addbits;
                target.shared = true;
                return Block.count(addbits, 0, 255);
            }
            target.bits = targetbits = Block.emptyBits(null);
            target.shared = false;
            return Bitset.add(targetbits, addbits, 0, 255, inv);
        }
        if (target.shared) {
            targetbits = Block.copyBits(target);
        }
        return Bitset.add(targetbits, addbits, 0, 255, inv);
    }

    static final int subtract(Block[] targets, Block[] subtrahends, int from, int to, boolean inv) {
        int s = 0;
        int i = from;
        while (i <= to) {
            Block target = targets[i];
            if (target != null && (target.isFull || target.bits != null)) {
                Block subtrahend = subtrahends[i];
                if (subtrahend == null) {
                    if (inv) {
                        s = target.isFull ? (s -= 256) : (s -= Block.count(target.bits, 0, 255));
                        target.isFull = false;
                        target.bits = null;
                        target.shared = false;
                    }
                } else {
                    s += Block.subtract(target, subtrahend, inv);
                }
            }
            ++i;
        }
        return s;
    }

    private static final int subtract(Block target, Block subtrahend, boolean inv) {
        if (subtrahend.isFull) {
            if (inv) {
                return 0;
            }
            int s = 0;
            s = target.isFull ? 256 : Block.count(target.bits, 0, 255);
            target.isFull = false;
            target.bits = null;
            target.shared = false;
            return s;
        }
        boolean[] subbits = subtrahend.bits;
        if (subtrahend.bits == null) {
            if (!inv) {
                return 0;
            }
            int s = 0;
            s = target.isFull ? 256 : Block.count(target.bits, 0, 255);
            target.isFull = false;
            target.bits = null;
            target.shared = false;
            return s;
        }
        if (target.isFull) {
            boolean[] bits = Block.fullBits(target.bits);
            int s = Bitset.subtract(bits, subbits, 0, 255, inv);
            target.isFull = false;
            target.shared = false;
            target.bits = bits;
            return s;
        }
        boolean[] targetbits = target.shared ? Block.copyBits(target) : target.bits;
        return Bitset.subtract(targetbits, subbits, 0, 255, inv);
    }

    private static boolean[] copyBits(Block block) {
        boolean[] bits = new boolean[256];
        System.arraycopy(block.bits, 0, bits, 0, 256);
        block.bits = bits;
        block.shared = false;
        return bits;
    }

    private static boolean[] fullBits(boolean[] bits) {
        if (bits == null) {
            bits = new boolean[256];
        }
        System.arraycopy(FULL_BITS, 0, bits, 0, 256);
        return bits;
    }

    private static boolean[] emptyBits(boolean[] bits) {
        if (bits == null) {
            bits = new boolean[256];
        } else {
            System.arraycopy(EMPTY_BITS, 0, bits, 0, 256);
        }
        return bits;
    }

    static final int count(boolean[] arr, int from, int to) {
        int s = 0;
        int i = from;
        while (i <= to) {
            if (arr[i]) {
                ++s;
            }
            ++i;
        }
        return s;
    }

    static final boolean[][] toBitset2(Block[] blocks) {
        int len = blocks.length;
        boolean[][] result = new boolean[len][];
        int i = 0;
        while (i < len) {
            Block block = blocks[i];
            if (block != null) {
                result[i] = block.isFull ? FULL_BITS : block.bits;
            }
            ++i;
        }
        return result;
    }

    static {
        int i = 0;
        while (i < 256) {
            Block.FULL_BITS[i] = true;
            ++i;
        }
    }
}

