/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import jregex.Pattern;
import jregex.PatternSyntaxException;

public class WildcardPattern
extends Pattern {
    public static final String WORD_CHAR = "\\w";
    public static final String ANY_CHAR = ".";
    private static final String defaultSpecials = "[]().{}+|^$\\";
    private static final String defaultWcClass = ".";
    private String str;

    protected static String convertSpecials(String s, String wcClass, String specials) {
        int len = s.length();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            char c2 = s.charAt(i);
            switch (c2) {
                case '*': {
                    sb.append("(");
                    sb.append(wcClass);
                    sb.append("*)");
                    break;
                }
                case '?': {
                    sb.append("(");
                    sb.append(wcClass);
                    sb.append(")");
                    break;
                }
                default: {
                    if (specials.indexOf(c2) >= 0) {
                        sb.append('\\');
                    }
                    sb.append(c2);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public WildcardPattern(String wc) {
        this(wc, true);
    }

    public WildcardPattern(String wc, boolean icase) {
        this(wc, icase ? 1 : 0);
    }

    public WildcardPattern(String wc, int flags) {
        this.compile(wc, ".", defaultSpecials, flags);
    }

    public WildcardPattern(String wc, String wcClass, int flags) {
        this.compile(wc, wcClass, defaultSpecials, flags);
    }

    protected WildcardPattern() {
    }

    protected void compile(String wc, String wcClass, String specials, int flags) {
        String converted = WildcardPattern.convertSpecials(wc, wcClass, specials);
        try {
            this.compile(converted, flags);
        }
        catch (PatternSyntaxException e2) {
            throw new Error(e2.getMessage() + "; original expr: " + wc + ", converted: " + converted);
        }
        this.str = wc;
    }

    public String toString() {
        return this.str;
    }
}

