/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Color;
import org.apache.batik.ext.awt.image.AbstractLight;

public class SpotLight
extends AbstractLight {
    private double lightX;
    private double lightY;
    private double lightZ;
    private double pointAtX;
    private double pointAtY;
    private double pointAtZ;
    private double specularExponent;
    private double limitingConeAngle;
    private double limitingCos;
    private final double[] S = new double[3];

    public double getLightX() {
        return this.lightX;
    }

    public double getLightY() {
        return this.lightY;
    }

    public double getLightZ() {
        return this.lightZ;
    }

    public double getPointAtX() {
        return this.pointAtX;
    }

    public double getPointAtY() {
        return this.pointAtY;
    }

    public double getPointAtZ() {
        return this.pointAtZ;
    }

    public double getSpecularExponent() {
        return this.specularExponent;
    }

    public double getLimitingConeAngle() {
        return this.limitingConeAngle;
    }

    public SpotLight(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Color color) {
        super(color);
        this.lightX = d2;
        this.lightY = d3;
        this.lightZ = d4;
        this.pointAtX = d5;
        this.pointAtY = d6;
        this.pointAtZ = d7;
        this.specularExponent = d8;
        this.limitingConeAngle = d9;
        this.limitingCos = Math.cos(d9 * Math.PI / 180.0);
        this.S[0] = d5 - d2;
        this.S[1] = d6 - d3;
        this.S[2] = d7 - d4;
        double d10 = Math.sqrt(this.S[0] * this.S[0] + this.S[1] * this.S[1] + this.S[2] * this.S[2]);
        this.S[0] = this.S[0] / d10;
        this.S[1] = this.S[1] / d10;
        this.S[2] = this.S[2] / d10;
    }

    public boolean isConstant() {
        return false;
    }

    public final void getLight(double d2, double d3, double d4, double[] dArray) {
        dArray[0] = this.lightX - d2;
        dArray[1] = this.lightY - d3;
        dArray[2] = this.lightZ - d4;
        double d5 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        dArray[0] = dArray[0] / d5;
        dArray[1] = dArray[1] / d5;
        dArray[2] = dArray[2] / d5;
        double d6 = -(dArray[0] * this.S[0] + dArray[1] * this.S[1] + dArray[2] * this.S[2]);
        if (d6 > this.limitingCos) {
            double d7 = this.limitingCos / d6;
            d7 *= d7;
            d7 *= d7;
            d7 *= d7;
            d7 *= d7;
            d7 *= d7;
            d7 *= d7;
            d7 = 1.0 - d7;
            d6 = d7 * Math.pow(d6, this.specularExponent);
            dArray[0] = dArray[0] * d6;
            dArray[1] = dArray[1] * d6;
            dArray[2] = dArray[2] * d6;
        } else {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
        }
    }
}

