/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.util.List;
import org.apache.batik.ext.awt.image.ARGBChannel;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.AbstractColorInterpolationRable;
import org.apache.batik.ext.awt.image.renderable.DisplacementMapRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.DisplacementMapRed;

public class DisplacementMapRable8Bit
extends AbstractColorInterpolationRable
implements DisplacementMapRable {
    private double scale;
    private ARGBChannel xChannelSelector;
    private ARGBChannel yChannelSelector;

    public DisplacementMapRable8Bit(List list, double d2, ARGBChannel aRGBChannel, ARGBChannel aRGBChannel2) {
        this.setSources(list);
        this.setScale(d2);
        this.setXChannelSelector(aRGBChannel);
        this.setYChannelSelector(aRGBChannel2);
    }

    public Rectangle2D getBounds2D() {
        return ((Filter)this.getSources().elementAt(0)).getBounds2D();
    }

    public void setScale(double d2) {
        this.touch();
        this.scale = d2;
    }

    public double getScale() {
        return this.scale;
    }

    public void setSources(List list) {
        if (list.size() != 2) {
            throw new IllegalArgumentException();
        }
        this.init(list, null);
    }

    public void setXChannelSelector(ARGBChannel aRGBChannel) {
        if (aRGBChannel == null) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.xChannelSelector = aRGBChannel;
    }

    public ARGBChannel getXChannelSelector() {
        return this.xChannelSelector;
    }

    public void setYChannelSelector(ARGBChannel aRGBChannel) {
        if (aRGBChannel == null) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.yChannelSelector = aRGBChannel;
    }

    public ARGBChannel getYChannelSelector() {
        return this.yChannelSelector;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Rectangle2D rectangle2D;
        Rectangle2D rectangle2D2;
        RenderContext renderContext2;
        RenderedImage renderedImage;
        Filter filter = (Filter)this.getSources().elementAt(0);
        Filter filter2 = (Filter)this.getSources().elementAt(1);
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        AffineTransform affineTransform = renderContext.getTransform();
        double d2 = affineTransform.getScaleX();
        double d3 = affineTransform.getScaleY();
        double d4 = affineTransform.getShearX();
        double d5 = affineTransform.getShearY();
        double d6 = affineTransform.getTranslateX();
        double d7 = affineTransform.getTranslateY();
        double d8 = Math.sqrt(d2 * d2 + d5 * d5);
        double d9 = Math.sqrt(d3 * d3 + d4 * d4);
        float f = (float)(this.scale * d8);
        float f2 = (float)(this.scale * d9);
        if (f == 0.0f && f2 == 0.0f) {
            return filter.createRendering(renderContext);
        }
        AffineTransform affineTransform2 = AffineTransform.getScaleInstance(d8, d9);
        Shape shape = renderContext.getAreaOfInterest();
        if (shape == null) {
            shape = this.getBounds2D();
        }
        if ((renderedImage = filter2.createRendering(renderContext2 = new RenderContext(affineTransform2, rectangle2D2 = shape.getBounds2D(), renderingHints))) == null) {
            return null;
        }
        if (!(rectangle2D2 = new Rectangle2D.Double(rectangle2D2.getX() - this.scale / 2.0, rectangle2D2.getY() - this.scale / 2.0, rectangle2D2.getWidth() + this.scale, rectangle2D2.getHeight() + this.scale)).intersects(rectangle2D = filter.getBounds2D())) {
            return null;
        }
        renderContext2 = new RenderContext(affineTransform2, rectangle2D2 = rectangle2D2.createIntersection(rectangle2D), renderingHints);
        RenderedImage renderedImage2 = filter.createRendering(renderContext2);
        if (renderedImage2 == null) {
            return null;
        }
        renderedImage = this.convertSourceCS(renderedImage);
        AbstractRed abstractRed = new DisplacementMapRed(GraphicsUtil.wrap(renderedImage2), GraphicsUtil.wrap(renderedImage), this.xChannelSelector, this.yChannelSelector, f, f2, renderingHints);
        AffineTransform affineTransform3 = new AffineTransform(d2 / d8, d5 / d8, d4 / d9, d3 / d9, d6, d7);
        if (!affineTransform3.isIdentity()) {
            abstractRed = new AffineRed((CachableRed)abstractRed, affineTransform3, renderingHints);
        }
        return abstractRed;
    }

    public Shape getDependencyRegion(int n, Rectangle2D rectangle2D) {
        return super.getDependencyRegion(n, rectangle2D);
    }

    public Shape getDirtyRegion(int n, Rectangle2D rectangle2D) {
        return super.getDirtyRegion(n, rectangle2D);
    }
}

