/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.Light;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.BumpMap;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class DiffuseLightingRed
extends AbstractRed {
    private double kd;
    private Light light;
    private BumpMap bumpMap;
    private double scaleX;
    private double scaleY;
    private Rectangle litRegion;
    private boolean linear;

    public DiffuseLightingRed(double d2, Light light, BumpMap bumpMap, Rectangle rectangle, double d3, double d4, boolean bl) {
        this.kd = d2;
        this.light = light;
        this.bumpMap = bumpMap;
        this.litRegion = rectangle;
        this.scaleX = d3;
        this.scaleY = d4;
        this.linear = bl;
        ColorModel colorModel = bl ? GraphicsUtil.Linear_sRGB_Pre : GraphicsUtil.sRGB_Pre;
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(rectangle.width, rectangle.height);
        this.init((CachableRed)null, rectangle, colorModel, sampleModel, rectangle.x, rectangle.y, null);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        double[] dArray = this.light.getColor(this.linear);
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getMinX();
        int n4 = writableRaster.getMinY();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n5 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n3 - writableRaster.getSampleModelTranslateX(), n4 - writableRaster.getSampleModelTranslateY());
        int n6 = singlePixelPackedSampleModel.getScanlineStride();
        int n7 = n6 - n;
        int n8 = n5;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        double d2 = this.scaleX * (double)n3;
        double d3 = this.scaleY * (double)n4;
        double d4 = 0.0;
        double[][][] dArray2 = this.bumpMap.getNormalArray(n3, n4, n, n2);
        if (!this.light.isConstant()) {
            double[][] dArray3 = new double[n][3];
            n12 = 0;
            while (n12 < n2) {
                double[][] dArray4 = dArray2[n12];
                this.light.getLightRow(d2, d3 + (double)n12 * this.scaleY, this.scaleX, n, dArray4, dArray3);
                n13 = 0;
                while (n13 < n) {
                    double[] dArray5 = dArray4[n13];
                    double[] dArray6 = dArray3[n13];
                    d4 = 255.0 * this.kd * (dArray5[0] * dArray6[0] + dArray5[1] * dArray6[1] + dArray5[2] * dArray6[2]);
                    n9 = (int)(d4 * dArray[0]);
                    n10 = (int)(d4 * dArray[1]);
                    n11 = (int)(d4 * dArray[2]);
                    if ((n9 & 0xFFFFFF00) != 0) {
                        int n14 = n9 = (n9 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((n10 & 0xFFFFFF00) != 0) {
                        int n15 = n10 = (n10 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((n11 & 0xFFFFFF00) != 0) {
                        n11 = (n11 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    nArray[n8++] = 0xFF000000 | n9 << 16 | n10 << 8 | n11;
                    ++n13;
                }
                n8 += n7;
                ++n12;
            }
        } else {
            double[] dArray7 = new double[3];
            this.light.getLight(0.0, 0.0, 0.0, dArray7);
            n12 = 0;
            while (n12 < n2) {
                double[][] dArray8 = dArray2[n12];
                n13 = 0;
                while (n13 < n) {
                    double[] dArray9 = dArray8[n13];
                    d4 = 255.0 * this.kd * (dArray9[0] * dArray7[0] + dArray9[1] * dArray7[1] + dArray9[2] * dArray7[2]);
                    n9 = (int)(d4 * dArray[0]);
                    n10 = (int)(d4 * dArray[1]);
                    n11 = (int)(d4 * dArray[2]);
                    if ((n9 & 0xFFFFFF00) != 0) {
                        int n16 = n9 = (n9 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((n10 & 0xFFFFFF00) != 0) {
                        int n17 = n10 = (n10 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((n11 & 0xFFFFFF00) != 0) {
                        n11 = (n11 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    nArray[n8++] = 0xFF000000 | n9 << 16 | n10 << 8 | n11;
                    ++n13;
                }
                n8 += n7;
                ++n12;
            }
        }
        return writableRaster;
    }
}

