/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.ErrorConstants;
import org.apache.batik.svggen.GenericImageHandler;
import org.apache.batik.svggen.ImageHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGSyntax;
import org.w3c.dom.Element;

public class SimpleImageHandler
implements GenericImageHandler,
SVGSyntax,
ErrorConstants {
    static final String XLINK_NAMESPACE_URI = "http://www.w3.org/1999/xlink";
    protected ImageHandler imageHandler;

    public SimpleImageHandler(ImageHandler imageHandler) {
        if (imageHandler == null) {
            throw new IllegalArgumentException();
        }
        this.imageHandler = imageHandler;
    }

    public void setDOMTreeManager(DOMTreeManager dOMTreeManager) {
    }

    public Element createElement(SVGGeneratorContext sVGGeneratorContext) {
        Element element = sVGGeneratorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "image");
        return element;
    }

    public AffineTransform handleImage(Image image, Element element, int n, int n2, int n3, int n4, SVGGeneratorContext sVGGeneratorContext) {
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        Object var10_10 = null;
        if (n5 == 0 || n6 == 0 || n3 == 0 || n4 == 0) {
            this.handleEmptyImage(element);
        } else {
            this.imageHandler.handleImage(image, element, sVGGeneratorContext);
            this.setImageAttributes(element, n, n2, n3, n4, sVGGeneratorContext);
        }
        return null;
    }

    public AffineTransform handleImage(RenderedImage renderedImage, Element element, int n, int n2, int n3, int n4, SVGGeneratorContext sVGGeneratorContext) {
        int n5 = renderedImage.getWidth();
        int n6 = renderedImage.getHeight();
        Object var10_10 = null;
        if (n5 == 0 || n6 == 0 || n3 == 0 || n4 == 0) {
            this.handleEmptyImage(element);
        } else {
            this.imageHandler.handleImage(renderedImage, element, sVGGeneratorContext);
            this.setImageAttributes(element, n, n2, n3, n4, sVGGeneratorContext);
        }
        return null;
    }

    public AffineTransform handleImage(RenderableImage renderableImage, Element element, double d2, double d3, double d4, double d5, SVGGeneratorContext sVGGeneratorContext) {
        double d6 = renderableImage.getWidth();
        double d7 = renderableImage.getHeight();
        Object var16_10 = null;
        if (d6 == 0.0 || d7 == 0.0 || d4 == 0.0 || d5 == 0.0) {
            this.handleEmptyImage(element);
        } else {
            this.imageHandler.handleImage(renderableImage, element, sVGGeneratorContext);
            this.setImageAttributes(element, d2, d3, d4, d5, sVGGeneratorContext);
        }
        return null;
    }

    protected void setImageAttributes(Element element, double d2, double d3, double d4, double d5, SVGGeneratorContext sVGGeneratorContext) {
        element.setAttributeNS(null, "x", sVGGeneratorContext.doubleString(d2));
        element.setAttributeNS(null, "y", sVGGeneratorContext.doubleString(d3));
        element.setAttributeNS(null, "width", sVGGeneratorContext.doubleString(d4));
        element.setAttributeNS(null, "height", sVGGeneratorContext.doubleString(d5));
        element.setAttributeNS(null, "preserveAspectRatio", "none");
    }

    protected void handleEmptyImage(Element element) {
        element.setAttributeNS(XLINK_NAMESPACE_URI, "xlink:href", "");
        element.setAttributeNS(null, "width", "0");
        element.setAttributeNS(null, "height", "0");
    }
}

