/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import java.awt.Color;
import jregex.Matcher;
import jregex.Pattern;
import uk.ac.cam.ch.oscar.DataInterface;

public class BPData
implements DataInterface {
    private boolean defined = false;
    private String blockdata = "";
    private String propDeleteProlog = "";
    private boolean propDeletePrologDefined = false;
    private String propbp_TempPoint = "";
    private boolean propbp_TempPointDefined = false;
    private String propbp_TempLower = "";
    private boolean propbp_TempLowerDefined = false;
    private String propbp_TempUpper = "";
    private boolean propbp_TempUpperDefined = false;
    private String propbp_Pressure = "";
    private boolean propbp_PressureDefined = false;

    public String Parse(String inputtext) {
        Pattern re = new Pattern("\t\t\t\t\\b b\\.?p\\.? \\W+?\t\t\t\t(\t\t\t\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t\\s*[\u2013\\-\\?]\\s*\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t\t\t|\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t) \\s*.C\t\t\t\t(\t\\W+?\t\t\t\t\t(?:at\\W+?)?\t\t\t\t\t\t\t\t(\t\t\t\t(?:\t\t\t\t\t\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t\t\t\t\t|\t\\d+ \\s*[x\u00d7]\\s* 10[\u2013\\-\\?] \\d+\t\t\t\t)\t\t\t\t\\s* (?: mmHg|Torr|mbar )\t\t\t)\t\t\t\t\t\t)?\t\t\t", 9);
        Matcher m = re.matcher(inputtext);
        this.defined = m.find();
        if (this.defined) {
            this.blockdata = m.group(0);
            int p0 = inputtext.indexOf(this.blockdata);
            inputtext = inputtext.substring(0, p0) + inputtext.substring(p0 + this.blockdata.length(), inputtext.length());
            this.breakUp(this.blockdata);
        } else {
            this.blockdata = "";
        }
        return inputtext;
    }

    public String getBlock() {
        return this.blockdata;
    }

    public Color getColor() {
        return new Color(255, 128, 0);
    }

    public String getSummary() {
        String out = "Boiling Point";
        return out;
    }

    public String getDetails() {
        String out = "";
        if (this.defined) {
            out = out + "Boiling Point:\n";
            if (this.propbp_TempLowerDefined) {
                out = out + "   Range: " + this.propbp_TempLower + " - " + this.propbp_TempUpper + " \u00b0C\n";
            }
            if (this.propbp_TempPointDefined) {
                out = out + "   Single point: " + this.propbp_TempPoint + " \u00b0C\n";
            }
            if (this.propbp_PressureDefined) {
                out = out + "   Pressure: " + this.propbp_Pressure + "\n";
            }
            out = out + "\n";
        }
        return out;
    }

    public String getDetailsHTML() {
        if (!this.defined) {
            return "";
        }
        String out = "<h3>";
        out = out + "<a name=\"Boiling Point\"></a>";
        out = out + "Boiling Point</h3>";
        out = out + "<ul>";
        if (this.propbp_TempLowerDefined) {
            out = out + "<li><b>Range:</b> " + this.propbp_TempLower + " - " + this.propbp_TempUpper + " \u00b0C";
        }
        if (this.propbp_TempPointDefined) {
            out = out + "<li><b>Single point:</b> " + this.propbp_TempPoint + " \u00b0C";
        }
        if (this.propbp_PressureDefined) {
            out = out + "<li><b>Pressure:</b> " + this.propbp_Pressure + "";
        }
        out = out + "</ul>";
        return out;
    }

    public String getXML() {
        if (!this.defined) {
            return "";
        }
        String out = "      <data class=\"bp\" type=\"property\">\n";
        if (this.propbp_TempPointDefined) {
            out = out + "         <value id=\"temppoint\">" + this.propbp_TempPoint + "</value>\n";
        }
        if (this.propbp_TempLowerDefined) {
            out = out + "         <value id=\"templower\">" + this.propbp_TempLower + "</value>\n";
        }
        if (this.propbp_TempUpperDefined) {
            out = out + "         <value id=\"tempupper\">" + this.propbp_TempUpper + "</value>\n";
        }
        if (this.propbp_PressureDefined) {
            out = out + "         <value id=\"pressure\">" + this.propbp_Pressure + "</value>\n";
        }
        out = out + "      </data>\n";
        return out;
    }

    public boolean isSet() {
        return this.defined;
    }

    private void breakUp(String data) {
        data = this.matchDeleteProlog(data);
        data = this.matchbp_TempPoint(data);
        data = this.matchbp_TempLower(data);
        data = this.matchbp_TempUpper(data);
        data = this.matchbp_Pressure(data);
    }

    private String matchDeleteProlog(String data) {
        boolean found = false;
        Pattern re = new Pattern("^([^\\d\u2013\\-\\?]*)", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propDeleteProlog = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propDeleteProlog = "";
        }
        this.propDeletePrologDefined = found;
        if (this.propDeleteProlog == "") {
            this.propDeletePrologDefined = false;
        }
        if (this.propDeleteProlog == null) {
            this.propDeletePrologDefined = false;
            this.propDeleteProlog = "";
        }
        return data;
    }

    public boolean isDeletePrologDefined() {
        return this.propDeletePrologDefined;
    }

    public String getDeleteProlog() {
        return this.propDeleteProlog;
    }

    private String matchbp_TempPoint(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t^\\s*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\\s*(?![\u2013\\-\\?]|\\.\\d)\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propbp_TempPoint = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propbp_TempPoint = "";
        }
        this.propbp_TempPointDefined = found;
        if (this.propbp_TempPoint == "") {
            this.propbp_TempPointDefined = false;
        }
        if (this.propbp_TempPoint == null) {
            this.propbp_TempPointDefined = false;
            this.propbp_TempPoint = "";
        }
        return data;
    }

    public boolean isbp_TempPointDefined() {
        return this.propbp_TempPointDefined;
    }

    public String getbp_TempPoint() {
        return this.propbp_TempPoint;
    }

    private String matchbp_TempLower(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t^\\s*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\\s*(?=[\u2013\\-\\?])\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propbp_TempLower = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propbp_TempLower = "";
        }
        this.propbp_TempLowerDefined = found;
        if (this.propbp_TempLower == "") {
            this.propbp_TempLowerDefined = false;
        }
        if (this.propbp_TempLower == null) {
            this.propbp_TempLowerDefined = false;
            this.propbp_TempLower = "";
        }
        return data;
    }

    public boolean isbp_TempLowerDefined() {
        return this.propbp_TempLowerDefined;
    }

    public String getbp_TempLower() {
        return this.propbp_TempLower;
    }

    private String matchbp_TempUpper(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t^\\s*[\u2013\\-\\?]\\s*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propbp_TempUpper = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propbp_TempUpper = "";
        }
        this.propbp_TempUpperDefined = found;
        if (this.propbp_TempUpper == "") {
            this.propbp_TempUpperDefined = false;
        }
        if (this.propbp_TempUpper == null) {
            this.propbp_TempUpperDefined = false;
            this.propbp_TempUpper = "";
        }
        return data;
    }

    public boolean isbp_TempUpperDefined() {
        return this.propbp_TempUpperDefined;
    }

    public String getbp_TempUpper() {
        return this.propbp_TempUpper;
    }

    private String matchbp_Pressure(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t(\t\t\t\t(?:\t\t\t\t\t\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t\t\t\t\t|\t\\d+ \\s*[x\u00d7]\\s* 10[\u2013\\-\\?] \\d+\t\t\t\t)\t\t\t\t\\s* (?: mmHg|Torr|mbar )\t\t\t)\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propbp_Pressure = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propbp_Pressure = "";
        }
        this.propbp_PressureDefined = found;
        if (this.propbp_Pressure == "") {
            this.propbp_PressureDefined = false;
        }
        if (this.propbp_Pressure == null) {
            this.propbp_PressureDefined = false;
            this.propbp_Pressure = "";
        }
        return data;
    }

    public boolean isbp_PressureDefined() {
        return this.propbp_PressureDefined;
    }

    public String getbp_Pressure() {
        return this.propbp_Pressure;
    }
}

