/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import jregex.Matcher;
import jregex.Pattern;
import uk.ac.cam.ch.oscar.DataPointInterface;
import uk.ac.cam.ch.oscar.Tools;

public class IRPeakData
implements DataPointInterface {
    private boolean defined = false;
    private String blockdata = "";
    private IRPeakData nextPeak = null;
    private String propir_vmaxPoint = "";
    private boolean propir_vmaxPointDefined = false;
    private String propir_vmaxLower = "";
    private boolean propir_vmaxLowerDefined = false;
    private String propir_vmaxUpper = "";
    private boolean propir_vmaxUpperDefined = false;
    private String propir_PeakType = "";
    private boolean propir_PeakTypeDefined = false;
    private String propir_Comment = "";
    private boolean propir_CommentDefined = false;

    public void Parse(String inputtext) {
        this.breakUp(inputtext);
        this.defined = true;
    }

    public String getDetails() {
        String out = "";
        if (this.defined) {
            out = out + "   ";
            if (this.propir_vmaxPointDefined) {
                out = out + "" + this.propir_vmaxPoint + "";
            }
            out = out + "";
            if (this.propir_vmaxLowerDefined) {
                out = out + "" + this.propir_vmaxLower + " - " + this.propir_vmaxUpper + "";
            }
            out = out + " cm-1";
            if (this.propir_PeakTypeDefined) {
                out = out + " (" + this.propir_PeakType + ")";
            }
            out = out + "";
            if (this.propir_CommentDefined) {
                out = out + " " + this.propir_Comment + "";
            }
            out = out + "\n";
        }
        return out;
    }

    public String getDetailsHTML() {
        String out = "";
        if (this.defined) {
            out = out + "<tr><td>";
            if (this.propir_vmaxPointDefined) {
                out = out + "" + this.propir_vmaxPoint + "";
            }
            out = out + "";
            if (this.propir_vmaxLowerDefined) {
                out = out + "" + this.propir_vmaxLower + " - " + this.propir_vmaxUpper + "";
            }
            out = out + "</td><td>" + this.propir_PeakType + "</td><td>" + this.propir_Comment + "</td></tr>";
        }
        return out;
    }

    public String getXML() {
        if (!this.defined) {
            return "";
        }
        String out = "         <peak>\n";
        if (this.propir_vmaxPointDefined) {
            out = out + "            <value id=\"vmaxpoint\">" + this.propir_vmaxPoint + "</value>\n";
        }
        if (this.propir_vmaxLowerDefined) {
            out = out + "            <value id=\"vmaxlower\">" + this.propir_vmaxLower + "</value>\n";
        }
        if (this.propir_vmaxUpperDefined) {
            out = out + "            <value id=\"vmaxupper\">" + this.propir_vmaxUpper + "</value>\n";
        }
        if (this.propir_PeakTypeDefined) {
            out = out + "            <value id=\"sigtype\">" + this.propir_PeakType + "</value>\n";
        }
        if (this.propir_CommentDefined) {
            out = out + "            <value id=\"comment\">" + this.propir_Comment + "</value>\n";
        }
        out = out + "         </peak>\n";
        return out;
    }

    public boolean isSet() {
        return this.defined;
    }

    private void breakUp(String data) {
        data = this.matchir_vmaxPoint(data);
        data = this.matchir_vmaxLower(data);
        data = this.matchir_vmaxUpper(data);
        data = this.matchir_PeakType(data);
        data = this.matchir_Comment(data);
    }

    public void setNextPeak(IRPeakData thePeak) {
        this.nextPeak = thePeak;
    }

    public IRPeakData getNextPeak() {
        return this.nextPeak;
    }

    private String matchir_vmaxPoint(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t^\\s*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\\s*(?![\u2013\\-\\?]|\\.\\d)\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propir_vmaxPoint = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propir_vmaxPoint = "";
        }
        this.propir_vmaxPointDefined = found;
        if (this.propir_vmaxPoint == "") {
            this.propir_vmaxPointDefined = false;
        }
        if (this.propir_vmaxPoint == null) {
            this.propir_vmaxPointDefined = false;
            this.propir_vmaxPoint = "";
        }
        return data;
    }

    public boolean isir_vmaxPointDefined() {
        return this.propir_vmaxPointDefined;
    }

    public String getir_vmaxPoint() {
        return this.propir_vmaxPoint;
    }

    private String matchir_vmaxLower(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t^\\s*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\\s*(?=[\u2013\\-\\?])\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propir_vmaxLower = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propir_vmaxLower = "";
        }
        this.propir_vmaxLowerDefined = found;
        if (this.propir_vmaxLower == "") {
            this.propir_vmaxLowerDefined = false;
        }
        if (this.propir_vmaxLower == null) {
            this.propir_vmaxLowerDefined = false;
            this.propir_vmaxLower = "";
        }
        return data;
    }

    public boolean isir_vmaxLowerDefined() {
        return this.propir_vmaxLowerDefined;
    }

    public String getir_vmaxLower() {
        return this.propir_vmaxLower;
    }

    private String matchir_vmaxUpper(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t^\\s*[\u2013\\-\\?]\\s*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propir_vmaxUpper = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propir_vmaxUpper = "";
        }
        this.propir_vmaxUpperDefined = found;
        if (this.propir_vmaxUpper == "") {
            this.propir_vmaxUpperDefined = false;
        }
        if (this.propir_vmaxUpper == null) {
            this.propir_vmaxUpperDefined = false;
            this.propir_vmaxUpper = "";
        }
        return data;
    }

    public boolean isir_vmaxUpperDefined() {
        return this.propir_vmaxUpperDefined;
    }

    public String getir_vmaxUpper() {
        return this.propir_vmaxUpper;
    }

    private String matchir_PeakType(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\<( (?:(?:s|vs|m|w|b|br|sh) [\\s,]*? )+ )\\> \\.?", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propir_PeakType = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propir_PeakType = "";
        }
        this.propir_PeakTypeDefined = found;
        if (this.propir_PeakType == "") {
            this.propir_PeakTypeDefined = false;
        }
        if (this.propir_PeakType == null) {
            this.propir_PeakTypeDefined = false;
            this.propir_PeakType = "";
        }
        return data;
    }

    public boolean isir_PeakTypeDefined() {
        return this.propir_PeakTypeDefined;
    }

    public String getir_PeakType() {
        return this.propir_PeakType;
    }

    private String matchir_Comment(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\( [\\s,]* (.*) \\s* \\)", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propir_Comment = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propir_Comment = "";
        }
        this.propir_CommentDefined = found;
        if (this.propir_Comment == "") {
            this.propir_CommentDefined = false;
        }
        if (this.propir_Comment == null) {
            this.propir_CommentDefined = false;
            this.propir_Comment = "";
        }
        return data;
    }

    public boolean isir_CommentDefined() {
        return this.propir_CommentDefined;
    }

    public String getir_Comment() {
        return this.propir_Comment;
    }

    public float getX() {
        if (this.isir_vmaxPointDefined()) {
            return Float.valueOf(this.getir_vmaxPoint()).floatValue();
        }
        if (this.isir_vmaxUpperDefined() & this.isir_vmaxLowerDefined()) {
            return (Float.valueOf(this.getir_vmaxLower()).floatValue() + Float.valueOf(this.getir_vmaxUpper()).floatValue()) / 2.0f;
        }
        return 0.0f;
    }

    public float getHeight() {
        if (Tools.SearchExp("\\bs\\b", this.getir_PeakType())) {
            return 0.6f;
        }
        if (Tools.SearchExp("\\bvs\\b", this.getir_PeakType())) {
            return 0.8f;
        }
        if (Tools.SearchExp("\\bm\\b", this.getir_PeakType())) {
            return 0.4f;
        }
        if (Tools.SearchExp("\\bw\\b", this.getir_PeakType())) {
            return 0.2f;
        }
        return 0.6f;
    }

    public float getWidth() {
        if (Tools.SearchExp("\\bb\\b", this.getir_PeakType())) {
            return 100.0f;
        }
        if (Tools.SearchExp("\\bbr\\b", this.getir_PeakType())) {
            return 100.0f;
        }
        if (Tools.SearchExp("\\bsh\\b", this.getir_PeakType())) {
            return 10.0f;
        }
        return 30.0f;
    }

    public int getType() {
        return 2;
    }

    public String getAnnotation() {
        return this.getir_Comment();
    }
}

