/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import java.awt.Color;
import jregex.Matcher;
import jregex.Pattern;
import uk.ac.cam.ch.oscar.DataInterface;

public class RFData
implements DataInterface {
    private boolean defined = false;
    private String blockdata = "";
    private String proprf_Solvent = "";
    private boolean proprf_SolventDefined = false;
    private String proprf_Value = "";
    private boolean proprf_ValueDefined = false;

    public String Parse(String inputtext) {
        Pattern re = new Pattern("\t\t\t\t\\b(Rf|TLC) \\s*[:=,]?\\s*  \t\t\t\t(?:\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t \\s*[:=,]?\\s* )?\t\t\t\t(?: [\\s,]*? \t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t )+\t\t\t\t(?:\t\\s* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t )?\t\t\t", 9);
        Matcher m = re.matcher(inputtext);
        this.defined = m.find();
        if (this.defined) {
            this.blockdata = m.group(0);
            int p0 = inputtext.indexOf(this.blockdata);
            inputtext = inputtext.substring(0, p0) + inputtext.substring(p0 + this.blockdata.length(), inputtext.length());
            this.breakUp(this.blockdata);
        } else {
            this.blockdata = "";
        }
        return inputtext;
    }

    public String getBlock() {
        return this.blockdata;
    }

    public Color getColor() {
        return new Color(255, 128, 128);
    }

    public String getSummary() {
        String out = "Rf";
        return out;
    }

    public String getDetails() {
        String out = "";
        if (this.defined) {
            out = out + "Rf:\n";
            if (this.proprf_ValueDefined) {
                out = out + "   Value: " + this.proprf_Value + "\n";
            }
            if (this.proprf_SolventDefined) {
                out = out + "   Solvent mix: " + this.proprf_Solvent + "\n";
            }
            out = out + "\n";
        }
        return out;
    }

    public String getDetailsHTML() {
        if (!this.defined) {
            return "";
        }
        String out = "<h3>";
        out = out + "<a name=\"Rf\"></a>";
        out = out + "Rf</h3>";
        out = out + "<ul>";
        if (this.proprf_ValueDefined) {
            out = out + "<li><b>Value:</b> " + this.proprf_Value + "";
        }
        if (this.proprf_SolventDefined) {
            out = out + "<li><b>Solvent mix:</b> " + this.proprf_Solvent + "";
        }
        out = out + "</ul>";
        return out;
    }

    public String getXML() {
        if (!this.defined) {
            return "";
        }
        String out = "      <data class=\"rf\" type=\"property\">\n";
        if (this.proprf_SolventDefined) {
            out = out + "         <value id=\"solvent\">" + this.proprf_Solvent + "</value>\n";
        }
        if (this.proprf_ValueDefined) {
            out = out + "         <value id=\"value\">" + this.proprf_Value + "</value>\n";
        }
        out = out + "      </data>\n";
        return out;
    }

    public boolean isSet() {
        return this.defined;
    }

    private void breakUp(String data) {
        data = this.matchrf_Solvent(data);
        data = this.matchrf_Value(data);
    }

    private String matchrf_Solvent(String data) {
        boolean found = false;
        Pattern re = new Pattern("(\\(.*?\\)|\\[.*?\\])", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.proprf_Solvent = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.proprf_Solvent = "";
        }
        this.proprf_SolventDefined = found;
        if (this.proprf_Solvent == "") {
            this.proprf_SolventDefined = false;
        }
        if (this.proprf_Solvent == null) {
            this.proprf_SolventDefined = false;
            this.proprf_Solvent = "";
        }
        return data;
    }

    public boolean isrf_SolventDefined() {
        return this.proprf_SolventDefined;
    }

    public String getrf_Solvent() {
        return this.proprf_Solvent;
    }

    private String matchrf_Value(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\b([\\s,]*?\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)+\\b", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.proprf_Value = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.proprf_Value = "";
        }
        this.proprf_ValueDefined = found;
        if (this.proprf_Value == "") {
            this.proprf_ValueDefined = false;
        }
        if (this.proprf_Value == null) {
            this.proprf_ValueDefined = false;
            this.proprf_Value = "";
        }
        return data;
    }

    public boolean isrf_ValueDefined() {
        return this.proprf_ValueDefined;
    }

    public String getrf_Value() {
        return this.proprf_Value;
    }
}

