/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar.app;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.SystemColor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import uk.ac.cam.ch.oscar.Plotter;
import uk.ac.cam.ch.oscar.SpectrumInfo;
import uk.ac.cam.ch.oscar.app.ExampleFileFilter;

public class PlotPanel
extends JPanel {
    private Plotter plotter;

    public PlotPanel() {
        this.setBorder(BorderFactory.createEtchedBorder(SystemColor.controlLtHighlight, SystemColor.controlDkShadow));
        this.setBackground(Color.white);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.plotter = new Plotter();
        this.enableEvents(56L);
        this.setDoubleBuffered(true);
    }

    public void setSI(SpectrumInfo specinfo) {
        this.plotter.setSI(specinfo);
    }

    public void toggleAnnotations() {
        this.plotter.toggleAnnotations();
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.plotter.getSize().equals(this.getSize())) {
            this.plotter.setSize(this.getSize());
        }
        this.plotter.paint(g);
    }

    public void processEvent(AWTEvent e2) {
        if (this.plotter.processEvent(e2, this.getGraphics())) {
            this.repaint();
        }
    }

    public void saveAsSVG() {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(null, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        svgGenerator.setSVGCanvasSize(this.getSize());
        this.plotter.paint(svgGenerator);
        boolean useCSS = false;
        try {
            JFileChooser chooser = new JFileChooser();
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("svg");
            filter.setDescription("SVG Images");
            chooser.setFileFilter(filter);
            int retval = chooser.showSaveDialog(this);
            if (retval == 0) {
                File file = chooser.getSelectedFile();
                FileOutputStream fos = new FileOutputStream(file);
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                svgGenerator.stream(out, useCSS);
            }
        }
        catch (HeadlessException e2) {
        }
        catch (FileNotFoundException e3) {
        }
        catch (SVGGraphics2DIOException e4) {
        }
        catch (UnsupportedEncodingException e5) {
            // empty catch block
        }
    }
}

