/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import java.awt.Color;
import java.util.Vector;
import jregex.Matcher;
import jregex.Pattern;
import uk.ac.cam.ch.oscar.DataInterface;
import uk.ac.cam.ch.oscar.HNMRPeakData;
import uk.ac.cam.ch.oscar.SpectrumInfo;
import uk.ac.cam.ch.oscar.SpectrumInterface;

public class HNMRData
implements DataInterface,
SpectrumInterface {
    private boolean defined = false;
    private String blockdata = "";
    private Vector peaks = new Vector();
    private String prophnmr_Solvent = "";
    private boolean prophnmr_SolventDefined = false;
    private String prophnmr_Standard = "";
    private boolean prophnmr_StandardDefined = false;
    private String prophnmr_Frequency = "";
    private boolean prophnmr_FrequencyDefined = false;
    private String prophnmr_Temperature = "";
    private boolean prophnmr_TemperatureDefined = false;

    public String getBlock() {
        return this.blockdata;
    }

    public Color getColor() {
        return new Color(0, 0, 255);
    }

    public SpectrumInfo getSI() {
        SpectrumInfo specinfo = new SpectrumInfo();
        if (this.peaks.size() == 0) {
            return null;
        }
        specinfo.xmin = 0.0f;
        specinfo.xmax = 10.0f;
        specinfo.ymin = 0.0f;
        specinfo.ymax = 1.0f;
        specinfo.xscale = 1.0f;
        specinfo.yscale = 0.0f;
        specinfo.revX = true;
        specinfo.revY = false;
        specinfo.abs = true;
        specinfo.npeaks = this.peaks.size();
        specinfo.x = new float[this.peaks.size()];
        specinfo.height = new float[this.peaks.size()];
        specinfo.width = new float[this.peaks.size()];
        specinfo.type = new int[this.peaks.size()];
        specinfo.annotation = new String[this.peaks.size()];
        int i = 0;
        while (i < this.peaks.size()) {
            specinfo.x[i] = ((HNMRPeakData)this.peaks.elementAt(i)).getX();
            specinfo.height[i] = ((HNMRPeakData)this.peaks.elementAt(i)).getHeight();
            specinfo.width[i] = ((HNMRPeakData)this.peaks.elementAt(i)).getWidth();
            specinfo.type[i] = ((HNMRPeakData)this.peaks.elementAt(i)).getType();
            specinfo.annotation[i] = ((HNMRPeakData)this.peaks.elementAt(i)).getAnnotation();
            ++i;
        }
        return specinfo;
    }

    public String Parse(String inputtext) {
        Pattern re = new Pattern("\t\t\t\t\\b\t\t\t\t\t\t\t(?:\t\t\t\t(NMR\\W*)? (d|\u0111|\u03b4|\u00e4)H\t\t\t|\t1H(?!\\))\\W*NMR\t\t\t|\t\\b(?-i:H)\\b(?![\\)\\]\u2013\\-\\?])\t\t\t)\t\t\t\t\t\t(?: \\W* for\\s+\\w+ (?: (![\\(\\);]).)*?)?\t\t\t\t\t\t\t( ((?![\\(\\[\\{])\\W)* \t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t)\t\t )\t\t?\t\t\t\t(\\W+(d|\u0111|\u03b4|\u00e4|H)+\\b)?\t\t\t\t[\\s:=]+?\t\t\t\t(?: \\W*ppm\\W*?)?\t\t\t\t(?: peaks\\s+at\\s+)?\t\t\t\t\t\t\t\t\t\t(\t(?:about\\s+)?\t\t\t\t\t\t\t[+\u2013\\-\\?]?\t\t\t\\d{1,3}(?:\\.\\d+)?\t\t\t(?: \\s* [\u2013\\-\\?] \\s* \\d{1,3}(?:\\.\\d+)? )?\t\t\t(?: \\s*\\* )? \t\t\t\t\t\t(?: \t\t\t\\s*\t\t\t(?:\t\t\t\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t (?: \\s*\\* )?\t\t\t)\t\t )?\t\t\t)\t\t\t(?!\\w|\\s*=)\t\t\t\t\t(?:\t\t\t\t\t\t\t(?: \\s* (,|and|including|&|;|\\/) \\s* )+\t\t\t\t\t\t\t\t\t(\t(?:about\\s+)?\t\t\t\t\t\t\t[+\u2013\\-\\?]?\t\t\t\\d{1,3}(?:\\.\\d+)?\t\t\t(?: \\s* [\u2013\\-\\?] \\s* \\d{1,3}(?:\\.\\d+)? )?\t\t\t(?: \\s*\\* )? \t\t\t\t\t\t(?: \t\t\t\\s*\t\t\t(?:\t\t\t\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t (?: \\s*\\* )?\t\t\t)\t\t )?\t\t\t)\t\t\t(?!\\w|\\s*=)\t\t\t\t\t)+\t\t\t(?!-)\t\t\t\t\t", 9);
        Matcher m = re.matcher(inputtext);
        this.defined = m.find();
        if (this.defined) {
            this.blockdata = m.group(0);
            int i = inputtext.indexOf(this.blockdata);
            inputtext = inputtext.substring(0, i) + inputtext.substring(i + this.blockdata.length(), inputtext.length());
            this.breakUp(this.blockdata);
        } else {
            this.blockdata = "";
        }
        return inputtext;
    }

    public int getPeakCount() {
        return this.peaks.size();
    }

    public HNMRPeakData getPeakAt(int n) {
        return (HNMRPeakData)this.peaks.elementAt(n);
    }

    public String getSummary() {
        String out = "H-NMR";
        return out;
    }

    public String getDetails() {
        String out = "";
        if (this.defined) {
            out = out + "H-NMR:\n";
            if (this.prophnmr_SolventDefined) {
                out = out + "   Solvent: " + this.prophnmr_Solvent + "\n";
            }
            if (this.prophnmr_StandardDefined) {
                out = out + "   Standard: " + this.prophnmr_Standard + "\n";
            }
            if (this.prophnmr_FrequencyDefined) {
                out = out + "   Frequency: " + this.prophnmr_Frequency + " MHz\n";
            }
            if (this.prophnmr_TemperatureDefined) {
                out = out + "   Temperature: " + this.prophnmr_Temperature + " K\n";
            }
            int i = 0;
            while (i < this.peaks.size()) {
                HNMRPeakData dp = (HNMRPeakData)this.peaks.elementAt(i);
                out = out + dp.getDetails();
                ++i;
            }
            out = out + "\n";
        }
        return out;
    }

    public String getDetailsHTML() {
        if (!this.defined) {
            return "";
        }
        String out = "";
        out = out + "<h3>";
        out = out + "<a name=\"H-NMR\"></a>";
        out = out + "H-NMR</h3>";
        out = out + "<ul>";
        out = out + "<li>";
        out = out + "<a href=\"spec1\">View plot</a>";
        if (this.prophnmr_SolventDefined) {
            out = out + "<li><b>Solvent:</b> " + this.prophnmr_Solvent + "";
        }
        if (this.prophnmr_StandardDefined) {
            out = out + "<li><b>Standard:</b> " + this.prophnmr_Standard + "";
        }
        if (this.prophnmr_FrequencyDefined) {
            out = out + "<li><b>Frequency:</b> " + this.prophnmr_Frequency + " MHz";
        }
        if (this.prophnmr_TemperatureDefined) {
            out = out + "<li><b>Temperature:</b> " + this.prophnmr_Temperature + " K";
        }
        out = out + "</ul>";
        out = out + "<table border=0><tr><td width=\"40\">&nbsp;</td><td>";
        out = out + "<table border=1>";
        out = out + "<td><b>Shift Point / ppm</b></td><td><b>Integral</b></td><td><b>Signal Type</b></td><td><b>Coupling</b></td><td><b>Comment</b></td>";
        int i = 0;
        while (i < this.peaks.size()) {
            HNMRPeakData dp = (HNMRPeakData)this.peaks.elementAt(i);
            out = out + dp.getDetailsHTML();
            ++i;
        }
        out = out + "</table>";
        out = out + "</td></tr></table>";
        return out;
    }

    public String getXML() {
        if (!this.defined) {
            return "";
        }
        String out = "      <data class=\"hnmr\" type=\"spectrum\">\n";
        if (this.prophnmr_SolventDefined) {
            out = out + "         <value id=\"solvent\">" + this.prophnmr_Solvent + "</value>\n";
        }
        if (this.prophnmr_StandardDefined) {
            out = out + "         <value id=\"standard\">" + this.prophnmr_Standard + "</value>\n";
        }
        if (this.prophnmr_FrequencyDefined) {
            out = out + "         <value id=\"frequency\">" + this.prophnmr_Frequency + "</value>\n";
        }
        if (this.prophnmr_TemperatureDefined) {
            out = out + "         <value id=\"temperature\">" + this.prophnmr_Temperature + "</value>\n";
        }
        int i = 0;
        while (i < this.peaks.size()) {
            HNMRPeakData dp = (HNMRPeakData)this.peaks.elementAt(i);
            out = out + dp.getXML();
            ++i;
        }
        out = out + "      </data>\n";
        return out;
    }

    public boolean isSet() {
        return this.defined;
    }

    private void breakUp(String data) {
        data = this.matchhnmr_Solvent(data);
        data = this.matchhnmr_Standard(data);
        data = this.matchhnmr_Frequency(data);
        data = this.matchhnmr_Temperature(data);
        data = this.matchPeaks(data);
    }

    private String matchPeaks(String data) {
        this.peaks.removeAllElements();
        boolean found = false;
        Pattern re = new Pattern("(\t\t\t\t\t\t(\t(?:about\\s+)?\t\t\t\t\t\t\t[+\u2013\\-\\?]?\t\t\t\\d{1,3}(?:\\.\\d+)?\t\t\t(?: \\s* [\u2013\\-\\?] \\s* \\d{1,3}(?:\\.\\d+)? )?\t\t\t(?: \\s*\\* )? \t\t\t\t\t\t(?: \t\t\t\\s*\t\t\t(?:\t\t\t\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t (?: \\s*\\* )?\t\t\t)\t\t )?\t\t\t)\t\t\t(?!\\w|\\s*=)\t\t\t\t\t(?:\t\t\t\t\t\t\t(?: \\s* (,|and|including|&|;|\\/) \\s* )+\t\t\t\t\t\t\t\t\t(\t(?:about\\s+)?\t\t\t\t\t\t\t[+\u2013\\-\\?]?\t\t\t\\d{1,3}(?:\\.\\d+)?\t\t\t(?: \\s* [\u2013\\-\\?] \\s* \\d{1,3}(?:\\.\\d+)? )?\t\t\t(?: \\s*\\* )? \t\t\t\t\t\t(?: \t\t\t\\s*\t\t\t(?:\t\t\t\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t (?: \\s*\\* )?\t\t\t)\t\t )?\t\t\t)\t\t\t(?!\\w|\\s*=)\t\t\t\t\t)+\t\t\t(?!-)\t\t)$", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            String peakblock = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
            boolean foundpeak = false;
            re = new Pattern("(\t\t\t(\t(?:about\\s+)?\t\t\t\t\t\t\t[+\u2013\\-\\?]?\t\t\t\\d{1,3}(?:\\.\\d+)?\t\t\t(?: \\s* [\u2013\\-\\?] \\s* \\d{1,3}(?:\\.\\d+)? )?\t\t\t(?: \\s*\\* )? \t\t\t\t\t\t(?: \t\t\t\\s*\t\t\t(?:\t\t\t\t\t\t\t(?:\t\t\t\t\\( (?: [^\\(\\)] | \\( (?: [^\\(\\)] | \\( [^\\(\\)]+ \\) )+ \\) )+ \\)\t\t\t|\t\\[ (?: [^\\[\\]] | \\[ [^\\[\\]]+ \\] )+ \\]\t\t\t|\t\\{ (?: [^\\{\\}] | \\{ [^\\{\\}]+ \\} )+ \\}\t\t\t)\t\t (?: \\s*\\* )?\t\t\t)\t\t )?\t\t\t)\t\t\t(?!\\w|\\s*=)\t\t)", 9);
            m = re.matcher(peakblock);
            foundpeak = m.find();
            while (foundpeak) {
                HNMRPeakData dp = new HNMRPeakData();
                dp.Parse(m.group(1));
                this.peaks.addElement(dp);
                int j = peakblock.indexOf(m.group(0));
                peakblock = peakblock.substring(0, j) + peakblock.substring(j + m.group(0).length(), peakblock.length());
                m = re.matcher(peakblock);
                foundpeak = m.find();
            }
            i = this.peaks.size() - 1;
            while (i-- > 0) {
                ((HNMRPeakData)this.peaks.elementAt(i)).setNextPeak((HNMRPeakData)this.peaks.elementAt(i + 1));
            }
        }
        return data;
    }

    private String matchhnmr_Solvent(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\W((?:\\[2H6\\]DMSO|Si(CH3)3|Me2CO-d6|\\(CH3CH2\\)2O|\\(OCH2CH2\\)2|Acetone-d6|C2HCl3|C4D8O|C4D8O2|C4H8O|C5D5N|C6D5CD3|C6D5NO2|C6D6|C6H5CD3|CCl4|CD2Cl2|CD3CD2OD|CD3CD2OH|CD3CN|CD3COCD3|CD3COOD|CD3NO2|CD3OD|CD3OH|CD3SOCD3|CDCl3|CF3CO2D|CF3COOD|CH3CH3OD|CH3OCH3|CH3OD|CHCl2CHCl2|Cl2CHCHCl2|Cl2DCCDCl2|CS2|D2O|d5-pyridine|d6-acetone|d6-DMSO|d6-THF|d8-toluene|DCM-d2|DCOOD|DMF-d7|DMSO-d6|Et2O|EtOD|Me2NCHO|MeOD|Pyridine-d5|THF-d6|Toluene-d8))\\b", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.prophnmr_Solvent = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.prophnmr_Solvent = "";
        }
        this.prophnmr_SolventDefined = found;
        if (this.prophnmr_Solvent == "") {
            this.prophnmr_SolventDefined = false;
        }
        if (this.prophnmr_Solvent == null) {
            this.prophnmr_SolventDefined = false;
            this.prophnmr_Solvent = "";
        }
        return data;
    }

    public boolean ishnmr_SolventDefined() {
        return this.prophnmr_SolventDefined;
    }

    public String gethnmr_Solvent() {
        return this.prophnmr_Solvent;
    }

    private String matchhnmr_Standard(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\W((?:Me4Si|CFCl3))\\b", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.prophnmr_Standard = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.prophnmr_Standard = "";
        }
        this.prophnmr_StandardDefined = found;
        if (this.prophnmr_Standard == "") {
            this.prophnmr_StandardDefined = false;
        }
        if (this.prophnmr_Standard == null) {
            this.prophnmr_StandardDefined = false;
            this.prophnmr_Standard = "";
        }
        return data;
    }

    public boolean ishnmr_StandardDefined() {
        return this.prophnmr_StandardDefined;
    }

    public String gethnmr_Standard() {
        return this.prophnmr_Standard;
    }

    private String matchhnmr_Frequency(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\b(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\\s*MHz\\b", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.prophnmr_Frequency = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.prophnmr_Frequency = "";
        }
        this.prophnmr_FrequencyDefined = found;
        if (this.prophnmr_Frequency == "") {
            this.prophnmr_FrequencyDefined = false;
        }
        if (this.prophnmr_Frequency == null) {
            this.prophnmr_FrequencyDefined = false;
            this.prophnmr_Frequency = "";
        }
        return data;
    }

    public boolean ishnmr_FrequencyDefined() {
        return this.prophnmr_FrequencyDefined;
    }

    public String gethnmr_Frequency() {
        return this.prophnmr_Frequency;
    }

    private String matchhnmr_Temperature(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\b(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\\s*K\\b", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.prophnmr_Temperature = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.prophnmr_Temperature = "";
        }
        this.prophnmr_TemperatureDefined = found;
        if (this.prophnmr_Temperature == "") {
            this.prophnmr_TemperatureDefined = false;
        }
        if (this.prophnmr_Temperature == null) {
            this.prophnmr_TemperatureDefined = false;
            this.prophnmr_Temperature = "";
        }
        return data;
    }

    public boolean ishnmr_TemperatureDefined() {
        return this.prophnmr_TemperatureDefined;
    }

    public String gethnmr_Temperature() {
        return this.prophnmr_Temperature;
    }
}

