/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import jregex.Matcher;
import jregex.Pattern;
import uk.ac.cam.ch.oscar.DataPointInterface;

public class MassSpecPeakData
implements DataPointInterface {
    private boolean defined = false;
    private String blockdata = "";
    private MassSpecPeakData nextPeak = null;
    private String propmassspec_Value = "";
    private boolean propmassspec_ValueDefined = false;
    private String propmassspec_Intensity = "";
    private boolean propmassspec_IntensityDefined = false;
    private String propmassspec_Comment = "";
    private boolean propmassspec_CommentDefined = false;

    public void Parse(String inputtext) {
        this.breakUp(inputtext);
        this.defined = true;
    }

    public String getDetails() {
        String out = "";
        if (this.defined) {
            out = out + "   " + this.propmassspec_Value + "";
            if (this.propmassspec_IntensityDefined) {
                out = out + " (" + this.propmassspec_Intensity + "%)";
            }
            out = out + "";
            if (this.propmassspec_CommentDefined) {
                out = out + " : " + this.propmassspec_Comment + "";
            }
            out = out + "\n";
        }
        return out;
    }

    public String getDetailsHTML() {
        String out = "";
        if (this.defined) {
            out = out + "<tr><td>" + this.propmassspec_Value + "</td><td>";
            if (this.propmassspec_IntensityDefined) {
                out = out + "" + this.propmassspec_Intensity + "%";
            }
            out = out + "</td><td>";
            if (this.propmassspec_CommentDefined) {
                out = out + "" + this.propmassspec_Comment + "";
            }
            out = out + "</td></tr>";
        }
        return out;
    }

    public String getXML() {
        if (!this.defined) {
            return "";
        }
        String out = "         <peak>\n";
        if (this.propmassspec_ValueDefined) {
            out = out + "            <value id=\"shift\">" + this.propmassspec_Value + "</value>\n";
        }
        if (this.propmassspec_IntensityDefined) {
            out = out + "            <value id=\"intensity\">" + this.propmassspec_Intensity + "</value>\n";
        }
        if (this.propmassspec_CommentDefined) {
            out = out + "            <value id=\"comment\">" + this.propmassspec_Comment + "</value>\n";
        }
        out = out + "         </peak>\n";
        return out;
    }

    public boolean isSet() {
        return this.defined;
    }

    private void breakUp(String data) {
        data = this.matchmassspec_Value(data);
        data = this.matchmassspec_Intensity(data);
        data = this.matchmassspec_Comment(data);
    }

    public void setNextPeak(MassSpecPeakData thePeak) {
        this.nextPeak = thePeak;
    }

    public MassSpecPeakData getNextPeak() {
        return this.nextPeak;
    }

    private String matchmassspec_Value(String data) {
        boolean found = false;
        Pattern re = new Pattern("(\\d{2,}(?:\\.\\d+)?)", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propmassspec_Value = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propmassspec_Value = "";
        }
        this.propmassspec_ValueDefined = found;
        if (this.propmassspec_Value == "") {
            this.propmassspec_ValueDefined = false;
        }
        if (this.propmassspec_Value == null) {
            this.propmassspec_ValueDefined = false;
            this.propmassspec_Value = "";
        }
        return data;
    }

    public boolean ismassspec_ValueDefined() {
        return this.propmassspec_ValueDefined;
    }

    public String getmassspec_Value() {
        return this.propmassspec_Value;
    }

    private String matchmassspec_Intensity(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\b(\\d+(?:\\.\\d+)?)\\b\\s*[\\%\\,\\)],?", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propmassspec_Intensity = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propmassspec_Intensity = "";
        }
        this.propmassspec_IntensityDefined = found;
        if (this.propmassspec_Intensity == "") {
            this.propmassspec_IntensityDefined = false;
        }
        if (this.propmassspec_Intensity == null) {
            this.propmassspec_IntensityDefined = false;
            this.propmassspec_Intensity = "";
        }
        return data;
    }

    public boolean ismassspec_IntensityDefined() {
        return this.propmassspec_IntensityDefined;
    }

    public String getmassspec_Intensity() {
        return this.propmassspec_Intensity;
    }

    private String matchmassspec_Comment(String data) {
        boolean found = false;
        Pattern re = new Pattern("[\\(\\{\\[][\\s,\\(\\[]*(.*?)[\\s,]*[\\)\\}\\]]", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propmassspec_Comment = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propmassspec_Comment = "";
        }
        this.propmassspec_CommentDefined = found;
        if (this.propmassspec_Comment == "") {
            this.propmassspec_CommentDefined = false;
        }
        if (this.propmassspec_Comment == null) {
            this.propmassspec_CommentDefined = false;
            this.propmassspec_Comment = "";
        }
        return data;
    }

    public boolean ismassspec_CommentDefined() {
        return this.propmassspec_CommentDefined;
    }

    public String getmassspec_Comment() {
        return this.propmassspec_Comment;
    }

    public float getX() {
        if (this.ismassspec_ValueDefined()) {
            return Float.valueOf(this.getmassspec_Value()).floatValue();
        }
        return 0.0f;
    }

    public float getHeight() {
        if (this.ismassspec_IntensityDefined()) {
            return Float.valueOf(this.getmassspec_Intensity()).floatValue();
        }
        return 0.5f;
    }

    public float getWidth() {
        return 0.0f;
    }

    public int getType() {
        return 0;
    }

    public String getAnnotation() {
        return this.getmassspec_Comment();
    }
}

