/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar;

import jregex.Matcher;
import jregex.Pattern;
import uk.ac.cam.ch.oscar.DataPointInterface;

public class UVPeakData
implements DataPointInterface {
    private boolean defined = false;
    private String blockdata = "";
    private UVPeakData nextPeak = null;
    private String propuv_lmaxPoint = "";
    private boolean propuv_lmaxPointDefined = false;
    private String propuv_lmaxLower = "";
    private boolean propuv_lmaxLowerDefined = false;
    private String propuv_lmaxUpper = "";
    private boolean propuv_lmaxUpperDefined = false;
    private String propuv_PeakType = "";
    private boolean propuv_PeakTypeDefined = false;
    private String propuv_e = "";
    private boolean propuv_eDefined = false;
    private String propuv_logE = "";
    private boolean propuv_logEDefined = false;

    public void Parse(String inputtext) {
        this.breakUp(inputtext);
        this.defined = true;
    }

    public String getDetails() {
        String out = "";
        if (this.defined) {
            out = out + "   ";
            if (this.propuv_lmaxPointDefined) {
                out = out + "" + this.propuv_lmaxPoint + "";
            }
            out = out + "";
            if (this.propuv_lmaxLowerDefined) {
                out = out + "" + this.propuv_lmaxLower + " - " + this.propuv_lmaxUpper + "";
            }
            out = out + " nm";
            if (this.propuv_PeakTypeDefined) {
                out = out + " (" + this.propuv_PeakType + ")";
            }
            out = out + "";
            if (this.propuv_eDefined) {
                out = out + " e, " + this.propuv_e + "";
            }
            out = out + "";
            if (this.propuv_logEDefined) {
                out = out + " log e, " + this.propuv_logE + "";
            }
            out = out + "\n";
        }
        return out;
    }

    public String getDetailsHTML() {
        String out = "";
        if (this.defined) {
            out = out + "<tr><td>";
            if (this.propuv_lmaxPointDefined) {
                out = out + "" + this.propuv_lmaxPoint + "";
            }
            out = out + "";
            if (this.propuv_lmaxLowerDefined) {
                out = out + "" + this.propuv_lmaxLower + " - " + this.propuv_lmaxUpper + "";
            }
            out = out + "</td><td>";
            if (this.propuv_PeakTypeDefined) {
                out = out + "" + this.propuv_PeakType + "";
            }
            out = out + "</td><td>";
            if (this.propuv_eDefined) {
                out = out + "" + this.propuv_e + "";
            }
            out = out + "";
            if (this.propuv_logEDefined) {
                out = out + "" + this.propuv_logE + "";
            }
            out = out + "</td></tr>";
        }
        return out;
    }

    public String getXML() {
        if (!this.defined) {
            return "";
        }
        String out = "         <peak>\n";
        if (this.propuv_lmaxPointDefined) {
            out = out + "            <value id=\"lmaxpoint\">" + this.propuv_lmaxPoint + "</value>\n";
        }
        if (this.propuv_lmaxLowerDefined) {
            out = out + "            <value id=\"lmaxlower\">" + this.propuv_lmaxLower + "</value>\n";
        }
        if (this.propuv_lmaxUpperDefined) {
            out = out + "            <value id=\"lmaxupper\">" + this.propuv_lmaxUpper + "</value>\n";
        }
        if (this.propuv_PeakTypeDefined) {
            out = out + "            <value id=\"peaktype\">" + this.propuv_PeakType + "</value>\n";
        }
        if (this.propuv_eDefined) {
            out = out + "            <value id=\"e\">" + this.propuv_e + "</value>\n";
        }
        if (this.propuv_logEDefined) {
            out = out + "            <value id=\"logE\">" + this.propuv_logE + "</value>\n";
        }
        out = out + "         </peak>\n";
        return out;
    }

    public boolean isSet() {
        return this.defined;
    }

    private void breakUp(String data) {
        data = this.matchuv_lmaxPoint(data);
        data = this.matchuv_lmaxLower(data);
        data = this.matchuv_lmaxUpper(data);
        data = this.matchuv_PeakType(data);
        data = this.matchuv_e(data);
        data = this.matchuv_logE(data);
    }

    public void setNextPeak(UVPeakData thePeak) {
        this.nextPeak = thePeak;
    }

    public UVPeakData getNextPeak() {
        return this.nextPeak;
    }

    private String matchuv_lmaxPoint(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t^\\s*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\\s*(?![\u2013\\-\\?]|\\.\\d)\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propuv_lmaxPoint = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propuv_lmaxPoint = "";
        }
        this.propuv_lmaxPointDefined = found;
        if (this.propuv_lmaxPoint == "") {
            this.propuv_lmaxPointDefined = false;
        }
        if (this.propuv_lmaxPoint == null) {
            this.propuv_lmaxPointDefined = false;
            this.propuv_lmaxPoint = "";
        }
        return data;
    }

    public boolean isuv_lmaxPointDefined() {
        return this.propuv_lmaxPointDefined;
    }

    public String getuv_lmaxPoint() {
        return this.propuv_lmaxPoint;
    }

    private String matchuv_lmaxLower(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t^\\s*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\\s*(?=[\u2013\\-\\?])\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propuv_lmaxLower = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propuv_lmaxLower = "";
        }
        this.propuv_lmaxLowerDefined = found;
        if (this.propuv_lmaxLower == "") {
            this.propuv_lmaxLowerDefined = false;
        }
        if (this.propuv_lmaxLower == null) {
            this.propuv_lmaxLowerDefined = false;
            this.propuv_lmaxLower = "";
        }
        return data;
    }

    public boolean isuv_lmaxLowerDefined() {
        return this.propuv_lmaxLowerDefined;
    }

    public String getuv_lmaxLower() {
        return this.propuv_lmaxLower;
    }

    private String matchuv_lmaxUpper(String data) {
        boolean found = false;
        Pattern re = new Pattern("\t\t\t^\\s*[\u2013\\-\\?]\\s*(\t\t\t[+\u2013\\-\\?]?\\<\\d+(?:\\.\\d+)?(?!\\d)\t\t)\t\t", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propuv_lmaxUpper = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propuv_lmaxUpper = "";
        }
        this.propuv_lmaxUpperDefined = found;
        if (this.propuv_lmaxUpper == "") {
            this.propuv_lmaxUpperDefined = false;
        }
        if (this.propuv_lmaxUpper == null) {
            this.propuv_lmaxUpperDefined = false;
            this.propuv_lmaxUpper = "";
        }
        return data;
    }

    public boolean isuv_lmaxUpperDefined() {
        return this.propuv_lmaxUpperDefined;
    }

    public String getuv_lmaxUpper() {
        return this.propuv_lmaxUpper;
    }

    private String matchuv_PeakType(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\b((?:inf\\w*|sh))\\b\\.?", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propuv_PeakType = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propuv_PeakType = "";
        }
        this.propuv_PeakTypeDefined = found;
        if (this.propuv_PeakType == "") {
            this.propuv_PeakTypeDefined = false;
        }
        if (this.propuv_PeakType == null) {
            this.propuv_PeakTypeDefined = false;
            this.propuv_PeakType = "";
        }
        return data;
    }

    public boolean isuv_PeakTypeDefined() {
        return this.propuv_PeakTypeDefined;
    }

    public String getuv_PeakType() {
        return this.propuv_PeakType;
    }

    private String matchuv_e(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\([^\\)]*?(?![\u2013\\-\\?])(\\d{1,2}\\s?\\d{3})", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propuv_e = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propuv_e = "";
        }
        this.propuv_eDefined = found;
        if (this.propuv_e == "") {
            this.propuv_eDefined = false;
        }
        if (this.propuv_e == null) {
            this.propuv_eDefined = false;
            this.propuv_e = "";
        }
        return data;
    }

    public boolean isuv_eDefined() {
        return this.propuv_eDefined;
    }

    public String getuv_e() {
        return this.propuv_e;
    }

    private String matchuv_logE(String data) {
        boolean found = false;
        Pattern re = new Pattern("\\([^\\)]*?(\\d+\\.\\d+)", 9);
        Matcher m = re.matcher(data);
        found = m.find();
        if (found) {
            this.propuv_logE = m.group(1);
            int i = data.indexOf(m.group(0));
            data = data.substring(0, i) + data.substring(i + m.group(0).length(), data.length());
        } else {
            this.propuv_logE = "";
        }
        this.propuv_logEDefined = found;
        if (this.propuv_logE == "") {
            this.propuv_logEDefined = false;
        }
        if (this.propuv_logE == null) {
            this.propuv_logEDefined = false;
            this.propuv_logE = "";
        }
        return data;
    }

    public boolean isuv_logEDefined() {
        return this.propuv_logEDefined;
    }

    public String getuv_logE() {
        return this.propuv_logE;
    }

    public float getX() {
        if (this.isuv_lmaxPointDefined()) {
            return Float.valueOf(this.getuv_lmaxPoint()).floatValue();
        }
        if (this.isuv_lmaxUpperDefined() & this.isuv_lmaxLowerDefined()) {
            return (Float.valueOf(this.getuv_lmaxLower()).floatValue() + Float.valueOf(this.getuv_lmaxUpper()).floatValue()) / 2.0f;
        }
        return 0.0f;
    }

    public float getHeight() {
        if (this.isuv_eDefined()) {
            Pattern re = new Pattern("(\\d+)\\s+(\\d+)", 9);
            String uve = this.getuv_e();
            Matcher m = re.matcher(uve);
            if (m.find()) {
                uve = m.group(1) + m.group(2);
            }
            return Float.valueOf(uve).floatValue();
        }
        if (this.isuv_logEDefined()) {
            return Float.valueOf(this.getuv_logE()).floatValue();
        }
        return 4.0f;
    }

    public float getWidth() {
        return 50.0f;
    }

    public int getType() {
        return 2;
    }

    public String getAnnotation() {
        return this.getuv_PeakType();
    }
}

