/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.oscar.app;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import uk.ac.cam.ch.oscar.ExpData;
import uk.ac.cam.ch.oscar.HighlightInfo;
import uk.ac.cam.ch.oscar.PaperSplitter;
import uk.ac.cam.ch.oscar.app.AnalListCellRenderer;
import uk.ac.cam.ch.oscar.app.AnalListModel;
import uk.ac.cam.ch.oscar.app.AppProgressInterface;
import uk.ac.cam.ch.oscar.app.ExampleFileFilter;
import uk.ac.cam.ch.oscar.app.FileTools;
import uk.ac.cam.ch.oscar.app.HelpDialog;
import uk.ac.cam.ch.oscar.app.JListEx;
import uk.ac.cam.ch.oscar.app.JTableEx;
import uk.ac.cam.ch.oscar.app.MyGlassPane;
import uk.ac.cam.ch.oscar.app.PlotPanel;
import uk.ac.cam.ch.oscar.app.TickCellRender;
import uk.ac.cam.ch.oscar.app.edcFrame;
import uk.ac.cam.ch.oscar.app.edcTableModel;

public class edcFrame
extends JFrame {
    protected DocState state;
    protected static final int INPUTPANEL = 1;
    protected static final int TABLEPANEL = 2;
    protected static final int SPLITPANEL = 3;
    protected static final int ANALPANEL = 4;
    protected static final int XMLPANEL = 5;
    protected static final int SUMMARYSPLIT = 10;
    protected static final int DETAILSSPLIT = 11;
    protected static final int ANALYSISSPLIT = 12;
    protected static final int GRAPHPANELOFFSET = 100;
    protected static String DefaultFilePath;
    protected Action actInput;
    protected Action actTable;
    protected Action actSplit;
    protected Action actAnal;
    protected Action actXML;
    protected Action actNew;
    protected Action actOpen;
    protected Action actSaveAs;
    protected Action actExit;
    protected Action actHighlight;
    protected Action actHighlightOff;
    protected Action actCut;
    protected Action actCopy;
    protected Action actPaste;
    protected Action actSelectAll;
    protected Action actToggleLabels;
    protected Action actAbout;
    protected Action actHelp;
    private JPanel cards;
    private JPanel inputPanel;
    private JPanel tablePanel;
    private JPanel splitPanel;
    private JPanel analPanel;
    private JPanel xmlPanel;
    private JTextArea inputEdit;
    private JLabel inputStatus;
    private JTableEx tableTable;
    private edcTableModel tableModel;
    private JLabel tableHelpLabel;
    private JListEx splitList;
    private DefaultListModel splitListModel;
    private JPanel splitPanelSummary;
    private JPanel splitPanelDetails;
    private JPanel splitPanelAnalysis;
    private JPanel splitPanelTab;
    private JLabel splitLabelHelpSummary;
    private JLabel splitLabelHelpDetails;
    private JLabel splitLabelHelpAnalysis;
    private JLabel[] splitLabelHelpPlots;
    private JPanel[] splitPanelPlots;
    private PlotPanel[] splitPlots;
    private JTabbedPane splitTab;
    private JEditorPane splitTextSummary;
    private JEditorPane splitTextDetails;
    private JEditorPane splitTextAnalysis;
    private JListEx analList;
    private AnalListModel analListModel;
    private JEditorPane analText;
    private JTextArea xmlText;
    private JPopupMenu popupInput;
    private JPopupMenu popupReadonly;
    private PaperSplitter splitter;
    private boolean doingList;
    private boolean doingAnalList;
    static /* synthetic */ Class class$java$lang$Boolean;

    public edcFrame() {
        super("Experimental Data Checker v2.6.1");
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                edcFrame.this.quit();
            }
        });
        this.createLayout();
        this.createActions();
        this.createMenuBar();
        this.createPopupMenus();
        this.createToolBar();
        this.splitter = new PaperSplitter();
        this.state = new DocState();
        this.state.New();
        this.pack();
        this.setBounds(50, 50, screenSize.width - 100, screenSize.height - 100);
        this.inputEdit.requestFocusInWindow();
    }

    private void createLayout() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.inputPanel = new JPanel();
        this.inputPanel.setLayout(new BorderLayout());
        this.inputStatus = new JLabel(" ");
        this.inputPanel.add((Component)this.inputStatus, "South");
        this.inputEdit = new JTextArea();
        this.inputEdit.setLineWrap(true);
        this.inputEdit.setWrapStyleWord(true);
        this.inputEdit.setText("");
        this.inputEdit.setMargin(new Insets(5, 10, 5, 10));
        this.inputEdit.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e2) {
                edcFrame.this.state.setInputModified(true);
            }

            public void insertUpdate(DocumentEvent e2) {
                edcFrame.this.state.setInputModified(true);
            }

            public void removeUpdate(DocumentEvent e2) {
                edcFrame.this.state.setInputModified(true);
            }
        });
        this.inputEdit.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e2) {
                if (e2.getMark() != e2.getDot()) {
                    edcFrame.this.actCut.setEnabled(true);
                    edcFrame.this.actCopy.setEnabled(true);
                } else {
                    edcFrame.this.actCut.setEnabled(false);
                    edcFrame.this.actCopy.setEnabled(false);
                }
            }
        });
        this.inputPanel.add((Component)new JScrollPane(this.inputEdit, 22, 31), "Center");
        this.tablePanel = new JPanel();
        this.tableModel = new edcTableModel();
        this.tableTable = new JTableEx(this.tableModel);
        this.tableTable.registerHeaderTooltips();
        this.tableTable.setSelectionMode(0);
        this.tableTable.setShowVerticalLines(false);
        this.tableTable.setDefaultRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = edcFrame.class$("java.lang.Boolean")) : class$java$lang$Boolean, new TickCellRender());
        this.tableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                if (e2.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e2.getSource();
                if (lsm.isSelectionEmpty()) {
                    return;
                }
                edcFrame.this.state.setSplitCompound(lsm.getMinSelectionIndex());
            }
        });
        JScrollPane tableScroller = new JScrollPane(this.tableTable);
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)tableScroller, "Center");
        this.tableHelpLabel = new JLabel("<HTML><CENTER>Select a row to view more detailed information</CENTER></HTML>");
        this.tableHelpLabel.setBackground(SystemColor.info);
        this.tableHelpLabel.setForeground(SystemColor.infoText);
        this.tableHelpLabel.setOpaque(true);
        this.tableHelpLabel.setHorizontalAlignment(0);
        this.tableHelpLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(SystemColor.controlLtHighlight, SystemColor.controlDkShadow), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.tablePanel.add((Component)this.tableHelpLabel, "North");
        this.splitPanel = new JPanel();
        this.splitListModel = new DefaultListModel();
        this.splitList = new JListEx((ListModel)this.splitListModel);
        this.splitList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                if (edcFrame.this.doingList) {
                    return;
                }
                if (e2.getValueIsAdjusting()) {
                    return;
                }
                int i = edcFrame.this.splitList.getSelectedIndex();
                if (i == -1) {
                    return;
                }
                if (i != edcFrame.this.state.getSplitCompound()) {
                    edcFrame.this.state.setSplitCompound(i);
                }
            }
        });
        this.splitList.setSelectionMode(0);
        this.splitList.setRequestFocusEnabled(false);
        JScrollPane splitListScroller = new JScrollPane(this.splitList);
        this.splitTab = new JTabbedPane(1);
        this.splitTab.setRequestFocusEnabled(false);
        this.splitPanelSummary = new JPanel();
        this.splitPanelSummary.setLayout(new BorderLayout());
        this.splitTextSummary = new JEditorPane();
        this.splitTextSummary.setEditable(false);
        this.splitTextSummary.setContentType("text/html");
        this.splitTextSummary.setMargin(new Insets(0, 10, 10, 10));
        this.splitTextSummary.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e2) {
                if (e2.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                edcFrame.this.state.doLink(e2.getDescription());
            }
        });
        JScrollPane splitScrollSummary = new JScrollPane(this.splitTextSummary, 22, 30);
        this.splitPanelSummary.add((Component)splitScrollSummary, "Center");
        this.splitLabelHelpSummary = new JLabel("<HTML><CENTER>Input data that is not highlighted has not been recognised - see online help for a list of common reasons.</CENTER></HTML>");
        this.splitLabelHelpSummary.setBackground(SystemColor.info);
        this.splitLabelHelpSummary.setForeground(SystemColor.infoText);
        this.splitLabelHelpSummary.setOpaque(true);
        this.splitLabelHelpSummary.setHorizontalAlignment(0);
        this.splitLabelHelpSummary.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.splitPanelSummary.add((Component)this.splitLabelHelpSummary, "North");
        this.splitTab.addTab("Summary", new ImageIcon(classLoader.getResource("text.gif")), this.splitPanelSummary);
        this.splitPanelDetails = new JPanel();
        this.splitPanelDetails.setLayout(new BorderLayout());
        this.splitTextDetails = new JEditorPane();
        this.splitTextDetails.setEditable(false);
        this.splitTextDetails.setContentType("text/html");
        this.splitTextDetails.setMargin(new Insets(0, 10, 10, 10));
        this.splitTextDetails.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e2) {
                if (e2.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                edcFrame.this.state.doLink(e2.getDescription());
            }
        });
        JScrollPane splitScrollDetails = new JScrollPane(this.splitTextDetails, 22, 30);
        this.splitPanelDetails.add((Component)splitScrollDetails, "Center");
        this.splitTab.addTab("Details", new ImageIcon(classLoader.getResource("text.gif")), this.splitPanelDetails);
        this.splitPanelAnalysis = new JPanel();
        this.splitPanelAnalysis.setLayout(new BorderLayout());
        this.splitTextAnalysis = new JEditorPane();
        this.splitTextAnalysis.setEditable(false);
        this.splitTextAnalysis.setContentType("text/html");
        this.splitTextAnalysis.setMargin(new Insets(0, 10, 10, 10));
        this.splitTextAnalysis.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e2) {
                if (e2.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                edcFrame.this.state.doLink(e2.getDescription());
            }
        });
        JScrollPane splitScrollAnalysis = new JScrollPane(this.splitTextAnalysis, 22, 30);
        this.splitPanelAnalysis.add((Component)splitScrollAnalysis, "Center");
        this.splitTab.addTab("Analysis", new ImageIcon(classLoader.getResource("text.gif")), this.splitPanelAnalysis);
        CaretListener CopyCaretListener = new CaretListener(){

            public void caretUpdate(CaretEvent e2) {
                if (e2.getMark() != e2.getDot()) {
                    edcFrame.this.actCopy.setEnabled(true);
                } else {
                    edcFrame.this.actCopy.setEnabled(false);
                }
            }
        };
        this.splitTextSummary.addCaretListener(CopyCaretListener);
        this.splitTextDetails.addCaretListener(CopyCaretListener);
        this.splitTextAnalysis.addCaretListener(CopyCaretListener);
        this.splitPanelPlots = new JPanel[ExpData.SpectrumNames.length];
        this.splitLabelHelpPlots = new JLabel[ExpData.SpectrumNames.length];
        this.splitPlots = new PlotPanel[this.splitPanelPlots.length];
        int i = 0;
        while (i < this.splitPanelPlots.length) {
            this.splitPanelPlots[i] = new JPanel();
            this.splitPanelPlots[i].setLayout(new BorderLayout());
            this.splitLabelHelpPlots[i] = new JLabel("<HTML><CENTER>Drag with left mouse to zoom in; right-click to zoom out; drag with middle button or Alt + left button to adjust peak widths.</CENTER></HTML>");
            this.splitLabelHelpPlots[i].setBackground(SystemColor.info);
            this.splitLabelHelpPlots[i].setForeground(SystemColor.infoText);
            this.splitLabelHelpPlots[i].setOpaque(true);
            this.splitLabelHelpPlots[i].setHorizontalAlignment(0);
            this.splitLabelHelpPlots[i].setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.splitPanelPlots[i].add((Component)this.splitLabelHelpPlots[i], "North");
            this.splitPlots[i] = new PlotPanel();
            this.splitPanelPlots[i].add((Component)this.splitPlots[i], "Center");
            this.splitTab.addTab(ExpData.SpectrumNames[i], new ImageIcon(classLoader.getResource("graph.gif")), this.splitPanelPlots[i]);
            ++i;
        }
        this.splitTab.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                switch (edcFrame.this.splitTab.getSelectedIndex()) {
                    case 0: {
                        edcFrame.this.state.setSplitPanel(10);
                        break;
                    }
                    case 1: {
                        edcFrame.this.state.setSplitPanel(11);
                        break;
                    }
                    case 2: {
                        edcFrame.this.state.setSplitPanel(12);
                        break;
                    }
                    case -1: {
                        edcFrame.this.state.setSplitPanel(-1);
                        break;
                    }
                    default: {
                        edcFrame.this.state.setSplitPanel(100 + edcFrame.this.splitTab.getSelectedIndex() - 3);
                    }
                }
            }
        });
        this.splitTab.setSelectedIndex(0);
        this.splitLabelHelpDetails = new JLabel("");
        this.splitLabelHelpDetails.setBackground(SystemColor.info);
        this.splitLabelHelpDetails.setForeground(SystemColor.infoText);
        this.splitLabelHelpDetails.setOpaque(true);
        this.splitLabelHelpDetails.setVisible(false);
        this.splitLabelHelpDetails.setHorizontalAlignment(0);
        this.splitLabelHelpDetails.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.splitPanelDetails.add((Component)this.splitLabelHelpDetails, "North");
        this.splitLabelHelpAnalysis = new JLabel("<HTML><CENTER>Significant errors appear in <FONT COLOR=\"e00000\">red</FONT>; warnings in <FONT COLOR=\"0000e0\">blue</FONT> and <FONT COLOR=\"000000\">black</FONT>; information in <FONT COLOR=\"00c000\">green</FONT>.</CENTER></HTML>");
        this.splitLabelHelpAnalysis.setBackground(SystemColor.info);
        this.splitLabelHelpAnalysis.setForeground(SystemColor.infoText);
        this.splitLabelHelpAnalysis.setOpaque(true);
        this.splitLabelHelpAnalysis.setHorizontalAlignment(0);
        this.splitLabelHelpAnalysis.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.splitPanelAnalysis.add((Component)this.splitLabelHelpAnalysis, "North");
        this.splitPanelTab = new JPanel();
        this.splitPanelTab.setLayout(new BorderLayout());
        this.splitPanelTab.add((Component)this.splitTab, "Center");
        JSplitPane splitPane = new JSplitPane(1, splitListScroller, this.splitPanelTab);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(150);
        this.splitPanel.setLayout(new BorderLayout());
        this.splitPanel.add((Component)splitPane, "Center");
        this.analPanel = new JPanel();
        this.analListModel = new AnalListModel();
        this.analList = new JListEx((ListModel)this.analListModel);
        this.analList.setCellRenderer(new AnalListCellRenderer());
        this.analList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                if (edcFrame.this.doingAnalList) {
                    return;
                }
                if (e2.getValueIsAdjusting()) {
                    return;
                }
                int i = edcFrame.this.analList.getSelectedIndex();
                if (i == -1) {
                    return;
                }
                if (i != edcFrame.this.state.getAnalItem()) {
                    edcFrame.this.state.setAnalItem(i);
                }
            }
        });
        this.analList.setSelectionMode(0);
        this.analList.setRequestFocusEnabled(false);
        JScrollPane analListScroller = new JScrollPane(this.analList);
        this.analText = new JEditorPane();
        this.analText.setEditable(false);
        this.analText.setContentType("text/html");
        this.analText.setMargin(new Insets(0, 10, 10, 10));
        this.analText.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e2) {
                if (e2.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                edcFrame.this.state.doLink(e2.getDescription());
            }
        });
        this.analText.addCaretListener(CopyCaretListener);
        JScrollPane analTextScroller = new JScrollPane(this.analText, 22, 30);
        JSplitPane analSplitPane = new JSplitPane(1, analListScroller, analTextScroller);
        analSplitPane.setOneTouchExpandable(true);
        analSplitPane.setDividerLocation(150);
        this.analPanel.setLayout(new BorderLayout());
        this.analPanel.add((Component)analSplitPane, "Center");
        this.xmlPanel = new JPanel();
        this.xmlText = new JTextArea("");
        this.xmlText.setLineWrap(false);
        this.xmlText.setEditable(false);
        this.xmlText.setMargin(new Insets(5, 10, 5, 10));
        this.xmlText.addCaretListener(CopyCaretListener);
        JScrollPane xmlScroller = new JScrollPane(this.xmlText, 22, 32);
        this.xmlPanel.setLayout(new BorderLayout());
        this.xmlPanel.add((Component)xmlScroller, "Center");
        this.cards = new JPanel();
        this.cards.setLayout(new CardLayout());
        this.cards.add((Component)this.inputPanel, "inputPanel");
        this.cards.add((Component)this.tablePanel, "tablePanel");
        this.cards.add((Component)this.splitPanel, "splitPanel");
        this.cards.add((Component)this.analPanel, "analPanel");
        this.cards.add((Component)this.xmlPanel, "xmlPanel");
        ((CardLayout)this.cards.getLayout()).show(this.cards, "inputPanel");
        this.getContentPane().add((Component)this.cards, "Center");
    }

    private void createActions() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.actInput = new InputAction("Input", new ImageIcon(classLoader.getResource("input.gif")), "Input data from journal");
        this.actTable = new TableAction("Table view", new ImageIcon(classLoader.getResource("table.gif")), "View parsed data as table");
        this.actSplit = new SplitAction("Detail view", new ImageIcon(classLoader.getResource("split.gif")), "View details and spectra");
        this.actAnal = new AnalAction("Analysis view", new ImageIcon(classLoader.getResource("anal.gif")), "View analysis of entire paper");
        this.actXML = new XMLAction("XML view", new ImageIcon(classLoader.getResource("xml.gif")), "View data as XML");
        this.actNew = new NewAction("New", new ImageIcon(classLoader.getResource("new.gif")), "New");
        this.actOpen = new OpenAction("Open...", new ImageIcon(classLoader.getResource("open.gif")), "Open...");
        this.actSaveAs = new SaveAsAction("Save As...", new ImageIcon(classLoader.getResource("save.gif")), "Save As...");
        this.actExit = new ExitAction("Exit", null, "Exit");
        this.actHighlight = new HighlightAction("Highlight", new ImageIcon(classLoader.getResource("highlight.gif")), "Highlight data");
        this.actHighlightOff = new HighlightOffAction("Highlights off", new ImageIcon(classLoader.getResource("highlight_off.gif")), "Turn highlights off");
        this.actCut = new CutAction("Cut", new ImageIcon(classLoader.getResource("cut.gif")), "Cut");
        this.actCopy = new CopyAction("Copy", new ImageIcon(classLoader.getResource("copy.gif")), "Copy");
        this.actPaste = new PasteAction("Paste", new ImageIcon(classLoader.getResource("paste.gif")), "Paste");
        this.actSelectAll = new SelectAllAction("Select All", null, "Select All");
        this.actToggleLabels = new ToggleLabelsAction("Toggle annotations", new ImageIcon(classLoader.getResource("toggle.gif")), "Toggle annotations");
        this.actAbout = new AboutAction("About EDC...", null, "About EDC...");
        this.actHelp = new HelpAction("EDC Help", new ImageIcon(classLoader.getResource("help.gif")), "EDC Help");
        this.actInput.setEnabled(false);
    }

    private void createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        menubar.setRequestFocusEnabled(false);
        JMenuItem menuItem = null;
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        menuItem = new JMenuItem(this.actNew);
        menuItem.setMnemonic('N');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        fileMenu.add(menuItem);
        menuItem = new JMenuItem(this.actOpen);
        menuItem.setMnemonic('O');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        fileMenu.add(menuItem);
        menuItem = new JMenuItem(this.actSaveAs);
        menuItem.setMnemonic('A');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        menuItem = new JMenuItem(this.actExit);
        menuItem.setMnemonic('X');
        fileMenu.add(menuItem);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        menuItem = new JMenuItem(this.actCut);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menuItem.setMnemonic('C');
        editMenu.add(menuItem);
        menuItem = new JMenuItem(this.actCopy);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menuItem.setMnemonic('O');
        editMenu.add(menuItem);
        menuItem = new JMenuItem(this.actPaste);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menuItem.setMnemonic('P');
        editMenu.add(menuItem);
        editMenu.addSeparator();
        menuItem = new JMenuItem(this.actSelectAll);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        menuItem.setMnemonic('A');
        editMenu.add(menuItem);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic('V');
        menuItem = new JMenuItem(this.actHighlight);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        menuItem.setMnemonic('H');
        viewMenu.add(menuItem);
        menuItem = new JMenuItem(this.actHighlightOff);
        menuItem.setMnemonic('O');
        viewMenu.add(menuItem);
        viewMenu.addSeparator();
        menuItem = new JMenuItem(this.actToggleLabels);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        menuItem.setMnemonic('A');
        viewMenu.add(menuItem);
        viewMenu.addSeparator();
        menuItem = new JMenuItem(this.actInput);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(49, 2));
        menuItem.setMnemonic('I');
        viewMenu.add(menuItem);
        menuItem = new JMenuItem(this.actTable);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(50, 2));
        menuItem.setMnemonic('T');
        viewMenu.add(menuItem);
        menuItem = new JMenuItem(this.actSplit);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(51, 2));
        menuItem.setMnemonic('D');
        viewMenu.add(menuItem);
        menuItem = new JMenuItem(this.actAnal);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(52, 2));
        menuItem.setMnemonic('A');
        viewMenu.add(menuItem);
        menuItem = new JMenuItem(this.actXML);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(53, 2));
        menuItem.setMnemonic('X');
        viewMenu.add(menuItem);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        menuItem = new JMenuItem(this.actHelp);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        menuItem.setMnemonic('H');
        helpMenu.add(menuItem);
        menuItem = new JMenuItem(this.actAbout);
        menuItem.setMnemonic('A');
        helpMenu.add(menuItem);
        menubar.add(fileMenu);
        menubar.add(editMenu);
        menubar.add(viewMenu);
        menubar.add(helpMenu);
        this.setJMenuBar(menubar);
    }

    private void createPopupMenus() {
        this.popupInput = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(this.actCut);
        this.popupInput.add(menuItem);
        menuItem = new JMenuItem(this.actCopy);
        this.popupInput.add(menuItem);
        menuItem = new JMenuItem(this.actPaste);
        this.popupInput.add(menuItem);
        menuItem = new JMenuItem(this.actSelectAll);
        this.popupInput.add(menuItem);
        this.popupInput.addSeparator();
        menuItem = new JMenuItem(this.actHighlight);
        this.popupInput.add(menuItem);
        this.popupReadonly = new JPopupMenu();
        menuItem = new JMenuItem(this.actCopy);
        this.popupReadonly.add(menuItem);
        menuItem = new JMenuItem(this.actSelectAll);
        this.popupReadonly.add(menuItem);
        MouseAdapter popupInputListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                this.maybeShowPopup(e2);
            }

            public void mouseReleased(MouseEvent e2) {
                this.maybeShowPopup(e2);
            }

            private void maybeShowPopup(MouseEvent e2) {
                if (e2.isPopupTrigger()) {
                    edcFrame.this.popupInput.show(e2.getComponent(), e2.getX(), e2.getY());
                }
            }
        };
        this.inputEdit.addMouseListener(popupInputListener);
        MouseAdapter popupReadonlyListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                this.maybeShowPopup(e2);
            }

            public void mouseReleased(MouseEvent e2) {
                this.maybeShowPopup(e2);
            }

            private void maybeShowPopup(MouseEvent e2) {
                if (e2.isPopupTrigger()) {
                    edcFrame.this.popupReadonly.show(e2.getComponent(), e2.getX(), e2.getY());
                }
            }
        };
        this.splitTextSummary.addMouseListener(popupReadonlyListener);
        this.splitTextDetails.addMouseListener(popupReadonlyListener);
        this.splitTextAnalysis.addMouseListener(popupReadonlyListener);
        this.analText.addMouseListener(popupReadonlyListener);
        this.xmlText.addMouseListener(popupReadonlyListener);
    }

    private void createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setRollover(true);
        toolBar.setRequestFocusEnabled(false);
        JButton tButton = null;
        this.getContentPane().add((Component)toolBar, "North");
        tButton = new JButton(this.actNew);
        tButton.setRequestFocusEnabled(false);
        tButton.setText("");
        toolBar.add(tButton);
        tButton = new JButton(this.actOpen);
        tButton.setRequestFocusEnabled(false);
        tButton.setText("");
        toolBar.add(tButton);
        tButton = new JButton(this.actSaveAs);
        tButton.setRequestFocusEnabled(false);
        tButton.setText("");
        toolBar.add(tButton);
        toolBar.addSeparator();
        tButton = new JButton(this.actCut);
        tButton.setRequestFocusEnabled(false);
        tButton.setText("");
        toolBar.add(tButton);
        tButton = new JButton(this.actCopy);
        tButton.setRequestFocusEnabled(false);
        tButton.setText("");
        toolBar.add(tButton);
        tButton = new JButton(this.actPaste);
        tButton.setRequestFocusEnabled(false);
        tButton.setText("");
        toolBar.add(tButton);
        tButton = new JButton(this.actHighlight);
        tButton.setRequestFocusEnabled(false);
        tButton.setText("");
        toolBar.add(tButton);
        tButton = new JButton(this.actHighlightOff);
        tButton.setRequestFocusEnabled(false);
        tButton.setText("");
        toolBar.add(tButton);
        toolBar.addSeparator();
        tButton = new JButton(this.actToggleLabels);
        tButton.setRequestFocusEnabled(false);
        tButton.setText("");
        toolBar.add(tButton);
        toolBar.addSeparator();
        tButton = new JButton(this.actInput);
        tButton.setRequestFocusEnabled(false);
        tButton.setText("");
        toolBar.add(tButton);
        tButton = new JButton(this.actTable);
        tButton.setRequestFocusEnabled(false);
        tButton.setText("");
        toolBar.add(tButton);
        tButton = new JButton(this.actSplit);
        tButton.setRequestFocusEnabled(false);
        tButton.setText("");
        toolBar.add(tButton);
        tButton = new JButton(this.actAnal);
        tButton.setRequestFocusEnabled(false);
        tButton.setText("");
        toolBar.add(tButton);
        tButton = new JButton(this.actXML);
        tButton.setRequestFocusEnabled(false);
        tButton.setText("");
        toolBar.add(tButton);
        toolBar.addSeparator();
        tButton = new JButton(this.actHelp);
        tButton.setRequestFocusEnabled(false);
        tButton.setText("");
        toolBar.add(tButton);
    }

    private boolean parse() {
        if (this.state.getInputModified()) {
            AppProgressInterface pi = new AppProgressInterface(this);
            this.inputStatus.setText("Parsing... please wait.");
            this.splitter.setProgressInterface(pi);
            if (this.splitter.setInput(this.inputEdit.getText())) {
                this.state.setInputModified(false);
                this.state.setSplitCompound(-1);
                this.buildTable();
                this.buildList();
                this.buildAnalList();
                this.buildXML();
                this.inputStatus.setText(" ");
                return true;
            }
            this.inputStatus.setText(" ");
            return false;
        }
        return true;
    }

    private void buildList() {
        if (this.doingList) {
            return;
        }
        this.doingList = true;
        this.splitList.clearSelection();
        this.splitListModel.removeAllElements();
        if (this.splitter.getCount() == 0) {
            this.doingList = false;
            return;
        }
        int i = 0;
        while (i < this.splitter.getCount()) {
            this.splitListModel.addElement(this.splitter.getDataAt(i).getName());
            ++i;
        }
        this.doingList = false;
    }

    private void buildAnalList() {
        if (this.doingAnalList) {
            return;
        }
        this.doingAnalList = true;
        this.analList.clearSelection();
        this.analListModel.removeAllElements();
        Color[] colors = new Color[]{new Color(0, 160, 0), new Color(0, 0, 0), new Color(0, 0, 192), new Color(192, 0, 0)};
        int j = 4;
        while (j >= 2) {
            int i = 0;
            while (i < this.splitter.getCount()) {
                Vector[] v = this.splitter.getDataAt(i).getAnalysisParagraphs(j);
                int k = 0;
                while (k < v[0].size()) {
                    String s = "<html><h2>Analysis</h2>" + (String)v[2].elementAt(k) + "<h3>Input Data</h3><p>" + this.splitter.getParagraphAt(i) + "</p></html>";
                    this.analListModel.addElementEx((String)v[0].elementAt(k), s, colors[j - 1], i);
                    ++k;
                }
                ++i;
            }
            --j;
        }
        if (this.analListModel.getSize() == 0) {
            this.analListModel.addElementEx("No problems", "<html><h3>Analysis</h3><p>No problems identified</p></html>", colors[0], -1);
        }
        this.doingAnalList = false;
    }

    private void buildTable() {
        this.tableModel.empty();
        int maxwidth = 0;
        FontMetrics fm = this.tableTable.getFontMetrics(this.tableTable.getFont());
        int i = 0;
        while (i < this.splitter.getCount()) {
            ExpData ed = this.splitter.getDataAt(i);
            int w = SwingUtilities.computeStringWidth(fm, ed.getName());
            if (w > maxwidth) {
                maxwidth = w;
            }
            this.tableModel.addRow(ed);
            ++i;
        }
        this.tableTable.getColumnModel().getColumn(0).setPreferredWidth(maxwidth);
        this.tableTable.doLayout();
    }

    public void buildXML() {
        this.xmlText.setText(this.splitter.getXML());
        this.xmlText.setCaretPosition(0);
    }

    private void doAbout() {
        JOptionPane.showMessageDialog(this, "<HTML><H2>Experimental Data Checker v2.6.1</H2><CENTER><P>The Experimental Data Checker and OSCAR toolkit have been developed as a collaboration between the<BR>Unilever Cambridge Centre for Molecular Informatics (<i>http://www-ucc.ch.cam.ac.uk</i>) at the Department<BR>of Chemistry, University of Cambridge, and the Royal Society of Chemistry (<i>http://www.rsc.org</i>).</P><P></P><P><B>Developed by:</B> Sam Adams, Jonathan Goodman, Richard Kidd, Alan McNaught, Peter Murray-Rust,<BR>Fraser Norton, Joe Townsend &amp; Christopher Waudby.</P><P></P><P>Copyright (c) 2003 - Unilever Cambridge Centre for Molecular Informatics and the Royal Society of Chemistry.<BR>Distributed under the terms of the Open Source Initiative's Artistic Licence<BR>(<i>http://www.opensource.org/licenses/artistic-license.php</i>)</P><P></P><P>JRegex Copyright (c) 2001, Sergey A. Samokhodkin. All rights reserved.</P><P></P><P>Apache Batik Copyright (c) 2000 The Apache Software Foundation. All rights reserved.</P></CENTER>", "About", 1);
    }

    private void doCopy() {
        block0 : switch (this.state.getCurrentPanel()) {
            case 1: {
                if (this.inputEdit.getSelectionEnd() > 0) {
                    this.inputEdit.copy();
                    break;
                }
                this.inputEdit.selectAll();
                this.inputEdit.copy();
                break;
            }
            case 3: {
                switch (this.state.getSplitPanel()) {
                    case 10: {
                        if (this.splitTextSummary.getSelectionEnd() <= 0) {
                            this.splitTextSummary.selectAll();
                        }
                        this.splitTextSummary.copy();
                        break block0;
                    }
                    case 11: {
                        if (this.splitTextDetails.getSelectionEnd() <= 0) {
                            this.splitTextDetails.selectAll();
                        }
                        this.splitTextDetails.copy();
                        break block0;
                    }
                    case 12: {
                        if (this.splitTextAnalysis.getSelectionEnd() <= 0) {
                            this.splitTextAnalysis.selectAll();
                        }
                        this.splitTextAnalysis.copy();
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                if (this.xmlText.getSelectionEnd() <= 0) {
                    this.xmlText.selectAll();
                }
                this.xmlText.copy();
                break;
            }
        }
    }

    private void doCut() {
        switch (this.state.getCurrentPanel()) {
            case 1: {
                this.inputEdit.cut();
                break;
            }
        }
    }

    private void doHelp() {
        HelpDialog hd = new HelpDialog(this);
        switch (this.state.getCurrentPanel()) {
            case 1: {
                hd.showHelp(1);
                break;
            }
            case 2: {
                hd.showHelp(5);
                break;
            }
            case 3: {
                if (this.state.getSplitPanel() >= 100) {
                    hd.showHelp(3);
                    break;
                }
                hd.showHelp(2);
                break;
            }
            case 4: {
                hd.showHelp(6);
                break;
            }
            case 5: {
                hd.showHelp(4);
                break;
            }
            default: {
                hd.showHelp(0);
            }
        }
    }

    private void doHighlight() {
        Thread parseThread = new Thread(){

            public void run() {
                if (!edcFrame.this.parse()) {
                    edcFrame.this.enableFrame(true);
                    return;
                }
                edcFrame.this.inputEdit.getHighlighter().removeAllHighlights();
                HighlightInfo hi = edcFrame.this.splitter.getHighlightInfo();
                hi.reset();
                while (hi.hasMoreItems()) {
                    try {
                        edcFrame.this.inputEdit.getHighlighter().addHighlight(hi.getP0(), hi.getP1(), new DefaultHighlighter.DefaultHighlightPainter(new Color(hi.getColor().getRed(), hi.getColor().getGreen(), hi.getColor().getBlue(), 50)));
                    }
                    catch (BadLocationException error) {
                        System.out.println("BadLocationException!");
                    }
                    hi.next();
                }
                if (hi.getExpStart() >= 0 & hi.getExpEnd() > hi.getExpStart()) {
                    try {
                        edcFrame.this.inputEdit.getHighlighter().addHighlight(0, hi.getExpStart(), new DefaultHighlighter.DefaultHighlightPainter(new Color(0, 0, 0, 20)));
                        edcFrame.this.inputEdit.getHighlighter().addHighlight(hi.getExpEnd(), edcFrame.this.inputEdit.getText().length(), new DefaultHighlighter.DefaultHighlightPainter(new Color(0, 0, 0, 20)));
                    }
                    catch (BadLocationException error) {
                        System.out.println("BadLocationException!");
                    }
                }
                if (!edcFrame.this.state.getInputHighlighted()) {
                    edcFrame.this.inputEdit.setCaretPosition(hi.getExpStart() > 10 ? hi.getExpStart() - 10 : 0);
                }
                edcFrame.this.state.setInputHighlighted(true);
                edcFrame.this.enableFrame(true);
            }
        };
        this.enableFrame(false);
        parseThread.start();
    }

    private void doHighlightOff() {
        this.inputEdit.getHighlighter().removeAllHighlights();
        this.state.setInputHighlighted(false);
    }

    private void doPaste() {
        switch (this.state.getCurrentPanel()) {
            case 1: {
                this.inputEdit.paste();
                break;
            }
        }
    }

    private void doOpen() {
        try {
            JFileChooser chooser = new JFileChooser();
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("rtf");
            filter.addExtension("doc");
            filter.addExtension("txt");
            filter.setDescription("Plain text and RTF files");
            chooser.setFileFilter(filter);
            if (DefaultFilePath != "") {
                chooser.setCurrentDirectory(new File(DefaultFilePath));
            }
            if (chooser.showOpenDialog(this) != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            DefaultFilePath = file.getCanonicalFile().getParent();
            String contents = new String("");
            if (FileTools.isFileRTF(file)) {
                contents = FileTools.doOpenRTF(file);
            } else if (FileTools.isFileWord(file)) {
                int retval = JOptionPane.showConfirmDialog(this, "The selected file appears to be a Microsoft Word document (which will\nprobably open incorrectly). Would you like to launch this in Word\ninstead (to copy and paste)?", "Open file", 1, 2);
                switch (retval) {
                    case 0: {
                        String winword = FileTools.findWordEXE();
                        if (winword != null) {
                            String[] cmd = new String[]{winword, file.getAbsolutePath()};
                            Runtime.getRuntime().exec(cmd);
                            break;
                        }
                        JOptionPane.showMessageDialog(this, "Cannot open file - unable to locate Microsoft Word on this system.", "Open file", 0);
                        break;
                    }
                    case 1: {
                        contents = FileTools.doOpenTXT(file);
                        break;
                    }
                }
            } else {
                contents = FileTools.doOpenTXT(file);
            }
            if (contents != "") {
                this.state.New();
                this.inputEdit.setText(contents);
            }
        }
        catch (HeadlessException e2) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void doSaveAs() {
        switch (this.state.getCurrentPanel()) {
            case 3: {
                if (this.state.getSplitPanel() < 100) {
                    return;
                }
                this.splitPlots[this.state.getSplitPanel() - 100].saveAsSVG();
                break;
            }
            case 5: {
                this.doSaveXML();
                break;
            }
        }
        if (this.state.getCurrentPanel() != 3) {
            return;
        }
    }

    private void doSaveXML() {
        try {
            JFileChooser chooser = new JFileChooser();
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("xml");
            filter.setDescription("XML files");
            chooser.setFileFilter(filter);
            int retval = chooser.showSaveDialog(this);
            if (retval == 0) {
                File file = chooser.getSelectedFile();
                FileOutputStream fos = new FileOutputStream(file);
                PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-16")));
                String[] theXML = this.xmlText.getText().split("\\n");
                int i = 0;
                while (i < theXML.length) {
                    out.println(theXML[i]);
                    ++i;
                }
                out.flush();
            }
        }
        catch (HeadlessException e2) {
        }
        catch (FileNotFoundException e3) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void doSelectAll() {
        block0 : switch (this.state.getCurrentPanel()) {
            case 1: {
                this.inputEdit.requestFocus();
                this.inputEdit.selectAll();
                break;
            }
            case 3: {
                switch (this.state.getSplitPanel()) {
                    case 10: {
                        this.splitTextSummary.requestFocus();
                        this.splitTextSummary.selectAll();
                        break block0;
                    }
                    case 11: {
                        this.splitTextDetails.requestFocus();
                        this.splitTextDetails.selectAll();
                        break block0;
                    }
                    case 12: {
                        this.splitTextAnalysis.requestFocus();
                        this.splitTextAnalysis.selectAll();
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                this.analText.requestFocus();
                this.analText.selectAll();
            }
            case 5: {
                this.xmlText.requestFocus();
                this.xmlText.selectAll();
                break;
            }
        }
    }

    private void doSetSplitTexts(int i) {
        if (this.splitter.getCount() == 0 | i >= this.splitter.getCount()) {
            this.splitTextSummary.setText("");
            this.splitTextDetails.setText("");
            this.splitTextAnalysis.setText("");
            int j = 0;
            while (j < this.splitPlots.length) {
                this.splitPlots[j].setSI(null);
                this.splitPlots[j].repaint();
                this.splitTab.setEnabledAt(j + 3, false);
                ++j;
            }
            return;
        }
        String s = this.splitter.getDataAt(i).getSummaryHTML();
        this.splitTextSummary.setText(s);
        this.splitTextSummary.setCaretPosition(0);
        this.splitTextDetails.setText(this.splitter.getDataAt(i).getDetailsHTML());
        this.splitTextDetails.setCaretPosition(0);
        this.splitTextAnalysis.setText(this.splitter.getDataAt(i).getAnalysisHTML());
        this.splitTextAnalysis.setCaretPosition(0);
        HighlightInfo hi = this.splitter.getDataAt(i).getHighlightInfo();
        String plaintext = s.replaceAll("</(td|h2|h3|p)>", " ");
        plaintext = plaintext.replaceAll("</?[a-z].*?>", "");
        plaintext = plaintext.replaceAll("&nbsp;", " ");
        plaintext = plaintext.replaceAll("<a.*?>", "");
        int offset = plaintext.indexOf(this.splitter.getParagraphAt(i));
        hi.reset();
        this.splitTextSummary.getHighlighter().removeAllHighlights();
        while (hi.hasMoreItems()) {
            try {
                int p0 = hi.getP0();
                int p1 = hi.getP1();
                if (p0 < 0 | p1 <= p0) {
                    hi.next();
                    continue;
                }
                this.splitTextSummary.getHighlighter().addHighlight(offset + 1 + this.splitter.getParagraphAt(i).substring(0, p0).replaceAll("\\s{2,}", " ").length(), offset + 1 + this.splitter.getParagraphAt(i).substring(0, p1).replaceAll("\\s{2,}", " ").length(), new DefaultHighlighter.DefaultHighlightPainter(new Color(hi.getColor().getRed(), hi.getColor().getGreen(), hi.getColor().getBlue(), 30)));
            }
            catch (BadLocationException error) {
                System.out.println("BadLocationException!");
            }
            hi.next();
        }
        int j = 0;
        while (j < this.splitPlots.length) {
            this.splitPlots[j].setSI(this.splitter.getDataAt(i).getSpectrumInfo(j));
            this.splitPlots[j].repaint();
            this.splitTab.setEnabledAt(j + 3, this.splitter.getDataAt(i).getSpectrumInfo(j) != null);
            ++j;
        }
    }

    private void doSetAnalText(int i) {
        String s = this.analListModel.getHTML(i);
        this.analText.setText(s);
        this.analText.setCaretPosition(0);
        int p = this.analListModel.getParagraph(i);
        if (p < 0) {
            return;
        }
        HighlightInfo hi = this.splitter.getDataAt(p).getHighlightInfo();
        String plaintext = s.replaceAll("</(td|h2|h3|p)>", " ");
        plaintext = plaintext.replaceAll("</?[a-z].*?>", "");
        plaintext = plaintext.replaceAll("&nbsp;", " ");
        plaintext = plaintext.replaceAll("<a.*?>", "");
        int offset = plaintext.indexOf(this.splitter.getParagraphAt(p));
        hi.reset();
        this.analText.getHighlighter().removeAllHighlights();
        while (hi.hasMoreItems()) {
            try {
                int p0 = hi.getP0();
                int p1 = hi.getP1();
                if (p0 < 0 | p1 <= p0) {
                    hi.next();
                    continue;
                }
                this.analText.getHighlighter().addHighlight(offset + 1 + this.splitter.getParagraphAt(p).substring(0, p0).replaceAll("\\s{2,}", " ").length(), offset + 1 + this.splitter.getParagraphAt(p).substring(0, p1).replaceAll("\\s{2,}", " ").length(), new DefaultHighlighter.DefaultHighlightPainter(new Color(hi.getColor().getRed(), hi.getColor().getGreen(), hi.getColor().getBlue(), 30)));
            }
            catch (BadLocationException error) {
                System.out.println("BadLocationException!");
            }
            hi.next();
        }
    }

    private void doToggleLabels() {
        int i = 0;
        while (i < this.splitPlots.length) {
            this.splitPlots[i].toggleAnnotations();
            ++i;
        }
    }

    private void enableFrame(boolean b2) {
        if (b2) {
            this.getGlassPane().setVisible(false);
            this.getJMenuBar().setEnabled(true);
            this.inputEdit.setEnabled(true);
            this.state.enableActions(this.state.getCurrentPanel());
        } else {
            this.setGlassPane(new MyGlassPane());
            this.getGlassPane().setVisible(true);
            this.getJMenuBar().setEnabled(false);
            this.inputEdit.setEnabled(false);
            this.actInput.setEnabled(false);
            this.actTable.setEnabled(false);
            this.actSplit.setEnabled(false);
            this.actAnal.setEnabled(false);
            this.actXML.setEnabled(false);
            this.actNew.setEnabled(false);
            this.actOpen.setEnabled(false);
            this.actSaveAs.setEnabled(false);
            this.actHighlight.setEnabled(false);
            this.actHighlightOff.setEnabled(false);
            this.actToggleLabels.setEnabled(false);
            this.actCut.setEnabled(false);
            this.actCopy.setEnabled(false);
            this.actPaste.setEnabled(false);
            this.actSelectAll.setEnabled(false);
        }
    }

    public void quit() {
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ JTableEx access$2400(edcFrame x0) {
        return x0.tableTable;
    }

    static {
        INPUTPANEL = 1;
        TABLEPANEL = 2;
        SPLITPANEL = 3;
        ANALPANEL = 4;
        XMLPANEL = 5;
        SUMMARYSPLIT = 10;
        DETAILSSPLIT = 11;
        ANALYSISSPLIT = 12;
        GRAPHPANELOFFSET = 100;
        DefaultFilePath = "";
    }

    protected class DocState {
        private int CurrentPanel;
        private int SplitCompound;
        private int SplitPanel;
        private int AnalItem;
        private boolean inputModified;
        private boolean inputHighlighted;

        protected DocState() {
            this.New();
        }

        public void New() {
            this.CurrentPanel = -1;
            this.SplitCompound = -1;
            this.SplitPanel = -1;
            this.AnalItem = -1;
            edcFrame.this.doingList = false;
            edcFrame.this.doingAnalList = false;
            this.setInputModified(true);
            edcFrame.this.inputEdit.setText("");
            this.setCurrentPanel(1);
            this.setInputHighlighted(false);
        }

        public int getCurrentPanel() {
            return this.CurrentPanel;
        }

        public int getSplitCompound() {
            return this.SplitCompound;
        }

        public int getSplitPanel() {
            return this.SplitPanel;
        }

        public int getAnalItem() {
            return this.AnalItem;
        }

        public boolean getInputModified() {
            return this.inputModified;
        }

        public boolean getInputHighlighted() {
            return this.inputHighlighted;
        }

        public void setInputHighlighted(boolean b2) {
            this.inputHighlighted = b2;
            edcFrame.this.actHighlightOff.setEnabled(b2);
        }

        public void setCurrentPanel(int p) {
            if (p == this.CurrentPanel) {
                return;
            }
            switch (p) {
                case 1: {
                    if (this.CurrentPanel != -1) {
                        this.CurrentPanel = p;
                        edcFrame.this.doHighlight();
                    }
                    this.CurrentPanel = p;
                    this.enableActions(p);
                    ((CardLayout)edcFrame.this.cards.getLayout()).show(edcFrame.this.cards, "inputPanel");
                    break;
                }
                case 2: {
                    edcFrame.this.enableFrame(false);
                    class TableThread
                    extends Thread {
                        int p;
                        private final /* synthetic */ DocState this$1;

                        TableThread(DocState this$1) {
                            this.this$1 = this$1;
                        }

                        public void setP(int i) {
                            this.p = i;
                        }

                        public void run() {
                            if (!edcFrame.access$700(DocState.access$2300(this.this$1))) {
                                edcFrame.access$800(DocState.access$2300(this.this$1), true);
                                return;
                            }
                            edcFrame.access$2400(DocState.access$2300(this.this$1)).getSelectionModel().clearSelection();
                            ((CardLayout)edcFrame.access$2200(DocState.access$2300(this.this$1)).getLayout()).show(edcFrame.access$2200(DocState.access$2300(this.this$1)), "tablePanel");
                            DocState.access$2502(this.this$1, this.p);
                            edcFrame.access$800(DocState.access$2300(this.this$1), true);
                        }
                    }
                    TableThread tt = new TableThread(this);
                    tt.setP(p);
                    tt.start();
                    break;
                }
                case 3: {
                    edcFrame.this.enableFrame(false);
                    class SplitThread
                    extends Thread {
                        int p;
                        private final /* synthetic */ DocState this$1;

                        SplitThread(DocState this$1) {
                            this.this$1 = this$1;
                        }

                        public void setP(int i) {
                            this.p = i;
                        }

                        public void run() {
                            if (!edcFrame.access$700(DocState.access$2300(this.this$1))) {
                                edcFrame.access$800(DocState.access$2300(this.this$1), true);
                                return;
                            }
                            if (this.this$1.getSplitCompound() == -1) {
                                this.this$1.setSplitCompound(0);
                            }
                            if (this.this$1.getSplitPanel() == -1) {
                                this.this$1.setSplitPanel(10);
                            }
                            ((CardLayout)edcFrame.access$2200(DocState.access$2300(this.this$1)).getLayout()).show(edcFrame.access$2200(DocState.access$2300(this.this$1)), "splitPanel");
                            DocState.access$2502(this.this$1, this.p);
                            edcFrame.access$100(DocState.access$2300(this.this$1)).repaint();
                            edcFrame.access$800(DocState.access$2300(this.this$1), true);
                        }
                    }
                    SplitThread st = new SplitThread(this);
                    st.setP(p);
                    st.start();
                    break;
                }
                case 4: {
                    edcFrame.this.enableFrame(false);
                    class AnalThread
                    extends Thread {
                        int p;
                        private final /* synthetic */ DocState this$1;

                        AnalThread(DocState this$1) {
                            this.this$1 = this$1;
                        }

                        public void setP(int i) {
                            this.p = i;
                        }

                        public void run() {
                            if (!edcFrame.access$700(DocState.access$2300(this.this$1))) {
                                edcFrame.access$800(DocState.access$2300(this.this$1), true);
                                return;
                            }
                            this.this$1.setAnalItem(0);
                            ((CardLayout)edcFrame.access$2200(DocState.access$2300(this.this$1)).getLayout()).show(edcFrame.access$2200(DocState.access$2300(this.this$1)), "analPanel");
                            DocState.access$2502(this.this$1, this.p);
                            edcFrame.access$400(DocState.access$2300(this.this$1)).repaint();
                            edcFrame.access$800(DocState.access$2300(this.this$1), true);
                        }
                    }
                    AnalThread at = new AnalThread(this);
                    at.setP(p);
                    at.start();
                    break;
                }
                case 5: {
                    edcFrame.this.enableFrame(false);
                    class XmlThread
                    extends Thread {
                        int p;
                        private final /* synthetic */ DocState this$1;

                        XmlThread(DocState this$1) {
                            this.this$1 = this$1;
                        }

                        public void setP(int i) {
                            this.p = i;
                        }

                        public void run() {
                            if (!edcFrame.access$700(DocState.access$2300(this.this$1))) {
                                edcFrame.access$800(DocState.access$2300(this.this$1), true);
                                return;
                            }
                            ((CardLayout)edcFrame.access$2200(DocState.access$2300(this.this$1)).getLayout()).show(edcFrame.access$2200(DocState.access$2300(this.this$1)), "xmlPanel");
                            DocState.access$2502(this.this$1, this.p);
                            edcFrame.access$800(DocState.access$2300(this.this$1), true);
                        }
                    }
                    XmlThread xt = new XmlThread(this);
                    xt.setP(p);
                    xt.start();
                }
            }
        }

        public void enableActions(int p) {
            switch (p) {
                case 1: {
                    edcFrame.this.actInput.setEnabled(false);
                    edcFrame.this.actTable.setEnabled(true);
                    edcFrame.this.actSplit.setEnabled(true);
                    edcFrame.this.actAnal.setEnabled(true);
                    edcFrame.this.actXML.setEnabled(true);
                    edcFrame.this.actNew.setEnabled(true);
                    edcFrame.this.actOpen.setEnabled(true);
                    edcFrame.this.actSaveAs.setEnabled(false);
                    edcFrame.this.actHighlight.setEnabled(true);
                    edcFrame.this.actHighlightOff.setEnabled(this.getInputHighlighted());
                    edcFrame.this.actToggleLabels.setEnabled(false);
                    edcFrame.this.actCut.setEnabled(false);
                    edcFrame.this.actCopy.setEnabled(false);
                    edcFrame.this.actPaste.setEnabled(true);
                    edcFrame.this.actSelectAll.setEnabled(true);
                    break;
                }
                case 2: {
                    edcFrame.this.actInput.setEnabled(true);
                    edcFrame.this.actTable.setEnabled(false);
                    edcFrame.this.actSplit.setEnabled(true);
                    edcFrame.this.actAnal.setEnabled(true);
                    edcFrame.this.actXML.setEnabled(true);
                    edcFrame.this.actNew.setEnabled(true);
                    edcFrame.this.actOpen.setEnabled(true);
                    edcFrame.this.actSaveAs.setEnabled(false);
                    edcFrame.this.actHighlight.setEnabled(false);
                    edcFrame.this.actHighlightOff.setEnabled(false);
                    edcFrame.this.actToggleLabels.setEnabled(false);
                    edcFrame.this.actCut.setEnabled(false);
                    edcFrame.this.actCopy.setEnabled(false);
                    edcFrame.this.actPaste.setEnabled(false);
                    edcFrame.this.actSelectAll.setEnabled(false);
                    break;
                }
                case 3: {
                    edcFrame.this.actInput.setEnabled(true);
                    edcFrame.this.actTable.setEnabled(true);
                    edcFrame.this.actSplit.setEnabled(false);
                    edcFrame.this.actAnal.setEnabled(true);
                    edcFrame.this.actXML.setEnabled(true);
                    edcFrame.this.actNew.setEnabled(true);
                    edcFrame.this.actOpen.setEnabled(true);
                    edcFrame.this.actHighlight.setEnabled(false);
                    edcFrame.this.actHighlightOff.setEnabled(false);
                    edcFrame.this.actCut.setEnabled(false);
                    this.doSplitCopyEnabled();
                    edcFrame.this.actPaste.setEnabled(false);
                    break;
                }
                case 4: {
                    edcFrame.this.actInput.setEnabled(true);
                    edcFrame.this.actTable.setEnabled(true);
                    edcFrame.this.actSplit.setEnabled(true);
                    edcFrame.this.actAnal.setEnabled(false);
                    edcFrame.this.actXML.setEnabled(true);
                    edcFrame.this.actNew.setEnabled(true);
                    edcFrame.this.actOpen.setEnabled(true);
                    edcFrame.this.actSaveAs.setEnabled(false);
                    edcFrame.this.actHighlight.setEnabled(false);
                    edcFrame.this.actHighlightOff.setEnabled(false);
                    edcFrame.this.actToggleLabels.setEnabled(false);
                    edcFrame.this.actCut.setEnabled(false);
                    edcFrame.this.actCopy.setEnabled(false);
                    edcFrame.this.actPaste.setEnabled(false);
                    edcFrame.this.actSelectAll.setEnabled(true);
                    break;
                }
                case 5: {
                    edcFrame.this.actInput.setEnabled(true);
                    edcFrame.this.actTable.setEnabled(true);
                    edcFrame.this.actSplit.setEnabled(true);
                    edcFrame.this.actAnal.setEnabled(true);
                    edcFrame.this.actXML.setEnabled(false);
                    edcFrame.this.actNew.setEnabled(true);
                    edcFrame.this.actOpen.setEnabled(true);
                    edcFrame.this.actSaveAs.setEnabled(true);
                    edcFrame.this.actHighlight.setEnabled(false);
                    edcFrame.this.actHighlightOff.setEnabled(false);
                    edcFrame.this.actToggleLabels.setEnabled(false);
                    edcFrame.this.actCut.setEnabled(false);
                    edcFrame.this.actCopy.setEnabled(false);
                    edcFrame.this.actPaste.setEnabled(false);
                    edcFrame.this.actSelectAll.setEnabled(true);
                }
            }
        }

        public void setSplitCompound(int n) {
            if (n == -1) {
                this.SplitCompound = n;
                return;
            }
            if (this.SplitCompound != n) {
                this.SplitCompound = n;
                edcFrame.this.splitList.setSelectedIndex(n);
                edcFrame.this.doSetSplitTexts(n);
            }
            if (this.getCurrentPanel() != 3) {
                this.setCurrentPanel(3);
            }
        }

        public void setSplitPanel(int n) {
            if (this.SplitPanel == n) {
                return;
            }
            this.SplitPanel = n;
            int i = n - 10;
            if (i > 10) {
                i -= 87;
            }
            if (edcFrame.this.splitTab.getSelectedIndex() != i) {
                edcFrame.this.splitTab.setSelectedIndex(i);
            }
            this.doSplitCopyEnabled();
        }

        public void setAnalItem(int n) {
            if (n == -1) {
                this.AnalItem = n;
                return;
            }
            if (this.AnalItem != n) {
                this.AnalItem = n;
            }
            edcFrame.this.analList.setSelectedIndex(n);
            edcFrame.this.doSetAnalText(n);
            if (this.getCurrentPanel() != 4) {
                this.setCurrentPanel(4);
            }
        }

        public void setInputModified(boolean b2) {
            if (this.inputModified != b2) {
                this.inputModified = b2;
                edcFrame.this.inputStatus.setText(this.inputModified ? "Modified" : " ");
            }
        }

        public void doLink(String url) {
            if (url.indexOf("spec") == 0) {
                int n = new Integer(url.substring(4));
                this.setCurrentPanel(3);
                this.setSplitPanel(100 + n);
            } else if (url.indexOf("prop") == 0) {
                this.setCurrentPanel(3);
                this.setSplitPanel(11);
                edcFrame.this.splitTextDetails.scrollToReference(url.substring(4));
            }
        }

        private void doSplitCopyEnabled() {
            switch (this.getSplitPanel()) {
                case 10: 
                case 11: 
                case 12: {
                    edcFrame.this.actCopy.setEnabled(false);
                    edcFrame.this.actSelectAll.setEnabled(true);
                    edcFrame.this.actToggleLabels.setEnabled(false);
                    edcFrame.this.actSaveAs.setEnabled(false);
                    break;
                }
                default: {
                    edcFrame.this.actCopy.setEnabled(false);
                    edcFrame.this.actSelectAll.setEnabled(false);
                    edcFrame.this.actToggleLabels.setEnabled(true);
                    edcFrame.this.actSaveAs.setEnabled(true);
                }
            }
        }

        static /* synthetic */ edcFrame access$2300(DocState x0) {
            return x0.edcFrame.this;
        }

        static /* synthetic */ int access$2502(DocState x0, int x1) {
            x0.CurrentPanel = x1;
            return x0.CurrentPanel;
        }
    }

    class ExitAction
    extends AbstractAction {
        public ExitAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.quit();
        }
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.doHelp();
        }
    }

    class AboutAction
    extends AbstractAction {
        public AboutAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.doAbout();
        }
    }

    class SaveAsAction
    extends AbstractAction {
        public SaveAsAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.doSaveAs();
        }
    }

    class ToggleLabelsAction
    extends AbstractAction {
        public ToggleLabelsAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.doToggleLabels();
        }
    }

    class SelectAllAction
    extends AbstractAction {
        public SelectAllAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.doSelectAll();
        }
    }

    class CopyAction
    extends AbstractAction {
        public CopyAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.doCopy();
        }
    }

    class PasteAction
    extends AbstractAction {
        public PasteAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.doPaste();
        }
    }

    class CutAction
    extends AbstractAction {
        public CutAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.doCut();
        }
    }

    class HighlightOffAction
    extends AbstractAction {
        public HighlightOffAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.doHighlightOff();
        }
    }

    class HighlightAction
    extends AbstractAction {
        public HighlightAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.doHighlight();
        }
    }

    class OpenAction
    extends AbstractAction {
        public OpenAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.doOpen();
        }
    }

    class NewAction
    extends AbstractAction {
        public NewAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.state.New();
        }
    }

    class XMLAction
    extends AbstractAction {
        public XMLAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.state.setCurrentPanel(5);
        }
    }

    class AnalAction
    extends AbstractAction {
        public AnalAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.state.setCurrentPanel(4);
        }
    }

    class SplitAction
    extends AbstractAction {
        public SplitAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.state.setCurrentPanel(3);
        }
    }

    class TableAction
    extends AbstractAction {
        public TableAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.state.setCurrentPanel(2);
        }
    }

    class InputAction
    extends AbstractAction {
        public InputAction(String text, ImageIcon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        public void actionPerformed(ActionEvent e2) {
            edcFrame.this.state.setCurrentPanel(1);
        }
    }
}

